/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.HttpClientConfig;
import io.gatling.http.client.ahc.util.HttpUtils;
import io.gatling.http.client.impl.DefaultHttpClient;
import io.gatling.http.client.impl.HttpTx;
import io.gatling.http.client.impl.request.WritableRequest;
import io.gatling.http.client.impl.request.WritableRequestBuilder;
import io.gatling.http.client.pool.ChannelPool;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderResultProvider;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpAppHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpAppHandler.class);
    static final IOException PREMATURE_CLOSE = new IOException("Premature close"){

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };
    private final DefaultHttpClient client;
    private final ChannelPool channelPool;
    private final HttpClientConfig config;
    private HttpTx tx;
    private boolean httpResponseReceived;

    HttpAppHandler(DefaultHttpClient defaultHttpClient, ChannelPool channelPool, HttpClientConfig httpClientConfig) {
        this.client = defaultHttpClient;
        this.channelPool = channelPool;
        this.config = httpClientConfig;
    }

    private void setActive(HttpTx httpTx) {
        this.tx = httpTx;
    }

    private void setInactive() {
        this.tx = null;
        this.httpResponseReceived = false;
    }

    private boolean isInactive() {
        return this.tx == null || this.tx.requestTimeout.isDone();
    }

    private void crash(ChannelHandlerContext channelHandlerContext, Throwable throwable, boolean bl) {
        if (throwable instanceof Error) {
            LOGGER.error("Fatal error", throwable);
            System.exit(1);
        }
        if (this.isInactive()) {
            return;
        }
        this.crash0(channelHandlerContext, throwable, bl, this.tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crash0(ChannelHandlerContext channelHandlerContext, Throwable throwable, boolean bl, HttpTx httpTx) {
        try {
            httpTx.requestTimeout.cancel();
            httpTx.listener.onThrowable(throwable);
            this.setInactive();
        }
        catch (Exception exception) {
            LOGGER.error("Exception while handling HTTP/1.1 crash, please report to Gatling maintainers", (Throwable)exception);
        }
        finally {
            if (bl) {
                channelHandlerContext.close();
            }
        }
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        HttpTx httpTx = (HttpTx)object;
        this.setActive(httpTx);
        if (httpTx.requestTimeout.isDone()) {
            this.setInactive();
            return;
        }
        try {
            WritableRequest writableRequest = WritableRequestBuilder.buildRequest(httpTx.request, channelHandlerContext.alloc(), this.config, false);
            httpTx.closeConnection = HttpUtils.isConnectionClose(writableRequest.getRequest().headers());
            LOGGER.debug("Write request {}", (Object)writableRequest);
            httpTx.listener.onWrite(channelHandlerContext.channel());
            writableRequest.write(channelHandlerContext);
        }
        catch (Exception exception) {
            this.crash(channelHandlerContext, exception, true);
        }
    }

    private boolean exitOnDecodingFailure(ChannelHandlerContext channelHandlerContext, DecoderResultProvider decoderResultProvider) {
        Throwable throwable = decoderResultProvider.decoderResult().cause();
        if (throwable != null) {
            this.crash(channelHandlerContext, throwable, true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        block14: {
            if (this.isInactive()) {
                return;
            }
            LOGGER.debug("Read msg='{}'", object);
            try {
                if (object instanceof HttpResponse) {
                    this.httpResponseReceived = true;
                    HttpResponse httpResponse = (HttpResponse)object;
                    if (this.exitOnDecodingFailure(channelHandlerContext, (DecoderResultProvider)httpResponse)) {
                        return;
                    }
                    this.tx.listener.onHttpResponse(httpResponse.status(), httpResponse.headers());
                    this.tx.closeConnection = this.tx.closeConnection && HttpUtils.isConnectionClose(httpResponse.headers());
                    break block14;
                }
                if (!(object instanceof HttpContent)) break block14;
                HttpContent httpContent = (HttpContent)object;
                if (this.exitOnDecodingFailure(channelHandlerContext, (DecoderResultProvider)httpContent)) {
                    return;
                }
                boolean bl = httpContent instanceof LastHttpContent;
                HttpTx httpTx = this.tx;
                if (bl) {
                    httpTx.requestTimeout.cancel();
                    this.setInactive();
                    if (httpTx.closeConnection) {
                        channelHandlerContext.channel().close();
                    } else {
                        this.channelPool.offer(channelHandlerContext.channel());
                    }
                }
                try {
                    httpTx.listener.onHttpResponseBodyChunk(httpContent.content(), bl);
                }
                catch (Throwable throwable) {
                    this.crash0(channelHandlerContext, throwable, true, httpTx);
                    throw throwable;
                }
            }
            finally {
                ReferenceCountUtil.release((Object)object);
            }
        }
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        if (this.isInactive()) {
            return;
        }
        HttpTx httpTx = this.tx;
        this.setInactive();
        httpTx.requestTimeout.cancel();
        if (!this.httpResponseReceived && this.client.canRetry(httpTx, channelHandlerContext.channel())) {
            this.client.retry(httpTx, channelHandlerContext.channel().eventLoop());
        } else {
            this.crash0(channelHandlerContext, PREMATURE_CLOSE, false, httpTx);
        }
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.crash(channelHandlerContext, throwable, true);
    }
}

