/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.proxy;

import io.gatling.http.client.proxy.ProxyServer;
import io.gatling.http.client.realm.BasicRealm;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class HttpProxyServer
extends ProxyServer {
    private final BasicRealm realm;
    private final int securedPort;
    private final InetSocketAddress securedAddress;

    public HttpProxyServer(String string, int n, int n2, BasicRealm basicRealm) throws UnknownHostException {
        super(string, n);
        this.securedPort = n2;
        this.realm = basicRealm;
        this.securedAddress = new InetSocketAddress(this.inetAddress, n2);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getSecuredPort() {
        return this.securedPort;
    }

    @Override
    public ProxyHandler newHandler() {
        return this.realm != null ? new HttpProxyHandler((SocketAddress)this.securedAddress, this.realm.getUsername(), this.realm.getPassword(), (HttpHeaders)EmptyHttpHeaders.INSTANCE, true) : new HttpProxyHandler((SocketAddress)this.securedAddress, (HttpHeaders)EmptyHttpHeaders.INSTANCE, true);
    }

    public String toString() {
        return "HttpProxyServer{realm=" + this.realm + ", securedPort=" + this.securedPort + ", securedAddress=" + this.securedAddress + ", host='" + this.host + '\'' + ", port=" + this.port + '}';
    }
}

