/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.oauth;

import io.gatling.http.client.Param;
import io.gatling.http.client.oauth.ConsumerKey;
import io.gatling.http.client.oauth.Params;
import io.gatling.http.client.oauth.RequestToken;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.util.MiscUtils;
import io.gatling.http.client.util.StringUtils;
import io.gatling.http.client.util.Utf8UrlEncoder;
import io.gatling.shared.util.StringBuilderPool;
import io.netty.handler.codec.http.HttpMethod;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class OAuthSignatureCalculatorInstance {
    private static final String KEY_OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    private static final String KEY_OAUTH_NONCE = "oauth_nonce";
    private static final String KEY_OAUTH_SIGNATURE = "oauth_signature";
    private static final String KEY_OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    private static final String KEY_OAUTH_TIMESTAMP = "oauth_timestamp";
    private static final String KEY_OAUTH_TOKEN = "oauth_token";
    private static final String KEY_OAUTH_VERSION = "oauth_version";
    private static final String OAUTH_VERSION_1_0 = "1.0";
    private static final String OAUTH_SIGNATURE_METHOD = "HMAC-SHA1";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private final Mac mac;
    private final byte[] nonceBuffer = new byte[16];
    private final Params params = new Params();

    public OAuthSignatureCalculatorInstance() {
        try {
            this.mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException("HmacSHA1 is not supported, really?", noSuchAlgorithmException);
        }
    }

    public Signature computeSignature(ConsumerKey consumerKey, RequestToken requestToken, HttpMethod httpMethod, Uri uri, List<Param> list) {
        String string = this.generateNonce();
        long l = this.generateTimestamp();
        StringBuilder stringBuilder = this.signatureBaseString(consumerKey, requestToken, httpMethod, uri, list, l, string);
        ByteBuffer byteBuffer = StringUtils.charSequence2ByteBuffer(stringBuilder, StandardCharsets.UTF_8);
        byte[] byArray = this.digest(consumerKey, requestToken, byteBuffer);
        String string2 = Base64.getEncoder().encodeToString(byArray);
        return new Signature(consumerKey, requestToken, l, string, string2);
    }

    protected String generateNonce() {
        ThreadLocalRandom.current().nextBytes(this.nonceBuffer);
        return Base64.getEncoder().encodeToString(this.nonceBuffer);
    }

    protected long generateTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    StringBuilder signatureBaseString(ConsumerKey consumerKey, RequestToken requestToken, HttpMethod httpMethod, Uri uri, List<Param> list, long l, String string) {
        String string2 = uri.toUrlWithoutQuery();
        String string3 = this.encodedParams(consumerKey, requestToken, l, Utf8UrlEncoder.percentEncodeQueryElement(string), uri.getEncodedQueryParams(), list);
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
        stringBuilder.append(httpMethod.name());
        stringBuilder.append('&');
        Utf8UrlEncoder.encodeAndAppendPercentEncoded(stringBuilder, string2);
        stringBuilder.append('&');
        Utf8UrlEncoder.encodeAndAppendPercentEncoded(stringBuilder, string3);
        return stringBuilder;
    }

    private String encodedParams(ConsumerKey consumerKey, RequestToken requestToken, long l, String string, List<Param> list, List<Param> list2) {
        this.params.reset();
        this.params.add(KEY_OAUTH_CONSUMER_KEY, consumerKey.percentEncodedKey).add(KEY_OAUTH_NONCE, string).add(KEY_OAUTH_SIGNATURE_METHOD, OAUTH_SIGNATURE_METHOD).add(KEY_OAUTH_TIMESTAMP, String.valueOf(l));
        if (requestToken.key != null) {
            this.params.add(KEY_OAUTH_TOKEN, requestToken.percentEncodedKey);
        }
        this.params.add(KEY_OAUTH_VERSION, OAUTH_VERSION_1_0);
        if (list2 != null) {
            for (Param param : list2) {
                this.params.add(Utf8UrlEncoder.percentEncodeQueryElement(param.getName()), Utf8UrlEncoder.percentEncodeQueryElement(param.getValue()));
            }
        }
        if (MiscUtils.isNonEmpty(list)) {
            for (Param param : list) {
                this.params.add(this.percentEncodeAlreadyFormUrlEncoded(param.getName()), this.percentEncodeAlreadyFormUrlEncoded(param.getValue()));
            }
        }
        return this.params.sortAndConcat();
    }

    private String percentEncodeAlreadyFormUrlEncoded(String string) {
        return string.replace("*", "%2A").replace("+", "%20").replace("%7E", "~");
    }

    private byte[] digest(ConsumerKey consumerKey, RequestToken requestToken, ByteBuffer byteBuffer) {
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
        Utf8UrlEncoder.encodeAndAppendQueryElement(stringBuilder, consumerKey.secret);
        stringBuilder.append('&');
        if (requestToken != null && requestToken.secret != null) {
            Utf8UrlEncoder.encodeAndAppendQueryElement(stringBuilder, requestToken.secret);
        }
        byte[] byArray = StringUtils.charSequence2Bytes(stringBuilder, StandardCharsets.UTF_8);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, HMAC_SHA1_ALGORITHM);
        try {
            this.mac.init(secretKeySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException("Failed to init Mac", invalidKeyException);
        }
        this.mac.update(byteBuffer);
        return this.mac.doFinal();
    }

    public static final class Signature {
        private final ConsumerKey consumerAuth;
        private final RequestToken requestToken;
        private final long timestamp;
        private final String nonce;
        final String signature;

        public Signature(ConsumerKey consumerKey, RequestToken requestToken, long l, String string, String string2) {
            this.consumerAuth = consumerKey;
            this.requestToken = requestToken;
            this.timestamp = l;
            this.nonce = string;
            this.signature = string2;
        }

        String computeAuthorizationHeader() {
            StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
            stringBuilder.append("OAuth ");
            stringBuilder.append(OAuthSignatureCalculatorInstance.KEY_OAUTH_CONSUMER_KEY).append("=\"").append(this.consumerAuth.percentEncodedKey).append("\", ");
            if (this.requestToken.key != null) {
                stringBuilder.append(OAuthSignatureCalculatorInstance.KEY_OAUTH_TOKEN).append("=\"").append(this.requestToken.percentEncodedKey).append("\", ");
            }
            stringBuilder.append(OAuthSignatureCalculatorInstance.KEY_OAUTH_SIGNATURE_METHOD).append("=\"").append(OAuthSignatureCalculatorInstance.OAUTH_SIGNATURE_METHOD).append("\", ");
            stringBuilder.append(OAuthSignatureCalculatorInstance.KEY_OAUTH_SIGNATURE).append("=\"");
            Utf8UrlEncoder.encodeAndAppendPercentEncoded(stringBuilder, this.signature).append("\", ");
            stringBuilder.append(OAuthSignatureCalculatorInstance.KEY_OAUTH_TIMESTAMP).append("=\"").append(this.timestamp).append("\", ").append(OAuthSignatureCalculatorInstance.KEY_OAUTH_NONCE).append("=\"").append(Utf8UrlEncoder.percentEncodeQueryElement(this.nonce)).append("\", ").append(OAuthSignatureCalculatorInstance.KEY_OAUTH_VERSION).append("=\"").append(OAuthSignatureCalculatorInstance.OAUTH_VERSION_1_0).append("\"");
            return stringBuilder.toString();
        }

        List<Param> computeParams() {
            ArrayList<Param> arrayList = new ArrayList<Param>(7);
            arrayList.add(new Param(OAuthSignatureCalculatorInstance.KEY_OAUTH_CONSUMER_KEY, this.consumerAuth.key));
            if (this.requestToken.key != null) {
                arrayList.add(new Param(OAuthSignatureCalculatorInstance.KEY_OAUTH_TOKEN, this.requestToken.key));
            }
            arrayList.add(new Param(OAuthSignatureCalculatorInstance.KEY_OAUTH_SIGNATURE_METHOD, OAuthSignatureCalculatorInstance.OAUTH_SIGNATURE_METHOD));
            arrayList.add(new Param(OAuthSignatureCalculatorInstance.KEY_OAUTH_SIGNATURE, this.signature));
            arrayList.add(new Param(OAuthSignatureCalculatorInstance.KEY_OAUTH_TIMESTAMP, String.valueOf(this.timestamp)));
            arrayList.add(new Param(OAuthSignatureCalculatorInstance.KEY_OAUTH_NONCE, this.nonce));
            arrayList.add(new Param(OAuthSignatureCalculatorInstance.KEY_OAUTH_VERSION, OAuthSignatureCalculatorInstance.OAUTH_VERSION_1_0));
            return arrayList;
        }
    }
}

