/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.pool;

import io.gatling.http.client.proxy.ProxyServer;
import io.gatling.http.client.uri.Uri;
import java.util.Objects;

public final class RemoteKey {
    private final String targetHostBaseUrl;
    private final String proxyHost;
    private final int proxyPort;

    public static RemoteKey newKey(Uri uri, ProxyServer proxyServer) {
        String string = uri.getBaseUrl();
        if (proxyServer == null) {
            return new RemoteKey(string, null, 0);
        }
        return new RemoteKey(string, proxyServer.getHost(), proxyServer.getPort());
    }

    private RemoteKey(String string, String string2, int n) {
        this.targetHostBaseUrl = string;
        this.proxyHost = string2;
        this.proxyPort = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RemoteKey remoteKey = (RemoteKey)object;
        if (this.proxyPort != remoteKey.proxyPort) {
            return false;
        }
        if (!this.targetHostBaseUrl.equals(remoteKey.targetHostBaseUrl)) {
            return false;
        }
        return Objects.equals(this.proxyHost, remoteKey.proxyHost);
    }

    public int hashCode() {
        int n = this.targetHostBaseUrl.hashCode();
        n = 31 * n + (this.proxyHost != null ? this.proxyHost.hashCode() : 0);
        n = 31 * n + this.proxyPort;
        return n;
    }

    public String toString() {
        return "RemoteKey{targetHostBaseUrl='" + this.targetHostBaseUrl + "', proxyHost='" + this.proxyHost + "', proxyPort=" + this.proxyPort + "}";
    }
}

