/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.stringchunks;

import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.WritableContent;
import io.gatling.http.client.body.stringchunks.StringChunksRequestBodyBuilder;
import io.gatling.netty.util.StringWithCachedBytes;
import io.netty.buffer.ByteBufAllocator;
import java.util.List;

public final class StringChunksRequestBody
extends RequestBody<List<StringWithCachedBytes>> {
    private final long contentLength;

    public StringChunksRequestBody(List<StringWithCachedBytes> list, String string) {
        super(list, string);
        long l = 0L;
        for (StringWithCachedBytes stringWithCachedBytes : list) {
            l += (long)stringWithCachedBytes.bytes.length;
        }
        this.contentLength = l;
    }

    @Override
    public WritableContent build(ByteBufAllocator byteBufAllocator) {
        return new WritableContent(StringWithCachedBytes.toByteBuf((List)((List)this.content)), this.contentLength);
    }

    @Override
    public RequestBodyBuilder<List<StringWithCachedBytes>> newBuilder() {
        return new StringChunksRequestBodyBuilder((List)this.content);
    }

    @Override
    public byte[] getBytes() {
        byte[] byArray = new byte[(int)this.contentLength];
        int n = 0;
        for (StringWithCachedBytes stringWithCachedBytes : (List)this.content) {
            System.arraycopy(stringWithCachedBytes.bytes, 0, byArray, n, stringWithCachedBytes.bytes.length);
            n += stringWithCachedBytes.bytes.length;
        }
        return byArray;
    }

    public String toString() {
        return "ElRequestBody{content=" + this.content + ", contentType='" + this.contentType + '\'' + '}';
    }
}

