/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketScheme;
import io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class FixedWebSocketClientHandshaker13 {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FixedWebSocketClientHandshaker13.class);
    public static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private String expectedChallengeResponseString;
    private final boolean allowExtensions;
    private final boolean performMasking;
    private final boolean allowMaskMismatch;
    private static final String HTTP_SCHEME_PREFIX = HttpScheme.HTTP + "://";
    private static final String HTTPS_SCHEME_PREFIX = HttpScheme.HTTPS + "://";
    protected static final int DEFAULT_FORCE_CLOSE_TIMEOUT_MILLIS = 10000;
    private final URI uri;
    private final WebSocketVersion version;
    private volatile boolean handshakeComplete;
    private volatile long forceCloseTimeoutMillis = 10000L;
    private volatile int forceCloseInit;
    private static final AtomicIntegerFieldUpdater<FixedWebSocketClientHandshaker13> FORCE_CLOSE_INIT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(FixedWebSocketClientHandshaker13.class, "forceCloseInit");
    private volatile boolean forceCloseComplete;
    private final String expectedSubprotocol;
    private volatile String actualSubprotocol;
    protected final HttpHeaders customHeaders;
    private final int maxFramePayloadLength;
    private final boolean absoluteUpgradeUrl;

    public URI uri() {
        return this.uri;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public int maxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    private void setHandshakeComplete() {
        this.handshakeComplete = true;
    }

    public String expectedSubprotocol() {
        return this.expectedSubprotocol;
    }

    public String actualSubprotocol() {
        return this.actualSubprotocol;
    }

    private void setActualSubprotocol(String string) {
        this.actualSubprotocol = string;
    }

    public long forceCloseTimeoutMillis() {
        return this.forceCloseTimeoutMillis;
    }

    protected boolean isForceCloseComplete() {
        return this.forceCloseComplete;
    }

    public FixedWebSocketClientHandshaker13 setForceCloseTimeoutMillis(long l) {
        this.forceCloseTimeoutMillis = l;
        return this;
    }

    public ChannelFuture handshake(Channel channel) {
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        return this.handshake(channel, channel.newPromise());
    }

    public final ChannelFuture handshake(Channel channel, final ChannelPromise channelPromise) {
        FullHttpRequest fullHttpRequest;
        ChannelPipeline channelPipeline = channel.pipeline();
        HttpResponseDecoder httpResponseDecoder = (HttpResponseDecoder)channelPipeline.get(HttpResponseDecoder.class);
        if (httpResponseDecoder == null && (fullHttpRequest = channelPipeline.get("http")) == null) {
            channelPromise.setFailure((Throwable)new IllegalStateException("ChannelPipeline does not contain an HttpResponseDecoder or HttpClientCodec"));
            return channelPromise;
        }
        fullHttpRequest = this.newHandshakeRequest();
        channel.writeAndFlush((Object)fullHttpRequest).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                if (channelFuture.isSuccess()) {
                    ChannelPipeline channelPipeline = channelFuture.channel().pipeline();
                    ChannelHandlerContext channelHandlerContext = channelPipeline.context(HttpRequestEncoder.class);
                    if (channelHandlerContext == null) {
                        channelHandlerContext = channelPipeline.context("http");
                    }
                    if (channelHandlerContext == null) {
                        channelPromise.setFailure((Throwable)new IllegalStateException("ChannelPipeline does not contain an HttpRequestEncoder or HttpClientCodec"));
                        return;
                    }
                    channelPipeline.addAfter(channelHandlerContext.name(), "ws-encoder", (ChannelHandler)FixedWebSocketClientHandshaker13.this.newWebSocketEncoder());
                    channelPromise.setSuccess();
                } else {
                    channelPromise.setFailure(channelFuture.cause());
                }
            }
        });
        return channelPromise;
    }

    public final void finishHandshake(Channel channel, FullHttpResponse fullHttpResponse) {
        HttpObjectAggregator httpObjectAggregator;
        String string4;
        this.verify(fullHttpResponse);
        String string2 = fullHttpResponse.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        string2 = string2 != null ? string2.trim() : null;
        String string3 = this.expectedSubprotocol != null ? this.expectedSubprotocol : "";
        boolean bl = false;
        if (string3.isEmpty() && string2 == null) {
            bl = true;
            this.setActualSubprotocol(this.expectedSubprotocol);
        } else if (!string3.isEmpty() && string2 != null && !string2.isEmpty()) {
            for (String string4 : string3.split(",")) {
                if (!string4.trim().equals(string2)) continue;
                bl = true;
                this.setActualSubprotocol(string2);
                break;
            }
        }
        if (!bl) {
            throw new WebSocketHandshakeException(String.format("Invalid subprotocol. Actual: %s. Expected one of: %s", string2, this.expectedSubprotocol));
        }
        this.setHandshakeComplete();
        String[] stringArray = channel.pipeline();
        HttpContentDecompressor httpContentDecompressor = (HttpContentDecompressor)stringArray.get(HttpContentDecompressor.class);
        if (httpContentDecompressor != null) {
            stringArray.remove((ChannelHandler)httpContentDecompressor);
        }
        if ((httpObjectAggregator = (HttpObjectAggregator)stringArray.get(HttpObjectAggregator.class)) != null) {
            stringArray.remove((ChannelHandler)httpObjectAggregator);
        }
        if ((string4 = stringArray.context(HttpResponseDecoder.class)) == null) {
            string4 = stringArray.context("http");
            if (string4 == null) {
                throw new IllegalStateException("ChannelPipeline does not contain an HttpRequestEncoder or HttpClientCodec");
            }
            HttpClientCodec httpClientCodec = (HttpClientCodec)string4.handler();
            httpClientCodec.removeOutboundHandler();
            stringArray.addAfter(string4.name(), "ws-decoder", (ChannelHandler)this.newWebsocketDecoder());
            channel.eventLoop().execute(new Runnable((ChannelPipeline)stringArray, httpClientCodec){
                final /* synthetic */ ChannelPipeline val$p;
                final /* synthetic */ HttpClientCodec val$codec;
                {
                    this.val$p = channelPipeline;
                    this.val$codec = httpClientCodec;
                }

                @Override
                public void run() {
                    this.val$p.remove((ChannelHandler)this.val$codec);
                }
            });
        } else {
            if (stringArray.get(HttpRequestEncoder.class) != null) {
                stringArray.remove(HttpRequestEncoder.class);
            }
            String string5 = string4;
            stringArray.addAfter(string5.name(), "ws-decoder", (ChannelHandler)this.newWebsocketDecoder());
            channel.eventLoop().execute(new Runnable((ChannelPipeline)stringArray, (ChannelHandlerContext)string5){
                final /* synthetic */ ChannelPipeline val$p;
                final /* synthetic */ ChannelHandlerContext val$context;
                {
                    this.val$p = channelPipeline;
                    this.val$context = channelHandlerContext;
                }

                @Override
                public void run() {
                    this.val$p.remove(this.val$context.handler());
                }
            });
        }
    }

    public final ChannelFuture processHandshake(Channel channel, HttpResponse httpResponse) {
        return this.processHandshake(channel, httpResponse, channel.newPromise());
    }

    public final ChannelFuture processHandshake(final Channel channel, HttpResponse httpResponse, final ChannelPromise channelPromise) {
        if (httpResponse instanceof FullHttpResponse) {
            try {
                this.finishHandshake(channel, (FullHttpResponse)httpResponse);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            ChannelPipeline channelPipeline = channel.pipeline();
            ChannelHandlerContext channelHandlerContext = channelPipeline.context(HttpResponseDecoder.class);
            if (channelHandlerContext == null && (channelHandlerContext = channelPipeline.context("http")) == null) {
                return channelPromise.setFailure((Throwable)new IllegalStateException("ChannelPipeline does not contain an HttpResponseDecoder or HttpClientCodec"));
            }
            String string = "httpAggregator";
            channelPipeline.addAfter(channelHandlerContext.name(), string, (ChannelHandler)new HttpObjectAggregator(8192));
            channelPipeline.addAfter(string, "handshaker", (ChannelHandler)new SimpleChannelInboundHandler<FullHttpResponse>(){

                protected void channelRead0(ChannelHandlerContext channelHandlerContext, FullHttpResponse fullHttpResponse) throws Exception {
                    channelHandlerContext.pipeline().remove((ChannelHandler)this);
                    try {
                        FixedWebSocketClientHandshaker13.this.finishHandshake(channel, fullHttpResponse);
                        channelPromise.setSuccess();
                    }
                    catch (Throwable throwable) {
                        channelPromise.setFailure(throwable);
                    }
                }

                public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
                    channelHandlerContext.pipeline().remove((ChannelHandler)this);
                    channelPromise.setFailure(throwable);
                }

                public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
                    if (!channelPromise.isDone()) {
                        channelPromise.tryFailure((Throwable)new ClosedChannelException());
                    }
                    channelHandlerContext.fireChannelInactive();
                }
            });
            try {
                channelHandlerContext.fireChannelRead(ReferenceCountUtil.retain((Object)httpResponse));
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        }
        return channelPromise;
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame) {
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        return this.close(channel, closeWebSocketFrame, channel.newPromise());
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        channel.writeAndFlush((Object)closeWebSocketFrame, channelPromise);
        this.applyForceCloseTimeout(channel, (ChannelFuture)channelPromise);
        return channelPromise;
    }

    private void applyForceCloseTimeout(final Channel channel, ChannelFuture channelFuture) {
        final long l = this.forceCloseTimeoutMillis;
        final FixedWebSocketClientHandshaker13 fixedWebSocketClientHandshaker13 = this;
        if (l <= 0L || !channel.isActive() || this.forceCloseInit != 0) {
            return;
        }
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (channelFuture.isSuccess() && channel.isActive() && FORCE_CLOSE_INIT_UPDATER.compareAndSet(fixedWebSocketClientHandshaker13, 0, 1)) {
                    ScheduledFuture scheduledFuture = channel.eventLoop().schedule(new Runnable(){

                        @Override
                        public void run() {
                            if (channel.isActive()) {
                                channel.close();
                                FixedWebSocketClientHandshaker13.this.forceCloseComplete = true;
                            }
                        }
                    }, l, TimeUnit.MILLISECONDS);
                    channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener((Future)scheduledFuture){
                        final /* synthetic */ Future val$forceCloseFuture;
                        {
                            this.val$forceCloseFuture = future;
                        }

                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            this.val$forceCloseFuture.cancel(false);
                        }
                    });
                }
            }
        });
    }

    protected String upgradeUrl(URI uRI) {
        if (this.absoluteUpgradeUrl) {
            return uRI.toString();
        }
        String string = uRI.getRawPath();
        string = string == null || string.isEmpty() ? "/" : string;
        String string2 = uRI.getRawQuery();
        return string2 != null && !string2.isEmpty() ? string + '?' + string2 : string;
    }

    static CharSequence websocketHostValue(URI uRI) {
        int n = uRI.getPort();
        if (n == -1) {
            return uRI.getHost();
        }
        String string = uRI.getHost();
        String string2 = uRI.getScheme();
        if (n == HttpScheme.HTTP.port()) {
            return HttpScheme.HTTP.name().contentEquals((CharSequence)string2) || WebSocketScheme.WS.name().contentEquals((CharSequence)string2) ? string : NetUtil.toSocketAddressString((String)string, (int)n);
        }
        if (n == HttpScheme.HTTPS.port()) {
            return HttpScheme.HTTPS.name().contentEquals((CharSequence)string2) || WebSocketScheme.WSS.name().contentEquals((CharSequence)string2) ? string : NetUtil.toSocketAddressString((String)string, (int)n);
        }
        return NetUtil.toSocketAddressString((String)string, (int)n);
    }

    static CharSequence websocketOriginValue(URI uRI) {
        int n;
        String string;
        String string2 = uRI.getScheme();
        int n2 = uRI.getPort();
        if (WebSocketScheme.WSS.name().contentEquals((CharSequence)string2) || HttpScheme.HTTPS.name().contentEquals((CharSequence)string2) || string2 == null && n2 == WebSocketScheme.WSS.port()) {
            string = HTTPS_SCHEME_PREFIX;
            n = WebSocketScheme.WSS.port();
        } else {
            string = HTTP_SCHEME_PREFIX;
            n = WebSocketScheme.WS.port();
        }
        String string3 = uRI.getHost().toLowerCase(Locale.US);
        if (n2 != n && n2 != -1) {
            return string + NetUtil.toSocketAddressString((String)string3, (int)n2);
        }
        return string + string3;
    }

    public FixedWebSocketClientHandshaker13(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl, HttpHeaders httpHeaders, int n, boolean bl2, boolean bl3, long l, boolean bl4) {
        this.uri = uRI;
        this.version = webSocketVersion;
        this.expectedSubprotocol = string;
        this.customHeaders = httpHeaders;
        this.maxFramePayloadLength = n;
        this.forceCloseTimeoutMillis = l;
        this.absoluteUpgradeUrl = bl4;
        this.allowExtensions = bl;
        this.performMasking = bl2;
        this.allowMaskMismatch = bl3;
    }

    private FullHttpRequest newHandshakeRequest() {
        String string;
        URI uRI = this.uri();
        byte[] byArray = WebSocketUtil.randomBytes((int)16);
        String string2 = WebSocketUtil.base64((byte[])byArray);
        String string3 = string2 + MAGIC_GUID;
        byte[] byArray2 = WebSocketUtil.sha1((byte[])string3.getBytes(CharsetUtil.US_ASCII));
        this.expectedChallengeResponseString = WebSocketUtil.base64((byte[])byArray2);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 13 client handshake key: {}, expected response: {}", (Object)string2, (Object)this.expectedChallengeResponseString);
        }
        DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.upgradeUrl(uRI), Unpooled.EMPTY_BUFFER);
        HttpHeaders httpHeaders = defaultFullHttpRequest.headers();
        if (this.customHeaders != null) {
            httpHeaders.add(this.customHeaders);
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)string2);
        if (!httpHeaders.contains((CharSequence)HttpHeaderNames.HOST)) {
            httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)FixedWebSocketClientHandshaker13.websocketHostValue(uRI));
        }
        if (!httpHeaders.contains((CharSequence)HttpHeaderNames.ORIGIN)) {
            httpHeaders.set((CharSequence)HttpHeaderNames.ORIGIN, (Object)FixedWebSocketClientHandshaker13.websocketOriginValue(uRI));
        }
        if ((string = this.expectedSubprotocol()) != null && !string.isEmpty()) {
            httpHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)string);
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)"13");
        return defaultFullHttpRequest;
    }

    private void verify(FullHttpResponse fullHttpResponse) {
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.SWITCHING_PROTOCOLS;
        HttpHeaders httpHeaders = fullHttpResponse.headers();
        if (!fullHttpResponse.status().equals((Object)httpResponseStatus)) {
            throw new WebSocketHandshakeException("Invalid handshake response getStatus: " + fullHttpResponse.status());
        }
        String string = httpHeaders.get((CharSequence)HttpHeaderNames.UPGRADE);
        if (!HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase((CharSequence)string)) {
            throw new WebSocketHandshakeException("Invalid handshake response upgrade: " + string);
        }
        if (!httpHeaders.containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true)) {
            throw new WebSocketHandshakeException("Invalid handshake response connection: " + httpHeaders.get((CharSequence)HttpHeaderNames.CONNECTION));
        }
        String string2 = httpHeaders.get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT);
        if (string2 == null || !string2.equals(this.expectedChallengeResponseString)) {
            throw new WebSocketHandshakeException(String.format("Invalid challenge. Actual: %s. Expected: %s", string2, this.expectedChallengeResponseString));
        }
    }

    private WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket13FrameDecoder(false, this.allowExtensions, this.maxFramePayloadLength(), this.allowMaskMismatch);
    }

    private WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket13FrameEncoder(this.performMasking);
    }
}

