/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.HttpClientConfig;
import io.gatling.http.client.HttpListener;
import io.gatling.http.client.impl.DefaultHttpClient;
import io.gatling.http.client.impl.Http2Content;
import io.gatling.http.client.impl.HttpTx;
import io.gatling.http.client.impl.request.WritableRequest;
import io.gatling.http.client.impl.request.WritableRequestBuilder;
import io.gatling.http.client.pool.ChannelPool;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2AppHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http2AppHandler.class);
    private static final IOException REMOTELY_CLOSED_EXCEPTION = new IOException("Channel was closed before handshake completed");
    private final DefaultHttpClient client;
    private final Http2Connection connection;
    private final Http2Connection.PropertyKey propertyKey;
    private final Http2ConnectionHandler http2ConnectionHandler;
    private final ChannelPool channelPool;
    private final HttpClientConfig config;
    private int nextStreamId = 1;

    Http2AppHandler(DefaultHttpClient defaultHttpClient, Http2Connection http2Connection, Http2ConnectionHandler http2ConnectionHandler, ChannelPool channelPool, HttpClientConfig httpClientConfig) {
        this.client = defaultHttpClient;
        this.connection = http2Connection;
        this.propertyKey = http2Connection.newKey();
        this.http2ConnectionHandler = http2ConnectionHandler;
        this.channelPool = channelPool;
        this.config = httpClientConfig;
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        HttpTx httpTx = (HttpTx)object;
        this.nextStreamId += 2;
        if (httpTx.requestTimeout.isDone()) {
            this.channelPool.offer(channelHandlerContext.channel());
            return;
        }
        try {
            ChannelFuture channelFuture;
            WritableRequest writableRequest = WritableRequestBuilder.buildRequest(httpTx.request, channelHandlerContext.alloc(), this.config, true);
            LOGGER.debug("Write request {}", (Object)writableRequest);
            httpTx.listener.onWrite(channelHandlerContext.channel());
            if (HttpUtil.is100ContinueExpected((HttpMessage)writableRequest.getRequest())) {
                LOGGER.debug("Delaying body write");
                httpTx.pendingRequestExpectingContinue = writableRequest;
                channelFuture = writableRequest.writeWithoutContent(channelHandlerContext);
            } else {
                channelFuture = writableRequest.write(channelHandlerContext);
            }
            channelFuture.addListener(future -> {
                if (future.isSuccess()) {
                    Http2Stream http2Stream = this.connection.stream(this.nextStreamId);
                    http2Stream.setProperty(this.propertyKey, (Object)httpTx);
                } else {
                    this.crash(channelHandlerContext, future.cause(), httpTx.listener, true);
                }
            });
        }
        catch (Exception exception) {
            this.crash(channelHandlerContext, exception, httpTx.listener, true);
        }
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)object;
            Integer n = httpResponse.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            Http2Stream http2Stream2 = this.connection.stream(n.intValue());
            HttpTx httpTx = (HttpTx)http2Stream2.getProperty(this.propertyKey);
            if (httpTx.requestTimeout.isDone()) {
                httpTx.releasePendingRequestExpectingContinue();
                this.http2ConnectionHandler.resetStream(channelHandlerContext, n.intValue(), 8L, channelHandlerContext.newPromise());
                this.channelPool.offer(channelHandlerContext.channel());
                return;
            }
            HttpResponseStatus httpResponseStatus = httpResponse.status();
            if (httpTx.pendingRequestExpectingContinue != null) {
                if (httpResponseStatus.equals((Object)HttpResponseStatus.CONTINUE)) {
                    LOGGER.debug("Received 100-Continue");
                    return;
                }
                LOGGER.debug("Request was sent with Expect:100-Continue but received response with status {}, dropping", (Object)httpResponseStatus);
                httpTx.releasePendingRequestExpectingContinue();
            }
            httpTx.listener.onHttpResponse(httpResponseStatus, httpResponse.headers());
        } else if (object instanceof Http2Content) {
            Http2Content http2Content = (Http2Content)object;
            int n = http2Content.getStreamId();
            Http2Stream http2Stream3 = this.connection.stream(n);
            HttpTx httpTx = (HttpTx)http2Stream3.getProperty(this.propertyKey);
            if (httpTx.requestTimeout.isDone()) {
                this.http2ConnectionHandler.resetStream(channelHandlerContext, n, 8L, channelHandlerContext.newPromise());
                this.channelPool.offer(channelHandlerContext.channel());
                return;
            }
            HttpContent httpContent = http2Content.getHttpContent();
            boolean bl = httpContent instanceof LastHttpContent;
            if (httpTx.pendingRequestExpectingContinue != null) {
                if (bl) {
                    LOGGER.debug("Received 100-Continue' LastHttpContent, sending body");
                    httpTx.pendingRequestExpectingContinue.writeContent(channelHandlerContext);
                    httpTx.pendingRequestExpectingContinue = null;
                }
                return;
            }
            httpTx.listener.onHttpResponseBodyChunk(httpContent.content(), bl);
            if (bl) {
                httpTx.requestTimeout.cancel();
                this.channelPool.offer(channelHandlerContext.channel());
            }
        } else if (object instanceof GoAwayFrame) {
            GoAwayFrame goAwayFrame = (GoAwayFrame)object;
            LOGGER.debug("Received GOAWAY frame: {}", (Object)goAwayFrame);
            ArrayList<HttpTx> arrayList = new ArrayList<HttpTx>(3);
            try {
                this.connection.forEachActiveStream(http2Stream -> {
                    if (http2Stream.id() > goAwayFrame.lastStreamId) {
                        HttpTx httpTx = (HttpTx)http2Stream.getProperty(this.propertyKey);
                        httpTx.releasePendingRequestExpectingContinue();
                        if (goAwayFrame.errorCode == 0L && this.client.canRetry(httpTx)) {
                            arrayList.add(httpTx);
                        } else {
                            httpTx.listener.onThrowable(REMOTELY_CLOSED_EXCEPTION);
                        }
                    }
                    return true;
                });
            }
            catch (Http2Exception http2Exception) {
                LOGGER.error("Failed to close active streams on GOAWAY", (Throwable)http2Exception);
            }
            if (!arrayList.isEmpty()) {
                this.client.retryHttp2(arrayList, channelHandlerContext.channel().eventLoop());
            }
            channelHandlerContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crash(ChannelHandlerContext channelHandlerContext, Throwable throwable, HttpListener httpListener, boolean bl) {
        try {
            if (httpListener != null) {
                httpListener.onThrowable(throwable);
            }
            this.connection.forEachActiveStream(http2Stream -> {
                HttpTx httpTx = (HttpTx)http2Stream.getProperty(this.propertyKey);
                httpTx.releasePendingRequestExpectingContinue();
                httpTx.listener.onThrowable(throwable);
                return true;
            });
        }
        catch (Http2Exception http2Exception) {
            LOGGER.error("Failed to close active streams", (Throwable)http2Exception);
        }
        finally {
            if (bl) {
                channelHandlerContext.close();
            }
        }
        if (throwable instanceof Error) {
            LOGGER.error("Fatal error", throwable);
            System.exit(1);
        }
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.crash(channelHandlerContext, throwable, null, true);
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.crash(channelHandlerContext, REMOTELY_CLOSED_EXCEPTION, null, false);
    }

    public static final class GoAwayFrame {
        private final int lastStreamId;
        private final long errorCode;

        public GoAwayFrame(int n, long l) {
            this.lastStreamId = n;
            this.errorCode = l;
        }

        public String toString() {
            return "GoAwayFrame{lastStreamId=" + this.lastStreamId + ", errorCode=" + this.errorCode + '}';
        }
    }
}

