/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.uri;

import io.gatling.http.client.Param;
import io.gatling.http.client.uri.UriParser;
import io.gatling.http.client.util.Assertions;
import io.gatling.http.client.util.MiscUtils;
import io.gatling.netty.util.StringBuilderPool;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Uri {
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String WS = "ws";
    public static final String WSS = "wss";
    private final String scheme;
    private final String userInfo;
    private final String host;
    private final int port;
    private final String query;
    private final String path;
    private final String fragment;
    private String url;
    private boolean secured;
    private boolean webSocket;

    public Uri(String string, String string2, String string3, int n, String string4, String string5, String string6) {
        this.scheme = Assertions.assertNotEmpty(string, "scheme");
        this.userInfo = string2;
        this.host = Assertions.assertNotEmpty(string3, "host");
        this.port = n;
        this.path = string4;
        this.query = string5;
        this.fragment = string6;
        this.secured = HTTPS.equals(string) || WSS.equals(string);
        this.webSocket = WS.equals(string) || WSS.equals(string);
    }

    public static Uri create(String string) {
        return Uri.create(null, string);
    }

    public static Uri create(Uri uri, String string) {
        UriParser uriParser = new UriParser();
        uriParser.parse(uri, string);
        if (MiscUtils.isEmpty(uriParser.scheme)) {
            throw new IllegalArgumentException(string + " could not be parsed into a proper Uri, missing scheme");
        }
        if (MiscUtils.isEmpty(uriParser.host)) {
            throw new IllegalArgumentException(string + " could not be parsed into a proper Uri, missing host");
        }
        return new Uri(uriParser.scheme, uriParser.userInfo, uriParser.host, uriParser.port, uriParser.path, uriParser.query, uriParser.fragment);
    }

    public String getQuery() {
        return this.query;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public boolean isWebSocket() {
        return this.webSocket;
    }

    public URI toJavaNetURI() throws URISyntaxException {
        return new URI(this.toUrl());
    }

    public int getExplicitPort() {
        return this.port == -1 ? this.getSchemeDefaultPort() : this.port;
    }

    public int getSchemeDefaultPort() {
        return this.isSecured() ? 443 : 80;
    }

    public String toUrl() {
        if (this.url == null) {
            StringBuilder stringBuilder = this.toBaseUrl0();
            if (this.path != null) {
                stringBuilder.append(this.path);
            }
            if (this.query != null) {
                stringBuilder.append('?').append(this.query);
            }
            this.url = stringBuilder.toString();
        }
        return this.url;
    }

    public String toFullUrl() {
        return this.fragment == null ? this.toUrl() : this.toUrl() + "#" + this.fragment;
    }

    public String toUrlWithoutQuery() {
        StringBuilder stringBuilder = this.toBaseUrl0();
        if (MiscUtils.isNonEmpty(this.path)) {
            stringBuilder.append(this.path);
        }
        return stringBuilder.toString();
    }

    public String getBaseUrl() {
        return this.toBaseUrl0().toString();
    }

    private StringBuilder toBaseUrl0() {
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
        stringBuilder.append(this.scheme).append("://");
        if (this.userInfo != null) {
            stringBuilder.append(this.userInfo).append('@');
        }
        stringBuilder.append(this.host);
        if (this.port != -1 && this.port != this.getSchemeDefaultPort()) {
            stringBuilder.append(':').append(this.port);
        }
        return stringBuilder;
    }

    public String toRelativeUrl() {
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
        if (MiscUtils.isNonEmpty(this.path)) {
            stringBuilder.append(this.path);
        } else {
            stringBuilder.append('/');
        }
        if (this.query != null) {
            stringBuilder.append('?').append(this.query);
        }
        return stringBuilder.toString();
    }

    public String getAuthority() {
        return this.host + ":" + this.getExplicitPort();
    }

    public boolean isSameBase(Uri uri) {
        return this.scheme.equals(uri.getScheme()) && this.host.equals(uri.getHost()) && this.getExplicitPort() == uri.getExplicitPort();
    }

    public String getNonEmptyPath() {
        return MiscUtils.isNonEmpty(this.path) ? this.path : "/";
    }

    public List<Param> getEncodedQueryParams() {
        if (MiscUtils.isNonEmpty(this.query)) {
            ArrayList<Param> arrayList = new ArrayList<Param>(1);
            for (String string : this.query.split("&")) {
                int n = string.indexOf(61);
                if (n <= 0) {
                    arrayList.add(new Param(string, null));
                    continue;
                }
                arrayList.add(new Param(string.substring(0, n), string.substring(n + 1)));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public Uri withNewScheme(String string) {
        return new Uri(string, this.userInfo, this.host, this.port, this.path, this.query, this.fragment);
    }

    public Uri withNewQuery(String string) {
        return new Uri(this.scheme, this.userInfo, this.host, this.port, this.path, string, this.fragment);
    }

    public String toString() {
        return this.toUrl();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.host == null ? 0 : this.host.hashCode());
        n = 31 * n + (this.path == null ? 0 : this.path.hashCode());
        n = 31 * n + this.port;
        n = 31 * n + (this.query == null ? 0 : this.query.hashCode());
        n = 31 * n + (this.scheme == null ? 0 : this.scheme.hashCode());
        n = 31 * n + (this.userInfo == null ? 0 : this.userInfo.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Uri uri = (Uri)object;
        if (this.host == null ? uri.host != null : !this.host.equals(uri.host)) {
            return false;
        }
        if (this.path == null ? uri.path != null : !this.path.equals(uri.path)) {
            return false;
        }
        if (this.port != uri.port) {
            return false;
        }
        if (this.query == null ? uri.query != null : !this.query.equals(uri.query)) {
            return false;
        }
        if (this.scheme == null ? uri.scheme != null : !this.scheme.equals(uri.scheme)) {
            return false;
        }
        return !(this.userInfo == null ? uri.userInfo != null : !this.userInfo.equals(uri.userInfo));
    }
}

