/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client;

import io.gatling.http.client.Request;
import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.proxy.HttpProxyServer;
import io.gatling.http.client.proxy.ProxyServer;
import io.gatling.http.client.realm.BasicRealm;
import io.gatling.http.client.realm.DigestRealm;
import io.gatling.http.client.realm.Realm;
import io.gatling.http.client.resolver.InetAddressNameResolver;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.util.HttpUtils;
import io.gatling.http.client.util.MiscUtils;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.util.AsciiString;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class RequestBuilder {
    private static final AsciiString ACCEPT_ALL_HEADER_VALUE = new AsciiString((CharSequence)"*/*");
    private final String name;
    private final HttpMethod method;
    private final Uri uri;
    private final InetAddressNameResolver nameResolver;
    private HttpHeaders headers = new DefaultHttpHeaders(false);
    private List<Cookie> cookies = Collections.emptyList();
    private RequestBodyBuilder bodyBuilder;
    private long requestTimeout;
    private String virtualHost;
    private boolean autoOrigin;
    private InetAddress localIpV4Address;
    private InetAddress localIpV6Address;
    private Realm realm;
    private ProxyServer proxyServer;
    private Consumer<Request> signatureCalculator;
    private boolean http2Enabled;
    private boolean alpnRequired;
    private boolean http2PriorKnowledge;
    private String wsSubprotocol;
    private Charset defaultCharset = StandardCharsets.UTF_8;

    public RequestBuilder(String string, HttpMethod httpMethod, Uri uri, InetAddressNameResolver inetAddressNameResolver) {
        this.name = string;
        this.method = httpMethod;
        this.uri = uri;
        this.nameResolver = inetAddressNameResolver;
    }

    public Uri getUri() {
        return this.uri;
    }

    public RequestBuilder setHeaders(HttpHeaders httpHeaders) {
        this.headers = httpHeaders;
        return this;
    }

    public RequestBuilder addHeader(CharSequence charSequence, Object object) {
        this.headers.add(charSequence, object);
        return this;
    }

    public RequestBuilder setCookies(List<Cookie> list) {
        this.cookies = list;
        return this;
    }

    public RequestBuilder setBodyBuilder(RequestBodyBuilder requestBodyBuilder) {
        this.bodyBuilder = requestBodyBuilder;
        return this;
    }

    public RequestBuilder setRequestTimeout(long l) {
        this.requestTimeout = l;
        return this;
    }

    public RequestBuilder setVirtualHost(String string) {
        this.virtualHost = string;
        return this;
    }

    public RequestBuilder setAutoOrigin(boolean bl) {
        this.autoOrigin = bl;
        return this;
    }

    public RequestBuilder setLocalIpV4Address(InetAddress inetAddress) {
        this.localIpV4Address = inetAddress;
        return this;
    }

    public RequestBuilder setLocalIpV6Address(InetAddress inetAddress) {
        this.localIpV6Address = inetAddress;
        return this;
    }

    public RequestBuilder setRealm(Realm realm) {
        this.realm = realm;
        return this;
    }

    public RequestBuilder setProxyServer(ProxyServer proxyServer) {
        this.proxyServer = proxyServer;
        return this;
    }

    public RequestBuilder setSignatureCalculator(Consumer<Request> consumer) {
        this.signatureCalculator = consumer;
        return this;
    }

    public RequestBuilder setHttp2Enabled(boolean bl) {
        this.http2Enabled = bl;
        return this;
    }

    public RequestBuilder setAlpnRequired(boolean bl) {
        this.alpnRequired = bl;
        return this;
    }

    public RequestBuilder setHttp2PriorKnowledge(boolean bl) {
        this.http2PriorKnowledge = bl;
        return this;
    }

    public RequestBuilder setDefaultCharset(Charset charset) {
        this.defaultCharset = charset;
        return this;
    }

    public RequestBuilder setWsSubprotocol(String string) {
        this.wsSubprotocol = string;
        return this;
    }

    public String getContentType() {
        return this.headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
    }

    public Request build() {
        Charset charset;
        CharSequence charSequence;
        String string;
        Object object;
        Object object2;
        if (!this.headers.contains((CharSequence)HttpHeaderNames.ACCEPT)) {
            this.headers.set((CharSequence)HttpHeaderNames.ACCEPT, (Object)ACCEPT_ALL_HEADER_VALUE);
        }
        String string2 = null;
        if (this.realm instanceof BasicRealm) {
            string2 = ((BasicRealm)this.realm).getAuthorizationHeader();
        } else if (this.realm instanceof DigestRealm) {
            string2 = ((DigestRealm)this.realm).getAuthorizationHeader(this.method, this.uri);
        }
        if (string2 != null) {
            this.headers.add((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)string2);
        }
        if (!this.uri.isSecured() && this.proxyServer instanceof HttpProxyServer && (object2 = ((HttpProxyServer)this.proxyServer).getRealm()) != null) {
            this.headers.set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)((BasicRealm)object2).getAuthorizationHeader());
        }
        if ((object2 = this.headers.get((CharSequence)HttpHeaderNames.ACCEPT_ENCODING)) != null && (object = HttpUtils.filterOutBrotliFromAcceptEncodingWhenUnavailable((String)object2)) != null) {
            this.headers.set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, object);
        }
        if (MiscUtils.isNonEmpty(this.cookies)) {
            this.headers.set((CharSequence)HttpHeaderNames.COOKIE, (Object)ClientCookieEncoder.LAX.encode(this.cookies));
        }
        if (this.autoOrigin && (object = this.headers.get((CharSequence)HttpHeaderNames.REFERER)) != null && !HttpMethod.GET.equals((Object)this.method) && !HttpMethod.HEAD.equals((Object)this.method) && !this.headers.contains((CharSequence)HttpHeaderNames.ORIGIN) && (string = HttpUtils.originHeader((String)object)) != null) {
            this.headers.set((CharSequence)HttpHeaderNames.ORIGIN, (Object)string);
        }
        if (!this.headers.contains((CharSequence)HttpHeaderNames.HOST)) {
            this.headers.set((CharSequence)HttpHeaderNames.HOST, (Object)(this.virtualHost != null ? this.virtualHost : HttpUtils.hostHeader(this.uri)));
        }
        object = null;
        if (this.bodyBuilder != null && (charSequence = (object = this.bodyBuilder.build(string = this.getContentType(), charset = HttpUtils.extractContentTypeCharsetAttribute(string), this.defaultCharset)).getPatchedContentType()) != null) {
            this.headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)charSequence);
        }
        return new Request(this.name, this.method, this.uri, this.headers, this.cookies != null ? this.cookies : Collections.emptyList(), (RequestBody)object, this.requestTimeout, this.virtualHost, this.autoOrigin, this.localIpV4Address, this.localIpV6Address, this.realm, this.proxyServer, this.signatureCalculator, this.nameResolver, this.http2Enabled, this.alpnRequired, this.http2PriorKnowledge, this.wsSubprotocol);
    }
}

