/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.cache;

import com.ning.http.client.Request;
import com.ning.http.client.cookie.RFC2616DateParser;
import com.ning.http.client.uri.Uri;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.GatlingConfiguration$;
import io.gatling.core.session.Session;
import io.gatling.core.session.Session$;
import io.gatling.core.session.SessionPrivateAttributes$;
import io.gatling.core.util.NumberHelper$;
import io.gatling.core.util.TimeHelper$;
import io.gatling.core.util.cache.SessionCacheHandler;
import io.gatling.core.validation.Validation;
import io.gatling.core.validation.package;
import io.gatling.core.validation.package$;
import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.gatling.http.cache.RequestCacheKey;
import io.gatling.http.config.HttpProtocol;
import io.gatling.http.response.Response;
import java.text.ParsePosition;
import java.util.Date;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class CacheHandling$
implements StrictLogging {
    public static final CacheHandling$ MODULE$;
    private final String HttpExpireCacheAttributeName;
    private final SessionCacheHandler<RequestCacheKey, Object> HttpExpireCacheHandler;
    private final String HttpLastModifiedCacheAttributeName;
    private final SessionCacheHandler<RequestCacheKey, String> HttpLastModifiedCacheHandler;
    private final String HttpEtagCacheAttributeName;
    private final SessionCacheHandler<RequestCacheKey, String> HttpEtagCacheHandler;
    private final String MaxAgePrefix;
    private final String MaxAgeZero;
    private final Function1<Session, Validation<Session>> FlushCache;
    private final Logger logger;

    static {
        new CacheHandling$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String HttpExpireCacheAttributeName() {
        return this.HttpExpireCacheAttributeName;
    }

    private SessionCacheHandler<RequestCacheKey, Object> HttpExpireCacheHandler() {
        return this.HttpExpireCacheHandler;
    }

    public String HttpLastModifiedCacheAttributeName() {
        return this.HttpLastModifiedCacheAttributeName;
    }

    private SessionCacheHandler<RequestCacheKey, String> HttpLastModifiedCacheHandler() {
        return this.HttpLastModifiedCacheHandler;
    }

    public String HttpEtagCacheAttributeName() {
        return this.HttpEtagCacheAttributeName;
    }

    private SessionCacheHandler<RequestCacheKey, String> HttpEtagCacheHandler() {
        return this.HttpEtagCacheHandler;
    }

    public Option<Object> getExpire(Session session, Uri uri2, String method) {
        return this.HttpExpireCacheHandler().getEntry(session, (Object)new RequestCacheKey(uri2, method));
    }

    public Session clearExpire(Session session, Uri uri2, String method) {
        return this.HttpExpireCacheHandler().removeEntry(session, (Object)new RequestCacheKey(uri2, method));
    }

    public Option<String> getLastModified(Session session, Uri uri2, String method) {
        return this.HttpLastModifiedCacheHandler().getEntry(session, (Object)new RequestCacheKey(uri2, method));
    }

    public Option<String> getEtag(Session session, Uri uri2, String method) {
        return this.HttpEtagCacheHandler().getEntry(session, (Object)new RequestCacheKey(uri2, method));
    }

    public String MaxAgePrefix() {
        return this.MaxAgePrefix;
    }

    public String MaxAgeZero() {
        return this.MaxAgeZero;
    }

    public Option<Object> extractExpiresValue(String timestring) {
        String trimmedTimeString = this.removeQuote$1(timestring.trim());
        return Option$.MODULE$.apply((Object)RFC2616DateParser.get().parse(trimmedTimeString, new ParsePosition(0))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Date x$1) {
                return x$1.getTime();
            }
        });
    }

    public Option<Object> extractMaxAgeValue(String s) {
        None$ none$;
        int index = s.indexOf(this.MaxAgePrefix());
        int start2 = this.MaxAgePrefix().length() + index;
        if (index >= 0 && start2 <= s.length()) {
            char c = s.charAt(start2);
            switch (c) {
                default: {
                    if (RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(c))) {
                        none$ = new Some((Object)BoxesRunTime.boxToLong((long)NumberHelper$.MODULE$.extractLongValue(s, start2)));
                        break;
                    }
                    none$ = None$.MODULE$;
                    break;
                }
                case '-': {
                    none$ = new Some((Object)BoxesRunTime.boxToLong((long)-1L));
                    break;
                }
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Object> getResponseExpires(HttpProtocol httpProtocol2, Response response) {
        return this.pragmaNoCache$1(response) || this.cacheControlNoCache$1(response) ? None$.MODULE$ : this.maxAgeAsExpiresValue$1(response).orElse((Function0)new Serializable(response){
            public static final long serialVersionUID = 0L;
            private final Response response$1;

            public final Option<Object> apply() {
                return CacheHandling$.MODULE$.io$gatling$http$cache$CacheHandling$$expiresValue$1(this.response$1);
            }
            {
                this.response$1 = response$1;
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$4) {
                return this.apply$mcZJ$sp(x$4);
            }

            public boolean apply$mcZJ$sp(long x$4) {
                return x$4 > 0L;
            }
        });
    }

    public Function1<Session, Session> cache(HttpProtocol httpProtocol2, Request request, Response response) {
        Function1 function1;
        if (httpProtocol2.requestPart().cache()) {
            RequestCacheKey key = new RequestCacheKey(request.getUri(), request.getMethod());
            Function1 updateExpire = this.updateCache$1(this.HttpExpireCacheHandler(), this.getResponseExpires(httpProtocol2, response), key);
            Function1 updateEtag = this.updateCache$1(this.HttpEtagCacheHandler(), response.header(HeaderNames$.MODULE$.ETag()), key);
            Function1 updateLastModified = this.updateCache$1(this.HttpLastModifiedCacheHandler(), response.header(HeaderNames$.MODULE$.LastModified()), key);
            function1 = updateExpire.andThen(updateEtag).andThen(updateLastModified);
        } else {
            function1 = Session$.MODULE$.Identity();
        }
        return function1;
    }

    public Function1<Session, Validation<Session>> FlushCache() {
        return this.FlushCache;
    }

    private final String removeQuote$1(String s) {
        String string;
        if (s.isEmpty()) {
            string = s;
        } else {
            int start2 = 0;
            int end = s.length();
            if (s.charAt(0) == '\"') {
                ++start2;
            }
            if (s.charAt(s.length() - 1) == '\"') {
                --end;
            }
            string = s.substring(start2, end);
        }
        return string;
    }

    private final boolean pragmaNoCache$1(Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.Pragma()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.contains(HeaderValues$.MODULE$.NoCache());
            }
        });
    }

    private final boolean cacheControlNoCache$1(Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.CacheControl()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String h) {
                return h.contains(HeaderValues$.MODULE$.NoCache()) || h.contains(HeaderValues$.MODULE$.NoStore()) || h.contains(CacheHandling$.MODULE$.MaxAgeZero());
            }
        });
    }

    private final Option maxAgeAsExpiresValue$1(Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.CacheControl()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(String s) {
                return CacheHandling$.MODULE$.extractMaxAgeValue(s);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(long maxAge) {
                return this.apply$mcJJ$sp(maxAge);
            }

            public long apply$mcJJ$sp(long maxAge) {
                return maxAge < 0L ? maxAge : maxAge * 1000L + TimeHelper$.MODULE$.nowMillis();
            }
        });
    }

    public final Option io$gatling$http$cache$CacheHandling$$expiresValue$1(Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.Expires()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(String timestring) {
                return CacheHandling$.MODULE$.extractExpiresValue(timestring);
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$3) {
                return this.apply$mcZJ$sp(x$3);
            }

            public boolean apply$mcZJ$sp(long x$3) {
                return x$3 > TimeHelper$.MODULE$.nowMillis();
            }
        });
    }

    private final Function1 updateCache$1(SessionCacheHandler cacheHandler, Option value, RequestCacheKey key$1) {
        Option option;
        block4: {
            Object object;
            block3: {
                block2: {
                    option = value;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Object v = some.x();
                    object = new Serializable(key$1, cacheHandler, v){
                        public static final long serialVersionUID = 0L;
                        private final RequestCacheKey key$1;
                        private final SessionCacheHandler cacheHandler$1;
                        private final Object v$1;

                        public final Session apply(Session x$5) {
                            return this.cacheHandler$1.addEntry(x$5, (Object)this.key$1, this.v$1);
                        }
                        {
                            this.key$1 = key$1;
                            this.cacheHandler$1 = cacheHandler$1;
                            this.v$1 = v$1;
                        }
                    };
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                object = Session$.MODULE$.Identity();
            }
            return object;
        }
        throw new MatchError((Object)option);
    }

    private CacheHandling$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.HttpExpireCacheAttributeName = new StringBuilder().append((Object)SessionPrivateAttributes$.MODULE$.PrivateAttributePrefix()).append((Object)"http.cache.expireCache").toString();
        this.HttpExpireCacheHandler = new SessionCacheHandler(this.HttpExpireCacheAttributeName(), GatlingConfiguration$.MODULE$.configuration().http().expirePerUserCacheMaxCapacity());
        this.HttpLastModifiedCacheAttributeName = new StringBuilder().append((Object)SessionPrivateAttributes$.MODULE$.PrivateAttributePrefix()).append((Object)"http.cache.lastModifiedCache").toString();
        this.HttpLastModifiedCacheHandler = new SessionCacheHandler(this.HttpLastModifiedCacheAttributeName(), GatlingConfiguration$.MODULE$.configuration().http().lastModifiedPerUserCacheMaxCapacity());
        this.HttpEtagCacheAttributeName = new StringBuilder().append((Object)SessionPrivateAttributes$.MODULE$.PrivateAttributePrefix()).append((Object)"http.cache.etagCache").toString();
        this.HttpEtagCacheHandler = new SessionCacheHandler(this.HttpEtagCacheAttributeName(), GatlingConfiguration$.MODULE$.configuration().http().etagPerUserCacheMaxCapacity());
        this.MaxAgePrefix = "max-age=";
        this.MaxAgeZero = new StringBuilder().append((Object)this.MaxAgePrefix()).append((Object)"0").toString();
        this.FlushCache = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Validation<Session> apply(Session x$6) {
                return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)x$6.removeAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{CacheHandling$.MODULE$.HttpExpireCacheAttributeName(), CacheHandling$.MODULE$.HttpLastModifiedCacheAttributeName(), CacheHandling$.MODULE$.HttpEtagCacheAttributeName()}))));
            }
        };
    }
}

