/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.response;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.gatling.commons.util.CompositeByteArrayInputStream;
import io.gatling.commons.util.FastByteArrayInputStream;
import io.gatling.http.response.InputStreamResponseBody$;
import io.gatling.http.response.ResponseBody;
import io.gatling.http.util.BytesHelper$;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015q!B\u0001\u0003\u0011\u0003Y\u0011aF%oaV$8\u000b\u001e:fC6\u0014Vm\u001d9p]N,'i\u001c3z\u0015\t\u0019A!\u0001\u0005sKN\u0004xN\\:f\u0015\t)a!\u0001\u0003iiR\u0004(BA\u0004\t\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!C\u0001\u0003S>\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qBA\fJ]B,Ho\u0015;sK\u0006l'+Z:q_:\u001cXMQ8esN\u0011Q\u0002\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]iA\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005Y\u0001\"\u0002\u000e\u000e\t\u0003Y\u0012!B1qa2LH\u0003\u0002\u000fx\u0003\u0007\u0001\"\u0001D\u000f\u0007\t9\u0011\u0001AH\n\u0005;Ay\"\u0005\u0005\u0002\rA%\u0011\u0011E\u0001\u0002\r%\u0016\u001c\bo\u001c8tK\n{G-\u001f\t\u0003G)j\u0011\u0001\n\u0006\u0003K\u0019\nAb]2bY\u0006dwnZ4j]\u001eT!a\n\u0015\u0002\u0011QL\b/Z:bM\u0016T\u0011!K\u0001\u0004G>l\u0017BA\u0016%\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u00115j\"\u0011!Q\u0001\n9\naa\u00195v].\u001c\bcA\u00188u9\u0011\u0001'\u000e\b\u0003cQj\u0011A\r\u0006\u0003g)\ta\u0001\u0010:p_Rt\u0014\"A\n\n\u0005Y\u0012\u0012a\u00029bG.\fw-Z\u0005\u0003qe\u00121aU3r\u0015\t1$\u0003E\u0002\u0012wuJ!\u0001\u0010\n\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Eq\u0014BA \u0013\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0005k\"\u0011!Q\u0001\n\t\u000bqa\u00195beN,G\u000f\u0005\u0002D\u00136\tAI\u0003\u0002B\u000b*\u0011aiR\u0001\u0004]&|'\"\u0001%\u0002\t)\fg/Y\u0005\u0003\u0015\u0012\u0013qa\u00115beN,G\u000fC\u0003\u0018;\u0011\u0005A\nF\u0002\u001d\u001b:CQ!L&A\u00029BQ!Q&A\u0002\tCQ\u0001U\u000f\u0005\u0002E\u000baa\u001d;sK\u0006lW#\u0001*\u0011\u0005M+V\"\u0001+\u000b\u0005%9\u0015B\u0001,U\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000fak\u0002\u0019!C\u00053\u0006Y!-\u001f;fg2{\u0017\rZ3e+\u0005Q\u0006CA\t\\\u0013\ta&CA\u0004C_>dW-\u00198\t\u000fyk\u0002\u0019!C\u0005?\u0006y!-\u001f;fg2{\u0017\rZ3e?\u0012*\u0017\u000f\u0006\u0002aGB\u0011\u0011#Y\u0005\u0003EJ\u0011A!\u00168ji\"9A-XA\u0001\u0002\u0004Q\u0016a\u0001=%c!1a-\bQ!\ni\u000bABY=uKNdu.\u00193fI\u0002B\u0001\u0002[\u000f\t\u0006\u0004%\t![\u0001\u0006Ef$Xm]\u000b\u0002u!A1.\bE\u0001B\u0003&!(\u0001\u0004csR,7\u000f\t\u0005\t[vA)\u0019!C\u0001]\u000611\u000f\u001e:j]\u001e,\u0012a\u001c\t\u0003aNl\u0011!\u001d\u0006\u0003e\u001e\u000bA\u0001\\1oO&\u0011A/\u001d\u0002\u0007'R\u0014\u0018N\\4\t\u0011Yl\u0002\u0012!Q!\n=\fqa\u001d;sS:<\u0007\u0005C\u0003.3\u0001\u0007\u0001\u0010E\u00020oe\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\r\t,hMZ3s\u0015\tq\b\"A\u0003oKR$\u00180C\u0002\u0002\u0002m\u0014qAQ=uK\n+h\rC\u0003B3\u0001\u0007!\t")
public class InputStreamResponseBody
implements ResponseBody,
LazyLogging {
    private final Seq<byte[]> chunks;
    private final Charset charset;
    private boolean bytesLoaded;
    private byte[] bytes;
    private String string;
    private final Logger logger;
    private volatile byte bitmap$0;

    public static InputStreamResponseBody apply(Seq<ByteBuf> seq, Charset charset) {
        return InputStreamResponseBody$.MODULE$.apply(seq, charset);
    }

    private byte[] bytes$lzycompute() {
        InputStreamResponseBody inputStreamResponseBody = this;
        synchronized (inputStreamResponseBody) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.bytesLoaded_$eq(true);
                this.bytes = BytesHelper$.MODULE$.byteArraysToByteArray(this.chunks);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.bytes;
    }

    private String string$lzycompute() {
        InputStreamResponseBody inputStreamResponseBody = this;
        synchronized (inputStreamResponseBody) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.string = this.bytesLoaded() ? new String(this.bytes(), this.charset) : this.liftedTree1$1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.string;
    }

    private Logger logger$lzycompute() {
        InputStreamResponseBody inputStreamResponseBody = this;
        synchronized (inputStreamResponseBody) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public InputStream stream() {
        Object object;
        int n = this.chunks.size();
        switch (n) {
            case 0: {
                object = new FastByteArrayInputStream(BytesHelper$.MODULE$.EmptyBytes());
                break;
            }
            case 1: {
                object = new ByteArrayInputStream((byte[])this.chunks.head());
                break;
            }
            default: {
                object = new CompositeByteArrayInputStream(this.chunks);
                break;
            }
        }
        return object;
    }

    private boolean bytesLoaded() {
        return this.bytesLoaded;
    }

    private void bytesLoaded_$eq(boolean x$1) {
        this.bytesLoaded = x$1;
    }

    @Override
    public byte[] bytes() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.bytes$lzycompute() : this.bytes;
    }

    @Override
    public String string() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.string$lzycompute() : this.string;
    }

    private final String liftedTree1$1() {
        String string;
        try {
            string = BytesHelper$.MODULE$.byteArraysToString(this.chunks, this.charset);
        }
        catch (MalformedInputException e) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response body is not valid ", " bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.charset.name()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            string = "";
        }
        return string;
    }

    public InputStreamResponseBody(Seq<byte[]> chunks, Charset charset) {
        this.chunks = chunks;
        this.charset = charset;
        LazyLogging.class.$init$((LazyLogging)this);
        this.bytesLoaded = false;
    }
}

