/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.ws;

import akka.actor.ActorRef;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.gatling.commons.util.Clock;
import io.gatling.core.stats.StatsEngine;
import io.gatling.http.action.ws.fsm.BinaryFrameReceived;
import io.gatling.http.action.ws.fsm.TextFrameReceived;
import io.gatling.http.action.ws.fsm.WebSocketClosed;
import io.gatling.http.action.ws.fsm.WebSocketConnected;
import io.gatling.http.action.ws.fsm.WebSocketCrashed;
import io.gatling.http.client.WebSocket;
import io.gatling.http.client.WebSocketListener;
import io.gatling.http.util.HttpHelper$;
import io.gatling.netty.util.ahc.ByteBufUtils;
import io.gatling.netty.util.ahc.Utf8ByteBufCharsetDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u00015\u0011!bV:MSN$XM\\3s\u0015\t\u0019A!\u0001\u0002xg*\u0011QAB\u0001\u0007C\u000e$\u0018n\u001c8\u000b\u0005\u001dA\u0011\u0001\u00025uiBT!!\u0003\u0006\u0002\u000f\u001d\fG\u000f\\5oO*\t1\"\u0001\u0002j_\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\u0011\u0011CB\u0001\u0007G2LWM\u001c;\n\u0005M\u0001\"!E,fEN{7m[3u\u0019&\u001cH/\u001a8feB\u0011Q\u0003H\u0007\u0002-)\u0011q\u0003G\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u00033i\t\u0001\u0002^=qKN\fg-\u001a\u0006\u00027\u0005\u00191m\\7\n\u0005u1\"a\u0003'bufdunZ4j]\u001eD\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\boN\f5\r^8s!\t\tc%D\u0001#\u0015\t\u0019C%A\u0003bGR|'OC\u0001&\u0003\u0011\t7n[1\n\u0005\u001d\u0012#\u0001C!di>\u0014(+\u001a4\t\u0011%\u0002!\u0011!Q\u0001\n)\n1b\u001d;biN,enZ5oKB\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\u0006gR\fGo\u001d\u0006\u0003_!\tAaY8sK&\u0011\u0011\u0007\f\u0002\f'R\fGo]#oO&tW\r\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0003\u0015\u0019Gn\\2l!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0003vi&d'BA\u001d\t\u0003\u001d\u0019w.\\7p]NL!a\u000f\u001c\u0003\u000b\rcwnY6\t\u000bu\u0002A\u0011\u0001 \u0002\rqJg.\u001b;?)\u0011y\u0014IQ\"\u0011\u0005\u0001\u0003Q\"\u0001\u0002\t\u000b}a\u0004\u0019\u0001\u0011\t\u000b%b\u0004\u0019\u0001\u0016\t\u000bMb\u0004\u0019\u0001\u001b\t\u000f\u0015\u0003\u0001\u0019!C\u0005\r\u000691m\\8lS\u0016\u001cX#A$\u0011\u0007!\u0013VK\u0004\u0002J\u001f:\u0011!*T\u0007\u0002\u0017*\u0011A\nD\u0001\u0007yI|w\u000e\u001e \n\u00039\u000bQa]2bY\u0006L!\u0001U)\u0002\u000fA\f7m[1hK*\ta*\u0003\u0002T)\n!A*[:u\u0015\t\u0001\u0016\u000b\u0005\u0002WA6\tqK\u0003\u0002Y3\u000611m\\8lS\u0016T!a\u0002.\u000b\u0005mc\u0016!B2pI\u0016\u001c'BA/_\u0003\u001dA\u0017M\u001c3mKJT!a\u0018\u0006\u0002\u000b9,G\u000f^=\n\u0005\u0005<&AB\"p_.LW\rC\u0004d\u0001\u0001\u0007I\u0011\u00023\u0002\u0017\r|wn[5fg~#S-\u001d\u000b\u0003K&\u0004\"AZ4\u000e\u0003EK!\u0001[)\u0003\tUs\u0017\u000e\u001e\u0005\bU\n\f\t\u00111\u0001H\u0003\rAH%\r\u0005\u0007Y\u0002\u0001\u000b\u0015B$\u0002\u0011\r|wn[5fg\u0002BQA\u001c\u0001\u0005B=\fab\u001c8IiR\u0004(+Z:q_:\u001cX\rF\u0002faZDQ!]7A\u0002I\f!\u0003\u001b;uaJ+7\u000f]8og\u0016\u001cF/\u0019;vgB\u00111\u000f^\u0007\u00023&\u0011Q/\u0017\u0002\u0013\u0011R$\bOU3ta>t7/Z*uCR,8\u000fC\u0003x[\u0002\u0007\u00010A\u0006iiR\u0004\b*Z1eKJ\u001c\bCA:z\u0013\tQ\u0018LA\u0006IiR\u0004\b*Z1eKJ\u001c\b\"\u0002?\u0001\t\u0003j\u0018aD8o/\u0016\u00147k\\2lKR|\u0005/\u001a8\u0015\u0003\u0015Daa \u0001\u0005B\u0005\u0005\u0011\u0001D8o\u00072|7/\u001a$sC6,GcA3\u0002\u0004!9\u0011Q\u0001@A\u0002\u0005\u001d\u0011!\u00024sC6,\u0007\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055\u0011,\u0001\u0006xK\n\u001cxnY6fibLA!!\u0005\u0002\f\t\u00192\t\\8tK^+'mU8dW\u0016$hI]1nK\"9\u0011Q\u0003\u0001\u0005B\u0005]\u0011aC8o)\u0016DHO\u0012:b[\u0016$2!ZA\r\u0011!\t)!a\u0005A\u0002\u0005m\u0001\u0003BA\u0005\u0003;IA!a\b\u0002\f\t\u0011B+\u001a=u/\u0016\u00147k\\2lKR4%/Y7f\u0011\u001d\t\u0019\u0003\u0001C!\u0003K\tQb\u001c8CS:\f'/\u001f$sC6,GcA3\u0002(!A\u0011QAA\u0011\u0001\u0004\tI\u0003\u0005\u0003\u0002\n\u0005-\u0012\u0002BA\u0017\u0003\u0017\u0011ACQ5oCJLx+\u001a2T_\u000e\\W\r\u001e$sC6,\u0007bBA\u0019\u0001\u0011\u0005\u00131G\u0001\f_:\u0004vN\\4Ge\u0006lW\rF\u0002f\u0003kA\u0001\"a\u000e\u00020\u0001\u0007\u0011\u0011H\u0001\u0013a>twmV3c'>\u001c7.\u001a;Ge\u0006lW\r\u0005\u0003\u0002\n\u0005m\u0012\u0002BA\u001f\u0003\u0017\u0011!\u0003U8oO^+'mU8dW\u0016$hI]1nK\"9\u0011\u0011\t\u0001\u0005B\u0005\r\u0013aC8o)\"\u0014xn^1cY\u0016$2!ZA#\u0011!\t9%a\u0010A\u0002\u0005%\u0013!\u0001;\u0011\u0007!\u000bY%C\u0002\u0002NQ\u0013\u0011\u0002\u00165s_^\f'\r\\3")
public class WsListener
extends WebSocketListener
implements LazyLogging {
    private final ActorRef wsActor;
    private final Clock clock;
    private List<Cookie> cookies;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        WsListener wsListener = this;
        synchronized (wsListener) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private List<Cookie> cookies() {
        return this.cookies;
    }

    private void cookies_$eq(List<Cookie> x$1) {
        this.cookies = x$1;
    }

    public void onHttpResponse(HttpResponseStatus httpResponseStatus, HttpHeaders httpHeaders) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Received response to WebSocket CONNECT: {} {}", new Object[]{httpResponseStatus, httpHeaders});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.cookies_$eq(HttpHelper$.MODULE$.responseCookies(httpHeaders));
    }

    public void onWebSocketOpen() {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.wsActor);
        WebSocketConnected x$1 = new WebSocketConnected((WebSocket)this, this.cookies(), this.clock.nowMillis());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void onCloseFrame(CloseWebSocketFrame frame) {
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.wsActor);
        WebSocketClosed x$3 = new WebSocketClosed(frame.statusCode(), frame.reasonText(), this.clock.nowMillis());
        ActorRef x$4 = qual$2.$bang$default$2((Object)x$3);
        qual$2.$bang((Object)x$3, x$4);
    }

    public void onTextFrame(TextWebSocketFrame frame) {
        ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.wsActor);
        TextFrameReceived x$5 = new TextFrameReceived(Utf8ByteBufCharsetDecoder.decodeUtf8((ByteBuf)frame.content()), this.clock.nowMillis());
        ActorRef x$6 = qual$3.$bang$default$2((Object)x$5);
        qual$3.$bang((Object)x$5, x$6);
    }

    public void onBinaryFrame(BinaryWebSocketFrame frame) {
        ScalaActorRef qual$4 = package$.MODULE$.actorRef2Scala(this.wsActor);
        BinaryFrameReceived x$7 = new BinaryFrameReceived(ByteBufUtils.byteBuf2Bytes((ByteBuf)frame.content()), this.clock.nowMillis());
        ActorRef x$8 = qual$4.$bang$default$2((Object)x$7);
        qual$4.$bang((Object)x$7, x$8);
    }

    public void onPongFrame(PongWebSocketFrame pongWebSocketFrame) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Received PONG frame");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void onThrowable(Throwable t) {
        ScalaActorRef qual$5 = package$.MODULE$.actorRef2Scala(this.wsActor);
        WebSocketCrashed x$9 = new WebSocketCrashed(t, this.clock.nowMillis());
        ActorRef x$10 = qual$5.$bang$default$2((Object)x$9);
        qual$5.$bang((Object)x$9, x$10);
    }

    public WsListener(ActorRef wsActor, StatsEngine statsEngine, Clock clock) {
        this.wsActor = wsActor;
        this.clock = clock;
        LazyLogging.$init$((LazyLogging)this);
        this.cookies = Nil$.MODULE$;
    }
}

