/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.request.builder;

import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.Validation$;
import io.gatling.commons.validation.package;
import io.gatling.core.body.Body;
import io.gatling.core.body.ByteArrayBody;
import io.gatling.core.body.CompositeByteArrayBody;
import io.gatling.core.body.InputStreamBody;
import io.gatling.core.body.PebbleBody;
import io.gatling.core.body.RawFileBody;
import io.gatling.core.body.RawFileBody$;
import io.gatling.core.body.ResourceAndCachedBytes;
import io.gatling.core.body.StringBody;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.util.FileResource;
import io.gatling.core.util.Resource;
import io.gatling.http.HeaderNames$;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.client.Request;
import io.gatling.http.client.RequestBuilder;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.bytearray.ByteArrayRequestBodyBuilder;
import io.gatling.http.client.body.bytearrays.ByteArraysRequestBodyBuilder;
import io.gatling.http.client.body.file.FileRequestBodyBuilder;
import io.gatling.http.client.body.form.FormUrlEncodedRequestBodyBuilder;
import io.gatling.http.client.body.is.InputStreamRequestBodyBuilder;
import io.gatling.http.client.body.multipart.MultipartFormDataRequestBodyBuilder;
import io.gatling.http.client.body.multipart.StringPart;
import io.gatling.http.client.body.string.StringRequestBodyBuilder;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.protocol.Remote$;
import io.gatling.http.request.BodyPart;
import io.gatling.http.request.builder.CommonAttributes;
import io.gatling.http.request.builder.HttpAttributes;
import io.gatling.http.request.builder.RequestExpressionBuilder;
import io.gatling.http.request.builder.RequestExpressionBuilder$;
import io.gatling.http.request.builder.package$;
import io.gatling.http.request.builder.package$HttpParams$;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u00015\u0011A\u0004\u0013;uaJ+\u0017/^3ti\u0016C\bO]3tg&|gNQ;jY\u0012,'O\u0003\u0002\u0004\t\u00059!-^5mI\u0016\u0014(BA\u0003\u0007\u0003\u001d\u0011X-];fgRT!a\u0002\u0005\u0002\t!$H\u000f\u001d\u0006\u0003\u0013)\tqaZ1uY&twMC\u0001\f\u0003\tIwn\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005a\u0011V-];fgR,\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM\u001d\u0005\t'\u0001\u0011\t\u0011)A\u0005)\u0005\u00012m\\7n_:\fE\u000f\u001e:jEV$Xm\u001d\t\u0003\u001fUI!A\u0006\u0002\u0003!\r{W.\\8o\u0003R$(/\u001b2vi\u0016\u001c\b\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011B\r\u0002\u001d!$H\u000f]!uiJL'-\u001e;fgB\u0011qBG\u0005\u00037\t\u0011a\u0002\u0013;ua\u0006#HO]5ckR,7\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003)AG\u000f\u001e9DC\u000eDWm\u001d\t\u0003?\tj\u0011\u0001\t\u0006\u0003C\u0019\tQaY1dQ\u0016L!a\t\u0011\u0003\u0015!#H\u000f]\"bG\",7\u000f\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u00031AG\u000f\u001e9Qe>$xnY8m!\t9#&D\u0001)\u0015\tIc!\u0001\u0005qe>$xnY8m\u0013\tY\u0003F\u0001\u0007IiR\u0004\bK]8u_\u000e|G\u000e\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0007G>tg-[4\u000b\u0005MB\u0011\u0001B2pe\u0016L!!\u000e\u0019\u0003)\u001d\u000bG\u000f\\5oO\u000e{gNZ5hkJ\fG/[8o\u0011\u00159\u0004\u0001\"\u00019\u0003\u0019a\u0014N\\5u}Q1\u0011HO\u001e={y\u0002\"a\u0004\u0001\t\u000bM1\u0004\u0019\u0001\u000b\t\u000ba1\u0004\u0019A\r\t\u000bu1\u0004\u0019\u0001\u0010\t\u000b\u00152\u0004\u0019\u0001\u0014\t\u000b52\u0004\u0019\u0001\u0018\t\u000f\u0001\u0003!\u0019!C\u0005\u0003\u0006\u00192i\u001c8gS\u001e,(/\u001a$pe6\u0004\u0016M]1ngV\t!\t\u0005\u0002D\r:\u0011q\u0002R\u0005\u0003\u000b\n\t\u0001DU3rk\u0016\u001cH/\u0012=qe\u0016\u001c8/[8o\u0005VLG\u000eZ3s\u0013\t9\u0005JA\fSKF,Xm\u001d;Ck&dG-\u001a:D_:4\u0017nZ;sK*\u0011QI\u0001\u0005\u0007\u0015\u0002\u0001\u000b\u0011\u0002\"\u0002)\r{gNZ5hkJ,gi\u001c:n!\u0006\u0014\u0018-\\:!\u0011\u0015a\u0005\u0001\"\u0003N\u0003I\u0019wN\u001c4jOV\u0014XMQ8esB\u000b'\u000f^:\u0015\t9c6-\u001a\t\u0004\u001fR3V\"\u0001)\u000b\u0005E\u0013\u0016A\u0003<bY&$\u0017\r^5p]*\u00111\u000bC\u0001\bG>lWn\u001c8t\u0013\t)\u0006K\u0001\u0006WC2LG-\u0019;j_:\u0004\"a\u0016.\u000e\u0003aS!!\u0017\u0004\u0002\r\rd\u0017.\u001a8u\u0013\tY\u0006L\u0001\bSKF,Xm\u001d;Ck&dG-\u001a:\t\u000bu[\u0005\u0019\u00010\u0002\u000fM,7o]5p]B\u0011q,Y\u0007\u0002A*\u0011QLM\u0005\u0003E\u0002\u0014qaU3tg&|g\u000eC\u0003e\u0017\u0002\u0007a+\u0001\bsKF,Xm\u001d;Ck&dG-\u001a:\t\u000b\u0019\\\u0005\u0019A4\u0002\u0013\t|G-\u001f)beR\u001c\bc\u00015sk:\u0011\u0011n\u001c\b\u0003U6l\u0011a\u001b\u0006\u0003Y2\ta\u0001\u0010:p_Rt\u0014\"\u00018\u0002\u000bM\u001c\u0017\r\\1\n\u0005A\f\u0018a\u00029bG.\fw-\u001a\u0006\u0002]&\u00111\u000f\u001e\u0002\u0005\u0019&\u001cHO\u0003\u0002qcB\u0011ao^\u0007\u0002\t%\u0011\u0001\u0010\u0002\u0002\t\u0005>$\u0017\u0010U1si\")!\u0010\u0001C\u0005w\u000691/\u001a;C_\u0012LH\u0003\u0002(}{zDQ!X=A\u0002yCQ\u0001Z=A\u0002YCaa`=A\u0002\u0005\u0005\u0011\u0001\u00022pIf\u0004B!a\u0001\u0002\b5\u0011\u0011Q\u0001\u0006\u0003\u007fJJA!!\u0003\u0002\u0006\t!!i\u001c3z\u0011!\ti\u0001\u0001b\u0001\n\u0013\t\u0015!D2p]\u001aLw-\u001e:f\u0005>$\u0017\u0010C\u0004\u0002\u0012\u0001\u0001\u000b\u0011\u0002\"\u0002\u001d\r|gNZ5hkJ,'i\u001c3zA!A\u0011Q\u0003\u0001C\u0002\u0013%\u0011)A\fd_:4\u0017nZ;sKB\u0013\u0018n\u001c:L]><H.\u001a3hK\"9\u0011\u0011\u0004\u0001!\u0002\u0013\u0011\u0015\u0001G2p]\u001aLw-\u001e:f!JLwN]&o_^dW\rZ4fA!9\u0011Q\u0004\u0001\u0005R\u0005}\u0011aF2p]\u001aLw-\u001e:f%\u0016\fX/Z:u\u0005VLG\u000eZ3s)\u0015q\u0015\u0011EA\u0012\u0011\u0019i\u00161\u0004a\u0001=\"1A-a\u0007A\u0002YCq!a\n\u0001\t\u0013\tI#A\fd_:4\u0017nZ;sK\u000e\u000b7\r[5oO\"+\u0017\rZ3sgR!\u00111FA\u001b)\u0011\ti#a\r\u0011\u0007]\u000by#C\u0002\u00022a\u0013qAU3rk\u0016\u001cH\u000fC\u0004\u0006\u0003K\u0001\r!!\f\t\ru\u000b)\u00031\u0001_\u0011\u001d\tI\u0004\u0001C!\u0003w\tQAY;jY\u0012,\"!!\u0010\u0011\r\u0005}\u00121KA\u0017\u001d\u0011\t\t%!\u0015\u000f\t\u0005\r\u0013q\n\b\u0005\u0003\u000b\niE\u0004\u0003\u0002H\u0005-cb\u00016\u0002J%\t1\"\u0003\u0002\n\u0015%\u00111\u0007C\u0005\u0003;JJ!\u0001\u001d1\n\t\u0005U\u0013q\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t'B\u00019a\u0001")
public class HttpRequestExpressionBuilder
extends RequestExpressionBuilder {
    private final HttpAttributes httpAttributes;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> ConfigureFormParams;
    private final Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configureBody;
    private final Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configurePriorKnowledge;

    private Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> ConfigureFormParams() {
        return this.ConfigureFormParams;
    }

    private Validation<RequestBuilder> configureBodyParts(Session session, RequestBuilder requestBuilder, List<BodyPart> bodyParts) {
        return package$HttpParams$.MODULE$.mergeWithFormIntoParamJList$extension(package$.MODULE$.HttpParams(this.httpAttributes.formParams()), this.httpAttributes.form(), session).map((Function1 & Serializable & scala.Serializable)params -> {
            Buffer stringParts = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(params).asScala()).map((Function1 & Serializable & scala.Serializable)param -> new StringPart(param.getName(), param.getValue(), this.charset(), null, null, null, null), Buffer$.MODULE$.canBuildFrom());
            return new Tuple2(params, (Object)stringParts);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer stringParts = (Buffer)tuple2._2();
            Validation validation = Validation$.MODULE$.sequence((Seq)bodyParts.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toMultiPart(session), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)parts -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new MultipartFormDataRequestBodyBuilder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)parts.$plus$plus((GenTraversableOnce)stringParts, Seq$.MODULE$.canBuildFrom())).asJava())));
            return validation;
        });
    }

    private Validation<RequestBuilder> setBody(Session session, RequestBuilder requestBuilder, Body body) {
        RawFileBody rawFileBody;
        Some some;
        Validation validation;
        Body body2 = body;
        if (body2 instanceof StringBody) {
            StringBody stringBody = (StringBody)body2;
            Function1 string = stringBody.string();
            validation = ((Validation)string.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)s -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new StringRequestBodyBuilder(s)));
        } else if (body2 instanceof RawFileBody && !(some = RawFileBody$.MODULE$.unapply(rawFileBody = (RawFileBody)body2)).isEmpty()) {
            Function1 resourceWithCachedBytes = (Function1)some.get();
            validation = ((Validation)resourceWithCachedBytes.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                RequestBuilder requestBuilder;
                ResourceAndCachedBytes resourceAndCachedBytes = x0$1;
                if (resourceAndCachedBytes == null) throw new MatchError((Object)resourceAndCachedBytes);
                Resource resource = resourceAndCachedBytes.resource();
                Option cachedBytes = resourceAndCachedBytes.cachedBytes();
                Option option = cachedBytes;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    byte[] bytes = (byte[])some.value();
                    requestBuilder = requestBuilder.setBodyBuilder((RequestBodyBuilder)new ByteArrayRequestBodyBuilder(bytes));
                    return requestBuilder;
                } else {
                    RequestBuilder requestBuilder2;
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    Resource resource2 = resource;
                    if (resource2 instanceof FileResource) {
                        FileResource fileResource = (FileResource)resource2;
                        File file = fileResource.file();
                        requestBuilder2 = requestBuilder.setBodyBuilder((RequestBodyBuilder)new FileRequestBodyBuilder(file));
                    } else {
                        requestBuilder2 = requestBuilder.setBodyBuilder((RequestBodyBuilder)new ByteArrayRequestBodyBuilder(resource.bytes()));
                    }
                    requestBuilder = requestBuilder2;
                }
                return requestBuilder;
            });
        } else if (body2 instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)body2;
            Function1 bytes = byteArrayBody.bytes();
            validation = ((Validation)bytes.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)b -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new ByteArrayRequestBodyBuilder(b)));
        } else if (body2 instanceof CompositeByteArrayBody) {
            CompositeByteArrayBody compositeByteArrayBody = (CompositeByteArrayBody)body2;
            Function1 byteArrays = compositeByteArrayBody.bytes();
            validation = ((Validation)byteArrays.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)bs -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new ByteArraysRequestBodyBuilder((byte[][])bs.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))))));
        } else if (body2 instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)body2;
            Function1 is2 = inputStreamBody.is();
            validation = ((Validation)is2.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)is -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new InputStreamRequestBodyBuilder(is)));
        } else if (body2 instanceof PebbleBody) {
            PebbleBody pebbleBody = (PebbleBody)body2;
            validation = pebbleBody.apply(session).map((Function1 & Serializable & scala.Serializable)s -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new StringRequestBodyBuilder(s)));
        } else {
            throw new MatchError((Object)body2);
        }
        return validation;
    }

    private Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configureBody() {
        return this.configureBody;
    }

    private Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configurePriorKnowledge() {
        return this.configurePriorKnowledge;
    }

    @Override
    public Validation<RequestBuilder> configureRequestBuilder(Session session, RequestBuilder requestBuilder) {
        return super.configureRequestBuilder(session, requestBuilder).flatMap((Function1)this.configureBody().apply((Object)session)).flatMap((Function1)this.configurePriorKnowledge().apply((Object)session));
    }

    private Request configureCachingHeaders(Session session, Request request) {
        this.httpCaches.contentCacheEntry(session, request).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            HttpRequestExpressionBuilder.$anonfun$configureCachingHeaders$1(request, x0$2);
            return BoxedUnit.UNIT;
        });
        return request;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Function1<Session, Validation<Request>> build() {
        void var1_1;
        Function1<Session, Validation<Request>> exp = super.build();
        return this.httpProtocol.requestPart().cache() ? session -> ((Validation)exp.apply(session)).map((Function1 & Serializable & scala.Serializable)request -> this.configureCachingHeaders((Session)session, (Request)request)) : var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$configurePriorKnowledge$3(boolean x$3) {
        return x$3;
    }

    public static final /* synthetic */ void $anonfun$configureCachingHeaders$1(Request request$1, ContentCacheEntry x0$2) {
        ContentCacheEntry contentCacheEntry = x0$2;
        if (contentCacheEntry == null) {
            throw new MatchError((Object)contentCacheEntry);
        }
        Option<String> etag = contentCacheEntry.etag();
        Option<String> lastModified = contentCacheEntry.lastModified();
        etag.foreach((Function1 & Serializable & scala.Serializable)x$4 -> request$1.getHeaders().set(HeaderNames$.MODULE$.IfNoneMatch(), x$4));
        lastModified.foreach((Function1 & Serializable & scala.Serializable)x$5 -> request$1.getHeaders().set(HeaderNames$.MODULE$.IfModifiedSince(), x$5));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HttpRequestExpressionBuilder(CommonAttributes commonAttributes, HttpAttributes httpAttributes, HttpCaches httpCaches, HttpProtocol httpProtocol, GatlingConfiguration configuration) {
        Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> function1;
        this.httpAttributes = httpAttributes;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        super(commonAttributes, httpCaches, httpProtocol, configuration);
        this.ConfigureFormParams = (Function1 & Serializable & scala.Serializable)session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> package$HttpParams$.MODULE$.mergeWithFormIntoParamJList$extension(package$.MODULE$.HttpParams($this.httpAttributes.formParams()), $this.httpAttributes.form(), (Session)session).map((Function1 & Serializable & scala.Serializable)resolvedFormParams -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new FormUrlEncodedRequestBodyBuilder(resolvedFormParams)));
        Predef$.MODULE$.require(httpAttributes.body().isEmpty() || httpAttributes.bodyParts().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Can't have both a body and body parts!");
        Option<Body> option = httpAttributes.body();
        if (option instanceof Some) {
            Some some = (Some)option;
            Body body = (Body)some.value();
            function1 = session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> this.setBody((Session)session, (RequestBuilder)requestBuilder, body);
        } else {
            function1 = httpAttributes.bodyParts().nonEmpty() ? session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> this.configureBodyParts((Session)session, (RequestBuilder)requestBuilder, $this.httpAttributes.bodyParts()) : (httpAttributes.formParams().nonEmpty() || httpAttributes.form().nonEmpty() ? this.ConfigureFormParams() : RequestExpressionBuilder$.MODULE$.ConfigureIdentity());
        }
        this.configureBody = function1;
        this.configurePriorKnowledge = httpProtocol.enginePart().enableHttp2() ? session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> {
            Option<Object> http2PriorKnowledge = $this.httpCaches.isHttp2PriorKnowledge((Session)session, Remote$.MODULE$.apply(requestBuilder.getUri()));
            return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)requestBuilder.setHttp2Enabled(true).setAlpnRequired(http2PriorKnowledge.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HttpRequestExpressionBuilder.$anonfun$configurePriorKnowledge$3(BoxesRunTime.unboxToBoolean((Object)x$3))))).setHttp2PriorKnowledge(http2PriorKnowledge.contains((Object)BoxesRunTime.boxToBoolean((boolean)true)))));
        } : RequestExpressionBuilder$.MODULE$.ConfigureIdentity();
    }
}

