/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.response;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.gatling.commons.util.Bytes$;
import io.gatling.commons.util.CompositeByteArrayInputStream;
import io.gatling.commons.util.FastByteArrayInputStream;
import io.gatling.http.response.InputStreamResponseBody$;
import io.gatling.http.response.ResponseBody;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import scala.Array$;
import scala.Option;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001]<Q!\u0001\u0002\t\u0002-\tq#\u00138qkR\u001cFO]3b[J+7\u000f]8og\u0016\u0014u\u000eZ=\u000b\u0005\r!\u0011\u0001\u0003:fgB|gn]3\u000b\u0005\u00151\u0011\u0001\u00025uiBT!a\u0002\u0005\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011\"\u0001\u0002j_\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!aF%oaV$8\u000b\u001e:fC6\u0014Vm\u001d9p]N,'i\u001c3z'\ti\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006/5!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-AQAG\u0007\u0005\u0002m\tQ!\u00199qYf$2\u0001\b7w!\taQD\u0002\u0003\u000f\u0005\u0001q2\u0003B\u000f\u0011?\t\u0002\"\u0001\u0004\u0011\n\u0005\u0005\u0012!\u0001\u0004*fgB|gn]3C_\u0012L\bCA\u0012+\u001b\u0005!#BA\u0013'\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t9\u0003&\u0001\u0005usB,7/\u00194f\u0015\u0005I\u0013aA2p[&\u00111\u0006\n\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\r\u0003\u0005.;\t\u0005\t\u0015!\u0003/\u0003\u0019\u0019\u0007.\u001e8lgB\u0019qf\u000e\u001e\u000f\u0005A*dBA\u00195\u001b\u0005\u0011$BA\u001a\u000b\u0003\u0019a$o\\8u}%\t1#\u0003\u00027%\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001d:\u0005\r\u0019V-\u001d\u0006\u0003mI\u00012!E\u001e>\u0013\ta$CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0012}%\u0011qH\u0005\u0002\u0005\u0005f$X\r\u0003\u0005B;\t\u0005\t\u0015!\u0003C\u0003\u001d\u0019\u0007.\u0019:tKR\u0004\"aQ%\u000e\u0003\u0011S!!Q#\u000b\u0005\u0019;\u0015a\u00018j_*\t\u0001*\u0001\u0003kCZ\f\u0017B\u0001&E\u0005\u001d\u0019\u0005.\u0019:tKRDQaF\u000f\u0005\u00021#2\u0001H'O\u0011\u0015i3\n1\u0001/\u0011\u0015\t5\n1\u0001C\u0011!\u0001V\u0004#b\u0001\n\u0003\n\u0016AB:ue&tw-F\u0001S!\t\u0019vK\u0004\u0002U+B\u0011\u0011GE\u0005\u0003-J\ta\u0001\u0015:fI\u00164\u0017B\u0001-Z\u0005\u0019\u0019FO]5oO*\u0011aK\u0005\u0005\t7vA)\u0019!C!9\u0006)1\r[1sgV\tQ\fE\u0002\u0012wy\u0003\"!E0\n\u0005\u0001\u0014\"\u0001B\"iCJD\u0001BY\u000f\t\u0006\u0004%\teY\u0001\u0006Ef$Xm]\u000b\u0002u!)Q-\bC!M\u000611\u000f\u001e:fC6,\u0012a\u001a\t\u0003Q*l\u0011!\u001b\u0006\u0003\u0013\u001dK!a[5\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006[e\u0001\r!\u001c\t\u0004_]r\u0007CA8u\u001b\u0005\u0001(BA9s\u0003\u0019\u0011WO\u001a4fe*\u00111\u000fC\u0001\u0006]\u0016$H/_\u0005\u0003kB\u0014qAQ=uK\n+h\rC\u0003B3\u0001\u0007!\t")
public class InputStreamResponseBody
implements ResponseBody,
LazyLogging {
    private String string;
    private char[] chars;
    private byte[] bytes;
    private final Seq<byte[]> chunks;
    private final Charset charset;
    private transient Logger logger;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static InputStreamResponseBody apply(Seq<ByteBuf> seq, Charset charset) {
        return InputStreamResponseBody$.MODULE$.apply(seq, charset);
    }

    private Logger logger$lzycompute() {
        InputStreamResponseBody inputStreamResponseBody = this;
        synchronized (inputStreamResponseBody) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private String string$lzycompute() {
        InputStreamResponseBody inputStreamResponseBody = this;
        synchronized (inputStreamResponseBody) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.string = this.liftedTree1$1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.string;
    }

    @Override
    public String string() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.string$lzycompute() : this.string;
    }

    private char[] chars$lzycompute() {
        InputStreamResponseBody inputStreamResponseBody = this;
        synchronized (inputStreamResponseBody) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.chars = this.string().toCharArray();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.chars;
    }

    @Override
    public char[] chars() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.chars$lzycompute() : this.chars;
    }

    private byte[] bytes$lzycompute() {
        InputStreamResponseBody inputStreamResponseBody = this;
        synchronized (inputStreamResponseBody) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.bytes = Bytes$.MODULE$.byteArraysToByteArray(this.chunks);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.bytes;
    }

    @Override
    public byte[] bytes() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.bytes$lzycompute() : this.bytes;
    }

    @Override
    public InputStream stream() {
        Object object;
        int n = this.chunks.size();
        switch (n) {
            case 0: {
                object = new FastByteArrayInputStream(Array$.MODULE$.emptyByteArray());
                break;
            }
            case 1: {
                object = new ByteArrayInputStream((byte[])this.chunks.head());
                break;
            }
            default: {
                object = new CompositeByteArrayInputStream(this.chunks);
                break;
            }
        }
        return object;
    }

    private final String liftedTree1$1() {
        String string;
        try {
            string = Bytes$.MODULE$.byteArraysToString(this.chunks, this.charset);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(33).append("Response body is not valid ").append(this.charset.name()).append(" bytes").toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            String string2 = "";
            string = string2;
        }
        return string;
    }

    public InputStreamResponseBody(Seq<byte[]> chunks, Charset charset) {
        this.chunks = chunks;
        this.charset = charset;
        LazyLogging.$init$((LazyLogging)this);
    }
}

