/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.fetch;

import com.softwaremill.quicklens.package;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.core.action.Action;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.client.Request;
import io.gatling.http.client.ahc.uri.Uri;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.HttpTxExecutor;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.fetch.ResourceAggregator;
import io.gatling.http.fetch.ResourceFetcher;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.protocol.Remote;
import io.gatling.http.protocol.Remote$;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestConfig;
import io.gatling.http.response.ResponseBuilder;
import io.gatling.http.response.ResponseBuilder$;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5f\u0001\u0002\u00180\u0001aB\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t-\u0002\u0011\t\u0011)A\u0005/\"A\u0011\u000e\u0001B\u0001B\u0003%!\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003r\u0011!!\bA!A!\u0002\u0013)\b\u0002\u0003=\u0001\u0005\u0003\u0005\u000b\u0011B=\t\u0015\u0005\r\u0001A!A!\u0002\u0013\t)\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u0013\u0005%\u0002A1A\u0005\n\u0005-\u0002\u0002CA\u001a\u0001\u0001\u0006I!!\f\t\u0013\u0005U\u0002A1A\u0005\n\u0005]\u0002\u0002CA#\u0001\u0001\u0006I!!\u000f\t\u0017\u0005\u001d\u0003\u00011AA\u0002\u0013%\u0011\u0011\n\u0005\f\u0003+\u0002\u0001\u0019!a\u0001\n\u0013\t9\u0006C\u0006\u0002d\u0001\u0001\r\u0011!Q!\n\u0005-\u0003\"CA3\u0001\t\u0007I\u0011BA4\u0011!\ti\t\u0001Q\u0001\n\u0005%\u0004\"CAH\u0001\t\u0007I\u0011BAI\u0011!\t)\u000b\u0001Q\u0001\n\u0005M\u0005\"CAT\u0001\t\u0007I\u0011BAU\u0011!\t\t\f\u0001Q\u0001\n\u0005-\u0006\"CAZ\u0001\t\u0007I\u0011BA[\u0011!\tI\f\u0001Q\u0001\n\u0005]\u0006\"CA^\u0001\u0001\u0007I\u0011BAU\u0011%\ti\f\u0001a\u0001\n\u0013\ty\f\u0003\u0005\u0002D\u0002\u0001\u000b\u0015BAV\u0011%\t)\r\u0001a\u0001\n\u0013\t9\rC\u0005\u0002V\u0002\u0001\r\u0011\"\u0003\u0002X\"A\u00111\u001c\u0001!B\u0013\tI\rC\u0005\u0002^\u0002\u0011\r\u0011\"\u0003\u0002`\"A\u0011q\u001d\u0001!\u0002\u0013\t\t\u000fC\u0004\u0002j\u0002!\t%!\u0013\t\u000f\u0005-\b\u0001\"\u0011\u0002n\"9\u0011\u0011\u001f\u0001\u0005\n\u0005M\bb\u0002B\u0002\u0001\u0011%!Q\u0001\u0005\b\u0005\u0013\u0001A\u0011\u0002B\u0006\u0011\u001d\u00119\u0002\u0001C\u0005\u00053AqAa\u0007\u0001\t\u0013\u0011i\u0002C\u0004\u0003&\u0001!IAa\n\t\u000f\t=\u0002\u0001\"\u0003\u00032!9!q\b\u0001\u0005\n\t\u0005\u0003b\u0002B>\u0001\u0011\u0005#Q\u0010\u0005\b\u0005\u000f\u0003A\u0011\tBE\u0011\u001d\u0011I\n\u0001C!\u00057CqA!*\u0001\t\u0003\u00129KA\rEK\u001a\fW\u000f\u001c;SKN|WO]2f\u0003\u001e<'/Z4bi>\u0014(B\u0001\u00192\u0003\u00151W\r^2i\u0015\t\u00114'\u0001\u0003iiR\u0004(B\u0001\u001b6\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011AN\u0001\u0003S>\u001c\u0001a\u0005\u0003\u0001s}\u001a\u0005C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$AB!osJ+g\r\u0005\u0002A\u00036\tq&\u0003\u0002C_\t\u0011\"+Z:pkJ\u001cW-Q4he\u0016<\u0017\r^8s!\t!5*D\u0001F\u0015\t1u)\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002I\u0013\u0006AA/\u001f9fg\u00064WMC\u0001K\u0003\r\u0019w.\\\u0005\u0003\u0019\u0016\u0013Qb\u0015;sS\u000e$Hj\\4hS:<\u0017A\u0002:p_R$\u0006\u0010\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u0006\u0011A\u000f\u001f\u0006\u0003'F\na!\u001a8hS:,\u0017BA+Q\u0005\u0019AE\u000f\u001e9Uq\u0006\u0001\u0012N\\5uS\u0006d'+Z:pkJ\u001cWm\u001d\t\u00041\u0002\u001cgBA-_\u001d\tQV,D\u0001\\\u0015\tav'\u0001\u0004=e>|GOP\u0005\u0002y%\u0011qlO\u0001\ba\u0006\u001c7.Y4f\u0013\t\t'MA\u0002TKFT!aX\u001e\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019\f\u0014a\u0002:fcV,7\u000f^\u0005\u0003Q\u0016\u00141\u0002\u0013;uaJ+\u0017/^3ti\u0006Q\u0001\u000e\u001e;q\u0007\u0006\u001c\u0007.Z:\u0011\u0005-tW\"\u00017\u000b\u00055\f\u0014!B2bG\",\u0017BA8m\u0005)AE\u000f\u001e9DC\u000eDWm]\u0001\u0010e\u0016\u001cx.\u001e:dK\u001a+Go\u00195feB\u0011\u0001I]\u0005\u0003g>\u0012qBU3t_V\u00148-\u001a$fi\u000eDWM]\u0001\u000fQR$\b\u000f\u0016=Fq\u0016\u001cW\u000f^8s!\tye/\u0003\u0002x!\nq\u0001\n\u001e;q)b,\u00050Z2vi>\u0014\u0018!B2m_\u000e\\\u0007C\u0001>\u0000\u001b\u0005Y(B\u0001?~\u0003\u0011)H/\u001b7\u000b\u0005y\u001c\u0014aB2p[6|gn]\u0005\u0004\u0003\u0003Y(!B\"m_\u000e\\\u0017!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\r\r|gNZ5h\u0015\r\tyaM\u0001\u0005G>\u0014X-\u0003\u0003\u0002\u0014\u0005%!\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0011\u00033\tY\"!\b\u0002 \u0005\u0005\u00121EA\u0013\u0003O\u0001\"\u0001\u0011\u0001\t\u000b5C\u0001\u0019\u0001(\t\u000bYC\u0001\u0019A,\t\u000b%D\u0001\u0019\u00016\t\u000bAD\u0001\u0019A9\t\u000bQD\u0001\u0019A;\t\u000baD\u0001\u0019A=\t\u000f\u0005\r\u0001\u00021\u0001\u0002\u0006\u0005IA\u000f\u001b:piRdW\rZ\u000b\u0003\u0003[\u00012AOA\u0018\u0013\r\t\td\u000f\u0002\b\u0005>|G.Z1o\u0003)!\bN]8ui2,G\rI\u0001\rQR$\b\u000f\u0015:pi>\u001cw\u000e\\\u000b\u0003\u0003s\u0001B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007f\t\u0014\u0001\u00039s_R|7m\u001c7\n\t\u0005\r\u0013Q\b\u0002\r\u0011R$\b\u000f\u0015:pi>\u001cw\u000e\\\u0001\u000eQR$\b\u000f\u0015:pi>\u001cw\u000e\u001c\u0011\u0002\u000fM,7o]5p]V\u0011\u00111\n\t\u0005\u0003\u001b\n\t&\u0004\u0002\u0002P)!\u0011qIA\u0007\u0013\u0011\t\u0019&a\u0014\u0003\u000fM+7o]5p]\u0006Y1/Z:tS>tw\fJ3r)\u0011\tI&a\u0018\u0011\u0007i\nY&C\u0002\u0002^m\u0012A!\u00168ji\"I\u0011\u0011\r\b\u0002\u0002\u0003\u0007\u00111J\u0001\u0004q\u0012\n\u0014\u0001C:fgNLwN\u001c\u0011\u0002\u0017\u0005d'/Z1esN+WM\\\u000b\u0003\u0003S\u0002b!a\u001b\u0002v\u0005eTBAA7\u0015\u0011\ty'!\u001d\u0002\u000f5,H/\u00192mK*\u0019\u00111O\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002x\u00055$aA*fiB!\u00111PAE\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0015aA;sS*!\u00111QAC\u0003\r\t\u0007n\u0019\u0006\u0004\u0003\u000f\u000b\u0014AB2mS\u0016tG/\u0003\u0003\u0002\f\u0006u$aA+sS\u0006a\u0011\r\u001c:fC\u0012L8+Z3oA\u00059\"-\u001e4gKJ,GMU3t_V\u00148-Z:Cs\"{7\u000f^\u000b\u0003\u0003'\u0003\u0002\"a\u001b\u0002\u0016\u0006e\u0015qT\u0005\u0005\u0003/\u000biGA\u0002NCB\u0004B!a\u000f\u0002\u001c&!\u0011QTA\u001f\u0005\u0019\u0011V-\\8uKB!\u0001,!)d\u0013\r\t\u0019K\u0019\u0002\u0005\u0019&\u001cH/\u0001\rck\u001a4WM]3e%\u0016\u001cx.\u001e:dKN\u0014\u0015\u0010S8ti\u0002\nQ#\\1y\u0007>tg.Z2uS>t7\u000fU3s\u0011>\u001cH/\u0006\u0002\u0002,B\u0019!(!,\n\u0007\u0005=6HA\u0002J]R\fa#\\1y\u0007>tg.Z2uS>t7\u000fU3s\u0011>\u001cH\u000fI\u0001\u0016CZ\f\u0017\u000e\\1cY\u0016$vn[3og\nK\bj\\:u+\t\t9\f\u0005\u0005\u0002l\u0005U\u0015\u0011TAV\u0003Y\tg/Y5mC\ndW\rV8lK:\u001c()\u001f%pgR\u0004\u0013!\u00069f]\u0012Lgn\u001a*fg>,(oY3t\u0007>,h\u000e^\u0001\u001aa\u0016tG-\u001b8h%\u0016\u001cx.\u001e:dKN\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002Z\u0005\u0005\u0007\"CA13\u0005\u0005\t\u0019AAV\u0003Y\u0001XM\u001c3j]\u001e\u0014Vm]8ve\u000e,7oQ8v]R\u0004\u0013\u0001D4m_\n\fGn\u0015;biV\u001cXCAAe!\u0011\tY-!5\u000e\u0005\u00055'bAAh{\u0006)1\u000f^1ug&!\u00111[Ag\u0005\u0019\u0019F/\u0019;vg\u0006\u0001r\r\\8cC2\u001cF/\u0019;vg~#S-\u001d\u000b\u0005\u00033\nI\u000eC\u0005\u0002bq\t\t\u00111\u0001\u0002J\u0006iq\r\\8cC2\u001cF/\u0019;vg\u0002\nab\u001d;beR$\u0016.\\3ti\u0006l\u0007/\u0006\u0002\u0002bB\u0019!(a9\n\u0007\u0005\u00158H\u0001\u0003M_:<\u0017aD:uCJ$H+[7fgR\fW\u000e\u001d\u0011\u0002\u001d\r,(O]3oiN+7o]5p]\u0006)1\u000f^1siR!\u0011\u0011LAx\u0011\u001d\t9%\ta\u0001\u0003\u0017\n\u0001c\u0019:fCR,'+Z:pkJ\u001cW\r\u0016=\u0015\u000b9\u000b)0!?\t\r\u0005](\u00051\u0001d\u0003!\u0011Xm]8ve\u000e,\u0007bBA~E\u0001\u0007\u0011Q`\u0001\u0016SNDE\u000f\u001e93!JLwN]&o_^dW\rZ4f!\u0015Q\u0014q`A\u0017\u0013\r\u0011\ta\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0002)!\fg\u000e\u001a7f\u0007\u0006\u001c\u0007.\u001a3SKN|WO]2f)\u0011\tIFa\u0002\t\r\u0005]8\u00051\u0001d\u0003Y1W\r^2i\u001fJ\u0014UO\u001a4feJ+7o\\;sG\u0016\u001cH\u0003BA-\u0005\u001bAqAa\u0004%\u0001\u0004\u0011\t\"A\u0005sKN|WO]2fgB!\u0001La\u0005d\u0013\r\u0011)B\u0019\u0002\t\u0013R,'/\u00192mK\u0006!Am\u001c8f)\t\tI&A\ntK:$')\u001e4gKJ,GMU3rk\u0016\u001cH\u000f\u0006\u0004\u0002Z\t}!\u0011\u0005\u0005\u0006M\u001a\u0002\ra\u0019\u0005\b\u0005G1\u0003\u0019AAM\u0003\u0019\u0011X-\\8uK\u00069\"/\u001a7fCN,Gk\\6f]\u0006sGmQ8oi&tW/\u001a\u000b\u0007\u00033\u0012ICa\u000b\t\u000f\t\rr\u00051\u0001\u0002\u001a\"9!QF\u0014A\u0002\u00055\u0012aB5t\u0011R$\bOM\u0001\u0010e\u0016\u001cx.\u001e:dK\u001a+Go\u00195fIRQ\u0011\u0011\fB\u001a\u0005k\u0011ID!\u0010\t\u000f\t\r\u0002\u00061\u0001\u0002\u001a\"9!q\u0007\u0015A\u0002\u0005%\u0017AB:uCR,8\u000fC\u0004\u0003<!\u0002\r!!\f\u0002\rMLG.\u001a8u\u0011\u001d\u0011i\u0003\u000ba\u0001\u0003[\t!bY:t\r\u0016$8\r[3e)1\tIFa\u0011\u0003F\t\u001d#\u0011\rB<\u0011\u001d\ty(\u000ba\u0001\u0003sBqAa\u000e*\u0001\u0004\tI\rC\u0004\u0003J%\u0002\rAa\u0013\u0002\u001dI,7\u000f]8og\u0016\u001cF/\u0019;vgB!!Q\nB/\u001b\t\u0011yEC\u00023\u0005#RAAa\u0015\u0003V\u0005)1m\u001c3fG*!!q\u000bB-\u0003\u001dA\u0017M\u001c3mKJT1Aa\u00176\u0003\u0015qW\r\u001e;z\u0013\u0011\u0011yFa\u0014\u0003%!#H\u000f\u001d*fgB|gn]3Ti\u0006$Xo\u001d\u0005\b\u0005GJ\u0003\u0019\u0001B3\u0003Ia\u0017m\u001d;N_\u0012Lg-[3e\u001fJ,E/Y4\u0011\u000bi\nyPa\u001a\u0011\t\t%$\u0011\u000f\b\u0005\u0005W\u0012i\u0007\u0005\u0002[w%\u0019!qN\u001e\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\u0019H!\u001e\u0003\rM#(/\u001b8h\u0015\r\u0011yg\u000f\u0005\b\u0005sJ\u0003\u0019\u0001B4\u0003\u001d\u0019wN\u001c;f]R\f\u0001d\u001c8SK\u001e,H.\u0019:SKN|WO]2f\r\u0016$8\r[3e))\tIFa \u0003\u0002\n\r%Q\u0011\u0005\b\u0003\u007fR\u0003\u0019AA=\u0011\u001d\u00119D\u000ba\u0001\u0003\u0013Dq!a\u0012+\u0001\u0004\tY\u0005C\u0004\u0003<)\u0002\r!!\f\u0002)=t7i]:SKN|WO]2f\r\u0016$8\r[3e)A\tIFa#\u0003\u000e\n=%\u0011\u0013BJ\u0005+\u00139\nC\u0004\u0002\u0000-\u0002\r!!\u001f\t\u000f\t]2\u00061\u0001\u0002J\"9\u0011qI\u0016A\u0002\u0005-\u0003b\u0002B\u001eW\u0001\u0007\u0011Q\u0006\u0005\b\u0005\u0013Z\u0003\u0019\u0001B&\u0011\u001d\u0011\u0019g\u000ba\u0001\u0005KBqA!\u001f,\u0001\u0004\u00119'\u0001\u0006p]J+G-\u001b:fGR$b!!\u0017\u0003\u001e\n\u0005\u0006B\u0002BPY\u0001\u0007a*\u0001\u0006pe&<\u0017N\\1m)bDaAa)-\u0001\u0004q\u0015A\u0003:fI&\u0014Xm\u0019;Uq\u0006\u0001rN\\\"bG\",GMU3t_V\u00148-\u001a\u000b\u0007\u00033\u0012IKa+\t\u000f\u0005}T\u00061\u0001\u0002z!)\u0011+\fa\u0001\u001d\u0002")
public class DefaultResourceAggregator
implements ResourceAggregator,
StrictLogging {
    private final HttpTx rootTx;
    private final Seq<HttpRequest> initialResources;
    private final HttpCaches httpCaches;
    private final ResourceFetcher resourceFetcher;
    private final HttpTxExecutor httpTxExecutor;
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final boolean throttled;
    private final HttpProtocol httpProtocol;
    private Session session;
    private final Set<Uri> alreadySeen;
    private final Map<Remote, List<HttpRequest>> bufferedResourcesByHost;
    private final int maxConnectionsPerHost;
    private final Map<Remote, Object> availableTokensByHost;
    private int pendingResourcesCount;
    private Status globalStatus;
    private final long startTimestamp;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private boolean throttled() {
        return this.throttled;
    }

    private HttpProtocol httpProtocol() {
        return this.httpProtocol;
    }

    private Session session() {
        return this.session;
    }

    private void session_$eq(Session x$1) {
        this.session = x$1;
    }

    private Set<Uri> alreadySeen() {
        return this.alreadySeen;
    }

    private Map<Remote, List<HttpRequest>> bufferedResourcesByHost() {
        return this.bufferedResourcesByHost;
    }

    private int maxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    private Map<Remote, Object> availableTokensByHost() {
        return this.availableTokensByHost;
    }

    private int pendingResourcesCount() {
        return this.pendingResourcesCount;
    }

    private void pendingResourcesCount_$eq(int x$1) {
        this.pendingResourcesCount = x$1;
    }

    private Status globalStatus() {
        return this.globalStatus;
    }

    private void globalStatus_$eq(Status x$1) {
        this.globalStatus = x$1;
    }

    private long startTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public Session currentSession() {
        return this.session();
    }

    @Override
    public void start(Session session) {
        this.session_$eq(session);
        this.fetchOrBufferResources((Iterable<HttpRequest>)this.initialResources);
    }

    private HttpTx createResourceTx(HttpRequest resource, Option<Object> isHttp2PriorKnowledge) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Fetching resource {}", new Object[]{resource.clientRequest().getUri()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Function1<Request, ResponseBuilder> responseBuilderFactory = ResponseBuilder$.MODULE$.newResponseBuilderFactory(resource.requestConfig().checks(), this.httpProtocol().responsePart().inferHtmlResources(), this.clock, this.configuration);
        boolean isAlpnRequired = this.rootTx.request().clientRequest().isHttp2Enabled() && isHttp2PriorKnowledge.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultResourceAggregator.$anonfun$createResourceTx$1(BoxesRunTime.unboxToBoolean((Object)x$1))));
        Session x$4 = this.session();
        HttpRequest fresh$macro$3 = resource;
        HttpRequest x$5 = (HttpRequest)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable & scala.Serializable)(fresh$macro$1, fresh$macro$2) -> {
            Request x$1 = (Request)fresh$macro$2.apply((Object)fresh$macro$1.clientRequest());
            String x$2 = fresh$macro$1.copy$default$1();
            HttpRequestConfig x$3 = fresh$macro$1.copy$default$3();
            return fresh$macro$1.copy(x$2, x$1, x$3);
        }).using((Function1 & Serializable & scala.Serializable)x$3 -> x$3.copyWithAlpnRequiredAndPriorKnowledge(isAlpnRequired, isHttp2PriorKnowledge.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        Function1<Request, ResponseBuilder> x$6 = responseBuilderFactory;
        Some x$7 = new Some((Object)new ResourceTx(this, resource.clientRequest().getUri()));
        int x$8 = 0;
        Action x$9 = this.rootTx.copy$default$4();
        HttpTx resourceTx = this.rootTx.copy(x$4, x$5, x$6, x$9, (Option<ResourceTx>)x$7, x$8);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Creating resourceTx {}", new Object[]{resourceTx});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return resourceTx;
    }

    private void handleCachedResource(HttpRequest resource) {
        BoxedUnit boxedUnit;
        Uri uri = resource.clientRequest().getUri();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Fetching resource {} from cache", new Object[]{uri});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean silent = resource.isSilent(false);
        if (this.httpCaches.isCssCached(uri)) {
            this.onCssResourceFetched(uri, (Status)OK$.MODULE$, this.session(), silent, HttpResponseStatus.NOT_MODIFIED, (Option<String>)None$.MODULE$, "");
        } else {
            this.onRegularResourceFetched(uri, (Status)OK$.MODULE$, this.session(), silent);
        }
    }

    private void fetchOrBufferResources(Iterable<HttpRequest> resources) {
        this.alreadySeen().$plus$plus$eq((TraversableOnce)resources.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.clientRequest().getUri(), Iterable$.MODULE$.canBuildFrom()));
        this.pendingResourcesCount_$eq(this.pendingResourcesCount() + resources.size());
        Tuple2 tuple2 = resources.partition((Function1 & Serializable & scala.Serializable)resource -> BoxesRunTime.boxToBoolean((boolean)DefaultResourceAggregator.$anonfun$fetchOrBufferResources$3(this, resource)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable cached = (Iterable)tuple2._1();
        Iterable nonCached = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)cached, (Object)nonCached);
        Tuple2 tuple23 = tuple22;
        Iterable cached2 = (Iterable)tuple23._1();
        Iterable nonCached2 = (Iterable)tuple23._2();
        cached2.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            this.handleCachedResource(resource);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map requestsByRemote = nonCached2.groupBy((Function1 & Serializable & scala.Serializable)resource -> Remote$.MODULE$.apply(resource.clientRequest().getUri()));
        if (this.httpProtocol().enginePart().enableHttp2()) {
            requestsByRemote.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DefaultResourceAggregator.$anonfun$fetchOrBufferResources$6(this, resources, x0$1);
                return BoxedUnit.UNIT;
            });
        } else {
            requestsByRemote.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                DefaultResourceAggregator.$anonfun$fetchOrBufferResources$8(this, x0$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void done() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("All resources were fetched");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Session newSession = this.rootTx.silent() ? this.session() : this.session().logGroupRequest(this.startTimestamp(), this.clock.nowMillis(), this.globalStatus());
        this.rootTx.next().$bang(newSession);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendBufferedRequest(HttpRequest request, Remote remote) {
        Option<Object> option;
        Some some;
        ContentCacheEntry contentCacheEntry;
        Option<ContentCacheEntry> option2 = this.httpCaches.contentCacheEntry(this.session(), request.clientRequest());
        if (None$.MODULE$.equals(option2)) {
            this.httpTxExecutor.execute(this.createResourceTx(request, this.httpCaches.isHttp2PriorKnowledge(this.session(), remote)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (option2 instanceof Some && (contentCacheEntry = (ContentCacheEntry)(some = (Some)option2).value()) != null && (option = contentCacheEntry.expires()) instanceof Some) {
            Some some2 = (Some)option;
            long expire = BoxesRunTime.unboxToLong((Object)some2.value());
            if (this.clock.nowMillis() > expire) {
                this.session_$eq(this.httpCaches.clearContentCache(this.session(), request.clientRequest()));
                this.httpTxExecutor.execute(this.createResourceTx(request, this.httpCaches.isHttp2PriorKnowledge(this.session(), remote)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        this.handleCachedResource(request);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void releaseTokenAndContinue(Remote remote, boolean isHttp2) {
        Some some;
        List list;
        Option option = this.bufferedResourcesByHost().get((Object)remote);
        boolean bl = option instanceof Some && Nil$.MODULE$.equals(list = (List)(some = (Some)option).value()) ? true : None$.MODULE$.equals(option);
        if (bl) {
            int availableToken = BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)remote));
            this.availableTokensByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)(availableToken == this.maxConnectionsPerHost() ? BoxesRunTime.boxToInteger((int)availableToken) : BoxesRunTime.boxToInteger((int)(availableToken + 1)))));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some2 = (Some)option;
            List requests = (List)some2.value();
            if (isHttp2) {
                this.bufferedResourcesByHost().remove((Object)remote);
                requests.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                    this.sendBufferedRequest(x$9, remote);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                List list2 = requests;
                if (!(list2 instanceof .colon.colon)) {
                    throw new MatchError((Object)list2);
                }
                .colon.colon colon2 = (.colon.colon)list2;
                HttpRequest request = (HttpRequest)colon2.head();
                List tail = colon2.tl$access$1();
                Tuple2 tuple2 = new Tuple2((Object)request, (Object)tail);
                Tuple2 tuple22 = tuple2;
                HttpRequest request2 = (HttpRequest)tuple22._1();
                List tail2 = (List)tuple22._2();
                this.bufferedResourcesByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)tail2));
                this.sendBufferedRequest(request2, remote);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void resourceFetched(Remote remote, Status status, boolean silent, boolean isHttp2) {
        this.pendingResourcesCount_$eq(this.pendingResourcesCount() - 1);
        if (!silent) {
            Status status2 = status;
            KO$ kO$ = KO$.MODULE$;
            if (!(status2 != null ? !status2.equals(kO$) : kO$ != null)) {
                this.globalStatus_$eq((Status)KO$.MODULE$);
            }
        }
        if (this.pendingResourcesCount() == 0) {
            this.done();
        } else {
            this.releaseTokenAndContinue(remote, isHttp2);
        }
    }

    private void cssFetched(Uri uri, Status status, HttpResponseStatus responseStatus, Option<String> lastModifiedOrEtag, String content) {
        block0: {
            List<HttpRequest> cssResources;
            Status status2 = status;
            OK$ oK$ = OK$.MODULE$;
            if ((status2 != null ? !status2.equals(oK$) : oK$ != null) || !(cssResources = this.resourceFetcher.cssFetched(uri, responseStatus, lastModifiedOrEtag, content, this.session(), this.throttled())).nonEmpty()) break block0;
            List filtered = (List)cssResources.filterNot((Function1 & Serializable & scala.Serializable)resource -> BoxesRunTime.boxToBoolean((boolean)DefaultResourceAggregator.$anonfun$cssFetched$1(this, resource)));
            this.fetchOrBufferResources((Iterable<HttpRequest>)filtered);
        }
    }

    @Override
    public void onRegularResourceFetched(Uri uri, Status status, Session session, boolean silent) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Resource {} was fetched", new Object[]{uri});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.session_$eq(session);
        Remote remote = Remote$.MODULE$.apply(uri);
        this.resourceFetched(remote, status, silent, this.httpCaches.isHttp2PriorKnowledge(session, remote).contains((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    @Override
    public void onCssResourceFetched(Uri uri, Status status, Session session, boolean silent, HttpResponseStatus responseStatus, Option<String> lastModifiedOrEtag, String content) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Css resource {} was fetched", new Object[]{uri});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.session_$eq(session);
        this.cssFetched(uri, status, responseStatus, lastModifiedOrEtag, content);
        Remote remote = Remote$.MODULE$.apply(uri);
        this.resourceFetched(remote, status, silent, this.httpCaches.isHttp2PriorKnowledge(session, remote).contains((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    @Override
    public void onRedirect(HttpTx originalTx, HttpTx redirectTx) {
        Remote redirectRemote;
        this.session_$eq(redirectTx.session());
        Uri originUri = originalTx.request().clientRequest().getUri();
        Remote originRemote = Remote$.MODULE$.apply(originUri);
        Uri redirectUri = redirectTx.request().clientRequest().getUri();
        Remote remote = redirectRemote = Remote$.MODULE$.apply(redirectUri);
        Remote remote2 = originRemote;
        if (!(remote != null ? !((Object)remote).equals(remote2) : remote2 != null)) {
            this.sendBufferedRequest(redirectTx.request(), redirectRemote);
        } else {
            this.releaseTokenAndContinue(originRemote, this.httpCaches.isHttp2PriorKnowledge(this.session(), originRemote).contains((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.availableTokensByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)redirectRemote), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)redirectRemote)) - 1))));
            if (BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)redirectRemote)) > 0) {
                this.sendBufferedRequest(redirectTx.request(), redirectRemote);
            } else {
                HttpRequest httpRequest = redirectTx.request();
                this.bufferedResourcesByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)redirectRemote), (Object)((List)this.bufferedResourcesByHost().apply((Object)redirectRemote)).$colon$colon((Object)httpRequest)));
            }
        }
    }

    @Override
    public void onCachedResource(Uri uri, HttpTx tx) {
        Remote remote = Remote$.MODULE$.apply(uri);
        this.resourceFetched(remote, (Status)OK$.MODULE$, tx.silent(), this.httpCaches.isHttp2PriorKnowledge(tx.session(), remote).contains((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    public static final /* synthetic */ boolean $anonfun$createResourceTx$1(boolean x$1) {
        return x$1;
    }

    private final void fetchAndBufferWithTokens$1(Remote remote, Iterable resources, Option isHttp2PriorKnowledge) {
        int availableTokens = BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)remote));
        Tuple2 tuple2 = resources.splitAt(availableTokens);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable immediate = (Iterable)tuple2._1();
        Iterable buffered = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)immediate, (Object)buffered);
        Tuple2 tuple23 = tuple22;
        Iterable immediate2 = (Iterable)tuple23._1();
        Iterable buffered2 = (Iterable)tuple23._2();
        this.fetchHttp1Resources$1(remote, immediate2, isHttp2PriorKnowledge);
        this.bufferResources$1(remote, buffered2);
    }

    private final void fetchHttp1Resources$1(Remote remote, Iterable resources, Option isHttp2PriorKnowledge) {
        this.availableTokensByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)remote)) - resources.size()))));
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            this.httpTxExecutor.execute(this.createResourceTx(resource, (Option<Object>)isHttp2PriorKnowledge));
            return BoxedUnit.UNIT;
        });
    }

    private final void bufferResources$1(Remote remote, Iterable resources) {
        List list = (List)this.bufferedResourcesByHost().apply((Object)remote);
        this.bufferedResourcesByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)resources.toList().$colon$colon$colon(list)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$fetchOrBufferResources$3(DefaultResourceAggregator $this, HttpRequest resource) {
        Option<Object> option;
        Some some;
        ContentCacheEntry contentCacheEntry;
        Request request = resource.clientRequest();
        Option<ContentCacheEntry> option2 = $this.httpCaches.contentCacheEntry($this.session(), request);
        if (None$.MODULE$.equals(option2)) {
            return false;
        }
        if (option2 instanceof Some && (contentCacheEntry = (ContentCacheEntry)(some = (Some)option2).value()) != null && None$.MODULE$.equals(option = contentCacheEntry.expires())) {
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        if (!(option2 instanceof Some)) return true;
        Some some2 = (Some)option2;
        ContentCacheEntry contentCacheEntry2 = (ContentCacheEntry)some2.value();
        if (contentCacheEntry2 == null) return true;
        Option<Object> option3 = contentCacheEntry2.expires();
        if (!(option3 instanceof Some)) return true;
        Some some3 = (Some)option3;
        long expire = BoxesRunTime.unboxToLong((Object)some3.value());
        if ($this.clock.nowMillis() <= expire) return true;
        $this.session_$eq($this.httpCaches.clearContentCache($this.session(), request));
        return false;
    }

    public static final /* synthetic */ void $anonfun$fetchOrBufferResources$6(DefaultResourceAggregator $this, Iterable resources$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Remote remote = (Remote)tuple2._1();
            Iterable res = (Iterable)tuple2._2();
            Option<Object> isHttp2PriorKnowledge = $this.httpCaches.isHttp2PriorKnowledge($this.session(), remote);
            if (isHttp2PriorKnowledge.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                $this.httpTxExecutor.execute((Iterable<HttpTx>)((Iterable)resources$1.map((Function1 & Serializable & scala.Serializable)x$8 -> $this.createResourceTx((HttpRequest)x$8, isHttp2PriorKnowledge), Iterable$.MODULE$.canBuildFrom())));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.fetchAndBufferWithTokens$1(remote, res, isHttp2PriorKnowledge);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$fetchOrBufferResources$8(DefaultResourceAggregator $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Remote remote = (Remote)tuple2._1();
        Iterable res = (Iterable)tuple2._2();
        $this.fetchAndBufferWithTokens$1(remote, res, (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$cssFetched$1(DefaultResourceAggregator $this, HttpRequest resource) {
        return $this.alreadySeen().contains((Object)resource.clientRequest().getUri());
    }

    public DefaultResourceAggregator(HttpTx rootTx, Seq<HttpRequest> initialResources, HttpCaches httpCaches, ResourceFetcher resourceFetcher, HttpTxExecutor httpTxExecutor, Clock clock, GatlingConfiguration configuration) {
        this.rootTx = rootTx;
        this.initialResources = initialResources;
        this.httpCaches = httpCaches;
        this.resourceFetcher = resourceFetcher;
        this.httpTxExecutor = httpTxExecutor;
        this.clock = clock;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        this.throttled = rootTx.request().requestConfig().throttled();
        this.httpProtocol = rootTx.request().requestConfig().httpProtocol();
        this.alreadySeen = Set$.MODULE$.empty();
        this.bufferedResourcesByHost = HashMap$.MODULE$.empty().withDefaultValue((Object)Nil$.MODULE$);
        this.maxConnectionsPerHost = this.httpProtocol().enginePart().maxConnectionsPerHost();
        this.availableTokensByHost = HashMap$.MODULE$.empty().withDefaultValue((Object)BoxesRunTime.boxToInteger((int)this.maxConnectionsPerHost()));
        this.pendingResourcesCount = 0;
        this.globalStatus = OK$.MODULE$;
        this.startTimestamp = clock.nowMillis();
    }
}

