/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine;

import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Hex$;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.check.ChecksumAlgorithm;
import io.gatling.http.client.HttpListener;
import io.gatling.http.client.impl.RequestTimeoutException;
import io.gatling.http.engine.GatlingHttpListener$;
import io.gatling.http.engine.response.ResponseProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.Response;
import io.gatling.http.response.ResponseBody;
import io.gatling.http.response.ResponseBody$;
import io.gatling.http.util.HttpHelper$;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.ssl.NotSslRecordException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.MapFactory;
import scala.collection.MapFactory$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tet!B\u001a5\u0011\u0003id!B 5\u0011\u0003\u0001\u0005\"B)\u0002\t\u0003\u0011\u0006\"B*\u0002\t\u0013!\u0006\"\u00028\u0002\t\u0013yg!B 5\u0001\u0005E\u0001\u0002\u0003;\u0006\u0005\u0003\u0005\u000b\u0011B;\t\u0015\u0005-RA!A!\u0002\u0013\ti\u0003\u0003\u0006\u0002>\u0015\u0011\t\u0011)A\u0005\u0003\u007fAa!U\u0003\u0005\u0002\u0005-\u0003\"CA+\u000b\u0001\u0007I\u0011BA,\u0011%\ty&\u0002a\u0001\n\u0013\t\t\u0007\u0003\u0005\u0002h\u0015\u0001\u000b\u0015BA-\u0011%\tI'\u0002a\u0001\n\u0013\t9\u0006C\u0005\u0002l\u0015\u0001\r\u0011\"\u0003\u0002n!A\u0011\u0011O\u0003!B\u0013\tI\u0006C\u0006\u0002t\u0015\u0001\r\u00111A\u0005\n\u0005]\u0003bCA;\u000b\u0001\u0007\t\u0019!C\u0005\u0003oB1\"a\u001f\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002Z!Y\u0011QP\u0003A\u0002\u0003\u0007I\u0011BA@\u0011-\t9)\u0002a\u0001\u0002\u0004%I!!#\t\u0017\u00055U\u00011A\u0001B\u0003&\u0011\u0011\u0011\u0005\f\u0003\u001f+\u0001\u0019!a\u0001\n\u0013\ty\bC\u0006\u0002\u0012\u0016\u0001\r\u00111A\u0005\n\u0005M\u0005bCAL\u000b\u0001\u0007\t\u0011)Q\u0005\u0003\u0003C1\"!'\u0006\u0001\u0004\u0005\r\u0011\"\u0003\u0002X!Y\u00111T\u0003A\u0002\u0003\u0007I\u0011BAO\u0011-\t\t+\u0002a\u0001\u0002\u0003\u0006K!!\u0017\t\u0017\u0005\rV\u00011AA\u0002\u0013%\u0011Q\u0015\u0005\f\u0003[+\u0001\u0019!a\u0001\n\u0013\ty\u000bC\u0006\u00024\u0016\u0001\r\u0011!Q!\n\u0005\u001d\u0006\u0002\u00031\u0006\u0001\u0004%I!!.\t\u0013\u0005]V\u00011A\u0005\n\u0005e\u0006bBA_\u000b\u0001\u0006K!\u0019\u0005\n\u0003\u007f+\u0001\u0019!C\u0005\u0003\u0003D\u0011\"!3\u0006\u0001\u0004%I!a3\t\u0011\u0005=W\u0001)Q\u0005\u0003\u0007D\u0011\"!5\u0006\u0001\u0004%I!a5\t\u0013\u0005\u001dX\u00011A\u0005\n\u0005%\b\u0002CAw\u000b\u0001\u0006K!!6\t\u0013\u0005=XA1A\u0005\n\u0005E\b\u0002\u0003B\u0010\u000b\u0001\u0006I!a=\t\u000f\t\u0005R\u0001\"\u0011\u0003$!9!QE\u0003\u0005B\t\u001d\u0002b\u0002B\u0016\u000b\u0011\u0005#Q\u0006\u0005\b\u0005g)A\u0011\tB\u001b\u0011\u001d\u0011y$\u0002C\u0005\u0005\u0003BqA!\u0014\u0006\t\u0013\u0011y\u0005C\u0004\u0003N\u0015!IAa\u0017\t\u000f\tET\u0001\"\u0003\u0003$!9!1O\u0003\u0005B\tU\u0014aE$bi2Lgn\u001a%uiBd\u0015n\u001d;f]\u0016\u0014(BA\u001b7\u0003\u0019)gnZ5oK*\u0011q\u0007O\u0001\u0005QR$\bO\u0003\u0002:u\u00059q-\u0019;mS:<'\"A\u001e\u0002\u0005%|7\u0001\u0001\t\u0003}\u0005i\u0011\u0001\u000e\u0002\u0014\u000f\u0006$H.\u001b8h\u0011R$\b\u000fT5ti\u0016tWM]\n\u0004\u0003\u0005;\u0005C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%AB!osJ+g\r\u0005\u0002I\u001f6\t\u0011J\u0003\u0002K\u0017\u0006a1oY1mC2|wmZ5oO*\u0011A*T\u0001\tif\u0004Xm]1gK*\ta*A\u0002d_6L!\u0001U%\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tQ(\u0001\bsKN|GN^3DQ\u0006\u00148/\u001a;\u0015\u0007U{F\u000e\u0005\u0002W;6\tqK\u0003\u0002Y3\u000691\r[1sg\u0016$(B\u0001.\\\u0003\rq\u0017n\u001c\u0006\u00029\u0006!!.\u0019<b\u0013\tqvKA\u0004DQ\u0006\u00148/\u001a;\t\u000b\u0001\u001c\u0001\u0019A1\u0002\u000f!,\u0017\rZ3sgB\u0011!M[\u0007\u0002G*\u0011q\u0007\u001a\u0006\u0003K\u001a\fQaY8eK\u000eT!a\u001a5\u0002\u000f!\fg\u000e\u001a7fe*\u0011\u0011NO\u0001\u0006]\u0016$H/_\u0005\u0003W\u000e\u00141\u0002\u0013;ua\"+\u0017\rZ3sg\")Qn\u0001a\u0001+\u0006qA-\u001a4bk2$8\t[1sg\u0016$\u0018a\u00047pOJ+\u0017/^3ti\u000e\u0013\u0018m\u001d5\u0015\u0007A\u001c(\u0010\u0005\u0002Cc&\u0011!o\u0011\u0002\u0005+:LG\u000fC\u0003u\t\u0001\u0007Q/\u0001\u0002uqB\u0011a\u000f_\u0007\u0002o*\u0011A\u000fN\u0005\u0003s^\u0014a\u0001\u0013;uaRC\b\"B>\u0005\u0001\u0004a\u0018!\u0003;ie><\u0018M\u00197f!\ri\u00181\u0002\b\u0004}\u0006\u001dabA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007a\u0014A\u0002\u001fs_>$h(C\u0001E\u0013\r\tIaQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti!a\u0004\u0003\u0013QC'o\\<bE2,'bAA\u0005\u0007N)Q!a\u0005\u0002 A!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001am\u000bA\u0001\\1oO&!\u0011QDA\f\u0005\u0019y%M[3diB!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&Y\naa\u00197jK:$\u0018\u0002BA\u0015\u0003G\u0011A\u0002\u0013;ua2K7\u000f^3oKJ\fQa\u00197pG.\u0004B!a\f\u0002:5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0003vi&d'bAA\u001cq\u000591m\\7n_:\u001c\u0018\u0002BA\u001e\u0003c\u0011Qa\u00117pG.\f\u0011C]3ta>t7/\u001a)s_\u000e,7o]8s!\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#i\u0005A!/Z:q_:\u001cX-\u0003\u0003\u0002J\u0005\r#!\u0005*fgB|gn]3Qe>\u001cWm]:peRA\u0011QJA(\u0003#\n\u0019\u0006\u0005\u0002?\u000b!)A/\u0003a\u0001k\"9\u00111F\u0005A\u0002\u00055\u0002bBA\u001f\u0013\u0001\u0007\u0011qH\u0001\u0005S:LG/\u0006\u0002\u0002ZA\u0019!)a\u0017\n\u0007\u0005u3IA\u0004C_>dW-\u00198\u0002\u0011%t\u0017\u000e^0%KF$2\u0001]A2\u0011%\t)gCA\u0001\u0002\u0004\tI&A\u0002yIE\nQ!\u001b8ji\u0002\nA\u0001Z8oK\u0006AAm\u001c8f?\u0012*\u0017\u000fF\u0002q\u0003_B\u0011\"!\u001a\u000f\u0003\u0003\u0005\r!!\u0017\u0002\u000b\u0011|g.\u001a\u0011\u0002\u001dM$xN]3Ii6dwJ]\"tg\u0006\u00112\u000f^8sK\"#X\u000e\\(s\u0007N\u001cx\fJ3r)\r\u0001\u0018\u0011\u0010\u0005\n\u0003K\n\u0012\u0011!a\u0001\u00033\nqb\u001d;pe\u0016DE/\u001c7Pe\u000e\u001b8\u000fI\u0001\u0016e\u0016\fX/Z:u'R\f'\u000f\u001e+j[\u0016\u001cH/Y7q+\t\t\t\tE\u0002C\u0003\u0007K1!!\"D\u0005\u0011auN\\4\u00023I,\u0017/^3tiN#\u0018M\u001d;US6,7\u000f^1na~#S-\u001d\u000b\u0004a\u0006-\u0005\"CA3)\u0005\u0005\t\u0019AAA\u0003Y\u0011X-];fgR\u001cF/\u0019:u)&lWm\u001d;b[B\u0004\u0013a\u0005:fcV,7\u000f^#oIRKW.Z:uC6\u0004\u0018a\u0006:fcV,7\u000f^#oIRKW.Z:uC6\u0004x\fJ3r)\r\u0001\u0018Q\u0013\u0005\n\u0003K:\u0012\u0011!a\u0001\u0003\u0003\u000bAC]3rk\u0016\u001cH/\u00128e)&lWm\u001d;b[B\u0004\u0013aB5t\u0011R$\bOM\u0001\fSNDE\u000f\u001e93?\u0012*\u0017\u000fF\u0002q\u0003?C\u0011\"!\u001a\u001b\u0003\u0003\u0005\r!!\u0017\u0002\u0011%\u001c\b\n\u001e;qe\u0001\naa\u001d;biV\u001cXCAAT!\r\u0011\u0017\u0011V\u0005\u0004\u0003W\u001b'A\u0005%uiB\u0014Vm\u001d9p]N,7\u000b^1ukN\f!b\u001d;biV\u001cx\fJ3r)\r\u0001\u0018\u0011\u0017\u0005\n\u0003Kj\u0012\u0011!a\u0001\u0003O\u000bqa\u001d;biV\u001c\b%F\u0001b\u0003-AW-\u00193feN|F%Z9\u0015\u0007A\fY\f\u0003\u0005\u0002f\u0001\n\t\u00111\u0001b\u0003!AW-\u00193feN\u0004\u0013A\u00032pIfdUM\\4uQV\u0011\u00111\u0019\t\u0004\u0005\u0006\u0015\u0017bAAd\u0007\n\u0019\u0011J\u001c;\u0002\u001d\t|G-\u001f'f]\u001e$\bn\u0018\u0013fcR\u0019\u0001/!4\t\u0013\u0005\u00154%!AA\u0002\u0005\r\u0017a\u00032pIfdUM\\4uQ\u0002\naa\u00195v].\u001cXCAAk!\u0015i\u0018q[An\u0013\u0011\tI.a\u0004\u0003\t1K7\u000f\u001e\t\u0005\u0003;\f\u0019/\u0004\u0002\u0002`*\u0019\u0011\u0011\u001d5\u0002\r\t,hMZ3s\u0013\u0011\t)/a8\u0003\u000f\tKH/\u001a\"vM\u0006Q1\r[;oWN|F%Z9\u0015\u0007A\fY\u000fC\u0005\u0002f\u0019\n\t\u00111\u0001\u0002V\u000691\r[;oWN\u0004\u0013a\u00023jO\u0016\u001cHo]\u000b\u0003\u0003g\u0004\u0002\"!>\u0002\u0000\n\r!1C\u0007\u0003\u0003oTA!!?\u0002|\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003{\u001c\u0015AC2pY2,7\r^5p]&!!\u0011AA|\u0005\ri\u0015\r\u001d\t\u0005\u0005\u000b\u0011y!\u0004\u0002\u0003\b)!!\u0011\u0002B\u0006\u0003\u0015\u0019\u0007.Z2l\u0015\r\u0011i\u0001O\u0001\u0005G>\u0014X-\u0003\u0003\u0003\u0012\t\u001d!!E\"iK\u000e\\7/^7BY\u001e|'/\u001b;i[B!!Q\u0003B\u000e\u001b\t\u00119BC\u0002\u0003\u001am\u000b\u0001b]3dkJLG/_\u0005\u0005\u0005;\u00119BA\u0007NKN\u001c\u0018mZ3ES\u001e,7\u000f^\u0001\tI&<Wm\u001d;tA\u00051qN\\*f]\u0012$\u0012\u0001]\u0001\u0014_:\u0004&o\u001c;pG>d\u0017i^1sK:,7o\u001d\u000b\u0004a\n%\u0002bBAMW\u0001\u0007\u0011\u0011L\u0001\u000f_:DE\u000f\u001e9SKN\u0004xN\\:f)\u0015\u0001(q\u0006B\u0019\u0011\u001d\t\u0019\u000b\fa\u0001\u0003OCQ\u0001\u0019\u0017A\u0002\u0005\fqc\u001c8IiR\u0004(+Z:q_:\u001cXMQ8es\u000eCWO\\6\u0015\u000bA\u00149Da\u000f\t\u000f\teR\u00061\u0001\u0002\\\u0006)1\r[;oW\"9!QH\u0017A\u0002\u0005e\u0013\u0001\u00027bgR\fQBY;jY\u0012\u0014Vm\u001d9p]N,WC\u0001B\"!\u0011\u0011)E!\u0013\u000e\u0005\t\u001d#bAA#m%!!1\nB$\u0005)AE\u000f\u001e9SKN,H\u000e^\u0001\rEVLG\u000e\u001a$bS2,(/\u001a\u000b\u0005\u0005#\u00129\u0006\u0005\u0003\u0003F\tM\u0013\u0002\u0002B+\u0005\u000f\u00121\u0002\u0013;ua\u001a\u000b\u0017\u000e\\;sK\"1!\u0011L\u0018A\u0002q\f\u0011\u0001\u001e\u000b\u0005\u0005#\u0012i\u0006C\u0004\u0003`A\u0002\rA!\u0019\u0002\u0019\u0015\u0014(o\u001c:NKN\u001c\u0018mZ3\u0011\t\t\r$1\u000e\b\u0005\u0005K\u00129\u0007\u0005\u0002\u0000\u0007&\u0019!\u0011N\"\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011iGa\u001c\u0003\rM#(/\u001b8h\u0015\r\u0011IgQ\u0001\u000ee\u0016dW-Y:f\u0007\",hn[:\u0002\u0017=tG\u000b\u001b:po\u0006\u0014G.\u001a\u000b\u0004a\n]\u0004\"B>3\u0001\u0004a\b")
public class GatlingHttpListener
implements HttpListener {
    private final HttpTx tx;
    private final Clock clock;
    private final ResponseProcessor responseProcessor;
    private boolean init;
    private boolean done;
    private boolean storeHtmlOrCss;
    private long requestStartTimestamp;
    private long requestEndTimestamp;
    private boolean isHttp2;
    private HttpResponseStatus status;
    private HttpHeaders headers;
    private int bodyLength;
    private List<ByteBuf> chunks;
    private final Map<ChecksumAlgorithm, MessageDigest> digests;

    public void onWrite(Channel x$1) {
        super.onWrite(x$1);
    }

    private boolean init() {
        return this.init;
    }

    private void init_$eq(boolean x$1) {
        this.init = x$1;
    }

    private boolean done() {
        return this.done;
    }

    private void done_$eq(boolean x$1) {
        this.done = x$1;
    }

    private boolean storeHtmlOrCss() {
        return this.storeHtmlOrCss;
    }

    private void storeHtmlOrCss_$eq(boolean x$1) {
        this.storeHtmlOrCss = x$1;
    }

    private long requestStartTimestamp() {
        return this.requestStartTimestamp;
    }

    private void requestStartTimestamp_$eq(long x$1) {
        this.requestStartTimestamp = x$1;
    }

    private long requestEndTimestamp() {
        return this.requestEndTimestamp;
    }

    private void requestEndTimestamp_$eq(long x$1) {
        this.requestEndTimestamp = x$1;
    }

    private boolean isHttp2() {
        return this.isHttp2;
    }

    private void isHttp2_$eq(boolean x$1) {
        this.isHttp2 = x$1;
    }

    private HttpResponseStatus status() {
        return this.status;
    }

    private void status_$eq(HttpResponseStatus x$1) {
        this.status = x$1;
    }

    private HttpHeaders headers() {
        return this.headers;
    }

    private void headers_$eq(HttpHeaders x$1) {
        this.headers = x$1;
    }

    private int bodyLength() {
        return this.bodyLength;
    }

    private void bodyLength_$eq(int x$1) {
        this.bodyLength = x$1;
    }

    private List<ByteBuf> chunks() {
        return this.chunks;
    }

    private void chunks_$eq(List<ByteBuf> x$1) {
        this.chunks = x$1;
    }

    private Map<ChecksumAlgorithm, MessageDigest> digests() {
        return this.digests;
    }

    public void onSend() {
        if (!this.init()) {
            this.init_$eq(true);
            this.requestStartTimestamp_$eq(this.clock.nowMillis());
            return;
        }
    }

    public void onProtocolAwareness(boolean isHttp2) {
        this.isHttp2_$eq(isHttp2);
    }

    public void onHttpResponse(HttpResponseStatus status, HttpHeaders headers) {
        if (!this.done()) {
            this.requestEndTimestamp_$eq(this.clock.nowMillis());
            this.status_$eq(status);
            this.headers_$eq(headers);
            this.storeHtmlOrCss_$eq(this.tx.request().requestConfig().httpProtocol().responsePart().inferHtmlResources() && (HttpHelper$.MODULE$.isHtml(headers) || HttpHelper$.MODULE$.isCss(headers)));
            return;
        }
    }

    public void onHttpResponseBodyChunk(ByteBuf chunk, boolean last) {
        if (!this.done()) {
            this.requestEndTimestamp_$eq(this.clock.nowMillis());
            int chunkLength = chunk.readableBytes();
            if (chunkLength > 0) {
                this.bodyLength_$eq(this.bodyLength() + chunkLength);
                if (this.tx.request().requestConfig().storeBodyParts() || this.storeHtmlOrCss()) {
                    ByteBuf byteBuf = chunk.retain();
                    this.chunks_$eq((List<ByteBuf>)this.chunks().$colon$colon((Object)byteBuf));
                }
                if (this.digests().nonEmpty()) {
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])chunk.nioBuffers()), (Function1 & Serializable)nioBuffer -> {
                        GatlingHttpListener.$anonfun$onHttpResponseBodyChunk$1(this, nioBuffer);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            if (last) {
                this.done_$eq(true);
                try {
                    this.responseProcessor.onComplete(this.buildResponse());
                }
                finally {
                    this.releaseChunks();
                }
                return;
            }
            return;
        }
    }

    private HttpResult buildResponse() {
        Product product;
        if (this.status() == null) {
            return this.buildFailure("How come we're trying to build a response with no status?!");
        }
        try {
            this.requestEndTimestamp_$eq(package$.MODULE$.max(this.requestEndTimestamp(), this.requestStartTimestamp()));
            Map checksums = (Map)this.digests().view().mapValues((Function1 & Serializable)md -> Hex$.MODULE$.toHexString(md.digest())).to(MapFactory$.MODULE$.toFactory((MapFactory)Predef$.MODULE$.Map()));
            List chunksOrderedByArrival = this.chunks().reverse();
            ResponseBody body = ResponseBody$.MODULE$.apply(this.bodyLength(), (List<ByteBuf>)chunksOrderedByArrival, GatlingHttpListener$.MODULE$.io$gatling$http$engine$GatlingHttpListener$$resolveCharset(this.headers(), this.tx.request().requestConfig().defaultCharset()));
            product = new Response(this.tx.request().clientRequest(), this.requestStartTimestamp(), this.requestEndTimestamp(), this.status(), this.headers(), body, (Map<ChecksumAlgorithm, String>)checksums, this.isHttp2());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable t = (Throwable)option.get();
                product = this.buildFailure(t);
            }
            throw throwable;
        }
        return product;
    }

    private HttpFailure buildFailure(Throwable t) {
        Throwable rootCause = Throwables.PimpedException$.MODULE$.rootCause$extension(Throwables$.MODULE$.PimpedException(t));
        Class<?> rootCauseClass = rootCause.getClass();
        String message = rootCauseClass == NotSslRecordException.class ? "i.n.h.s.NotSslRecordException" : (rootCauseClass == RequestTimeoutException.class ? rootCause.getMessage() : Throwables.PimpedException$.MODULE$.detailedMessage$extension(Throwables$.MODULE$.PimpedException(rootCause)));
        return this.buildFailure(message);
    }

    private HttpFailure buildFailure(String errorMessage) {
        return new HttpFailure(this.tx.request().clientRequest(), this.requestStartTimestamp(), this.requestEndTimestamp(), errorMessage);
    }

    private void releaseChunks() {
        this.chunks().foreach((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.release()));
        this.chunks_$eq((List<ByteBuf>)Nil$.MODULE$);
    }

    public void onThrowable(Throwable throwable) {
        if (!this.done()) {
            this.done_$eq(true);
            this.requestEndTimestamp_$eq(this.clock.nowMillis());
            GatlingHttpListener$.MODULE$.io$gatling$http$engine$GatlingHttpListener$$logRequestCrash(this.tx, throwable);
            try {
                this.responseProcessor.onComplete(this.buildFailure(throwable));
            }
            finally {
                this.releaseChunks();
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$onHttpResponseBodyChunk$1(GatlingHttpListener $this, ByteBuffer nioBuffer) {
        $this.digests().values().foreach((Function1 & Serializable)digest -> {
            digest.update(nioBuffer.duplicate());
            return BoxedUnit.UNIT;
        });
    }

    public GatlingHttpListener(HttpTx tx, Clock clock, ResponseProcessor responseProcessor) {
        this.tx = tx;
        this.clock = clock;
        this.responseProcessor = responseProcessor;
        this.init = false;
        this.done = false;
        this.headers = EmptyHttpHeaders.INSTANCE;
        this.bodyLength = 0;
        this.chunks = Nil$.MODULE$;
        this.digests = tx.request().requestConfig().checksumAlgorithms().map((Function1 & Serializable)algorithm -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(algorithm), (Object)algorithm.digest())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }
}

