/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.request.builder;

import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.Validation$;
import io.gatling.core.body.Body;
import io.gatling.core.body.ByteArrayBody;
import io.gatling.core.body.ElBody;
import io.gatling.core.body.InputStreamBody;
import io.gatling.core.body.RawFileBody;
import io.gatling.core.body.ResourceAndCachedBytes;
import io.gatling.core.body.StringBody;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.util.Resource;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.Http2PriorKnowledgeSupport$;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.client.Http2PriorKnowledge;
import io.gatling.http.client.Param;
import io.gatling.http.client.Request;
import io.gatling.http.client.RequestBuilder;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.bytearray.ByteArrayRequestBodyBuilder;
import io.gatling.http.client.body.file.FileRequestBodyBuilder;
import io.gatling.http.client.body.form.FormUrlEncodedRequestBodyBuilder;
import io.gatling.http.client.body.is.InputStreamRequestBodyBuilder;
import io.gatling.http.client.body.multipart.MultipartFormDataRequestBodyBuilder;
import io.gatling.http.client.body.multipart.StringPart;
import io.gatling.http.client.body.string.StringRequestBodyBuilder;
import io.gatling.http.client.body.stringchunks.StringChunksRequestBodyBuilder;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.protocol.Remote$;
import io.gatling.http.request.builder.CommonAttributes;
import io.gatling.http.request.builder.HttpAttributes;
import io.gatling.http.request.builder.HttpParam;
import io.gatling.http.request.builder.HttpRequestExpressionBuilder$;
import io.gatling.http.request.builder.RequestExpressionBuilder;
import io.gatling.http.request.builder.package$;
import io.gatling.http.util.HttpHelper$;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\t}u!\u0002\u0012$\u0011\u0003qc!\u0002\u0019$\u0011\u0003\t\u0004\"\u0002\u001d\u0002\t\u0003I\u0004b\u0002\u001e\u0002\u0005\u0004%Ia\u000f\u0005\u0007?\u0006\u0001\u000b\u0011\u0002\u001f\t\u000b\u001d\fA\u0011\u00025\t\u000f\u0005m\u0011\u0001\"\u0003\u0002\u001e\u0019)\u0001g\t\u0001\u0002F!Q\u0011QJ\u0004\u0003\u0002\u0003\u0006I!a\u0014\t\u0015\u0005UsA!A!\u0002\u0013\t9\u0006\u0003\u0006\u0002^\u001d\u0011\t\u0011)A\u0005\u0003?B!\"a\u001b\b\u0005\u0003\u0005\u000b\u0011BA7\u0011)\tIh\u0002B\u0001B\u0003%\u00111\u0010\u0005\u0007q\u001d!\t!a\"\t\u000f\u0005Uu\u0001\"\u0012\u0002\u0018\"9\u0011\u0011Y\u0004\u0005\n\u0005\r\u0007bBA{\u000f\u0011%\u0011q\u001f\u0005\b\u0005\u001f9A\u0011\u0002B\t\u0011%\u0011\tc\u0002b\u0001\n\u0013\u0011\u0019\u0003\u0003\u0005\u00032\u001d\u0001\u000b\u0011\u0002B\u0013\u0011%\u0011\u0019d\u0002b\u0001\n\u0013\u0011)\u0004\u0003\u0005\u0003>\u001d\u0001\u000b\u0011\u0002B\u001c\u0011%\u0011yd\u0002b\u0001\n\u0013\u0011)\u0004\u0003\u0005\u0003B\u001d\u0001\u000b\u0011\u0002B\u001c\u0011\u001d\u0011\u0019e\u0002C\u0005\u0005\u000bB\u0011B!\u0016\b\u0005\u0004%IA!\u000e\t\u0011\t]s\u0001)A\u0005\u0005oAqA!\u0017\b\t\u0013\u0011Y\u0006C\u0005\u0003h\u001d\u0011\r\u0011\"\u0003\u0003j!A!\u0011O\u0004!\u0002\u0013\u0011Y\u0007C\u0004\u0003t\u001d!\tF!\u001e\t\u000f\tet\u0001\"\u0015\u0003|!9!1R\u0004\u0005\n\t5\u0005b\u0002BM\u000f\u0011\u0005#1T\u0001\u001d\u0011R$\bOU3rk\u0016\u001cH/\u0012=qe\u0016\u001c8/[8o\u0005VLG\u000eZ3s\u0015\t!S%A\u0004ck&dG-\u001a:\u000b\u0005\u0019:\u0013a\u0002:fcV,7\u000f\u001e\u0006\u0003Q%\nA\u0001\u001b;ua*\u0011!fK\u0001\bO\u0006$H.\u001b8h\u0015\u0005a\u0013AA5p\u0007\u0001\u0001\"aL\u0001\u000e\u0003\r\u0012A\u0004\u0013;uaJ+\u0017/^3ti\u0016C\bO]3tg&|gNQ;jY\u0012,'o\u0005\u0002\u0002eA\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0018\u00023\t|G-\u001f)beR\u001cHk\\'vYRL\u0007/\u0019:ugj+'o\\\u000b\u0002yA\u0019QH\u0011#\u000e\u0003yR!a\u0010!\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002BS\u000591m\\7n_:\u001c\u0018BA\"?\u0005)1\u0016\r\\5eCRLwN\u001c\t\u0004\u000b6\u0003fB\u0001$L\u001d\t9%*D\u0001I\u0015\tIU&\u0001\u0004=e>|GOP\u0005\u0002k%\u0011A\nN\u0001\ba\u0006\u001c7.Y4f\u0013\tquJ\u0001\u0003MSN$(B\u0001'5a\t\tV\fE\u0002S3nk\u0011a\u0015\u0006\u0003)V\u000b\u0011\"\\;mi&\u0004\u0018M\u001d;\u000b\u0005Y;\u0016\u0001\u00022pIfT!\u0001W\u0014\u0002\r\rd\u0017.\u001a8u\u0013\tQ6K\u0001\u0003QCJ$\bC\u0001/^\u0019\u0001!\u0011B\u0018\u0003\u0002\u0002\u0003\u0005)\u0011\u00011\u0003\u0007}#\u0013'\u0001\u000ec_\u0012L\b+\u0019:ugR{W*\u001e7uSB\f'\u000f^:[KJ|\u0007%\u0005\u0002bIB\u00111GY\u0005\u0003GR\u0012qAT8uQ&tw\r\u0005\u00024K&\u0011a\r\u000e\u0002\u0004\u0003:L\u0018!\u00062pIf\u0004\u0016M\u001d;t)>lU\u000f\u001c;ja\u0006\u0014Ho\u001d\u000b\u0004SB<\bcA\u001fCUB\u0019Q)T61\u00051t\u0007c\u0001*Z[B\u0011AL\u001c\u0003\n_\u0016\t\t\u0011!A\u0003\u0002\u0001\u00141a\u0018\u00133\u0011\u0015\tX\u00011\u0001s\u0003%\u0011w\u000eZ=QCJ$8\u000fE\u0002F\u001bN\u0004\"\u0001^;\u000e\u0003\u0015J!A^\u0013\u0003\u0011\t{G-\u001f)beRDQ\u0001_\u0003A\u0002e\fqa]3tg&|g\u000e\u0005\u0002{}6\t1P\u0003\u0002yy*\u0011Q0K\u0001\u0005G>\u0014X-\u0003\u0002\u0000w\n91+Z:tS>t\u0007fB\u0003\u0002\u0004\u0005M\u0011Q\u0003\t\u0005\u0003\u000b\ty!\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0011\u0001\u00026bm\u0006LA!!\u0005\u0002\b\t\u00012+\u001e9qe\u0016\u001c8oV1s]&twm]\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003/\t#!!\u0007\u0002A=\u0014xML<beR\u0014X-\\8wKJts/\u0019:ug:b\u0015n\u001d;BaB,g\u000eZ\u0001\u001cM&dG/\u001a:PkR\u001c\u0015m]3J]N,gn]5uSZ,7*Z=\u0016\t\u0005}\u0011\u0011\b\u000b\u0007\u0003C\ti$!\u0011\u0011\u0011\u0005\r\u00121FA\u0019\u0003oqA!!\n\u0002(A\u0011q\tN\u0005\u0004\u0003S!\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002.\u0005=\"aA'ba*\u0019\u0011\u0011\u0006\u001b\u0011\t\u0005\u0015\u00111G\u0005\u0005\u0003k\t9A\u0001\u0007DQ\u0006\u00148+Z9vK:\u001cW\rE\u0002]\u0003s!a!a\u000f\u0007\u0005\u0004\u0001'!\u0001+\t\u000f\u0005}b\u00011\u0001\u0002\"\u0005\u0019Q.\u00199\t\u000f\u0005\rc\u00011\u0001\u00022\u0005\u00191.Z=\u0014\u0007\u001d\t9\u0005E\u00020\u0003\u0013J1!a\u0013$\u0005a\u0011V-];fgR,\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM]\u0001\u0011G>lWn\u001c8BiR\u0014\u0018NY;uKN\u00042aLA)\u0013\r\t\u0019f\t\u0002\u0011\u0007>lWn\u001c8BiR\u0014\u0018NY;uKN\fa\u0002\u001b;ua\u0006#HO]5ckR,7\u000fE\u00020\u00033J1!a\u0017$\u00059AE\u000f\u001e9BiR\u0014\u0018NY;uKN\f!\u0002\u001b;ua\u000e\u000b7\r[3t!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA3O\u0005)1-Y2iK&!\u0011\u0011NA2\u0005)AE\u000f\u001e9DC\u000eDWm]\u0001\rQR$\b\u000f\u0015:pi>\u001cw\u000e\u001c\t\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0019\u00111O\u0014\u0002\u0011A\u0014x\u000e^8d_2LA!a\u001e\u0002r\ta\u0001\n\u001e;q!J|Go\\2pY\u0006i1m\u001c8gS\u001e,(/\u0019;j_:\u0004B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0004\u0003\u0003c\u0018AB2p]\u001aLw-\u0003\u0003\u0002\u0006\u0006}$\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0007\u0002\n\u0006-\u0015QRAH\u0003#\u000b\u0019\n\u0005\u00020\u000f!9\u0011QJ\u0007A\u0002\u0005=\u0003bBA+\u001b\u0001\u0007\u0011q\u000b\u0005\b\u0003;j\u0001\u0019AA0\u0011\u001d\tY'\u0004a\u0001\u0003[Bq!!\u001f\u000e\u0001\u0004\tY(A\btC:LG/\u001b>f\u0011\u0016\fG-\u001a:t)\u0011\tI*!0\u0011\u0011\u0005\r\u00121FA\u0019\u00037\u0003b!!(\u00022\u0006]f\u0002BAP\u0003_sA!!)\u0002.:!\u00111UAV\u001d\u0011\t)+!+\u000f\u0007\u001d\u000b9+C\u0001-\u0013\tQ3&\u0003\u0002~S%\u0011\u0001\u0010`\u0005\u0003\u0019nLA!a-\u00026\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u00051[\b\u0003BA\u0012\u0003sKA!a/\u00020\t11\u000b\u001e:j]\u001eDq!a0\u000f\u0001\u0004\tI*\u0001\u0006sC^DU-\u00193feN\fA%\\3sO\u00164uN]7QCJ\fWn]!oI\u001a{'/\\%oi>\u0004\u0016M]1n\u00152K7\u000f\u001e\u000b\t\u0003\u000b\fI.!:\u0002tB!QHQAd!\u0019\tI-a4\u0002R6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\fY!\u0001\u0003vi&d\u0017b\u0001(\u0002LB!\u00111[Ak\u001b\u00059\u0016bAAl/\n)\u0001+\u0019:b[\"9\u00111\\\bA\u0002\u0005u\u0017A\u00029be\u0006l7\u000f\u0005\u0003F\u001b\u0006}\u0007cA\u0018\u0002b&\u0019\u00111]\u0012\u0003\u0013!#H\u000f\u001d)be\u0006l\u0007bBAt\u001f\u0001\u0007\u0011\u0011^\u0001\n[\u0006L(-\u001a$pe6\u0004RaMAv\u0003_L1!!<5\u0005\u0019y\u0005\u000f^5p]B1\u0011QTAY\u0003c\u0004r!a\t\u0002,\u0005]F\rC\u0003y\u001f\u0001\u0007\u00110\u0001\u000ed_:4\u0017nZ;sK6+H\u000e^5qCJ$hi\u001c:n\t\u0006$\u0018\r\u0006\u0004\u0002z\n\r!Q\u0001\u0019\u0005\u0003w\fy\u0010\u0005\u0003>\u0005\u0006u\bc\u0001/\u0002\u0000\u0012Q!\u0011\u0001\t\u0002\u0002\u0003\u0005)\u0011\u00011\u0003\u0007}#3\u0007C\u0003y!\u0001\u0007\u0011\u0010C\u0004\u0003\bA\u0001\rA!\u0003\u0002\u001dI,\u0017/^3ti\n+\u0018\u000e\u001c3feB!\u00111\u001bB\u0006\u0013\r\u0011ia\u0016\u0002\u000f%\u0016\fX/Z:u\u0005VLG\u000eZ3s\u0003]\u0019wN\u001c4jOV\u0014XMR8s[V\u0013H.\u00128d_\u0012,G\r\u0006\u0004\u0003\u0014\tu!q\u0004\u0019\u0005\u0005+\u0011I\u0002\u0005\u0003>\u0005\n]\u0001c\u0001/\u0003\u001a\u0011Q!1D\t\u0002\u0002\u0003\u0005)\u0011\u00011\u0003\u0007}#C\u0007C\u0003y#\u0001\u0007\u0011\u0010C\u0004\u0003\bE\u0001\rA!\u0003\u0002C5\f\u0017PY3SKF,Xm\u001d;C_\u0012L()^5mI\u0016\u0014X\t\u001f9sKN\u001c\u0018n\u001c8\u0016\u0005\t\u0015\u0002#B\u001a\u0002l\n\u001d\u0002CBAO\u0003c\u0013I\u0003\u0005\u0003\u0003,\t5R\"A+\n\u0007\t=RK\u0001\nSKF,Xm\u001d;C_\u0012L()^5mI\u0016\u0014\u0018AI7bs\n,'+Z9vKN$(i\u001c3z\u0005VLG\u000eZ3s\u000bb\u0004(/Z:tS>t\u0007%\u0001\u0005iCN\u0004\u0016M\u001d;t+\t\u00119\u0004E\u00024\u0005sI1Aa\u000f5\u0005\u001d\u0011un\u001c7fC:\f\u0011\u0002[1t!\u0006\u0014Ho\u001d\u0011\u0002\u000f!\f7OR8s[\u0006A\u0001.Y:G_Jl\u0007%A\u0007d_:4\u0017nZ;sK\n{G-\u001f\u000b\u0007\u0005\u000f\u0012\tFa\u00151\t\t%#Q\n\t\u0005{\t\u0013Y\u0005E\u0002]\u0005\u001b\"!Ba\u0014\u0019\u0003\u0003\u0005\tQ!\u0001a\u0005\ryF%\u000e\u0005\u0006qb\u0001\r!\u001f\u0005\b\u0005\u000fA\u0002\u0019\u0001B\u0005\u0003-)g.\u00192mK\"#H\u000f\u001d\u001a\u0002\u0019\u0015t\u0017M\u00197f\u0011R$\bO\r\u0011\u0002/\r|gNZ5hkJ,\u0007K]5pe.swn\u001e7fI\u001e,GC\u0002B/\u0005G\u0012)\u0007E\u00024\u0005?J1A!\u00195\u0005\u0011)f.\u001b;\t\u000ba\\\u0002\u0019A=\t\u000f\t\u001d1\u00041\u0001\u0003\n\u0005q!/Z9vKN$H+[7f_V$XC\u0001B6!\r\u0019$QN\u0005\u0004\u0005_\"$\u0001\u0002'p]\u001e\fqB]3rk\u0016\u001cH\u000fV5nK>,H\u000fI\u0001\u0018G>tg-[4ve\u0016\u0014V-];fgR$\u0016.\\3pkR$BA!\u0018\u0003x!9!q\u0001\u0010A\u0002\t%\u0011!G2p]\u001aLw-\u001e:f!J|Go\\2pYN\u0003XmY5gS\u000e$bA! \u0003\b\n%\u0005\u0007\u0002B@\u0005\u0007\u0003B!\u0010\"\u0003\u0002B\u0019ALa!\u0005\u0015\t\u0015u$!A\u0001\u0002\u000b\u0005\u0001MA\u0002`IYBQ\u0001_\u0010A\u0002eDqAa\u0002 \u0001\u0004\u0011I!A\fd_:4\u0017nZ;sK\u000e\u000b7\r[5oO\"+\u0017\rZ3sgR1!Q\fBH\u0005#CQ\u0001\u001f\u0011A\u0002eDaA\n\u0011A\u0002\tM\u0005\u0003BAj\u0005+K1Aa&X\u0005\u001d\u0011V-];fgR\fQAY;jY\u0012,\"A!(\u0011\r\u0005u\u0015\u0011\u0017BJ\u0001")
public class HttpRequestExpressionBuilder
extends RequestExpressionBuilder {
    private final HttpAttributes httpAttributes;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final GatlingConfiguration configuration;
    private final Option<Function1<Session, Validation<RequestBodyBuilder>>> maybeRequestBodyBuilderExpression;
    private final boolean hasParts;
    private final boolean hasForm;
    private final boolean enableHttp2;
    private final long requestTimeout;

    @Override
    public final Map<CharSequence, Function1<Session, Validation<String>>> sanitizeHeaders(Map<CharSequence, Function1<Session, Validation<String>>> rawHeaders) {
        if (this.httpAttributes.body().isEmpty() && this.httpAttributes.bodyParts().isEmpty()) {
            return HttpRequestExpressionBuilder$.MODULE$.io$gatling$http$request$builder$HttpRequestExpressionBuilder$$filterOutCaseInsensitiveKey(rawHeaders, (CharSequence)HttpHeaderNames.CONTENT_TYPE);
        }
        return rawHeaders;
    }

    private Validation<java.util.List<Param>> mergeFormParamsAndFormIntoParamJList(List<HttpParam> params, Option<Function1<Session, Validation<Map<String, Object>>>> maybeForm, Session session) {
        Validation<java.util.List<Param>> formParams = package$.MODULE$.resolveParamJList(params, session);
        Option<Function1<Session, Validation<Map<String, Object>>>> option = maybeForm;
        if (option instanceof Some) {
            Some some = (Some)option;
            Function1 form = (Function1)some.value();
            return formParams.flatMap((Function1 & Serializable)resolvedFormParams -> ((Validation)form.apply((Object)session)).map((Function1 & Serializable)resolvedForm -> {
                Map formParamsByName = CollectionConverters$.MODULE$.ListHasAsScala(resolvedFormParams).asScala().groupBy((Function1 & Serializable)x$1 -> x$1.getName());
                Map formFieldsByName = (Map)resolvedForm.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        Object value2 = tuple2._2();
                        Object object = value2;
                        if (object instanceof scala.collection.immutable.Seq) {
                            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)object;
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), seq.map((Function1 & Serializable)value -> new Param(key, value.toString())));
                        }
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new .colon.colon((Object)new Param(key, object.toString()), (List)Nil$.MODULE$));
                    }
                    throw new MatchError((Object)tuple2);
                });
                java.util.List javaParams = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((MapOps)formFieldsByName.$plus$plus((IterableOnce)formParamsByName)).values().flatten(Predef$.MODULE$.$conforms())).toSeq()).asJava();
                return javaParams;
            }));
        }
        return formParams;
    }

    private Validation<?> configureMultipartFormData(Session session, RequestBuilder requestBuilder) {
        return this.mergeFormParamsAndFormIntoParamJList(this.httpAttributes.formParams(), this.httpAttributes.form(), session).flatMap((Function1 & Serializable)params -> {
            Buffer stringParts = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params).asScala().map((Function1 & Serializable)param -> new StringPart(param.getName(), param.getValue(), this.charset(), null, null, null, null, null));
            return HttpRequestExpressionBuilder$.MODULE$.io$gatling$http$request$builder$HttpRequestExpressionBuilder$$bodyPartsToMultiparts($this.httpAttributes.bodyParts(), session).map((Function1 & Serializable)parts -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new MultipartFormDataRequestBodyBuilder(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)stringParts.$plus$plus((IterableOnce)parts)).asJava())));
        });
    }

    private Validation<?> configureFormUrlEncoded(Session session, RequestBuilder requestBuilder) {
        return this.mergeFormParamsAndFormIntoParamJList(this.httpAttributes.formParams(), this.httpAttributes.form(), session).map((Function1 & Serializable)params -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new FormUrlEncodedRequestBodyBuilder(params)));
    }

    private Option<Function1<Session, Validation<RequestBodyBuilder>>> maybeRequestBodyBuilderExpression() {
        return this.maybeRequestBodyBuilderExpression;
    }

    private boolean hasParts() {
        return this.hasParts;
    }

    private boolean hasForm() {
        return this.hasForm;
    }

    private Validation<?> configureBody(Session session, RequestBuilder requestBuilder) {
        Option<Function1<Session, Validation<RequestBodyBuilder>>> option = this.maybeRequestBodyBuilderExpression();
        if (option instanceof Some) {
            Some some = (Some)option;
            Function1 requestBodyBuilderExpression = (Function1)some.value();
            return ((Validation)requestBodyBuilderExpression.apply((Object)session)).map((Function1 & Serializable)x$1 -> requestBuilder.setBodyBuilder(x$1));
        }
        if (this.hasParts() || this.hasForm() && HttpHelper$.MODULE$.isMultipartFormData(requestBuilder.getContentType())) {
            return this.configureMultipartFormData(session, requestBuilder);
        }
        if (this.hasForm()) {
            return this.configureFormUrlEncoded(session, requestBuilder);
        }
        return Validation$.MODULE$.unit();
    }

    private boolean enableHttp2() {
        return this.enableHttp2;
    }

    private void configurePriorKnowledge(Session session, RequestBuilder requestBuilder) {
        if (this.enableHttp2()) {
            Option<Http2PriorKnowledge> http2PriorKnowledge = Http2PriorKnowledgeSupport$.MODULE$.getHttp2PriorKnowledge(session, Remote$.MODULE$.apply(requestBuilder.getUri()));
            requestBuilder.setHttp2Enabled(true).setHttp2PriorKnowledge((Http2PriorKnowledge)http2PriorKnowledge.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return;
        }
    }

    private long requestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public void configureRequestTimeout(RequestBuilder requestBuilder) {
        requestBuilder.setRequestTimeout(this.requestTimeout());
    }

    @Override
    public Validation<?> configureProtocolSpecific(Session session, RequestBuilder requestBuilder) {
        return this.configureBody(session, requestBuilder).map((Function1 & Serializable)x$11 -> {
            Object object = x$11;
            this.configurePriorKnowledge(session, requestBuilder);
            return BoxedUnit.UNIT;
        });
    }

    private void configureCachingHeaders(Session session, Request request) {
        this.httpCaches.contentCacheEntry(session, request).foreach((Function1 & Serializable)x0$1 -> {
            HttpRequestExpressionBuilder.$anonfun$configureCachingHeaders$1(request, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Function1<Session, Validation<Request>> build() {
        Function1<Session, Validation<Request>> exp = super.build();
        if (this.httpProtocol.requestPart().cache()) {
            return (Function1 & Serializable)session -> ((Validation)exp.apply(session)).map((Function1 & Serializable)request -> {
                this.configureCachingHeaders((Session)session, (Request)request);
                return request;
            });
        }
        return exp;
    }

    public static final /* synthetic */ void $anonfun$configureCachingHeaders$1(Request request$1, ContentCacheEntry x0$1) {
        ContentCacheEntry contentCacheEntry = x0$1;
        if (contentCacheEntry != null) {
            Option<String> etag = contentCacheEntry.etag();
            Option<String> lastModified = contentCacheEntry.lastModified();
            etag.foreach((Function1 & Serializable)x$12 -> request$1.getHeaders().set((CharSequence)HttpHeaderNames.IF_NONE_MATCH, x$12));
            lastModified.foreach((Function1 & Serializable)x$13 -> request$1.getHeaders().set((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE, x$13));
            return;
        }
        throw new MatchError((Object)contentCacheEntry);
    }

    public HttpRequestExpressionBuilder(CommonAttributes commonAttributes, HttpAttributes httpAttributes, HttpCaches httpCaches, HttpProtocol httpProtocol, GatlingConfiguration configuration) {
        this.httpAttributes = httpAttributes;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.configuration = configuration;
        super(commonAttributes, httpCaches, httpProtocol, configuration);
        Predef$.MODULE$.require(httpAttributes.body().isEmpty() || httpAttributes.bodyParts().isEmpty(), (Function0 & Serializable)() -> "Can't have both a body and body parts!");
        this.maybeRequestBodyBuilderExpression = httpAttributes.body().map((Function1 & Serializable)x0$1 -> {
            Body body = x0$1;
            if (body instanceof StringBody) {
                StringBody stringBody = (StringBody)body;
                Function1 string = stringBody.string();
                return (Function1 & Serializable)x$3 -> ((Validation)string.apply(x$3)).map((Function1 & Serializable)x$4 -> new StringRequestBodyBuilder(x$4));
            }
            if (body instanceof RawFileBody) {
                RawFileBody rawFileBody = (RawFileBody)body;
                Function1 resourceWithCachedBytes = rawFileBody.resourceAndCachedBytes();
                return (Function1 & Serializable)x$5 -> ((Validation)resourceWithCachedBytes.apply(x$5)).map((Function1 & Serializable)x0$2 -> {
                    ResourceAndCachedBytes resourceAndCachedBytes = x0$2;
                    if (resourceAndCachedBytes != null) {
                        Resource resource = resourceAndCachedBytes.resource();
                        Option cachedBytes = resourceAndCachedBytes.cachedBytes();
                        Option option = cachedBytes;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            byte[] bytes = (byte[])some.value();
                            return new ByteArrayRequestBodyBuilder(bytes, resource.name());
                        }
                        return new FileRequestBodyBuilder(resource.file());
                    }
                    throw new MatchError((Object)resourceAndCachedBytes);
                });
            }
            if (body instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)body;
                Function1 bytes = byteArrayBody.bytes();
                return (Function1 & Serializable)x$6 -> ((Validation)bytes.apply(x$6)).map((Function1 & Serializable)x$7 -> new ByteArrayRequestBodyBuilder(x$7, null));
            }
            if (body instanceof ElBody) {
                ElBody elBody = (ElBody)body;
                return (Function1 & Serializable)x$8 -> ((Validation)elBody.asStringWithCachedBytes().apply(x$8)).map((Function1 & Serializable)chunks -> new StringChunksRequestBodyBuilder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)chunks).asJava()));
            }
            if (body instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = (InputStreamBody)body;
                Function1 is = inputStreamBody.is();
                return (Function1 & Serializable)x$9 -> ((Validation)is.apply(x$9)).map((Function1 & Serializable)x$10 -> new InputStreamRequestBodyBuilder(x$10));
            }
            throw new MatchError((Object)body);
        });
        this.hasParts = httpAttributes.bodyParts().nonEmpty();
        this.hasForm = httpAttributes.formParams().nonEmpty() || httpAttributes.form().nonEmpty();
        this.enableHttp2 = httpProtocol.enginePart().enableHttp2();
        this.requestTimeout = ((FiniteDuration)httpAttributes.requestTimeout().getOrElse((Function0 & Serializable)() -> $this.configuration.http().requestTimeout())).toMillis();
    }
}

