/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.cache;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.session.Session;
import io.gatling.core.session.Session$;
import io.gatling.core.session.SessionPrivateAttributes$;
import io.gatling.http.engine.HttpEngine;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.util.SslContexts;
import java.io.Serializable;
import javax.net.ssl.KeyManagerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class SslContextSupport$
implements StrictLogging {
    public static final SslContextSupport$ MODULE$ = new SslContextSupport$();
    private static final String HttpSslContextsAttributeName;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        HttpSslContextsAttributeName = SessionPrivateAttributes$.MODULE$.generatePrivateAttribute("http.ssl.sslContexts");
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private String HttpSslContextsAttributeName() {
        return HttpSslContextsAttributeName;
    }

    private Option<KeyManagerFactory> resolvePerUserKeyManagerFactory(Session session, Option<Function1<Object, KeyManagerFactory>> perUserKeyManagerFactory) {
        Option<Function1<Object, KeyManagerFactory>> option = perUserKeyManagerFactory;
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            Function1 kmf = (Function1)some2.value();
            try {
                some = new Some(kmf.apply((Object)BoxesRunTime.boxToLong((long)session.userId())));
            }
            catch (Throwable throwable) {
                Option option2;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option2.get();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Can't build perUserKeyManagerFactory: " + Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(e)), e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    some = None$.MODULE$;
                }
                throw throwable;
            }
            return some;
        }
        return None$.MODULE$;
    }

    public Function1<Session, Session> setSslContexts(HttpProtocol httpProtocol, HttpEngine httpEngine) {
        if (httpProtocol.enginePart().shareConnections()) {
            return Session$.MODULE$.Identity();
        }
        return (Function1 & Serializable)session -> {
            Option<KeyManagerFactory> perUserKeyManagerFactory = MODULE$.resolvePerUserKeyManagerFactory((Session)session, httpProtocol.enginePart().perUserKeyManagerFactory());
            SslContexts sslContexts = httpEngine.newSslContexts(httpProtocol.enginePart().enableHttp2(), perUserKeyManagerFactory);
            return session.set(MODULE$.HttpSslContextsAttributeName(), (Object)sslContexts);
        };
    }

    public Option<SslContexts> sslContexts(Session session) {
        return session.attributes().get((Object)this.HttpSslContextsAttributeName()).map((Function1 & Serializable)x$1 -> (SslContexts)x$1);
    }

    private SslContextSupport$() {
    }
}

