/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.commons.validation.Validation;
import io.gatling.core.CoreComponents;
import io.gatling.core.body.Body;
import io.gatling.core.body.StringBody;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.session.package;
import io.gatling.core.session.package$;
import io.gatling.http.client.HttpClient;
import io.gatling.http.client.HttpListener;
import io.gatling.http.client.Request;
import io.gatling.http.client.SslContextsHolder;
import io.gatling.http.client.resolver.InetAddressNameResolver;
import io.gatling.http.client.resolver.InetAddressNameResolverWrapper;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.util.Pair;
import io.gatling.http.engine.HttpEngine$;
import io.gatling.http.protocol.HttpComponents;
import io.gatling.http.request.builder.Http;
import io.gatling.http.request.builder.HttpRequestBuilder;
import io.gatling.http.request.builder.RequestBuilder;
import io.gatling.http.util.SslContexts;
import io.gatling.http.util.SslContextsFactory;
import io.gatling.netty.util.Transports;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.resolver.NameResolver;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.resolver.dns.SequentialDnsServerAddressStreamProvider;
import java.io.Serializable;
import java.net.InetSocketAddress;
import javax.net.ssl.KeyManagerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Iterable;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u00055x!\u0002\u000b\u0016\u0011\u0003qb!\u0002\u0011\u0016\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003\"\u0002\u0016\u0002\t\u0003Yc\u0001\u0002\u0011\u0016\u00055B\u0001b\u0011\u0003\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u0015\u0012\u0011\t\u0011)A\u0005\u0017\"A\u0011\u000b\u0002B\u0001B\u0003%!\u000b\u0003\u0005[\t\t\u0005\t\u0015!\u0003\\\u0011!\u0011GA!A!\u0002\u0013\u0019\u0007\"\u0002\u0015\u0005\t\u0003Y\u0007BB9\u0005A\u0003&!\u000fC\u0003v\t\u0011\u0005a\u000fC\u0004\u0002\u0006\u0011!\t!a\u0002\t\u000f\u0005\u0015C\u0001\"\u0001\u0002H!9\u0011q\u000f\u0003\u0005\u0002\u0005e\u0004bBAD\t\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003k#A\u0011AA\\\u0011\u001d\t)\u000e\u0002C\u0001\u0003/Dq!!8\u0005\t\u0003\ny.\u0001\u0006IiR\u0004XI\\4j]\u0016T!AF\f\u0002\r\u0015tw-\u001b8f\u0015\tA\u0012$\u0001\u0003iiR\u0004(B\u0001\u000e\u001c\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011\u0001H\u0001\u0003S>\u001c\u0001\u0001\u0005\u0002 \u00035\tQC\u0001\u0006IiR\u0004XI\\4j]\u0016\u001c\"!\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta$A\u0003baBd\u0017\u0010F\u0002-\u0003C\u0004\"a\b\u0003\u0014\t\u0011qc'\u000f\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nA\u0001\\1oO*\t1'\u0001\u0003kCZ\f\u0017BA\u001b1\u0005\u0019y%M[3diB\u0011qfN\u0005\u0003qA\u0012Q\"Q;u_\u000ecwn]3bE2,\u0007C\u0001\u001eB\u001b\u0005Y$B\u0001\u001f>\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tqt(\u0001\u0005usB,7/\u00194f\u0015\u0005\u0001\u0015aA2p[&\u0011!i\u000f\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002%M\u001cHnQ8oi\u0016DHo\u001d$bGR|'/\u001f\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f^\tA!\u001e;jY&\u0011\u0011J\u0012\u0002\u0013'Nd7i\u001c8uKb$8OR1di>\u0014\u00180\u0001\u0006iiR\u00048\t\\5f]R\u0004\"\u0001T(\u000e\u00035S!AT\f\u0002\r\rd\u0017.\u001a8u\u0013\t\u0001VJ\u0001\u0006IiR\u00048\t\\5f]R\fa\"\u001a<f]Rdun\u001c9He>,\b\u000f\u0005\u0002T16\tAK\u0003\u0002V-\u000691\r[1o]\u0016d'BA,\u001c\u0003\u0015qW\r\u001e;z\u0013\tIFK\u0001\bFm\u0016tG\u000fT8pa\u001e\u0013x.\u001e9\u0002\u000b\rdwnY6\u0011\u0005q\u0003W\"A/\u000b\u0005\u001ds&BA0\u001a\u0003\u001d\u0019w.\\7p]NL!!Y/\u0003\u000b\rcwnY6\u0002\u001b\r|gNZ5hkJ\fG/[8o!\t!\u0017.D\u0001f\u0015\t1w-\u0001\u0004d_:4\u0017n\u001a\u0006\u0003Qf\tAaY8sK&\u0011!.\u001a\u0002\u0015\u000f\u0006$H.\u001b8h\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\r1bWN\\8q\u0011\u0015\u0019%\u00021\u0001E\u0011\u0015Q%\u00021\u0001L\u0011\u0015\t&\u00021\u0001S\u0011\u0015Q&\u00021\u0001\\\u0011\u0015\u0011'\u00021\u0001d\u0003!9\u0018M]7fIV\u0003\bCA\u0012t\u0013\t!HEA\u0004C_>dW-\u00198\u0002\r]\f'/\\+q)\t9(\u0010\u0005\u0002$q&\u0011\u0011\u0010\n\u0002\u0005+:LG\u000fC\u0003|\u0019\u0001\u0007A0\u0001\biiR\u00048i\\7q_:,g\u000e^:\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyx#\u0001\u0005qe>$xnY8m\u0013\r\t\u0019A \u0002\u000f\u0011R$\boQ8na>tWM\u001c;t\u00039)\u00070Z2vi\u0016\u0014V-];fgR$Rb^A\u0005\u0003'\ti\"!\t\u0002,\u0005U\u0002bBA\u0006\u001b\u0001\u0007\u0011QB\u0001\u000eG2LWM\u001c;SKF,Xm\u001d;\u0011\u00071\u000by!C\u0002\u0002\u00125\u0013qAU3rk\u0016\u001cH\u000fC\u0004\u0002\u00165\u0001\r!a\u0006\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\u00042aIA\r\u0013\r\tY\u0002\n\u0002\u0005\u0019>tw\r\u0003\u0004\u0002 5\u0001\rA]\u0001\u0007g\"\f'/\u001a3\t\u000f\u0005\rR\u00021\u0001\u0002&\u0005IQM^3oi2{w\u000e\u001d\t\u0004'\u0006\u001d\u0012bAA\u0015)\nIQI^3oi2{w\u000e\u001d\u0005\b\u0003[i\u0001\u0019AA\u0018\u0003!a\u0017n\u001d;f]\u0016\u0014\bc\u0001'\u00022%\u0019\u00111G'\u0003\u0019!#H\u000f\u001d'jgR,g.\u001a:\t\u000f\u0005]R\u00021\u0001\u0002:\u0005yQo]3s'Nd7i\u001c8uKb$8\u000fE\u0003$\u0003w\ty$C\u0002\u0002>\u0011\u0012aa\u00149uS>t\u0007cA#\u0002B%\u0019\u00111\t$\u0003\u0017M\u001bHnQ8oi\u0016DHo]\u0001\u0015Kb,7-\u001e;f\u0011R$\bO\r*fcV,7\u000f^:\u0015\u0017]\fI%a\u001c\u0002r\u0005M\u0014Q\u000f\u0005\b\u0003\u0017r\u0001\u0019AA'\u0003Q\u0011X-];fgR\u001c\u0018I\u001c3MSN$XM\\3sgB1\u0011qJA0\u0003KrA!!\u0015\u0002\\9!\u00111KA-\u001b\t\t)FC\u0002\u0002Xu\ta\u0001\u0010:p_Rt\u0014\"A\u0013\n\u0007\u0005uC%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00141\r\u0002\t\u0013R,'/\u00192mK*\u0019\u0011Q\f\u0013\u0011\u0011\u0005\u001d\u00141NA\u0007\u0003_i!!!\u001b\u000b\u0005\u001dk\u0015\u0002BA7\u0003S\u0012A\u0001U1je\"9\u0011Q\u0003\bA\u0002\u0005]\u0001BBA\u0010\u001d\u0001\u0007!\u000fC\u0004\u0002$9\u0001\r!!\n\t\u000f\u0005]b\u00021\u0001\u0002:\u00051b.Z<KCZ\fGI\\:OC6,'+Z:pYZ,'/\u0006\u0002\u0002|A!\u0011QPAB\u001b\t\tyHC\u0002\u0002\u00026\u000b\u0001B]3t_24XM]\u0005\u0005\u0003\u000b\u000byHA\fJ]\u0016$\u0018\t\u001a3sKN\u001ch*Y7f%\u0016\u001cx\u000e\u001c<fe\u00069b.Z<Bgft7\r\u00128t\u001d\u0006lWMU3t_24XM\u001d\u000b\t\u0003w\nY)!$\u0002$\"9\u00111\u0005\tA\u0002\u0005\u0015\u0002bBAH!\u0001\u0007\u0011\u0011S\u0001\u000bI:\u001c8+\u001a:wKJ\u001c\b#B\u0012\u0002\u0014\u0006]\u0015bAAKI\t)\u0011I\u001d:bsB!\u0011\u0011TAP\u001b\t\tYJC\u0002\u0002\u001eJ\n1A\\3u\u0013\u0011\t\t+a'\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8\u000fC\u0004\u0002&B\u0001\r!a*\u0002\u000b\r\f7\r[3\u0011\t\u0005%\u0016\u0011W\u0007\u0003\u0003WSA!!,\u00020\u0006\u0019AM\\:\u000b\u0007\u0005\u0005e+\u0003\u0003\u00024\u0006-&\u0001\u0003#og\u000e\u000b7\r[3\u0002\u001d9,woU:m\u0007>tG/\u001a=ugR1\u0011qHA]\u0003{Ca!a/\u0012\u0001\u0004\u0011\u0018\u0001\u00045uiB\u0014TI\\1cY\u0016$\u0007bBA`#\u0001\u0007\u0011\u0011Y\u0001\u0019a\u0016\u0014Xk]3s\u0017\u0016LX*\u00198bO\u0016\u0014h)Y2u_JL\b#B\u0012\u0002<\u0005\r\u0007\u0003BAc\u0003#l!!a2\u000b\t\u0005%\u00171Z\u0001\u0004gNd'\u0002BAO\u0003\u001bT!!a4\u0002\u000b)\fg/\u0019=\n\t\u0005M\u0017q\u0019\u0002\u0012\u0017\u0016LX*\u00198bO\u0016\u0014h)Y2u_JL\u0018!\u00064mkND7\t\\5f]RLEm\u00115b]:,Gn\u001d\u000b\u0006o\u0006e\u00171\u001c\u0005\b\u0003+\u0011\u0002\u0019AA\f\u0011\u001d\t\u0019C\u0005a\u0001\u0003K\tQa\u00197pg\u0016$\u0012a\u001e\u0005\b\u0003G\u001c\u0001\u0019AAs\u00039\u0019wN]3D_6\u0004xN\\3oiN\u0004B!a:\u0002j6\tq-C\u0002\u0002l\u001e\u0014abQ8sK\u000e{W\u000e]8oK:$8\u000f")
public final class HttpEngine
implements AutoCloseable,
StrictLogging {
    private final SslContextsFactory sslContextsFactory;
    private final HttpClient httpClient;
    private final EventLoopGroup eventLoopGroup;
    private final GatlingConfiguration configuration;
    private boolean warmedUp;
    private Logger logger;

    public static HttpEngine apply(CoreComponents coreComponents) {
        return HttpEngine$.MODULE$.apply(coreComponents);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void warmUp(HttpComponents httpComponents) {
        if (!this.warmedUp) {
            BoxedUnit boxedUnit;
            block19: {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Start warm up");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.warmedUp = true;
                Function1 expression = package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)"foo"));
                ((HttpRequestBuilder)((RequestBuilder)new Http((Function1<Session, Validation<String>>)expression).get((Function1<Session, Validation<String>>)expression).header("bar", (Function1<Session, Validation<String>>)expression)).queryParam((Function1<Session, Validation<String>>)expression, (Function1<Session, Validation<Object>>)expression)).build(httpComponents.httpCaches(), httpComponents.httpProtocol(), false, this.configuration);
                new Http((Function1<Session, Validation<String>>)expression).post((Function1<Session, Validation<String>>)expression).body((Body)new StringBody(expression, this.configuration.core().charset())).build(httpComponents.httpCaches(), httpComponents.httpProtocol(), false, this.configuration);
                String url = (String)httpComponents.httpProtocol().warmUpUrl().getOrElse((Function0 & Serializable)() -> "https://gatling.io");
                io.gatling.http.client.RequestBuilder requestBuilder = new io.gatling.http.client.RequestBuilder("warmUp", HttpMethod.GET, Uri.create((String)url), InetAddressNameResolver.JAVA_RESOLVER).setHeaders(new DefaultHttpHeaders().add((CharSequence)HttpHeaderNames.ACCEPT, (Object)"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8").add((CharSequence)HttpHeaderNames.ACCEPT_LANGUAGE, (Object)"en-US,en;q=0.5").add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP).add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE).add((CharSequence)HttpHeaderNames.USER_AGENT, (Object)"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/119.0")).setRequestTimeout(1000L).setDefaultCharset(this.configuration.core().charset());
                httpComponents.httpProtocol().proxyPart().proxy().foreach((Function1 & Serializable)x$1 -> requestBuilder.setProxyServer(x$1));
                EventLoop eventLoop = this.eventLoopGroup.next();
                SslContexts sslContexts = this.sslContextsFactory.newSslContexts(true, (Option<KeyManagerFactory>)None$.MODULE$);
                try {
                    BoxedUnit boxedUnit3;
                    try {
                        if (httpComponents.httpProtocol().warmUpUrl().isDefined()) {
                            Promise p = Promise$.MODULE$.apply();
                            this.httpClient.sendRequest(requestBuilder.build(), 0L, eventLoop, new HttpListener(null, p){
                                private final Promise p$1;

                                public void onSend() {
                                    super.onSend();
                                }

                                public void onProtocolAwareness(boolean x$1) {
                                    super.onProtocolAwareness(x$1);
                                }

                                public void onWrite(Channel x$1) {
                                    super.onWrite(x$1);
                                }

                                public void onHttpResponse(HttpResponseStatus httpResponseStatus, HttpHeaders httpHeaders) {
                                }

                                public void onThrowable(Throwable throwable) {
                                    this.p$1.failure(throwable);
                                }

                                public void onHttpResponseBodyChunk(ByteBuf byteBuf, boolean last) {
                                    if (last) {
                                        this.p$1.success((Object)BoxedUnit.UNIT);
                                        return;
                                    }
                                }
                                {
                                    this.p$1 = p$1;
                                }
                            }, (SslContextsHolder)sslContexts);
                            Await$.MODULE$.result((Awaitable)p.future(), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).seconds());
                            if (this.logger().underlying().isDebugEnabled()) {
                                this.logger().underlying().debug("Warm up request {} successful", (Object)url);
                                boxedUnit3 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit3 = BoxedUnit.UNIT;
                            }
                            break block19;
                        }
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(throwable2)) {
                            if (this.logger().underlying().isDebugEnabled()) {
                                if (this.logger().underlying().isDebugEnabled()) {
                                    this.logger().underlying().debug("Couldn't execute warm up request " + url, throwable2);
                                }
                            } else if (this.logger().underlying().isDebugEnabled()) {
                                this.logger().underlying().debug("Couldn't execute warm up request {}: {}", new Object[]{url, Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(throwable2))});
                            }
                        } else {
                            throw throwable;
                        }
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                }
                finally {
                    this.httpClient.flushClientIdChannels(0L, eventLoop);
                    sslContexts.close();
                }
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Warm up done");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void executeRequest(Request clientRequest, long clientId, boolean shared, EventLoop eventLoop, HttpListener listener, Option<SslContexts> userSslContexts) {
        if (!this.httpClient.isClosed()) {
            this.httpClient.sendRequest(clientRequest, shared ? -1L : clientId, eventLoop, listener, (SslContextsHolder)userSslContexts.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return;
        }
    }

    public void executeHttp2Requests(Iterable<Pair<Request, HttpListener>> requestsAndListeners, long clientId, boolean shared, EventLoop eventLoop, Option<SslContexts> userSslContexts) {
        if (!this.httpClient.isClosed()) {
            this.httpClient.sendHttp2Requests((Pair[])requestsAndListeners.toArray(ClassTag$.MODULE$.apply(Pair.class)), shared ? -1L : clientId, eventLoop, (SslContextsHolder)userSslContexts.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return;
        }
    }

    public InetAddressNameResolver newJavaDnsNameResolver() {
        return InetAddressNameResolver.JAVA_RESOLVER;
    }

    public InetAddressNameResolver newAsyncDnsNameResolver(EventLoop eventLoop, InetSocketAddress[] dnsServers, DnsCache cache) {
        return new InetAddressNameResolverWrapper((NameResolver)new DnsNameResolverBuilder(eventLoop).channelFactory(Transports.newDatagramChannelFactory((boolean)this.configuration.netty().useNativeTransport(), (boolean)this.configuration.netty().useIoUring())).nameServerProvider((DnsServerAddressStreamProvider)(dnsServers.length == 0 ? DnsServerAddressStreamProviders.platformDefault() : new SequentialDnsServerAddressStreamProvider(dnsServers))).queryTimeoutMillis((long)((int)this.configuration.http().dns().queryTimeout().toMillis())).maxQueriesPerResolve(this.configuration.http().dns().maxQueriesPerResolve()).resolveCache(cache).build());
    }

    public SslContexts newSslContexts(boolean http2Enabled, Option<KeyManagerFactory> perUserKeyManagerFactory) {
        return this.sslContextsFactory.newSslContexts(http2Enabled, perUserKeyManagerFactory);
    }

    public void flushClientIdChannels(long clientId, EventLoop eventLoop) {
        if (!this.httpClient.isClosed()) {
            this.httpClient.flushClientIdChannels(clientId, eventLoop);
            return;
        }
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    public HttpEngine(SslContextsFactory sslContextsFactory, HttpClient httpClient, EventLoopGroup eventLoopGroup, Clock clock, GatlingConfiguration configuration) {
        this.sslContextsFactory = sslContextsFactory;
        this.httpClient = httpClient;
        this.eventLoopGroup = eventLoopGroup;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        this.warmedUp = false;
        Statics.releaseFence();
    }
}

