/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.polling;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.session.Session;
import io.gatling.core.util.NameGen;
import io.gatling.http.engine.response.Crash;
import io.gatling.http.engine.response.FollowUp;
import io.gatling.http.engine.response.Proceed;
import io.gatling.http.engine.response.ProcessorResult;
import io.gatling.http.engine.response.ResponseProcessor$;
import io.gatling.http.engine.response.SessionProcessor;
import io.gatling.http.engine.response.StatsProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.Response;
import java.nio.charset.Charset;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000514A\u0001C\u0005\u0003)!AQ\u0006\u0001B\u0001B\u0003%a\u0006\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011!a\u0004A!A!\u0002\u0013i\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u000b-\u0003A\u0011\u0001'\t\u000bM\u0003A\u0011\u0001+\t\u000b\t\u0004A\u0011B2\u0003/A{G\u000e\\3s%\u0016\u001c\bo\u001c8tKB\u0013xnY3tg>\u0014(B\u0001\u0006\f\u0003\u001d\u0001x\u000e\u001c7j]\u001eT!\u0001D\u0007\u0002\r\u0005\u001cG/[8o\u0015\tqq\"\u0001\u0003iiR\u0004(B\u0001\t\u0012\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011AE\u0001\u0003S>\u001c\u0001a\u0005\u0003\u0001+m)\u0003C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u001dG5\tQD\u0003\u0002\u001f?\u0005a1oY1mC2|wmZ5oO*\u0011\u0001%I\u0001\tif\u0004Xm]1gK*\t!%A\u0002d_6L!\u0001J\u000f\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\t\u0003M-j\u0011a\n\u0006\u0003Q%\nA!\u001e;jY*\u0011!fD\u0001\u0005G>\u0014X-\u0003\u0002-O\t9a*Y7f\u000f\u0016t\u0017A\u0001;y!\ty3'D\u00011\u0015\ti\u0013G\u0003\u00023\u001b\u00051QM\\4j]\u0016L!\u0001\u000e\u0019\u0003\r!#H\u000f\u001d+y\u0003A\u0019Xm]:j_:\u0004&o\\2fgN|'\u000f\u0005\u00028u5\t\u0001H\u0003\u0002:c\u0005A!/Z:q_:\u001cX-\u0003\u0002<q\t\u00012+Z:tS>t\u0007K]8dKN\u001cxN]\u0001\u000fgR\fGo\u001d)s_\u000e,7o]8s!\t9d(\u0003\u0002@q\tq1\u000b^1ugB\u0013xnY3tg>\u0014\u0018A\u00043fM\u0006,H\u000e^\"iCJ\u001cX\r\u001e\t\u0003\u0005&k\u0011a\u0011\u0006\u0003\t\u0016\u000bqa\u00195beN,GO\u0003\u0002G\u000f\u0006\u0019a.[8\u000b\u0003!\u000bAA[1wC&\u0011!j\u0011\u0002\b\u0007\"\f'o]3u\u0003\u0019a\u0014N\\5u}Q)Qj\u0014)R%B\u0011a\nA\u0007\u0002\u0013!)Q&\u0002a\u0001]!)Q'\u0002a\u0001m!)A(\u0002a\u0001{!)\u0001)\u0002a\u0001\u0003\u0006QqN\\\"p[BdW\r^3\u0015\u0005U[\u0006C\u0001,Z\u001b\u00059&B\u0001-*\u0003\u001d\u0019Xm]:j_:L!AW,\u0003\u000fM+7o]5p]\")AL\u0002a\u0001;\u00061!/Z:vYR\u0004\"A\u00181\u000e\u0003}S!!O\u0007\n\u0005\u0005|&A\u0003%uiB\u0014Vm];mi\u00069\u0001O]8dK\u0016$GcA+eQ\")\u0011h\u0002a\u0001KB\u0011aLZ\u0005\u0003O~\u0013\u0001BU3ta>t7/\u001a\u0005\u00069\u001e\u0001\r!\u001b\t\u0003o)L!a\u001b\u001d\u0003\u001fA\u0013xnY3tg>\u0014(+Z:vYR\u0004")
public final class PollerResponseProcessor
implements LazyLogging,
NameGen {
    private final HttpTx tx;
    private final SessionProcessor sessionProcessor;
    private final StatsProcessor statsProcessor;
    private final Charset defaultCharset;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    private Logger logger$lzycompute() {
        PollerResponseProcessor pollerResponseProcessor = this;
        synchronized (pollerResponseProcessor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Session onComplete(HttpResult result) {
        HttpResult httpResult = result;
        if (httpResult instanceof Response) {
            Response response = (Response)httpResult;
            return this.proceed(response, ResponseProcessor$.MODULE$.processResponse(this.tx, this.sessionProcessor, this.defaultCharset, response));
        }
        if (httpResult instanceof HttpFailure) {
            HttpFailure httpFailure = (HttpFailure)httpResult;
            return ResponseProcessor$.MODULE$.processFailure(this.tx, this.sessionProcessor, this.statsProcessor, httpFailure);
        }
        throw new MatchError((Object)httpResult);
    }

    private Session proceed(Response response, ProcessorResult result) {
        ProcessorResult processorResult = result;
        if (processorResult instanceof Proceed) {
            Proceed proceed = (Proceed)processorResult;
            Session newSession = proceed.newSession();
            Option<String> errorMessage = proceed.error();
            KO$ status = errorMessage.isDefined() ? KO$.MODULE$ : OK$.MODULE$;
            this.statsProcessor.reportStats(this.tx.fullRequestName(), newSession, (Status)status, response, errorMessage);
            return newSession;
        }
        if (processorResult instanceof FollowUp) {
            BoxedUnit boxedUnit;
            FollowUp followUp = (FollowUp)processorResult;
            HttpTx followUpTx = followUp.followUpTx();
            this.statsProcessor.reportStats(this.tx.fullRequestName(), followUpTx.session(), (Status)OK$.MODULE$, response, (Option<String>)None$.MODULE$);
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Polling support doesn't support follow-up requests such as redirect atm");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return this.tx.session().markAsFailed();
        }
        if (processorResult instanceof Crash) {
            Crash crash = (Crash)processorResult;
            String errorMessage = crash.error();
            Session newSession = this.sessionProcessor.updateSessionCrashed(this.tx.session(), response.startTimestamp(), response.endTimestamp());
            this.statsProcessor.reportStats(this.tx.fullRequestName(), newSession, (Status)KO$.MODULE$, response, (Option<String>)new Some((Object)errorMessage));
            return newSession;
        }
        throw new MatchError((Object)processorResult);
    }

    public PollerResponseProcessor(HttpTx tx, SessionProcessor sessionProcessor, StatsProcessor statsProcessor, Charset defaultCharset) {
        this.tx = tx;
        this.sessionProcessor = sessionProcessor;
        this.statsProcessor = statsProcessor;
        this.defaultCharset = defaultCharset;
        LazyLogging.$init$((LazyLogging)this);
        NameGen.$init$((NameGen)this);
    }
}

