/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.SslConfiguration;
import io.gatling.http.util.SslContexts;
import io.gatling.http.util.SslContextsFactory$;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Serializable;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005msAB\r\u001b\u0011\u0003a\"E\u0002\u0004%5!\u0005A$\n\u0005\u0006Y\u0005!\tA\f\u0005\b_\u0005\u0011\r\u0011\"\u00031\u0011\u0019I\u0014\u0001)A\u0005c!9!(\u0001b\u0001\n\u0013Y\u0004B\u0002$\u0002A\u0003%AHB\u0003%5\tqr\t\u0003\u0005S\u000f\t\u0005\t\u0015!\u0003T\u0011!YvA!A!\u0002\u0013a\u0006\"\u0002\u0017\b\t\u0003y\u0006bB2\b\u0005\u0004%I\u0001\u001a\u0005\u0007K\u001e\u0001\u000b\u0011\u0002/\t\u000f\u0019<!\u0019!C\u0005O\"11n\u0002Q\u0001\n!D\u0001\u0002\\\u0004\t\u0006\u0004%I!\u001c\u0005\bo\u001e\u0011\r\u0011\"\u0003y\u0011\u001d\tya\u0002Q\u0001\neD\u0011\"!\u0005\b\u0005\u0004%I!a\u0005\t\u0011\u0005}q\u0001)A\u0005\u0003+A\u0011\"!\t\b\u0005\u0004%I!a\t\t\u0011\u0005-r\u0001)A\u0005\u0003KA\u0011\"!\f\b\u0005\u0004%I!a\f\t\u0011\u0005mr\u0001)A\u0005\u0003cAq!!\u0010\b\t\u0003\ty$\u0001\nTg2\u001cuN\u001c;fqR\u001ch)Y2u_JL(BA\u000e\u001d\u0003\u0011)H/\u001b7\u000b\u0005uq\u0012\u0001\u00025uiBT!a\b\u0011\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011%\u0001\u0002j_B\u00111%A\u0007\u00025\t\u00112k\u001d7D_:$X\r\u001f;t\r\u0006\u001cGo\u001c:z'\t\ta\u0005\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t!%\u0001\fEK\u001a\fW\u000f\u001c;Tg2\u001cVmY;sKJ\u000bg\u000eZ8n+\u0005\t\u0004C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003!\u0019XmY;sSRL(\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qM\u0012AbU3dkJ,'+\u00198e_6\fq\u0003R3gCVdGoU:m'\u0016\u001cWO]3SC:$w.\u001c\u0011\u0002\u0007\u0005\u0003h.F\u0001=!\tiD)D\u0001?\u0015\ty\u0004)A\u0002tg2T!!\u0011\"\u0002\u000f!\fg\u000e\u001a7fe*\u00111\tI\u0001\u0006]\u0016$H/_\u0005\u0003\u000bz\u0012\u0011$\u00119qY&\u001c\u0017\r^5p]B\u0013x\u000e^8d_2\u001cuN\u001c4jO\u0006!\u0011\t\u001d8!'\r9a\u0005\u0013\t\u0003\u0013Bk\u0011A\u0013\u0006\u0003\u00172\u000bAb]2bY\u0006dwnZ4j]\u001eT!!\u0014(\u0002\u0011QL\b/Z:bM\u0016T\u0011aT\u0001\u0004G>l\u0017BA)K\u00055\u0019FO]5di2{wmZ5oO\u0006I1o\u001d7D_:4\u0017n\u001a\t\u0003)fk\u0011!\u0016\u0006\u0003-^\u000baaY8oM&<'B\u0001-\u001f\u0003\u0011\u0019wN]3\n\u0005i+&\u0001E*tY\u000e{gNZ5hkJ\fG/[8o\u0003i)g.\u00192mK\"{7\u000f\u001e8b[\u00164VM]5gS\u000e\fG/[8o!\t9S,\u0003\u0002_Q\t9!i\\8mK\u0006tGc\u00011bEB\u00111e\u0002\u0005\u0006%*\u0001\ra\u0015\u0005\u00067*\u0001\r\u0001X\u0001\u000bkN,w\n]3o'NdW#\u0001/\u0002\u0017U\u001cXm\u00149f]N\u001bH\u000eI\u0001\u0019gNd7+Z:tS>tG+[7f_V$8+Z2p]\u0012\u001cX#\u00015\u0011\u0005\u001dJ\u0017B\u00016)\u0005\u0011auN\\4\u00023M\u001cHnU3tg&|g\u000eV5nK>,HoU3d_:$7\u000fI\u0001\u0019\t\u00164\u0017-\u001e7u\u0015\u00064\u0018mU:m!\u0006\u0014\u0018-\\3uKJ\u001cX#\u00018\u0011\u0005=,X\"\u00019\u000b\u0005}\n(B\u0001:t\u0003\rqW\r\u001e\u0006\u0002i\u0006)!.\u0019<bq&\u0011a\u000f\u001d\u0002\u000e'Nc\u0005+\u0019:b[\u0016$XM]:\u0002!\u0015t\u0017M\u00197fIB\u0013x\u000e^8d_2\u001cX#A=\u0011\u0007\u001dRH0\u0003\u0002|Q\t)\u0011I\u001d:bsB\u0019Q0!\u0003\u000f\u0007y\f)\u0001\u0005\u0002\u0000Q5\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007i\u0013A\u0002\u001fs_>$h(C\u0002\u0002\b!\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0006\u0003\u001b\u0011aa\u0015;sS:<'bAA\u0004Q\u0005\tRM\\1cY\u0016$\u0007K]8u_\u000e|Gn\u001d\u0011\u0002'\u0015t\u0017M\u00197fI\u000eK\u0007\u000f[3s'VLG/Z:\u0016\u0005\u0005U\u0001#BA\f\u00037aXBAA\r\u0015\tYR'\u0003\u0003\u0002\u001e\u0005e!\u0001\u0002'jgR\fA#\u001a8bE2,GmQ5qQ\u0016\u00148+^5uKN\u0004\u0013aC:tYB\u0013xN^5eKJ,\"!!\n\u0011\u0007u\n9#C\u0002\u0002*y\u00121bU:m!J|g/\u001b3fe\u0006a1o\u001d7Qe>4\u0018\u000eZ3sA\u0005yRM\u001c3q_&tG/\u00133f]RLg-[2bi&|g.\u00117h_JLG\u000f[7\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]R'\u0001\u0003mC:<\u0017\u0002BA\u0006\u0003k\t\u0001%\u001a8ea>Lg\u000e^%eK:$\u0018NZ5dCRLwN\\!mO>\u0014\u0018\u000e\u001e5nA\u0005qa.Z<Tg2\u001cuN\u001c;fqR\u001cHCBA!\u0003\u000f\nY\u0005E\u0002$\u0003\u0007J1!!\u0012\u001b\u0005-\u00196\u000f\\\"p]R,\u0007\u0010^:\t\r\u0005%\u0003\u00041\u0001]\u00031AG\u000f\u001e93\u000b:\f'\r\\3e\u0011\u001d\ti\u0005\u0007a\u0001\u0003\u001f\n\u0001\u0004]3s+N,'oS3z\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z!\u00159\u0013\u0011KA+\u0013\r\t\u0019\u0006\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007=\f9&C\u0002\u0002ZA\u0014\u0011cS3z\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z\u0001")
public final class SslContextsFactory
implements StrictLogging {
    private SSLParameters DefaultJavaSslParameters;
    private final SslConfiguration sslConfig;
    private final boolean useOpenSsl;
    private final long sslSessionTimeoutSeconds;
    private final String[] enabledProtocols;
    private final List<String> enabledCipherSuites;
    private final SslProvider sslProvider;
    private final String endpointIdentificationAlgorithm;
    private Logger logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private boolean useOpenSsl() {
        return this.useOpenSsl;
    }

    private long sslSessionTimeoutSeconds() {
        return this.sslSessionTimeoutSeconds;
    }

    private SSLParameters DefaultJavaSslParameters$lzycompute() {
        SslContextsFactory sslContextsFactory = this;
        synchronized (sslContextsFactory) {
            if (!this.bitmap$0) {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, null, null);
                this.DefaultJavaSslParameters = context.getDefaultSSLParameters();
                this.bitmap$0 = true;
            }
        }
        return this.DefaultJavaSslParameters;
    }

    private SSLParameters DefaultJavaSslParameters() {
        if (!this.bitmap$0) {
            return this.DefaultJavaSslParameters$lzycompute();
        }
        return this.DefaultJavaSslParameters;
    }

    private String[] enabledProtocols() {
        return this.enabledProtocols;
    }

    private List<String> enabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    private SslProvider sslProvider() {
        return this.sslProvider;
    }

    private String endpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    public SslContexts newSslContexts(boolean http2Enabled, Option<KeyManagerFactory> perUserKeyManagerFactory) {
        Option kmf = perUserKeyManagerFactory.orElse((Function0 & Serializable)() -> $this.sslConfig.keyManagerFactory());
        Option tmf = this.sslConfig.trustManagerFactory().orElse((Function0 & Serializable)() -> {
            if ($this.sslConfig.useInsecureTrustManager()) {
                return new Some((Object)InsecureTrustManagerFactory.INSTANCE);
            }
            return None$.MODULE$;
        });
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(this.sslProvider()).endpointIdentificationAlgorithm(this.endpointIdentificationAlgorithm()).secureRandom(SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$DefaultSslSecureRandom());
        Object object = this.sslConfig.sessionCacheSize() > 0 ? sslContextBuilder.sessionCacheSize((long)this.sslConfig.sessionCacheSize()) : BoxedUnit.UNIT;
        Object object2 = this.sslConfig.sessionTimeout().$greater((Object)Duration$.MODULE$.Zero()) ? sslContextBuilder.sessionTimeout(this.sslSessionTimeoutSeconds()) : BoxedUnit.UNIT;
        Object object3 = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.enabledProtocols())) ? sslContextBuilder.protocols(this.enabledProtocols()) : BoxedUnit.UNIT;
        SslContextBuilder sslContextBuilder2 = this.sslConfig.enabledCipherSuites().nonEmpty() ? sslContextBuilder.ciphers(this.enabledCipherSuites()) : sslContextBuilder.ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS);
        kmf.foreach((Function1 & Serializable)x$1 -> sslContextBuilder.keyManager(x$1));
        tmf.foreach((Function1 & Serializable)x$1 -> sslContextBuilder.trustManager(x$1));
        return new SslContexts(sslContextBuilder, (Option<ApplicationProtocolConfig>)(http2Enabled ? new Some((Object)SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn()) : None$.MODULE$));
    }

    public SslContextsFactory(SslConfiguration sslConfig, boolean enableHostnameVerification) {
        List list;
        String[] stringArray;
        boolean bl;
        this.sslConfig = sslConfig;
        StrictLogging.$init$((StrictLogging)this);
        if (sslConfig.useOpenSsl()) {
            BoxedUnit boxedUnit;
            boolean available = OpenSsl.isAvailable();
            if (!available) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("OpenSSL is enabled in the Gatling configuration but it's not available on your architecture.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = available;
        } else {
            bl = false;
        }
        this.useOpenSsl = bl;
        this.sslSessionTimeoutSeconds = sslConfig.sessionTimeout().toSeconds();
        if (this.useOpenSsl()) {
            stringArray = (String[])sslConfig.enabledProtocols().toArray(ClassTag$.MODULE$.apply(String.class));
        } else {
            Set supportedProtocols = Predef$.MODULE$.wrapRefArray((Object[])this.DefaultJavaSslParameters().getProtocols()).toSet();
            stringArray = this.enabledProtocols = (String[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])sslConfig.enabledProtocols().toArray(ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)supportedProtocols.contains((Object)elem)));
        }
        if (this.useOpenSsl()) {
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sslConfig.enabledCipherSuites()).asJava();
        } else {
            String[] supportedCipherSuites = this.DefaultJavaSslParameters().getCipherSuites();
            Object object = Predef$.MODULE$.refArrayOps((Object[])supportedCipherSuites);
            list = this.enabledCipherSuites = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sslConfig.enabledCipherSuites().filter((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(object, (Object)elem)))).asJava();
        }
        this.sslProvider = this.useOpenSsl() ? (sslConfig.useOpenSslFinalizers() ? SslProvider.OPENSSL : SslProvider.OPENSSL_REFCNT) : SslProvider.JDK;
        this.endpointIdentificationAlgorithm = enableHostnameVerification ? "HTTPS" : null;
        Statics.releaseFence();
    }
}

