/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse.fsm;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.action.sse.fsm.NextSseState;
import io.gatling.http.action.sse.fsm.NextSseState$;
import io.gatling.http.action.sse.fsm.ServerSentEvent;
import io.gatling.http.action.sse.fsm.SseCrashedState;
import io.gatling.http.action.sse.fsm.SseFsm;
import io.gatling.http.check.sse.SseMessageCheckSequence;
import scala.None$;
import scala.Option;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005md!\u0002\t\u0012\u0003\u0003q\u0002\u0002\u0003\n\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u000bM\u0002A\u0011\u0001\u001b\t\u000f]\u0002!\u0019!C\u0005q!1\u0011\t\u0001Q\u0001\neBQA\u0011\u0001\u0005\u0002\rCQ\u0001\u0014\u0001\u0005\u00025CQ\u0001 \u0001\u0005\u0002uDq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002bBA\u0012\u0001\u0011%\u0011Q\u0005\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\ti\u0004\u0001C\t\u0003\u007fAq!!\u0013\u0001\t#\tYE\u0001\u0005Tg\u0016\u001cF/\u0019;f\u0015\t\u00112#A\u0002gg6T!\u0001F\u000b\u0002\u0007M\u001cXM\u0003\u0002\u0017/\u00051\u0011m\u0019;j_:T!\u0001G\r\u0002\t!$H\u000f\u001d\u0006\u00035m\tqaZ1uY&twMC\u0001\u001d\u0003\tIwn\u0001\u0001\u0014\u0007\u0001yR\u0005\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0003M5j\u0011a\n\u0006\u0003Q%\nAb]2bY\u0006dwnZ4j]\u001eT!AK\u0016\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001L\u0001\u0004G>l\u0017B\u0001\u0018(\u00055\u0019FO]5di2{wmZ5oOB\u0011\u0001'M\u0007\u0002#%\u0011!'\u0005\u0002\u0007'N,gi]7\u0002\rqJg.\u001b;?)\t)d\u0007\u0005\u00021\u0001!)!C\u0001a\u0001_\u0005I1\u000f^1uK:\u000bW.Z\u000b\u0002sA\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0005Y\u0006twMC\u0001?\u0003\u0011Q\u0017M^1\n\u0005\u0001[$AB*ue&tw-\u0001\u0006ti\u0006$XMT1nK\u0002\nAc\u001c8Tg\u0016\u001cFO]3b[\u000e{gN\\3di\u0016$GC\u0001#H!\t\u0001T)\u0003\u0002G#\taa*\u001a=u'N,7\u000b^1uK\")\u0001*\u0002a\u0001\u0013\u0006IA/[7fgR\fW\u000e\u001d\t\u0003A)K!aS\u0011\u0003\t1{gnZ\u0001\u000b_:\u001cV\r^\"iK\u000e\\G#\u0002#O52,\b\"B(\u0007\u0001\u0004\u0001\u0016AC1di&|gNT1nKB\u0011\u0011\u000b\u0017\b\u0003%Z\u0003\"aU\u0011\u000e\u0003QS!!V\u000f\u0002\rq\u0012xn\u001c;?\u0013\t9\u0016%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001fS!aV\u0011\t\u000bm3\u0001\u0019\u0001/\u0002\u001d\rDWmY6TKF,XM\\2fgB\u0019QLY3\u000f\u0005y\u0003gBA*`\u0013\u0005\u0011\u0013BA1\"\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00193\u0003\t1K7\u000f\u001e\u0006\u0003C\u0006\u0002\"A\u001a6\u000e\u0003\u001dT!\u0001\u00065\u000b\u0005%<\u0012!B2iK\u000e\\\u0017BA6h\u0005]\u00196/Z'fgN\fw-Z\"iK\u000e\\7+Z9vK:\u001cW\rC\u0003n\r\u0001\u0007a.A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005=\u001cX\"\u00019\u000b\u00055\f(B\u0001:\u001a\u0003\u0011\u0019wN]3\n\u0005Q\u0004(aB*fgNLwN\u001c\u0005\u0006m\u001a\u0001\ra^\u0001\u0005]\u0016DH\u000f\u0005\u0002yu6\t\u0011P\u0003\u0002\u0017c&\u001110\u001f\u0002\u0007\u0003\u000e$\u0018n\u001c8\u0002\u001b=t7k]3SK\u000e,\u0017N^3e)\u0011!e0a\u0002\t\r}<\u0001\u0019AA\u0001\u0003\u0015)g/\u001a8u!\r\u0001\u00141A\u0005\u0004\u0003\u000b\t\"aD*feZ,'oU3oi\u00163XM\u001c;\t\u000b!;\u0001\u0019A%\u0002!=t7k]3F]\u0012|em\u0015;sK\u0006lGc\u0001#\u0002\u000e!)\u0001\n\u0003a\u0001\u0013\u0006\trN\\*tKN#(/Z1n\u00072|7/\u001a3\u0015\u0007\u0011\u000b\u0019\u0002C\u0003I\u0013\u0001\u0007\u0011*\u0001\u000bp]\u000ec\u0017.\u001a8u\u00072|7/\u001a*fcV,7\u000f\u001e\u000b\b\t\u0006e\u00111DA\u000f\u0011\u0015y%\u00021\u0001Q\u0011\u0015i'\u00021\u0001o\u0011\u00151(\u00021\u0001x\u0003%yg\u000eV5nK>,H\u000fF\u0001E\u00039yg.\u00137mK\u001e\fGn\u0015;bi\u0016$R\u0001RA\u0014\u0003WAa!!\u000b\r\u0001\u0004\u0001\u0016aB7fgN\fw-\u001a\u0005\u0006\u00112\u0001\r!S\u0001\u0013_:\u001c6/Z*ue\u0016\fWn\u0011:bg\",G\rF\u0003E\u0003c\tY\u0004C\u0004\u000245\u0001\r!!\u000e\u0002\u0003Q\u00042!XA\u001c\u0013\r\tI\u0004\u001a\u0002\n)\"\u0014xn^1cY\u0016DQ\u0001S\u0007A\u0002%\u000b\u0011\u0004\\8h+:l\u0017\r^2iK\u0012\u001cVM\u001d<fe6+7o]1hKR!\u0011\u0011IA$!\r\u0001\u00131I\u0005\u0004\u0003\u000b\n#\u0001B+oSRDQ!\u001c\bA\u00029\f1\u0002\\8h%\u0016\u001c\bo\u001c8tKRya.!\u0014\u0002P\u0005E\u0013QKA-\u0003[\n9\bC\u0003n\u001f\u0001\u0007a\u000eC\u0003P\u001f\u0001\u0007\u0001\u000b\u0003\u0004\u0002T=\u0001\r!S\u0001\u0006gR\f'\u000f\u001e\u0005\u0007\u0003/z\u0001\u0019A%\u0002\u0007\u0015tG\rC\u0004\u0002\\=\u0001\r!!\u0018\u0002\rM$\u0018\r^;t!\u0011\ty&!\u001b\u000e\u0005\u0005\u0005$\u0002BA2\u0003K\nQa\u001d;biNT1!a\u001a\u001a\u0003\u001d\u0019w.\\7p]NLA!a\u001b\u0002b\t11\u000b^1ukNDq!a\u001c\u0010\u0001\u0004\t\t(\u0001\u0003d_\u0012,\u0007\u0003\u0002\u0011\u0002tAK1!!\u001e\"\u0005\u0019y\u0005\u000f^5p]\"9\u0011\u0011P\bA\u0002\u0005E\u0014A\u0002:fCN|g\u000e")
public abstract class SseState
implements StrictLogging {
    private final SseFsm fsm;
    private final String stateName;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private String stateName() {
        return this.stateName;
    }

    public NextSseState onSseStreamConnected(long timestamp) {
        return this.onIllegalState("Can't call onSseStreamConnected in " + this.stateName() + " state", timestamp);
    }

    public NextSseState onSetCheck(String actionName, List<SseMessageCheckSequence> checkSequences, Session session, Action next) {
        return this.onIllegalState("Can't call onSetCheck in " + this.stateName() + " state", this.fsm.clock().nowMillis());
    }

    public NextSseState onSseReceived(ServerSentEvent event, long timestamp) {
        return this.onIllegalState("Can't call onSseReceived in " + this.stateName() + " state", timestamp);
    }

    public NextSseState onSseEndOfStream(long timestamp) {
        return this.onIllegalState("Can't call onSseEndOfStream in " + this.stateName() + " state", timestamp);
    }

    public NextSseState onSseStreamClosed(long timestamp) {
        return this.onIllegalState("Can't call onSseStreamClosed in " + this.stateName() + " state", timestamp);
    }

    public NextSseState onClientCloseRequest(String actionName, Session session, Action next) {
        return this.onIllegalState("Can't call onClientCloseRequest in " + this.stateName() + " state", this.fsm.clock().nowMillis());
    }

    public NextSseState onTimeout() {
        return this.onIllegalState("Can't call onTimeout in " + this.stateName() + " state", this.fsm.clock().nowMillis());
    }

    private NextSseState onIllegalState(String message, long timestamp) {
        BoxedUnit boxedUnit;
        this.fsm.cancelTimeout();
        IllegalStateException error = new IllegalStateException(message);
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error(error.getMessage(), (Throwable)error);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.onSseStreamCrashed(error, timestamp);
    }

    public NextSseState onSseStreamCrashed(Throwable t, long timestamp) {
        BoxedUnit boxedUnit;
        this.fsm.cancelTimeout();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("SSE crashed by the server while in " + this.stateName() + " state", t);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new NextSseState(new SseCrashedState(this.fsm, Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(t))), NextSseState$.MODULE$.apply$default$2());
    }

    public void logUnmatchedServerMessage(Session session) {
        this.fsm.statsEngine().logResponse(session.scenario(), session.groups(), this.fsm.sseName(), this.fsm.clock().nowMillis(), Long.MIN_VALUE, (Status)OK$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
    }

    public Session logResponse(Session session, String actionName, long start, long end, Status status, Option<String> code, Option<String> reason) {
        Session newSession = session.logGroupRequestTimings(start, end);
        Status status2 = status;
        KO$ kO$ = KO$.MODULE$;
        Session newSessionWithMark = !(status2 != null ? !status2.equals(kO$) : kO$ != null) ? newSession.markAsFailed() : newSession;
        this.fsm.statsEngine().logResponse(session.scenario(), session.groups(), actionName, start, end, status, code, reason);
        return newSessionWithMark;
    }

    public SseState(SseFsm fsm) {
        this.fsm = fsm;
        StrictLogging.$init$((StrictLogging)this);
        this.stateName = this.getClass().getSimpleName();
        Statics.releaseFence();
    }
}

