/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.ws.fsm;

import akka.actor.FSM;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.action.ws.fsm.Closing$;
import io.gatling.http.action.ws.fsm.ClosingData;
import io.gatling.http.action.ws.fsm.FrameReceived;
import io.gatling.http.action.ws.fsm.WebSocketClosed;
import io.gatling.http.action.ws.fsm.WebSocketCrashed;
import io.gatling.http.action.ws.fsm.WsActor;
import io.gatling.http.action.ws.fsm.WsActorData;
import io.gatling.http.action.ws.fsm.WsActorState;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00012\u0001BA\u0002\u0011\u0002\u0007\u0005\u0001\u0003\b\u0005\u0006/\u0001!\t\u0001\u0007\u0002\f/\",gn\u00117pg&twM\u0003\u0002\u0005\u000b\u0005\u0019am]7\u000b\u0005\u00199\u0011AA<t\u0015\tA\u0011\"\u0001\u0004bGRLwN\u001c\u0006\u0003\u0015-\tA\u0001\u001b;ua*\u0011A\"D\u0001\bO\u0006$H.\u001b8h\u0015\u0005q\u0011AA5p\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uIQ\t\u0011\u0004\u0005\u0002\u00135%\u00111d\u0005\u0002\u0005+:LG\u000f\u0005\u0002\u001e=5\t1!\u0003\u0002 \u0007\t9qk]!di>\u0014\b")
public interface WhenClosing {
    public static void $init$(WhenClosing $this) {
        ((FSM)$this).when((Object)Closing$.MODULE$, ((FSM)$this).when$default$2(), (PartialFunction)new Serializable((WsActor)$this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WsActor $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends FSM.Event<WsActorData>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                FSM.State<WsActorState, WsActorData> state;
                A1 A1 = x1;
                if (A1 != null) {
                    WsActorData wsActorData = (WsActorData)A1.stateData();
                    if (A1.event() instanceof FrameReceived && wsActorData instanceof ClosingData) {
                        ClosingData closingData = (ClosingData)wsActorData;
                        Session session = closingData.session();
                        this.$outer.logUnmatchedServerMessage(session);
                        state = this.$outer.stay();
                        return (B1)state;
                    }
                }
                if (A1 != null) {
                    Object object = A1.event();
                    WsActorData wsActorData = (WsActorData)A1.stateData();
                    if (object instanceof WebSocketClosed) {
                        WebSocketClosed webSocketClosed = (WebSocketClosed)object;
                        long timestamp = webSocketClosed.timestamp();
                        if (wsActorData instanceof ClosingData) {
                            BoxedUnit boxedUnit;
                            ClosingData closingData = (ClosingData)wsActorData;
                            String actionName = closingData.actionName();
                            Session session = closingData.session();
                            Action next = closingData.next();
                            long closeStart = closingData.timestamp();
                            if (this.$outer.logger().underlying().isInfoEnabled()) {
                                this.$outer.logger().underlying().info("Server has acked closing");
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            Session newSession = this.$outer.logResponse(session, actionName, closeStart, timestamp, (Status)OK$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
                            next.$bang(newSession.remove(this.$outer.wsName()));
                            state = this.$outer.stop();
                            return (B1)state;
                        }
                    }
                }
                if (A1 != null) {
                    Object object = A1.event();
                    WsActorData wsActorData = (WsActorData)A1.stateData();
                    if (object instanceof WebSocketCrashed) {
                        WebSocketCrashed webSocketCrashed = (WebSocketCrashed)object;
                        Throwable t = webSocketCrashed.t();
                        long timestamp = webSocketCrashed.timestamp();
                        if (wsActorData instanceof ClosingData) {
                            BoxedUnit boxedUnit;
                            ClosingData closingData = (ClosingData)wsActorData;
                            String actionName = closingData.actionName();
                            Session session = closingData.session();
                            Action next = closingData.next();
                            long closeStart = closingData.timestamp();
                            if (this.$outer.logger().underlying().isInfoEnabled()) {
                                this.$outer.logger().underlying().info("WebSocket crashed while waiting for close ack");
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            Session newSession = this.$outer.logResponse(session, actionName, closeStart, timestamp, (Status)KO$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)t.getMessage()));
                            next.$bang(newSession.markAsFailed().remove(this.$outer.wsName()));
                            state = this.$outer.stop();
                            return (B1)state;
                        }
                    }
                }
                state = function1.apply(x1);
                return (B1)state;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(FSM.Event<WsActorData> x1) {
                FSM.Event<WsActorData> event = x1;
                if (event != null) {
                    WsActorData wsActorData = (WsActorData)event.stateData();
                    if (event.event() instanceof FrameReceived) {
                        if (wsActorData instanceof ClosingData) return true;
                    }
                }
                if (event != null) {
                    Object object = event.event();
                    WsActorData wsActorData = (WsActorData)event.stateData();
                    if (object instanceof WebSocketClosed) {
                        if (wsActorData instanceof ClosingData) return true;
                    }
                }
                if (event == null) return false;
                Object object = event.event();
                WsActorData wsActorData = (WsActorData)event.stateData();
                if (!(object instanceof WebSocketCrashed)) return false;
                if (wsActorData instanceof ClosingData) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

