/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.HttpConfiguration;
import io.gatling.http.util.SslContexts;
import io.gatling.http.util.SslContextsFactory$;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Serializable;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005}rA\u0002\u000b\u0016\u0011\u00039RD\u0002\u0004 +!\u0005q\u0003\t\u0005\u0006O\u0005!\t!\u000b\u0005\bU\u0005\u0011\r\u0011\"\u0003,\u0011\u0019!\u0014\u0001)A\u0005Y!9Q'\u0001b\u0001\n\u00131\u0004BB!\u0002A\u0003%qGB\u0003 +\u0001I\"\t\u0003\u0005N\u000f\t\u0005\t\u0015!\u0003O\u0011\u00159s\u0001\"\u0001W\u0011\u001dIvA1A\u0005\niCaAX\u0004!\u0002\u0013Y\u0006bB0\b\u0005\u0004%I\u0001\u0019\u0005\u0007_\u001e\u0001\u000b\u0011B1\t\u000fA<!\u0019!C\u0005c\"1qo\u0002Q\u0001\nIDq\u0001_\u0004C\u0002\u0013%\u0011\u0010\u0003\u0004~\u000f\u0001\u0006IA\u001f\u0005\u0006}\u001e!\ta \u0005\b\u0003O9A\u0011BA\u0015\u0003I\u00196\u000f\\\"p]R,\u0007\u0010^:GC\u000e$xN]=\u000b\u0005Y9\u0012\u0001B;uS2T!\u0001G\r\u0002\t!$H\u000f\u001d\u0006\u00035m\tqaZ1uY&twMC\u0001\u001d\u0003\tIw\u000e\u0005\u0002\u001f\u00035\tQC\u0001\nTg2\u001cuN\u001c;fqR\u001ch)Y2u_JL8CA\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001\u001e\u0003Y!UMZ1vYR\u001c6\u000f\\*fGV\u0014XMU1oI>lW#\u0001\u0017\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003E\nAA[1wC&\u00111G\f\u0002\r'\u0016\u001cWO]3SC:$w.\\\u0001\u0018\t\u00164\u0017-\u001e7u'Nd7+Z2ve\u0016\u0014\u0016M\u001c3p[\u0002\n1!\u00119o+\u00059\u0004C\u0001\u001d@\u001b\u0005I$B\u0001\u001e<\u0003\r\u00198\u000f\u001c\u0006\u0003yu\nq\u0001[1oI2,'O\u0003\u0002?7\u0005)a.\u001a;us&\u0011\u0001)\u000f\u0002\u001a\u0003B\u0004H.[2bi&|g\u000e\u0015:pi>\u001cw\u000e\\\"p]\u001aLw-\u0001\u0003Ba:\u00043cA\u0004\"\u0007B\u0011AiS\u0007\u0002\u000b*\u0011aiR\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003\u0011&\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u0015\u0006\u00191m\\7\n\u00051+%!D*ue&\u001cG\u000fT8hO&tw-\u0001\u0006iiR\u00048i\u001c8gS\u001e\u0004\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\r\r|gNZ5h\u0015\t\u0019\u0016$\u0001\u0003d_J,\u0017BA+Q\u0005EAE\u000f\u001e9D_:4\u0017nZ;sCRLwN\u001c\u000b\u0003/b\u0003\"AH\u0004\t\u000b5K\u0001\u0019\u0001(\u00021M\u001cHnU3tg&|g\u000eV5nK>,HoU3d_:$7/F\u0001\\!\t\u0011C,\u0003\u0002^G\t!Aj\u001c8h\u0003e\u00198\u000f\\*fgNLwN\u001c+j[\u0016|W\u000f^*fG>tGm\u001d\u0011\u0002!\u0015t\u0017M\u00197fIB\u0013x\u000e^8d_2\u001cX#A1\u0011\u0007\t\u0012G-\u0003\u0002dG\t)\u0011I\u001d:bsB\u0011Q\r\u001c\b\u0003M*\u0004\"aZ\u0012\u000e\u0003!T!!\u001b\u0015\u0002\rq\u0012xn\u001c;?\u0013\tY7%\u0001\u0004Qe\u0016$WMZ\u0005\u0003[:\u0014aa\u0015;sS:<'BA6$\u0003E)g.\u00192mK\u0012\u0004&o\u001c;pG>d7\u000fI\u0001\u0014K:\f'\r\\3e\u0007&\u0004\b.\u001a:Tk&$Xm]\u000b\u0002eB\u00191/\u001e3\u000e\u0003QT!A\u0006\u0019\n\u0005Y$(\u0001\u0002'jgR\fA#\u001a8bE2,GmQ5qQ\u0016\u00148+^5uKN\u0004\u0013AC;tK>\u0003XM\\*tYV\t!\u0010\u0005\u0002#w&\u0011Ap\t\u0002\b\u0005>|G.Z1o\u0003-)8/Z(qK:\u001c6\u000f\u001c\u0011\u0002\u001d9,woU:m\u0007>tG/\u001a=ugR1\u0011\u0011AA\u0004\u0003\u0017\u00012AHA\u0002\u0013\r\t)!\u0006\u0002\f'Nd7i\u001c8uKb$8\u000f\u0003\u0004\u0002\nI\u0001\rA_\u0001\rQR$\bOM#oC\ndW\r\u001a\u0005\b\u0003\u001b\u0011\u0002\u0019AA\b\u0003a\u0001XM]+tKJ\\U-_'b]\u0006<WM\u001d$bGR|'/\u001f\t\u0006E\u0005E\u0011QC\u0005\u0004\u0003'\u0019#AB(qi&|g\u000e\u0005\u0003\u0002\u0018\u0005\rRBAA\r\u0015\rQ\u00141\u0004\u0006\u0005\u0003;\ty\"A\u0002oKRT!!!\t\u0002\u000b)\fg/\u0019=\n\t\u0005\u0015\u0012\u0011\u0004\u0002\u0012\u0017\u0016LX*\u00198bO\u0016\u0014h)Y2u_JL\u0018!\u00048foN\u001bHnQ8oi\u0016DH\u000f\u0006\u0004\u0002,\u0005E\u00121\b\t\u0004q\u00055\u0012bAA\u0018s\tQ1k\u001d7D_:$X\r\u001f;\t\u000f\u0005M2\u00031\u0001\u00026\u0005i!\u000eZ6Tg2\u001cuN\u001c;fqR\u0004B!a\u0006\u00028%!\u0011\u0011HA\r\u0005)\u00196\u000bT\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003{\u0019\u0002\u0019A\u001c\u0002\u0007\u0005\u0004h\u000e")
public class SslContextsFactory
implements StrictLogging {
    private final HttpConfiguration httpConfig;
    private final long sslSessionTimeoutSeconds;
    private final String[] enabledProtocols;
    private final List<String> enabledCipherSuites;
    private final boolean useOpenSsl;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private long sslSessionTimeoutSeconds() {
        return this.sslSessionTimeoutSeconds;
    }

    private String[] enabledProtocols() {
        return this.enabledProtocols;
    }

    private List<String> enabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    private boolean useOpenSsl() {
        return this.useOpenSsl;
    }

    public SslContexts newSslContexts(boolean http2Enabled, Option<KeyManagerFactory> perUserKeyManagerFactory) {
        SslContexts sslContexts;
        Option kmf = perUserKeyManagerFactory.orElse((Function0 & Serializable & scala.Serializable)() -> $this.httpConfig.ssl().keyManagerFactory());
        Option tmf = this.httpConfig.ssl().trustManagerFactory().orElse((Function0 & Serializable & scala.Serializable)() -> $this.httpConfig.advanced().useInsecureTrustManager() ? new Some((Object)InsecureTrustManagerFactory.INSTANCE) : None$.MODULE$);
        if (this.useOpenSsl()) {
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL);
            Object object = this.httpConfig.advanced().sslSessionCacheSize() > 0 ? sslContextBuilder.sessionCacheSize((long)this.httpConfig.advanced().sslSessionCacheSize()) : BoxedUnit.UNIT;
            Object object2 = this.httpConfig.advanced().sslSessionTimeout().$greater((Object)Duration$.MODULE$.Zero()) ? sslContextBuilder.sessionTimeout(this.sslSessionTimeoutSeconds()) : BoxedUnit.UNIT;
            Object object3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.enabledProtocols())).nonEmpty() ? sslContextBuilder.protocols(this.enabledProtocols()) : BoxedUnit.UNIT;
            SslContextBuilder sslContextBuilder2 = this.httpConfig.advanced().sslEnabledCipherSuites().nonEmpty() ? sslContextBuilder.ciphers(this.enabledCipherSuites()) : sslContextBuilder.ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS);
            kmf.foreach((Function1 & Serializable & scala.Serializable)x$1 -> sslContextBuilder.keyManager(x$1));
            tmf.foreach((Function1 & Serializable & scala.Serializable)x$1 -> sslContextBuilder.trustManager(x$1));
            SslContext sslContext = sslContextBuilder.build();
            None$ alpnSslContext = http2Enabled ? new Some((Object)sslContextBuilder.applicationProtocolConfig(SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn()).build()) : None$.MODULE$;
            sslContexts = new SslContexts(sslContext, (Option<SslContext>)alpnSslContext);
        } else {
            SSLContext jdkSslContext = SSLContext.getInstance("TLS");
            jdkSslContext.init((KeyManager[])kmf.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getKeyManagers()).orNull(Predef$.MODULE$.$conforms()), (TrustManager[])tmf.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getTrustManagers()).orNull(Predef$.MODULE$.$conforms()), SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$DefaultSslSecureRandom());
            SslContext sslContext = this.newSslContext(jdkSslContext, null);
            None$ alpnSslContext = http2Enabled ? new Some((Object)this.newSslContext(jdkSslContext, SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn())) : None$.MODULE$;
            sslContexts = new SslContexts(sslContext, (Option<SslContext>)alpnSslContext);
        }
        return sslContexts;
    }

    private SslContext newSslContext(SSLContext jdkSslContext, ApplicationProtocolConfig apn) {
        return new JdkSslContext(jdkSslContext, true, this.enabledCipherSuites().isEmpty() ? null : this.enabledCipherSuites(), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS, apn, ClientAuth.NONE, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.enabledProtocols())).nonEmpty() ? this.enabledProtocols() : null, false);
    }

    /*
     * WARNING - void declaration
     */
    public SslContextsFactory(HttpConfiguration httpConfig) {
        boolean bl;
        this.httpConfig = httpConfig;
        StrictLogging.$init$((StrictLogging)this);
        this.sslSessionTimeoutSeconds = httpConfig.advanced().sslSessionTimeout().toSeconds();
        this.enabledProtocols = (String[])httpConfig.advanced().sslEnabledProtocols().toArray(ClassTag$.MODULE$.apply(String.class));
        this.enabledCipherSuites = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)httpConfig.advanced().sslEnabledCipherSuites()).asJava();
        if (httpConfig.advanced().useOpenSsl()) {
            void var2_2;
            BoxedUnit boxedUnit;
            boolean available = OpenSsl.isAvailable();
            if (!available) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("OpenSSL is enabled in the Gatling configuration but it's not available on your architecture.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = var2_2;
        } else {
            bl = false;
        }
        this.useOpenSsl = bl;
    }
}

