/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse.fsm;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.action.sse.fsm.NextSseState;
import io.gatling.http.action.sse.fsm.NextSseState$;
import io.gatling.http.action.sse.fsm.SseClosedState;
import io.gatling.http.action.sse.fsm.SseFsm;
import io.gatling.http.action.sse.fsm.SseState;
import java.io.Serializable;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000154AAC\u0006\u00011!AA\u0002\u0001B\u0001B\u0003%q\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0011!A\u0004A!A!\u0002\u0013I\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dCQa\u0013\u0001\u0005\u00021CQa\u0015\u0001\u0005BQCQa\u0017\u0001\u0005BqCQa\u0018\u0001\u0005B\u0001\u0014qbU:f\u00072|7/\u001b8h'R\fG/\u001a\u0006\u0003\u00195\t1AZ:n\u0015\tqq\"A\u0002tg\u0016T!\u0001E\t\u0002\r\u0005\u001cG/[8o\u0015\t\u00112#\u0001\u0003iiR\u0004(B\u0001\u000b\u0016\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011AF\u0001\u0003S>\u001c\u0001aE\u0002\u00013u\u0001\"AG\u000e\u000e\u0003-I!\u0001H\u0006\u0003\u0011M\u001bXm\u0015;bi\u0016\u0004\"AH\u0013\u000e\u0003}Q!\u0001I\u0011\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\t\u001a\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0011\n1aY8n\u0013\t1sDA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\t\u00035!J!!K\u0006\u0003\rM\u001bXMR:n\u0003)\t7\r^5p]:\u000bW.\u001a\t\u0003YUr!!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0005A:\u0012A\u0002\u001fs_>$hHC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014'\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b2\u0003\u001d\u0019Xm]:j_:\u0004\"A\u000f \u000e\u0003mR!\u0001\u000f\u001f\u000b\u0005u\u001a\u0012\u0001B2pe\u0016L!aP\u001e\u0003\u000fM+7o]5p]\u0006!a.\u001a=u!\t\u0011E)D\u0001D\u0015\t\u0001B(\u0003\u0002F\u0007\n1\u0011i\u0019;j_:\f\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0005!KU\"A\u0019\n\u0005)\u000b$\u0001\u0002'p]\u001e\fa\u0001P5oSRtDCB'O\u001fB\u000b&\u000b\u0005\u0002\u001b\u0001!)AB\u0002a\u0001O!)!F\u0002a\u0001W!)\u0001H\u0002a\u0001s!)\u0001I\u0002a\u0001\u0003\")aI\u0002a\u0001\u000f\u0006iqN\\*tKJ+7-Z5wK\u0012$2!\u0016-[!\tQb+\u0003\u0002X\u0017\taa*\u001a=u'N,7\u000b^1uK\")\u0011l\u0002a\u0001W\u00059Q.Z:tC\u001e,\u0007\"\u0002$\b\u0001\u00049\u0015!E8o'N,7\u000b\u001e:fC6\u001cEn\\:fIR\u0011Q+\u0018\u0005\u0006=\"\u0001\raR\u0001\u000bG2|7/Z*uCJ$\u0018AE8o'N,7\u000b\u001e:fC6\u001c%/Y:iK\u0012$2!V1m\u0011\u0015\u0011\u0017\u00021\u0001d\u0003\u0005!\bC\u00013j\u001d\t)wM\u0004\u0002/M&\t!'\u0003\u0002ic\u00059\u0001/Y2lC\u001e,\u0017B\u00016l\u0005%!\u0006N]8xC\ndWM\u0003\u0002ic!)a,\u0003a\u0001\u000f\u0002")
public class SseClosingState
extends SseState
implements StrictLogging {
    private final SseFsm fsm;
    private final String actionName;
    private final Session session;
    private final Action next;
    private final long timestamp;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public NextSseState onSseReceived(String message, long timestamp) {
        this.logUnmatchedServerMessage(this.session);
        return new NextSseState(this, NextSseState$.MODULE$.apply$default$2());
    }

    @Override
    public NextSseState onSseStreamClosed(long closeStart) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Socket closed");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Session newSession = this.logResponse(this.session, this.actionName, closeStart, this.timestamp, (Status)OK$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$).remove(this.fsm.wsName());
        return new NextSseState(new SseClosedState(this.fsm), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.next.$bang(newSession));
    }

    @Override
    public NextSseState onSseStreamCrashed(Throwable t, long closeStart) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("SSE stream crashed while waiting for socket close");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Session newSession = this.logResponse(this.session, this.actionName, closeStart, this.timestamp, (Status)KO$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)t.getMessage())).markAsFailed().remove(this.fsm.wsName());
        return new NextSseState(new SseClosedState(this.fsm), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.next.$bang(newSession));
    }

    public SseClosingState(SseFsm fsm, String actionName, Session session, Action next, long timestamp) {
        this.fsm = fsm;
        this.actionName = actionName;
        this.session = session;
        this.next = next;
        this.timestamp = timestamp;
        super(fsm);
        StrictLogging.$init$((StrictLogging)this);
    }
}

