/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse.fsm;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.action.sse.fsm.NextSseState;
import io.gatling.http.action.sse.fsm.NextSseState$;
import io.gatling.http.action.sse.fsm.SetCheck;
import io.gatling.http.action.sse.fsm.SseConnectingState$;
import io.gatling.http.action.sse.fsm.SseCrashedState;
import io.gatling.http.action.sse.fsm.SseFsm;
import io.gatling.http.action.sse.fsm.SseIdleState;
import io.gatling.http.action.sse.fsm.SsePerformingCheckState;
import io.gatling.http.action.sse.fsm.SseState;
import io.gatling.http.action.sse.fsm.SseStream;
import io.gatling.http.check.sse.SseMessageCheck;
import io.gatling.http.check.sse.SseMessageCheckSequence;
import io.gatling.http.engine.HttpEngine;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.util.SslContexts;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005%t!\u0002\n\u0014\u0011\u0003\u0001c!\u0002\u0012\u0014\u0011\u0003\u0019\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004b\u0002\u001a\u0002\u0005\u0004%Ia\r\u0005\u0007\u007f\u0005\u0001\u000b\u0011\u0002\u001b\t\u000b\u0001\u000bA\u0011A!\t\u000b\u0001\u000bA\u0011\u00015\u0007\t\t\u001a\u0002!\u001d\u0005\t)\u001d\u0011\t\u0011)A\u0005\r\"A!j\u0002B\u0001B\u0003%1\n\u0003\u0005T\u000f\t\u0005\t\u0015!\u0003U\u0011%yxA!A!\u0002\u0013\t\t\u0001\u0003\u0005n\u000f\t\u0005\t\u0015!\u0003o\u0011\u0019\u0001t\u0001\"\u0001\u0002\b!9\u0011QC\u0004\u0005\n\u0005]\u0001bBA!\u000f\u0011\u0005\u00131\t\u0005\b\u0003#:A\u0011IA*\u0011\u001d\tIf\u0002C!\u00037\n!cU:f\u0007>tg.Z2uS:<7\u000b^1uK*\u0011A#F\u0001\u0004MNl'B\u0001\f\u0018\u0003\r\u00198/\u001a\u0006\u00031e\ta!Y2uS>t'B\u0001\u000e\u001c\u0003\u0011AG\u000f\u001e9\u000b\u0005qi\u0012aB4bi2Lgn\u001a\u0006\u0002=\u0005\u0011\u0011n\\\u0002\u0001!\t\t\u0013!D\u0001\u0014\u0005I\u00196/Z\"p]:,7\r^5oON#\u0018\r^3\u0014\u0007\u0005!#\u0006\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VM\u001a\t\u0003W9j\u0011\u0001\f\u0006\u0003[e\tQaY1dQ\u0016L!a\f\u0017\u0003#M\u001bHnQ8oi\u0016DHoU;qa>\u0014H/\u0001\u0004=S:LGO\u0010\u000b\u0002A\u0005Y2k]3D_:tWm\u0019;Tk\u000e\u001cWm]:Ti\u0006$Xo]\"pI\u0016,\u0012\u0001\u000e\t\u0004KU:\u0014B\u0001\u001c'\u0005\u0011\u0019v.\\3\u0011\u0005ajT\"A\u001d\u000b\u0005iZ\u0014\u0001\u00027b]\u001eT\u0011\u0001P\u0001\u0005U\u00064\u0018-\u0003\u0002?s\t11\u000b\u001e:j]\u001e\fAdU:f\u0007>tg.Z2u'V\u001c7-Z:t'R\fG/^:D_\u0012,\u0007%\u0001\bh_R|7i\u001c8oK\u000e$\u0018N\\4\u0015\t\t+\u0015J\u0015\t\u0003C\rK!\u0001R\n\u0003\u00199+\u0007\u0010^*tKN#\u0018\r^3\t\u000bQ)\u0001\u0019\u0001$\u0011\u0005\u0005:\u0015B\u0001%\u0014\u0005\u0019\u00196/\u001a$t[\")!*\u0002a\u0001\u0017\u000691/Z:tS>t\u0007C\u0001'Q\u001b\u0005i%B\u0001&O\u0015\ty5$\u0001\u0003d_J,\u0017BA)N\u0005\u001d\u0019Vm]:j_:DQaU\u0003A\u0002Q\u000bAA\\3yiB!Q+\u00181f\u001d\t16L\u0004\u0002X56\t\u0001L\u0003\u0002Z?\u00051AH]8pizJ\u0011aJ\u0005\u00039\u001a\nq\u0001]1dW\u0006<W-\u0003\u0002_?\n1Q)\u001b;iKJT!\u0001\u0018\u0014\u0011\u0005\u0005\u001cW\"\u00012\u000b\u0005aq\u0015B\u00013c\u0005\u0019\t5\r^5p]B\u0011\u0011EZ\u0005\u0003ON\u0011\u0001bU3u\u0007\",7m\u001b\u000b\u0006\u0005&T7\u000e\u001c\u0005\u0006)\u0019\u0001\rA\u0012\u0005\u0006\u0015\u001a\u0001\ra\u0013\u0005\u0006'\u001a\u0001\r\u0001\u0016\u0005\u0006[\u001a\u0001\rA\\\u0001\u000fe\u0016l\u0017-\u001b8j]\u001e$&/[3t!\t)s.\u0003\u0002qM\t\u0019\u0011J\u001c;\u0014\u0007\u001d\u0011X\u000f\u0005\u0002\"g&\u0011Ao\u0005\u0002\t'N,7\u000b^1uKB\u0011a/`\u0007\u0002o*\u0011\u00010_\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003un\f\u0001\u0002^=qKN\fg-\u001a\u0006\u0002y\u0006\u00191m\\7\n\u0005y<(!D*ue&\u001cG\u000fT8hO&tw-\u0001\u0007d_:tWm\u0019;Ti\u0006\u0014H\u000fE\u0002&\u0003\u0007I1!!\u0002'\u0005\u0011auN\\4\u0015\u0019\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0011\u0005\u0005:\u0001\"\u0002\u000b\u000e\u0001\u00041\u0005\"\u0002&\u000e\u0001\u0004Y\u0005\"B*\u000e\u0001\u0004!\u0006BB@\u000e\u0001\u0004\t\t\u0001C\u0003n\u001b\u0001\u0007a.\u0001\u000biC:$G.Z\"p]:,7\r\u001e$bS2,(/\u001a\u000b\u0010\u0005\u0006e\u00111DA\u000f\u0003?\t\u0019#a\u000f\u0002@!)!J\u0004a\u0001\u0017\")1K\u0004a\u0001)\"1qP\u0004a\u0001\u0003\u0003Aq!!\t\u000f\u0001\u0004\t\t!\u0001\u0006d_:tWm\u0019;F]\u0012Dq!!\n\u000f\u0001\u0004\t9#\u0001\u0003d_\u0012,\u0007#B\u0013\u0002*\u00055\u0012bAA\u0016M\t1q\n\u001d;j_:\u0004B!a\f\u000289!\u0011\u0011GA\u001a!\t9f%C\u0002\u00026\u0019\na\u0001\u0015:fI\u00164\u0017b\u0001 \u0002:)\u0019\u0011Q\u0007\u0014\t\u000f\u0005ub\u00021\u0001\u0002.\u00051!/Z1t_:DQ!\u001c\bA\u00029\fAc\u001c8Tg\u0016\u001cFO]3b[\u000e{gN\\3di\u0016$G#\u0002\"\u0002F\u0005=\u0003bBA$\u001f\u0001\u0007\u0011\u0011J\u0001\u0007gR\u0014X-Y7\u0011\u0007\u0005\nY%C\u0002\u0002NM\u0011\u0011bU:f'R\u0014X-Y7\t\u000f\u0005\u0005r\u00021\u0001\u0002\u0002\u0005\trN\\*tKN#(/Z1n\u00072|7/\u001a3\u0015\u0007\t\u000b)\u0006C\u0004\u0002XA\u0001\r!!\u0001\u0002\u0013QLW.Z:uC6\u0004\u0018AE8o'N,7\u000b\u001e:fC6\u001c%/Y:iK\u0012$RAQA/\u0003OBq!a\u0018\u0012\u0001\u0004\t\t'A\u0001u!\r)\u00161M\u0005\u0004\u0003Kz&!\u0003+ie><\u0018M\u00197f\u0011\u001d\t9&\u0005a\u0001\u0003\u0003\u0001")
public class SseConnectingState
extends SseState
implements StrictLogging {
    private final SseFsm fsm;
    private final Session session;
    private final Either<Action, SetCheck> next;
    private final long connectStart;
    private final int remainingTries;
    private final Logger logger;

    public static NextSseState gotoConnecting(SseFsm sseFsm, Session session, Either<Action, SetCheck> either, int n) {
        return SseConnectingState$.MODULE$.gotoConnecting(sseFsm, session, either, n);
    }

    public static NextSseState gotoConnecting(SseFsm sseFsm, Session session, Either<Action, SetCheck> either) {
        return SseConnectingState$.MODULE$.gotoConnecting(sseFsm, session, either);
    }

    public static Option<SslContexts> sslContexts(Session session) {
        return SseConnectingState$.MODULE$.sslContexts(session);
    }

    public static Function1<Session, Session> setSslContexts(HttpProtocol httpProtocol, HttpEngine httpEngine) {
        return SseConnectingState$.MODULE$.setSslContexts(httpProtocol, httpEngine);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private NextSseState handleConnectFailure(Session session, Either<Action, SetCheck> next, long connectStart, long connectEnd, Option<String> code, String reason, int remainingTries) {
        NextSseState nextSseState;
        Session newSession = this.logResponse(session, this.fsm.connectActionName(), connectStart, connectEnd, (Status)KO$.MODULE$, code, (Option<String>)new Some((Object)reason));
        int newRemainingTries = remainingTries - 1;
        if (newRemainingTries > 0) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Connect failed: {}:{}, retrying ({} remaining tries)", new Object[]{code, reason, BoxesRunTime.boxToInteger((int)newRemainingTries)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            nextSseState = SseConnectingState$.MODULE$.gotoConnecting(this.fsm, newSession, next, newRemainingTries);
        } else {
            Action action;
            Either<Action, SetCheck> either = next;
            if (either instanceof Left) {
                BoxedUnit boxedUnit;
                Left left = (Left)either;
                Action n = (Action)left.value();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Connect failed: {}:{}, no remaining tries, going to Crashed state and performing next action", new Object[]{code, reason});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                action = n;
            } else if (either instanceof Right) {
                BoxedUnit boxedUnit;
                Right right = (Right)either;
                SetCheck sendFrame = (SetCheck)right.value();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Connect failed: {}:{}, no remaining tries, going to Crashed state, failing pending Send and performing next action", new Object[]{code, reason});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.fsm.statsEngine().logCrash(newSession, sendFrame.actionName(), "Failed to reconnect");
                action = sendFrame.next();
            } else {
                throw new MatchError(either);
            }
            Action nextAction = action;
            nextSseState = new NextSseState(new SseCrashedState(this.fsm, (Option<String>)new Some((Object)reason)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> nextAction.$bang(newSession.markAsFailed()));
        }
        return nextSseState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NextSseState onSseStreamConnected(SseStream stream, long connectEnd) {
        Function0<BoxedUnit> function0;
        Either<Action, SetCheck> either;
        Session sessionWithGroupTimings = this.logResponse(this.session, this.fsm.connectActionName(), this.connectStart, connectEnd, (Status)OK$.MODULE$, (Option<String>)SseConnectingState$.MODULE$.io$gatling$http$action$sse$fsm$SseConnectingState$$SseConnectSuccessStatusCode(), (Option<String>)None$.MODULE$);
        List<SseMessageCheckSequence> list = this.fsm.connectCheckSequence();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            SseMessageCheckSequence sseMessageCheckSequence = (SseMessageCheckSequence)colon2.head();
            List remainingCheckSequences = colon2.tl$access$1();
            if (sseMessageCheckSequence != null) {
                FiniteDuration timeout = sseMessageCheckSequence.timeout();
                List<SseMessageCheck> list2 = sseMessageCheckSequence.checks();
                if (list2 instanceof .colon.colon) {
                    BoxedUnit boxedUnit;
                    .colon.colon colon3 = (.colon.colon)list2;
                    SseMessageCheck currentCheck = (SseMessageCheck)colon3.head();
                    List remainingChecks = colon3.tl$access$1();
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Connected, performing checks before proceeding");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.fsm.scheduleTimeout(timeout);
                    return new NextSseState(new SsePerformingCheckState(this.fsm, stream, currentCheck, (List<SseMessageCheck>)remainingChecks, connectEnd, (List<SseMessageCheckSequence>)remainingCheckSequences, sessionWithGroupTimings, this.next), NextSseState$.MODULE$.apply$default$2());
                }
            }
        }
        if ((either = this.next) instanceof Left) {
            BoxedUnit boxedUnit;
            Left left = (Left)either;
            Action nextAction = (Action)left.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Connected, no checks, performing next action");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            nextAction.$bang(sessionWithGroupTimings);
            function0 = BoxedUnit.UNIT;
            return new NextSseState(new SseIdleState(this.fsm, sessionWithGroupTimings, stream), NextSseState$.MODULE$.apply$default$2());
        } else {
            BoxedUnit boxedUnit;
            if (!(either instanceof Right)) throw new MatchError(either);
            Right right = (Right)either;
            SetCheck setCheck = (SetCheck)right.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Reconnected, no checks, sending pending message");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            function0 = this.setCheckNextAction(sessionWithGroupTimings, setCheck);
        }
        return new NextSseState(new SseIdleState(this.fsm, sessionWithGroupTimings, stream), NextSseState$.MODULE$.apply$default$2());
    }

    @Override
    public NextSseState onSseStreamClosed(long timestamp) {
        return this.handleConnectFailure(this.session, this.next, this.connectStart, timestamp, (Option<String>)None$.MODULE$, "Socket closed", this.remainingTries);
    }

    @Override
    public NextSseState onSseStreamCrashed(Throwable t, long timestamp) {
        return this.handleConnectFailure(this.session, this.next, this.connectStart, timestamp, (Option<String>)None$.MODULE$, Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(t)), this.remainingTries);
    }

    public SseConnectingState(SseFsm fsm, Session session, Either<Action, SetCheck> next, long connectStart, int remainingTries) {
        this.fsm = fsm;
        this.session = session;
        this.next = next;
        this.connectStart = connectStart;
        this.remainingTries = remainingTries;
        super(fsm);
        StrictLogging.$init$((StrictLogging)this);
    }
}

