/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse.fsm;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.action.sse.fsm.NextSseState;
import io.gatling.http.action.sse.fsm.SetCheck;
import io.gatling.http.action.sse.fsm.SseClosedState;
import io.gatling.http.action.sse.fsm.SseConnectingState$;
import io.gatling.http.action.sse.fsm.SseFsm;
import io.gatling.http.action.sse.fsm.SseState;
import io.gatling.http.check.sse.SseMessageCheckSequence;
import java.io.Serializable;
import scala.Function0;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001-4AAB\u0004\u0001)!A\u0001\u0002\u0001B\u0001B\u0003%1\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u0015i\u0004\u0001\"\u0011?\u0011\u0015!\u0006\u0001\"\u0011V\u0005=\u00196/Z\"sCNDW\rZ*uCR,'B\u0001\u0005\n\u0003\r17/\u001c\u0006\u0003\u0015-\t1a]:f\u0015\taQ\"\u0001\u0004bGRLwN\u001c\u0006\u0003\u001d=\tA\u0001\u001b;ua*\u0011\u0001#E\u0001\bO\u0006$H.\u001b8h\u0015\u0005\u0011\u0012AA5p\u0007\u0001\u00192\u0001A\u000b\u001a!\t1r#D\u0001\b\u0013\tArA\u0001\u0005Tg\u0016\u001cF/\u0019;f!\tQ\u0012%D\u0001\u001c\u0015\taR$\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002\u001f?\u0005AA/\u001f9fg\u00064WMC\u0001!\u0003\r\u0019w.\\\u0005\u0003Em\u0011Qb\u0015;sS\u000e$Hj\\4hS:<\u0007C\u0001\f%\u0013\t)sA\u0001\u0004Tg\u001645/\\\u0001\rKJ\u0014xN]'fgN\fw-\u001a\t\u0004Q-jS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\r=\u0003H/[8o!\tqSG\u0004\u00020gA\u0011\u0001'K\u0007\u0002c)\u0011!gE\u0001\u0007yI|w\u000e\u001e \n\u0005QJ\u0013A\u0002)sK\u0012,g-\u0003\u00027o\t11\u000b\u001e:j]\u001eT!\u0001N\u0015\u0002\rqJg.\u001b;?)\rQ4\b\u0010\t\u0003-\u0001AQ\u0001C\u0002A\u0002\rBQAJ\u0002A\u0002\u001d\nAc\u001c8DY&,g\u000e^\"m_N,'+Z9vKN$H\u0003B C\t6\u0003\"A\u0006!\n\u0005\u0005;!\u0001\u0004(fqR\u001c6/Z*uCR,\u0007\"B\"\u0005\u0001\u0004i\u0013AC1di&|gNT1nK\")Q\t\u0002a\u0001\r\u000691/Z:tS>t\u0007CA$L\u001b\u0005A%BA#J\u0015\tQu\"\u0001\u0003d_J,\u0017B\u0001'I\u0005\u001d\u0019Vm]:j_:DQA\u0014\u0003A\u0002=\u000bAA\\3yiB\u0011\u0001KU\u0007\u0002#*\u0011A\"S\u0005\u0003'F\u0013a!Q2uS>t\u0017AC8o'\u0016$8\t[3dWR)qHV,jU\")1)\u0002a\u0001[!)\u0001,\u0002a\u00013\u0006q1\r[3dWN+\u0017/^3oG\u0016\u001c\bc\u0001.`E:\u00111,\u0018\b\u0003aqK\u0011AK\u0005\u0003=&\nq\u0001]1dW\u0006<W-\u0003\u0002aC\n!A*[:u\u0015\tq\u0016\u0006\u0005\u0002dO6\tAM\u0003\u0002\u000bK*\u0011a-D\u0001\u0006G\",7m[\u0005\u0003Q\u0012\u0014qcU:f\u001b\u0016\u001c8/Y4f\u0007\",7m[*fcV,gnY3\t\u000b\u0015+\u0001\u0019\u0001$\t\u000b9+\u0001\u0019A(")
public class SseCrashedState
extends SseState
implements StrictLogging {
    private final SseFsm fsm;
    private final Option<String> errorMessage;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public NextSseState onClientCloseRequest(String actionName, Session session, Action next) {
        Session session2;
        Option<String> option = this.errorMessage;
        if (option instanceof Some) {
            Some some = (Some)option;
            String mess = (String)some.value();
            Session newSession = session.markAsFailed();
            this.fsm.statsEngine().logCrash(newSession, actionName, new StringBuilder(62).append("Client issued close order but SSE stream was already crashed: ").append(mess).toString());
            session2 = newSession;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Client issued close order but SSE stream was already closed");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            session2 = session;
        }
        Session newSession = session2;
        return new NextSseState(new SseClosedState(this.fsm), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> next.$bang(newSession.remove($this.fsm.wsName())));
    }

    @Override
    public NextSseState onSetCheck(String actionName, List<SseMessageCheckSequence> checkSequences, Session session, Action next) {
        BoxedUnit boxedUnit;
        String string;
        Option<String> option = this.errorMessage;
        if (option instanceof Some) {
            Some some = (Some)option;
            String mess = (String)some.value();
            string = new StringBuilder(58).append("Client issued message but SSE stream was already crashed: ").append(mess).toString();
        } else {
            string = "Client issued message but SSE stream was already closed";
        }
        String loggedMessage = string;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(loggedMessage);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return SseConnectingState$.MODULE$.gotoConnecting(this.fsm, session, (Either<Action, SetCheck>)package$.MODULE$.Right().apply((Object)new SetCheck(actionName, checkSequences, next)));
    }

    public SseCrashedState(SseFsm fsm, Option<String> errorMessage) {
        this.fsm = fsm;
        this.errorMessage = errorMessage;
        super(fsm);
        StrictLogging.$init$((StrictLogging)this);
    }
}

