/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.gatling.commons.util.Clock;
import io.gatling.http.client.HttpListener;
import io.gatling.http.engine.response.ResponseProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.response.ResponseBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001\u0002\n\u0014\u0001qA\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!AA\t\u0001B\u0001B\u0003%Q\tC\u0003L\u0001\u0011\u0005A\nC\u0004S\u0001\t\u0007I\u0011B*\t\re\u0003\u0001\u0015!\u0003U\u0011\u001dQ\u0006\u00011A\u0005\nmCqA\u0019\u0001A\u0002\u0013%1\r\u0003\u0004j\u0001\u0001\u0006K\u0001\u0018\u0005\bU\u0002\u0001\r\u0011\"\u0003\\\u0011\u001dY\u0007\u00011A\u0005\n1DaA\u001c\u0001!B\u0013a\u0006\"B8\u0001\t\u0003\u0002\b\"\u0002@\u0001\t\u0003z\bbBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011\u001d\t9\u0005\u0001C!\u0003\u0013\u00121cR1uY&tw\r\u0013;ua2K7\u000f^3oKJT!\u0001F\u000b\u0002\r\u0015tw-\u001b8f\u0015\t1r#\u0001\u0003iiR\u0004(B\u0001\r\u001a\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011AG\u0001\u0003S>\u001c\u0001a\u0005\u0003\u0001;\u0015Z\u0003C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0011a\u0017M\\4\u000b\u0003\t\nAA[1wC&\u0011Ae\b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!*\u0012AB2mS\u0016tG/\u0003\u0002+O\ta\u0001\n\u001e;q\u0019&\u001cH/\u001a8feB\u0011AfM\u0007\u0002[)\u0011afL\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003aE\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002e\u0005\u00191m\\7\n\u0005Qj#a\u0003'bufdunZ4j]\u001e\f!\u0001\u001e=\u0011\u0005]JT\"\u0001\u001d\u000b\u0005U\u001a\u0012B\u0001\u001e9\u0005\u0019AE\u000f\u001e9Uq\u0006)1\r\\8dWB\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0005kRLGN\u0003\u0002B/\u000591m\\7n_:\u001c\u0018BA\"?\u0005\u0015\u0019En\\2l\u0003E\u0011Xm\u001d9p]N,\u0007K]8dKN\u001cxN\u001d\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011N\t\u0001B]3ta>t7/Z\u0005\u0003\u0015\u001e\u0013\u0011CU3ta>t7/\u001a)s_\u000e,7o]8s\u0003\u0019a\u0014N\\5u}Q!Qj\u0014)R!\tq\u0005!D\u0001\u0014\u0011\u0015)D\u00011\u00017\u0011\u0015YD\u00011\u0001=\u0011\u0015!E\u00011\u0001F\u0003=\u0011Xm\u001d9p]N,')^5mI\u0016\u0014X#\u0001+\u0011\u0005U;V\"\u0001,\u000b\u0005!+\u0012B\u0001-W\u0005=\u0011Vm\u001d9p]N,')^5mI\u0016\u0014\u0018\u0001\u0005:fgB|gn]3Ck&dG-\u001a:!\u0003\u0011Ig.\u001b;\u0016\u0003q\u0003\"!\u00181\u000e\u0003yS\u0011aX\u0001\u0006g\u000e\fG.Y\u0005\u0003Cz\u0013qAQ8pY\u0016\fg.\u0001\u0005j]&$x\fJ3r)\t!w\r\u0005\u0002^K&\u0011aM\u0018\u0002\u0005+:LG\u000fC\u0004i\u0011\u0005\u0005\t\u0019\u0001/\u0002\u0007a$\u0013'A\u0003j]&$\b%\u0001\u0003e_:,\u0017\u0001\u00033p]\u0016|F%Z9\u0015\u0005\u0011l\u0007b\u00025\f\u0003\u0003\u0005\r\u0001X\u0001\u0006I>tW\rI\u0001\u0007_:\u001cVM\u001c3\u0015\u0005\u0011\f\b\"\u0002:\u000e\u0001\u0004\u0019\u0018AE<je\u0016\u0014V-];fgRDU-\u00193feN\u0004\"\u0001\u001e?\u000e\u0003UT!A\u0006<\u000b\u0005]D\u0018!B2pI\u0016\u001c'BA={\u0003\u001dA\u0017M\u001c3mKJT!a_\r\u0002\u000b9,G\u000f^=\n\u0005u,(a\u0003%uiBDU-\u00193feN\fab\u001c8IiR\u0004(+Z:q_:\u001cX\rF\u0003e\u0003\u0003\tY\u0001C\u0004\u0002\u00049\u0001\r!!\u0002\u0002\rM$\u0018\r^;t!\r!\u0018qA\u0005\u0004\u0003\u0013)(A\u0005%uiB\u0014Vm\u001d9p]N,7\u000b^1ukNDa!!\u0004\u000f\u0001\u0004\u0019\u0018a\u00025fC\u0012,'o]\u0001\u0018_:DE\u000f\u001e9SKN\u0004xN\\:f\u0005>$\u0017p\u00115v].$R\u0001ZA\n\u0003GAq!!\u0006\u0010\u0001\u0004\t9\"A\u0003dQVt7\u000e\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\tiB_\u0001\u0007EV4g-\u001a:\n\t\u0005\u0005\u00121\u0004\u0002\b\u0005f$XMQ;g\u0011\u0019\t)c\u0004a\u00019\u0006!A.Y:u\u0003-yg\u000e\u00165s_^\f'\r\\3\u0015\u0007\u0011\fY\u0003C\u0004\u0002.A\u0001\r!a\f\u0002\u0013QD'o\\<bE2,\u0007\u0003BA\u0019\u0003\u0003rA!a\r\u0002>9!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:m\ta\u0001\u0010:p_Rt\u0014\"A0\n\u0007\u0005}b,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0013Q\t\u0002\n)\"\u0014xn^1cY\u0016T1!a\u0010_\u0003Myg\u000e\u0015:pi>\u001cw\u000e\\!xCJ,g.Z:t)\r!\u00171\n\u0005\u0007\u0003\u001b\n\u0002\u0019\u0001/\u0002\u000f%\u001c\b\n\u001e;qe\u0001")
public class GatlingHttpListener
implements HttpListener,
LazyLogging {
    private final HttpTx tx;
    private final Clock clock;
    private final ResponseProcessor responseProcessor;
    private final ResponseBuilder responseBuilder;
    private boolean init;
    private boolean done;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public void onWrite(Channel x$1) {
        super.onWrite(x$1);
    }

    private Logger logger$lzycompute() {
        GatlingHttpListener gatlingHttpListener = this;
        synchronized (gatlingHttpListener) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private ResponseBuilder responseBuilder() {
        return this.responseBuilder;
    }

    private boolean init() {
        return this.init;
    }

    private void init_$eq(boolean x$1) {
        this.init = x$1;
    }

    private boolean done() {
        return this.done;
    }

    private void done_$eq(boolean x$1) {
        this.done = x$1;
    }

    public void onSend(HttpHeaders wireRequestHeaders) {
        block0: {
            if (this.init()) break block0;
            this.init_$eq(true);
            long now = this.clock.nowMillis();
            this.responseBuilder().updateStart(now, wireRequestHeaders);
        }
    }

    public void onHttpResponse(HttpResponseStatus status, HttpHeaders headers) {
        block0: {
            if (this.done()) break block0;
            this.responseBuilder().accumulate(status, headers, this.clock.nowMillis());
        }
    }

    public void onHttpResponseBodyChunk(ByteBuf chunk, boolean last) {
        if (!this.done()) {
            this.responseBuilder().accumulate(chunk, this.clock.nowMillis());
            if (last) {
                this.done_$eq(true);
                try {
                    this.responseProcessor.onComplete(this.responseBuilder().buildResponse());
                }
                finally {
                    this.responseBuilder().releaseChunks();
                }
            }
        }
    }

    public void onThrowable(Throwable throwable) {
        BoxedUnit boxedUnit;
        this.responseBuilder().updateEndTimestamp(this.clock.nowMillis());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(27).append("Request '").append(this.tx.request().requestName()).append("' failed for user ").append(this.tx.session().userId()).toString(), throwable);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            this.responseProcessor.onComplete(this.responseBuilder().buildFailure(throwable));
        }
        finally {
            this.responseBuilder().releaseChunks();
        }
    }

    public void onProtocolAwareness(boolean isHttp2) {
        this.responseBuilder().setHttp2(isHttp2);
    }

    public GatlingHttpListener(HttpTx tx, Clock clock, ResponseProcessor responseProcessor) {
        this.tx = tx;
        this.clock = clock;
        this.responseProcessor = responseProcessor;
        LazyLogging.$init$((LazyLogging)this);
        this.responseBuilder = (ResponseBuilder)tx.responseBuilderFactory().apply((Object)tx.request().clientRequest());
        this.init = false;
        this.done = false;
    }
}

