/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.validation.Validation;
import io.gatling.core.session.Session;
import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.gatling.http.client.realm.BasicRealm;
import io.gatling.http.client.realm.DigestRealm;
import io.gatling.http.client.realm.Realm;
import io.gatling.http.client.uri.Uri;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BitSet;
import scala.collection.BitSet$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.package$;
import scala.io.Codec$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class HttpHelper$
implements StrictLogging {
    public static HttpHelper$ MODULE$;
    private final String HttpScheme;
    private final String WsScheme;
    private final BitSet OkCodes;
    private final BitSet RedirectStatusCodes;
    private final String ApplicationStart;
    private final int ApplicationStartOffset;
    private final String ApplicationJavascriptEnd;
    private final String ApplicationJsonEnd;
    private final String ApplicationXmlEnd;
    private final String ApplicationFormUrlEncodedEnd;
    private final String ApplicationXhtmlEnd;
    private final String TextStart;
    private final int TextStartOffset;
    private final String TextCssEnd;
    private final String TextCsvEnd;
    private final String TextHtmlEnd;
    private final String TextJavascriptEnd;
    private final String TextPlainEnd;
    private final String TextXmlEnd;
    private final Logger logger;

    static {
        new HttpHelper$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String HttpScheme() {
        return this.HttpScheme;
    }

    public String WsScheme() {
        return this.WsScheme;
    }

    public BitSet OkCodes() {
        return this.OkCodes;
    }

    private BitSet RedirectStatusCodes() {
        return this.RedirectStatusCodes;
    }

    public List<Tuple2<String, String>> parseFormBody(String body) {
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])body.split("&"))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.split("=", 2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).map((Function1 & Serializable & scala.Serializable)pair -> {
            String paramName = HttpHelper$.utf8Decode$1(pair[0]);
            String paramValue = ((String[])pair).length > 1 ? HttpHelper$.utf8Decode$1(pair[1]) : "";
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)paramName), (Object)paramValue);
        }, package$.MODULE$.breakOut(List$.MODULE$.canBuildFrom()));
    }

    public Function1<Session, Validation<Realm>> buildBasicAuthRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password) {
        return (Function1 & Serializable & scala.Serializable)session -> ((Validation)username.apply(session)).flatMap((Function1 & Serializable & scala.Serializable)usernameValue -> ((Validation)password.apply(session)).map((Function1 & Serializable & scala.Serializable)passwordValue -> new BasicRealm(usernameValue, passwordValue)));
    }

    public Function1<Session, Validation<Realm>> buildDigestAuthRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password) {
        return (Function1 & Serializable & scala.Serializable)session -> ((Validation)username.apply(session)).flatMap((Function1 & Serializable & scala.Serializable)usernameValue -> ((Validation)password.apply(session)).map((Function1 & Serializable & scala.Serializable)passwordValue -> new DigestRealm(usernameValue, passwordValue)));
    }

    private boolean headerExists(HttpHeaders headers, String headerName, Function1<String, Object> f) {
        return Option$.MODULE$.apply((Object)headers.get(headerName)).exists(f);
    }

    public boolean isCss(HttpHeaders headers) {
        return this.headerExists(headers, HeaderNames$.MODULE$.ContentType(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith(HeaderValues$.MODULE$.TextCss())));
    }

    public boolean isHtml(HttpHeaders headers) {
        return this.headerExists(headers, HeaderNames$.MODULE$.ContentType(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)ct -> BoxesRunTime.boxToBoolean((boolean)HttpHelper$.$anonfun$isHtml$1(ct)));
    }

    public boolean isAjax(HttpHeaders headers) {
        return this.headerExists(headers, HeaderNames$.MODULE$.XRequestedWith(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HttpHelper$.$anonfun$isAjax$1(x$3)));
    }

    private String ApplicationStart() {
        return this.ApplicationStart;
    }

    private int ApplicationStartOffset() {
        return this.ApplicationStartOffset;
    }

    private String ApplicationJavascriptEnd() {
        return this.ApplicationJavascriptEnd;
    }

    private String ApplicationJsonEnd() {
        return this.ApplicationJsonEnd;
    }

    private String ApplicationXmlEnd() {
        return this.ApplicationXmlEnd;
    }

    private String ApplicationFormUrlEncodedEnd() {
        return this.ApplicationFormUrlEncodedEnd;
    }

    private String ApplicationXhtmlEnd() {
        return this.ApplicationXhtmlEnd;
    }

    private String TextStart() {
        return this.TextStart;
    }

    private int TextStartOffset() {
        return this.TextStartOffset;
    }

    private String TextCssEnd() {
        return this.TextCssEnd;
    }

    private String TextCsvEnd() {
        return this.TextCsvEnd;
    }

    private String TextHtmlEnd() {
        return this.TextHtmlEnd;
    }

    private String TextJavascriptEnd() {
        return this.TextJavascriptEnd;
    }

    private String TextPlainEnd() {
        return this.TextPlainEnd;
    }

    private String TextXmlEnd() {
        return this.TextXmlEnd;
    }

    public boolean isText(HttpHeaders headers) {
        return this.headerExists(headers, HeaderNames$.MODULE$.ContentType(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)ct -> BoxesRunTime.boxToBoolean((boolean)HttpHelper$.$anonfun$isText$1(ct)));
    }

    public Uri resolveFromUri(Uri rootURI, String relative) {
        return relative.startsWith("//") ? Uri.create((String)new StringBuilder(1).append(rootURI.getScheme()).append(":").append(relative).toString()) : Uri.create((Uri)rootURI, (String)relative);
    }

    public Option<Uri> resolveFromUriSilently(Uri rootURI, String relative) {
        Some some;
        try {
            some = new Some((Object)this.resolveFromUri(rootURI, relative));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder(45).append("Failed to resolve URI rootURI='").append(rootURI).append("', relative='").append(relative).append("'").toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public boolean isOk(int statusCode) {
        return this.OkCodes().contains(statusCode);
    }

    public boolean isRedirect(HttpResponseStatus status) {
        return this.RedirectStatusCodes().contains(status.code());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPermanentRedirect(HttpResponseStatus status) {
        HttpResponseStatus httpResponseStatus = status;
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.MOVED_PERMANENTLY;
        if (httpResponseStatus == null) {
            if (httpResponseStatus2 == null) return true;
        } else if (httpResponseStatus.equals(httpResponseStatus2)) return true;
        HttpResponseStatus httpResponseStatus3 = status;
        HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.PERMANENT_REDIRECT;
        if (httpResponseStatus3 != null) {
            if (!httpResponseStatus3.equals(httpResponseStatus4)) return false;
            return true;
        }
        if (httpResponseStatus4 == null) return true;
        return false;
    }

    public boolean isNotModified(HttpResponseStatus status) {
        HttpResponseStatus httpResponseStatus = status;
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.NOT_MODIFIED;
        return !(httpResponseStatus != null ? !httpResponseStatus.equals(httpResponseStatus2) : httpResponseStatus2 != null);
    }

    public boolean isAbsoluteHttpUrl(String url) {
        return url.startsWith(this.HttpScheme());
    }

    public boolean isAbsoluteWsUrl(String url) {
        return url.startsWith(this.WsScheme());
    }

    public Option<Charset> extractCharsetFromContentType(String contentType) {
        None$ none$;
        int n = contentType.indexOf("charset=");
        switch (n) {
            case -1: {
                none$ = None$.MODULE$;
                break;
            }
            default: {
                int n2;
                IntRef start = IntRef.create((int)(n + "charset=".length()));
                if (contentType.regionMatches(true, start.elem, "UTF-8", 0, 5)) {
                    none$ = new Some((Object)StandardCharsets.UTF_8);
                    break;
                }
                int n3 = contentType.indexOf(59, start.elem);
                switch (n3) {
                    case -1: {
                        n2 = contentType.length();
                        break;
                    }
                    default: {
                        n2 = n3;
                        break;
                    }
                }
                IntRef end = IntRef.create((int)n2);
                none$ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    while (contentType.charAt(start$1.elem) == ' ' && start$1.elem < end$1.elem) {
                        ++start$1.elem;
                    }
                    while (contentType.charAt(end$1.elem - 1) == ' ' && end$1.elem > start$1.elem) {
                        --end$1.elem;
                    }
                    if (contentType.charAt(start$1.elem) == '\"' && start$1.elem < end$1.elem) {
                        ++start$1.elem;
                    }
                    if (contentType.charAt(end$1.elem - 1) == '\"' && end$1.elem > start$1.elem) {
                        --end$1.elem;
                    }
                    String charsetString = contentType.substring(start$1.elem, end$1.elem);
                    return Charset.forName(charsetString);
                }).toOption();
                break;
            }
        }
        return none$;
    }

    public List<Cookie> responseCookies(HttpHeaders headers) {
        java.util.List setCookieValues = headers.getAll(HeaderNames$.MODULE$.SetCookie());
        return setCookieValues.isEmpty() ? Nil$.MODULE$ : (List)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(setCookieValues).asScala()).flatMap((Function1 & Serializable & scala.Serializable)setCookie -> Option$.MODULE$.apply((Object)ClientCookieDecoder.LAX.decode(setCookie)).toList(), package$.MODULE$.breakOut(List$.MODULE$.canBuildFrom()));
    }

    private static final String utf8Decode$1(String s) {
        return URLDecoder.decode(s, Codec$.MODULE$.UTF8().name());
    }

    public static final /* synthetic */ boolean $anonfun$isHtml$1(String ct) {
        return ct.startsWith(HeaderValues$.MODULE$.TextHtml()) || ct.startsWith(HeaderValues$.MODULE$.ApplicationXhtml());
    }

    public static final /* synthetic */ boolean $anonfun$isAjax$1(String x$3) {
        String string = x$3;
        String string2 = HeaderValues$.MODULE$.XmlHttpRequest();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isText$1(String ct) {
        return ct.startsWith(MODULE$.ApplicationStart()) && (ct.startsWith(MODULE$.ApplicationJavascriptEnd(), MODULE$.ApplicationStartOffset()) || ct.startsWith(MODULE$.ApplicationJsonEnd(), MODULE$.ApplicationStartOffset()) || ct.startsWith(MODULE$.ApplicationXmlEnd(), MODULE$.ApplicationStartOffset()) || ct.startsWith(MODULE$.ApplicationFormUrlEncodedEnd(), MODULE$.ApplicationStartOffset()) || ct.startsWith(MODULE$.ApplicationXhtmlEnd(), MODULE$.ApplicationStartOffset())) || ct.startsWith(MODULE$.TextStart()) && (ct.startsWith(MODULE$.TextCssEnd(), MODULE$.TextStartOffset()) || ct.startsWith(MODULE$.TextCsvEnd(), MODULE$.TextStartOffset()) || ct.startsWith(MODULE$.TextHtmlEnd(), MODULE$.TextStartOffset()) || ct.startsWith(MODULE$.TextJavascriptEnd(), MODULE$.TextStartOffset()) || ct.startsWith(MODULE$.TextJavascriptEnd(), MODULE$.TextStartOffset()) || ct.startsWith(MODULE$.TextPlainEnd(), MODULE$.TextStartOffset()) || ct.startsWith(MODULE$.TextXmlEnd(), MODULE$.TextStartOffset()));
    }

    private HttpHelper$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.HttpScheme = "http";
        this.WsScheme = "ws";
        this.OkCodes = (BitSet)BitSet$.MODULE$.empty().$plus((Object)BoxesRunTime.boxToInteger((int)HttpResponseStatus.OK.code())).$plus((Object)BoxesRunTime.boxToInteger((int)HttpResponseStatus.NOT_MODIFIED.code())).$plus((Object)BoxesRunTime.boxToInteger((int)HttpResponseStatus.CREATED.code())).$plus((Object)BoxesRunTime.boxToInteger((int)HttpResponseStatus.ACCEPTED.code())).$plus((Object)BoxesRunTime.boxToInteger((int)HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION.code())).$plus((Object)BoxesRunTime.boxToInteger((int)HttpResponseStatus.NO_CONTENT.code())).$plus((Object)BoxesRunTime.boxToInteger((int)HttpResponseStatus.RESET_CONTENT.code())).$plus((Object)BoxesRunTime.boxToInteger((int)HttpResponseStatus.PARTIAL_CONTENT.code())).$plus((Object)BoxesRunTime.boxToInteger((int)HttpResponseStatus.MULTI_STATUS.code())).$plus((Object)BoxesRunTime.boxToInteger((int)208)).$plus((Object)BoxesRunTime.boxToInteger((int)209));
        this.RedirectStatusCodes = (BitSet)BitSet$.MODULE$.empty().$plus((Object)BoxesRunTime.boxToInteger((int)HttpResponseStatus.MOVED_PERMANENTLY.code())).$plus((Object)BoxesRunTime.boxToInteger((int)HttpResponseStatus.FOUND.code())).$plus((Object)BoxesRunTime.boxToInteger((int)HttpResponseStatus.SEE_OTHER.code())).$plus((Object)BoxesRunTime.boxToInteger((int)HttpResponseStatus.TEMPORARY_REDIRECT.code())).$plus((Object)BoxesRunTime.boxToInteger((int)HttpResponseStatus.PERMANENT_REDIRECT.code()));
        this.ApplicationStart = "application/";
        this.ApplicationStartOffset = this.ApplicationStart().length();
        this.ApplicationJavascriptEnd = HeaderValues$.MODULE$.ApplicationJavascript().substring(this.ApplicationStartOffset());
        this.ApplicationJsonEnd = HeaderValues$.MODULE$.ApplicationJson().substring(this.ApplicationStartOffset());
        this.ApplicationXmlEnd = HeaderValues$.MODULE$.ApplicationXml().substring(this.ApplicationStartOffset());
        this.ApplicationFormUrlEncodedEnd = HeaderValues$.MODULE$.ApplicationFormUrlEncoded().substring(this.ApplicationStartOffset());
        this.ApplicationXhtmlEnd = HeaderValues$.MODULE$.ApplicationXhtml().substring(this.ApplicationStartOffset());
        this.TextStart = "text/";
        this.TextStartOffset = this.TextStart().length();
        this.TextCssEnd = HeaderValues$.MODULE$.TextCss().substring(this.TextStartOffset());
        this.TextCsvEnd = HeaderValues$.MODULE$.TextCsv().substring(this.TextStartOffset());
        this.TextHtmlEnd = HeaderValues$.MODULE$.TextHtml().substring(this.TextStartOffset());
        this.TextJavascriptEnd = HeaderValues$.MODULE$.TextJavascript().substring(this.TextStartOffset());
        this.TextPlainEnd = HeaderValues$.MODULE$.TextPlain().substring(this.TextStartOffset());
        this.TextXmlEnd = HeaderValues$.MODULE$.TextXml().substring(this.TextStartOffset());
    }
}

