/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine.response;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.session.Session;
import io.gatling.core.util.NameGen;
import io.gatling.http.engine.response.Crash;
import io.gatling.http.engine.response.NextExecutor;
import io.gatling.http.engine.response.Proceed;
import io.gatling.http.engine.response.ProcessorResult;
import io.gatling.http.engine.response.Redirect;
import io.gatling.http.engine.response.ResponseProcessor;
import io.gatling.http.engine.response.ResponseProcessor$;
import io.gatling.http.engine.response.SessionProcessor;
import io.gatling.http.engine.response.StatsProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.Response;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005A4AAC\u0006\u0001-!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011m\u0002!\u0011!Q\u0001\nqBQA\u0012\u0001\u0005\u0002\u001dCQA\u0014\u0001\u0005\u0002=CQA\u0017\u0001\u0005\nmCQ\u0001\u001a\u0001\u0005\n\u0015\u0014\u0001\u0004R3gCVdGOU3ta>t7/\u001a)s_\u000e,7o]8s\u0015\taQ\"\u0001\u0005sKN\u0004xN\\:f\u0015\tqq\"\u0001\u0004f]\u001eLg.\u001a\u0006\u0003!E\tA\u0001\u001b;ua*\u0011!cE\u0001\bO\u0006$H.\u001b8h\u0015\u0005!\u0012AA5p\u0007\u0001\u0019B\u0001A\f\u001eCA\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"AH\u0010\u000e\u0003-I!\u0001I\u0006\u0003#I+7\u000f]8og\u0016\u0004&o\\2fgN|'\u000f\u0005\u0002#O5\t1E\u0003\u0002%K\u0005!Q\u000f^5m\u0015\t1\u0013#\u0001\u0003d_J,\u0017B\u0001\u0015$\u0005\u001dq\u0015-\\3HK:\f!\u0001\u001e=\u0011\u0005-jS\"\u0001\u0017\u000b\u0005%j\u0011B\u0001\u0018-\u0005\u0019AE\u000f\u001e9Uq\u0006\u00012/Z:tS>t\u0007K]8dKN\u001cxN\u001d\t\u0003=EJ!AM\u0006\u0003!M+7o]5p]B\u0013xnY3tg>\u0014\u0018AD:uCR\u001c\bK]8dKN\u001cxN\u001d\t\u0003=UJ!AN\u0006\u0003\u001dM#\u0018\r^:Qe>\u001cWm]:pe\u0006aa.\u001a=u\u000bb,7-\u001e;peB\u0011a$O\u0005\u0003u-\u0011ABT3yi\u0016CXmY;u_J\fa\u0002Z3gCVdGo\u00115beN,G\u000f\u0005\u0002>\t6\taH\u0003\u0002@\u0001\u000691\r[1sg\u0016$(BA!C\u0003\rq\u0017n\u001c\u0006\u0002\u0007\u0006!!.\u0019<b\u0013\t)eHA\u0004DQ\u0006\u00148/\u001a;\u0002\rqJg.\u001b;?)\u0019A\u0015JS&M\u001bB\u0011a\u0004\u0001\u0005\u0006S\u0019\u0001\rA\u000b\u0005\u0006_\u0019\u0001\r\u0001\r\u0005\u0006g\u0019\u0001\r\u0001\u000e\u0005\u0006o\u0019\u0001\r\u0001\u000f\u0005\u0006w\u0019\u0001\r\u0001P\u0001\u000b_:\u001cu.\u001c9mKR,GC\u0001)T!\tA\u0012+\u0003\u0002S3\t!QK\\5u\u0011\u0015!v\u00011\u0001V\u0003\u0019\u0011Xm];miB\u0011a\u000bW\u0007\u0002/*\u0011AbD\u0005\u00033^\u0013!\u0002\u0013;uaJ+7/\u001e7u\u0003\u001d\u0001(o\\2fK\u0012$2\u0001\u0015/a\u0011\u0015a\u0001\u00021\u0001^!\t1f,\u0003\u0002`/\nA!+Z:q_:\u001cX\rC\u0003U\u0011\u0001\u0007\u0011\r\u0005\u0002\u001fE&\u00111m\u0003\u0002\u0010!J|7-Z:t_J\u0014Vm];mi\u0006A\u0012\r\u001d9msJ+7\u000f]8og\u0016$&/\u00198tM>\u0014X.\u001a:\u0015\u0005\u0019t\u0007cA4m;6\t\u0001N\u0003\u0002jU\u0006Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005-\f\u0012aB2p[6|gn]\u0005\u0003[\"\u0014!BV1mS\u0012\fG/[8o\u0011\u0015y\u0017\u00021\u0001^\u0003-\u0011\u0018m\u001e*fgB|gn]3")
public class DefaultResponseProcessor
implements ResponseProcessor,
NameGen {
    private final HttpTx tx;
    private final SessionProcessor sessionProcessor;
    private final StatsProcessor statsProcessor;
    private final NextExecutor nextExecutor;
    private final Charset defaultCharset;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    @Override
    public void onComplete(HttpResult result) {
        HttpResult httpResult = result;
        if (httpResult instanceof Response) {
            Response response = (Response)httpResult;
            Validation<Response> validation = this.applyResponseTransformer(response);
            if (validation instanceof Success) {
                Success success = (Success)validation;
                Response response2 = (Response)success.value();
                ProcessorResult result2 = ResponseProcessor$.MODULE$.processResponse(this.tx, this.sessionProcessor, this.defaultCharset, response2);
                this.proceed(response2, result2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (validation instanceof Failure) {
                Failure failure = (Failure)validation;
                String errorMessage = failure.message();
                this.proceed(response, new Crash(errorMessage));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(validation);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (httpResult instanceof HttpFailure) {
            HttpFailure httpFailure = (HttpFailure)httpResult;
            Session newSession = ResponseProcessor$.MODULE$.processFailure(this.tx, this.sessionProcessor, this.statsProcessor, httpFailure);
            this.nextExecutor.executeNextOnCrash(newSession);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)httpResult);
        }
    }

    private void proceed(Response response, ProcessorResult result) {
        ProcessorResult processorResult = result;
        if (processorResult instanceof Proceed) {
            Proceed proceed = (Proceed)processorResult;
            Session newSession = proceed.newSession();
            Option<String> errorMessage = proceed.error();
            KO$ status = errorMessage.isDefined() ? KO$.MODULE$ : OK$.MODULE$;
            this.statsProcessor.reportStats(this.tx.fullRequestName(), newSession, (Status)status, response, errorMessage);
            this.nextExecutor.executeNext(newSession, (Status)status, response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (processorResult instanceof Redirect) {
            Redirect redirect = (Redirect)processorResult;
            HttpTx redirectTx = redirect.redirectTx();
            this.statsProcessor.reportStats(this.tx.fullRequestName(), redirectTx.currentSession(), (Status)OK$.MODULE$, response, (Option<String>)None$.MODULE$);
            this.nextExecutor.executeRedirect(redirectTx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (processorResult instanceof Crash) {
            Crash crash = (Crash)processorResult;
            String errorMessage = crash.error();
            Session newSession = this.sessionProcessor.updateSessionCrashed(this.tx.currentSession(), response.startTimestamp(), response.endTimestamp());
            this.statsProcessor.reportStats(this.tx.fullRequestName(), newSession, (Status)KO$.MODULE$, response, (Option<String>)new Some((Object)errorMessage));
            this.nextExecutor.executeNextOnCrash(newSession);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)processorResult);
        }
    }

    private Validation<Response> applyResponseTransformer(Response rawResponse) {
        Validation validation;
        Option<Function2<Session, Response, Validation<Response>>> option = this.tx.request().requestConfig().responseTransformer();
        if (option instanceof Some) {
            Some some = (Some)option;
            Function2 transformer = (Function2)some.value();
            validation = package$.MODULE$.safely((Function1 & Serializable)x$2 -> new StringBuilder(30).append("Response transformer crashed: ").append((String)x$2).toString(), (Function0 & Serializable)() -> (Validation)transformer.apply((Object)$this.tx.currentSession(), (Object)rawResponse));
        } else {
            validation = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)rawResponse));
        }
        return validation;
    }

    public DefaultResponseProcessor(HttpTx tx, SessionProcessor sessionProcessor, StatsProcessor statsProcessor, NextExecutor nextExecutor, Charset defaultCharset) {
        this.tx = tx;
        this.sessionProcessor = sessionProcessor;
        this.statsProcessor = statsProcessor;
        this.nextExecutor = nextExecutor;
        this.defaultCharset = defaultCharset;
        NameGen.$init$((NameGen)this);
    }
}

