/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.auth;

import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.commons.validation.Validation;
import io.gatling.http.auth.DigestAuth;
import io.gatling.http.auth.DigestAuth$Algorithm$Md5$;
import io.gatling.http.auth.DigestAuth$Algorithm$Md5Sess$;
import io.gatling.http.auth.DigestAuth$Algorithm$Sha256$;
import io.gatling.http.auth.DigestAuth$Algorithm$Sha256Sess$;
import io.gatling.http.auth.DigestAuth$Algorithm$Sha512256$;
import io.gatling.http.auth.DigestAuth$Algorithm$Sha512256Sess$;
import io.gatling.http.auth.DigestWwwAuthenticateHeaderParser;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.util.StringUtils;
import io.gatling.netty.util.StringBuilderPool;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.concurrent.ThreadLocalRandom;
import scala.Function1;
import scala.MatchError;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

public final class DigestAuth$
implements Serializable {
    public static final DigestAuth$ MODULE$ = new DigestAuth$();
    private static final ThreadLocal<DigestWwwAuthenticateHeaderParser> ParserPool = new ThreadLocal<DigestWwwAuthenticateHeaderParser>(){

        public DigestWwwAuthenticateHeaderParser initialValue() {
            return new DigestWwwAuthenticateHeaderParser();
        }
    };
    private static final ThreadLocal<MessageDigest> Md5DigestPool = new ThreadLocal<MessageDigest>(){

        public MessageDigest initialValue() {
            return MessageDigest.getInstance("MD5");
        }
    };
    private static final ThreadLocal<MessageDigest> Sha256DigestPool = new ThreadLocal<MessageDigest>(){

        public MessageDigest initialValue() {
            return MessageDigest.getInstance("SHA-256");
        }
    };
    private static final ThreadLocal<MessageDigest> Sha512256DigestPool = new ThreadLocal<MessageDigest>(){

        public MessageDigest initialValue() {
            return MessageDigest.getInstance("SHA-512/256");
        }
    };
    private static final StringBuilderPool SbPool = new StringBuilderPool();

    private ThreadLocal<DigestWwwAuthenticateHeaderParser> ParserPool() {
        return ParserPool;
    }

    private ThreadLocal<MessageDigest> Md5DigestPool() {
        return Md5DigestPool;
    }

    private ThreadLocal<MessageDigest> Sha256DigestPool() {
        return Sha256DigestPool;
    }

    private ThreadLocal<MessageDigest> Sha512256DigestPool() {
        return Sha512256DigestPool;
    }

    private StringBuilderPool SbPool() {
        return SbPool;
    }

    public Validation<DigestAuth.Challenge> parseWwwAuthenticateHeader(String header, Uri origin) {
        return this.ParserPool().get().parse(header, origin);
    }

    private String newCnonce() {
        byte[] b = new byte[8];
        ThreadLocalRandom.current().nextBytes(b);
        return Base64.getEncoder().encodeToString(b);
    }

    public String hash(String s, MessageDigest md) {
        return StringUtils.toHexString((byte[])md.digest(s.getBytes(StandardCharsets.UTF_8)));
    }

    public String generateAuthorization(DigestAuth.Challenge challenge, String username, String password, HttpMethod requestMethod, Uri requestUri, int nc) {
        return this.generateAuthorization0(challenge, username, password, requestMethod, requestUri, nc, this.newCnonce());
    }

    public String generateAuthorization0(DigestAuth.Challenge challenge, String username, String password, HttpMethod requestMethod, Uri requestUri, int nc, String cnonce) {
        MessageDigest messageDigest;
        DigestAuth.Algorithm algorithm = challenge.algorithm();
        DigestAuth.Algorithm algorithm2 = algorithm;
        boolean bl = DigestAuth$Algorithm$Md5$.MODULE$.equals(algorithm2) ? true : DigestAuth$Algorithm$Md5Sess$.MODULE$.equals(algorithm2);
        if (bl) {
            messageDigest = this.Md5DigestPool().get();
        } else {
            boolean bl2 = DigestAuth$Algorithm$Sha256$.MODULE$.equals(algorithm2) ? true : DigestAuth$Algorithm$Sha256Sess$.MODULE$.equals(algorithm2);
            if (bl2) {
                messageDigest = this.Sha256DigestPool().get();
            } else {
                boolean bl3 = DigestAuth$Algorithm$Sha512256$.MODULE$.equals(algorithm2) ? true : DigestAuth$Algorithm$Sha512256Sess$.MODULE$.equals(algorithm2);
                if (bl3) {
                    messageDigest = this.Sha512256DigestPool().get();
                } else {
                    throw new MatchError((Object)algorithm2);
                }
            }
        }
        MessageDigest md = messageDigest;
        DigestAuth.Qop qop = challenge.qop();
        String hashedUsername = challenge.userhash() ? this.hash(new StringBuilder(1).append(username).append(":").append(challenge.realm()).toString(), md) : username;
        String paddedNc = StringHelper.RichString$.MODULE$.leftPad$extension(StringHelper$.MODULE$.RichString(Integer.toString(nc)), 8, "0");
        String a1 = challenge.algorithm().session() ? new StringBuilder(2).append(this.hash(new StringBuilder(2).append(username).append(":").append(challenge.realm()).append(":").append(password).toString(), md)).append(":").append(challenge.nonce()).append(":").append(cnonce).toString() : new StringBuilder(2).append(username).append(":").append(challenge.realm()).append(":").append(password).toString();
        String a2 = new StringBuilder(1).append(requestMethod.name()).append(":").append(requestUri.toRelativeUrl()).toString();
        String response = this.hash(new StringBuilder(5).append(this.hash(a1, md)).append(":").append(challenge.nonce()).append(":").append(paddedNc).append(":").append(cnonce).append(":").append(qop.value()).append(":").append(this.hash(a2, md)).toString(), md);
        StringBuilder sb = this.SbPool().get().append("Digest ").append("username=\"").append(hashedUsername).append("\", realm=\"").append(challenge.realm()).append("\", uri=\"").append(requestUri.toRelativeUrl()).append("\", algorithm=").append(algorithm.value()).append(", nonce=\"").append(challenge.nonce()).append("\", nc=").append(paddedNc).append(", cnonce=\"").append(cnonce).append("\", qop=").append(qop.value()).append(", response=\"").append(response).append("\"");
        challenge.opaque().foreach((Function1 & Serializable)opaque -> sb.append(", opaque=\"").append((String)opaque).append("\""));
        Object object = challenge.userhash() ? sb.append(", userhash=true") : BoxedUnit.UNIT;
        return sb.toString();
    }

    public DigestAuth apply() {
        return new DigestAuth();
    }

    public boolean unapply(DigestAuth x$0) {
        return x$0 != null;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DigestAuth$.class);
    }

    private DigestAuth$() {
    }
}

