/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse.fsm;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.session.Session;
import io.gatling.core.stats.StatsEngine;
import io.gatling.http.action.sse.SseListener;
import io.gatling.http.action.sse.fsm.Close$;
import io.gatling.http.action.sse.fsm.Connecting;
import io.gatling.http.action.sse.fsm.Open;
import io.gatling.http.action.sse.fsm.ProcessingClientCloseRequest;
import io.gatling.http.action.sse.fsm.ServerSentEvent;
import io.gatling.http.action.sse.fsm.SseFsm;
import io.gatling.http.action.sse.fsm.SseStream$;
import io.gatling.http.action.sse.fsm.SseStreamState;
import io.gatling.http.client.Request;
import io.gatling.http.engine.HttpEngine;
import io.gatling.http.util.SslContexts;
import io.netty.handler.ssl.SslContext;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005]v!\u0002\u0012$\u0011\u0003\u0001d!\u0002\u001a$\u0011\u0003\u0019\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004b\u0002\u001f\u0002\u0005\u0004%I!\u0010\u0005\u0007\u0003\u0006\u0001\u000b\u0011\u0002 \u0007\tI\u001a\u0003A\u0011\u0005\t\u001b\u0016\u0011\t\u0011)A\u0005\u001d\"Aa+\u0002B\u0001B\u0003%q\u000b\u0003\u0005^\u000b\t\u0005\t\u0015!\u0003_\u0011!IWA!A!\u0002\u0013Q\u0007\u0002C:\u0006\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0011],!\u0011!Q\u0001\naD\u0001B`\u0003\u0003\u0002\u0003\u0006Ia \u0005\u000b\u0003\u0017)!\u0011!Q\u0001\n\u00055\u0001B\u0002\u001e\u0006\t\u0003\tY\u0002C\u0005\u00020\u0015\u0011\r\u0011\"\u0003\u00022!A\u0011QI\u0003!\u0002\u0013\t\u0019\u0004C\u0006%\u000b\u0001\u0007\t\u0019!C\u0001G\u0005\u001d\u0003\u0002DA(\u000b\u0001\u0007\t\u0019!C\u0001G\u0005E\u0003bCA/\u000b\u0001\u0007\t\u0011)Q\u0005\u0003\u0013B1\"a\u0018\u0006\u0001\u0004\u0005\r\u0011\"\u0003\u0002b!Y\u0011\u0011N\u0003A\u0002\u0003\u0007I\u0011BA6\u0011-\ty'\u0002a\u0001\u0002\u0003\u0006K!a\u0019\t\u0011\u0005ET\u00011A\u0005\nuB\u0011\"a\u001d\u0006\u0001\u0004%I!!\u001e\t\u000f\u0005eT\u0001)Q\u0005}!9\u00111P\u0003\u0005\u0002\u0005u\u0004bBA@\u000b\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u0003+A\u0011AA?\u0011\u001d\t\u0019)\u0002C\u0001\u0003{Bq!!\"\u0006\t\u0003\ti\bC\u0004\u0002\b\u0016!\t!!#\t\u000f\u0005UU\u0001\"\u0001\u0002\u0018\"9\u00111U\u0003\u0005\n\u0005\u0015\u0016!C*tKN#(/Z1n\u0015\t!S%A\u0002gg6T!AJ\u0014\u0002\u0007M\u001cXM\u0003\u0002)S\u00051\u0011m\u0019;j_:T!AK\u0016\u0002\t!$H\u000f\u001d\u0006\u0003Y5\nqaZ1uY&twMC\u0001/\u0003\tIwn\u0001\u0001\u0011\u0005E\nQ\"A\u0012\u0003\u0013M\u001bXm\u0015;sK\u0006l7CA\u00015!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001M\u0001\u001b\t\u00164\u0017-\u001e7u%\u0016$(/\u001f#fY\u0006L\u0018J\\*fG>tGm]\u000b\u0002}A\u0011QgP\u0005\u0003\u0001Z\u00121!\u00138u\u0003m!UMZ1vYR\u0014V\r\u001e:z\t\u0016d\u0017-_%o'\u0016\u001cwN\u001c3tAM\u0019Q\u0001N\"\u0011\u0005\u0011[U\"A#\u000b\u0005\u0019;\u0015\u0001D:dC2\fGn\\4hS:<'B\u0001%J\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001&\u0002\u0007\r|W.\u0003\u0002M\u000b\ni1\u000b\u001e:jGRdunZ4j]\u001e\fqb\u001c:jO&t\u0017\r\\*fgNLwN\u001c\t\u0003\u001fRk\u0011\u0001\u0015\u0006\u0003#J\u000bqa]3tg&|gN\u0003\u0002TW\u0005!1m\u001c:f\u0013\t)\u0006KA\u0004TKN\u001c\u0018n\u001c8\u0002\u001d\r|gN\\3diJ+\u0017/^3tiB\u0011\u0001lW\u0007\u00023*\u0011!,K\u0001\u0007G2LWM\u001c;\n\u0005qK&a\u0002*fcV,7\u000f^\u0001\u0012G>tg.Z2u\u0003\u000e$\u0018n\u001c8OC6,\u0007CA0g\u001d\t\u0001G\r\u0005\u0002bm5\t!M\u0003\u0002d_\u00051AH]8pizJ!!\u001a\u001c\u0002\rA\u0013X\rZ3g\u0013\t9\u0007N\u0001\u0004TiJLgn\u001a\u0006\u0003KZ\nq\"^:feN\u001bHnQ8oi\u0016DHo\u001d\t\u0004k-l\u0017B\u000177\u0005\u0019y\u0005\u000f^5p]B\u0011a.]\u0007\u0002_*\u0011\u0001/K\u0001\u0005kRLG.\u0003\u0002s_\nY1k\u001d7D_:$X\r\u001f;t\u0003A\u0019\b.\u0019:f\u0007>tg.Z2uS>t7\u000f\u0005\u00026k&\u0011aO\u000e\u0002\b\u0005>|G.Z1o\u0003)AG\u000f\u001e9F]\u001eLg.\u001a\t\u0003srl\u0011A\u001f\u0006\u0003w&\na!\u001a8hS:,\u0017BA?{\u0005)AE\u000f\u001e9F]\u001eLg.Z\u0001\fgR\fGo]#oO&tW\r\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)AU\u0001\u0006gR\fGo]\u0005\u0005\u0003\u0013\t\u0019AA\u0006Ti\u0006$8/\u00128hS:,\u0017!B2m_\u000e\\\u0007\u0003BA\b\u0003/i!!!\u0005\u000b\u0007A\f\u0019BC\u0002\u0002\u0016-\nqaY8n[>t7/\u0003\u0003\u0002\u001a\u0005E!!B\"m_\u000e\\GCEA\u000f\u0003?\t\t#a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0003[\u0001\"!M\u0003\t\u000b5s\u0001\u0019\u0001(\t\u000bYs\u0001\u0019A,\t\u000bus\u0001\u0019\u00010\t\u000b%t\u0001\u0019\u00016\t\u000bMt\u0001\u0019\u0001;\t\u000b]t\u0001\u0019\u0001=\t\u000byt\u0001\u0019A@\t\u000f\u0005-a\u00021\u0001\u0002\u000e\u00051qM]8vaN,\"!a\r\u0011\u000b\u0005U\u0012q\b0\u000f\t\u0005]\u00121\b\b\u0004C\u0006e\u0012\"A\u001c\n\u0007\u0005ub'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00131\t\u0002\u0005\u0019&\u001cHOC\u0002\u0002>Y\nqa\u001a:pkB\u001c\b%\u0006\u0002\u0002JA\u0019\u0011'a\u0013\n\u0007\u000553E\u0001\u0004Tg\u001645/\\\u0001\bMNlw\fJ3r)\u0011\t\u0019&!\u0017\u0011\u0007U\n)&C\u0002\u0002XY\u0012A!\u00168ji\"I\u00111\f\n\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\u0004q\u0012\n\u0014\u0001\u00024t[\u0002\nQa\u001d;bi\u0016,\"!a\u0019\u0011\u0007E\n)'C\u0002\u0002h\r\u0012abU:f'R\u0014X-Y7Ti\u0006$X-A\u0005ti\u0006$Xm\u0018\u0013fcR!\u00111KA7\u0011%\tY&FA\u0001\u0002\u0004\t\u0019'\u0001\u0004ti\u0006$X\rI\u0001\u0014e\u0016$(/\u001f#fY\u0006L\u0018J\\*fG>tGm]\u0001\u0018e\u0016$(/\u001f#fY\u0006L\u0018J\\*fG>tGm]0%KF$B!a\u0015\u0002x!A\u00111\f\r\u0002\u0002\u0003\u0007a(\u0001\u000bsKR\u0014\u0018\u0010R3mCfLenU3d_:$7\u000fI\u0001\bG>tg.Z2u)\t\t\u0019&A\u0005d_:tWm\u0019;fI\u0006q1\r\\8tK\u0012\u0014\u0015pU3sm\u0016\u0014\u0018aC3oI>37\u000b\u001e:fC6\fqC]3rk\u0016\u001cH/\u001b8h\u00072|7/\u001a\"z\u00072LWM\u001c;\u0002\u000b\r\u0014\u0018m\u001d5\u0015\t\u0005M\u00131\u0012\u0005\b\u0003\u001b{\u0002\u0019AAH\u0003%!\bN]8xC\ndW\r\u0005\u0003\u00026\u0005E\u0015\u0002BAJ\u0003\u0007\u0012\u0011\u0002\u00165s_^\f'\r\\3\u0002\u001b\u00154XM\u001c;SK\u000e,\u0017N^3e)\u0011\t\u0019&!'\t\u000f\u0005m\u0005\u00051\u0001\u0002\u001e\u0006)QM^3oiB\u0019\u0011'a(\n\u0007\u0005\u00056EA\bTKJ4XM]*f]R,e/\u001a8u\u00031IG\u000e\\3hC2\u001cF/\u0019;f)\u0019\t\u0019&a*\u00024\"9\u0011\u0011V\u0011A\u0002\u0005-\u0016\u0001\u00037jgR,g.\u001a:\u0011\t\u00055\u0016qV\u0007\u0002K%\u0019\u0011\u0011W\u0013\u0003\u0017M\u001bX\rT5ti\u0016tWM\u001d\u0005\u0007\u0003k\u000b\u0003\u0019\u00010\u0002\u000f5,7o]1hK\u0002")
public class SseStream
implements StrictLogging {
    private final Session originalSession;
    private final Request connectRequest;
    private final Option<SslContexts> userSslContexts;
    private final boolean shareConnections;
    private final HttpEngine httpEngine;
    private final List<String> groups;
    private SseFsm fsm;
    private SseStreamState state;
    private int retryDelayInSeconds;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private List<String> groups() {
        return this.groups;
    }

    public SseFsm fsm() {
        return this.fsm;
    }

    public void fsm_$eq(SseFsm x$1) {
        this.fsm = x$1;
    }

    private SseStreamState state() {
        return this.state;
    }

    private void state_$eq(SseStreamState x$1) {
        this.state = x$1;
    }

    private int retryDelayInSeconds() {
        return this.retryDelayInSeconds;
    }

    private void retryDelayInSeconds_$eq(int x$1) {
        this.retryDelayInSeconds = x$1;
    }

    public void connect() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("(re-)connecting stream");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SseListener listener = new SseListener(this);
        this.state_$eq(new Connecting(listener));
        this.httpEngine.executeRequest(this.connectRequest, this.originalSession.userId(), this.shareConnections, this.originalSession.eventLoop(), listener, (SslContext)this.userSslContexts.map((Function1 & Serializable)x$3 -> x$3.sslContext()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (SslContext)this.userSslContexts.flatMap((Function1 & Serializable)x$4 -> x$4.alpnSslContext()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public void connected() {
        SseStreamState sseStreamState = this.state();
        if (sseStreamState instanceof Connecting) {
            BoxedUnit boxedUnit;
            Connecting connecting = (Connecting)sseStreamState;
            SseListener listener = connecting.listener();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Stream connected while in state Connecting. Processing.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.state_$eq(new Open(listener));
            this.fsm().onSseStreamConnected();
            return;
        }
        if (sseStreamState instanceof Open) {
            Open open = (Open)sseStreamState;
            SseListener listener = open.listener();
            this.illegalState(listener, "Invalid state: stream was connected while state was Open. Please report.");
            return;
        }
        if (sseStreamState instanceof ProcessingClientCloseRequest) {
            BoxedUnit boxedUnit;
            ProcessingClientCloseRequest processingClientCloseRequest = (ProcessingClientCloseRequest)sseStreamState;
            SseListener listener = processingClientCloseRequest.listener();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Stream connected while in state ProcessingClientCloseRequest. Closing.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            listener.closeChannel();
            this.fsm().onSseStreamClosed();
            this.state_$eq(Close$.MODULE$);
            return;
        }
        this.illegalState(null, "Invalid state: stream was connected while state was Close. Please report.");
    }

    public void closedByServer() {
        SseStreamState sseStreamState = this.state();
        if (sseStreamState instanceof Connecting) {
            Connecting connecting = (Connecting)sseStreamState;
            SseListener listener = connecting.listener();
            this.illegalState(listener, "Invalid state: server closed the stream while state was Connecting. Please report.");
            return;
        }
        if (sseStreamState instanceof Open) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Server closed the stream while in state Open. Reconnecting.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.originalSession.eventLoop().schedule(() -> this.connect(), (long)this.retryDelayInSeconds(), TimeUnit.SECONDS);
            return;
        }
        if (sseStreamState instanceof ProcessingClientCloseRequest) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Server closed the stream while in state ProcessingClientCloseRequest.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.state_$eq(Close$.MODULE$);
            return;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Server closed the stream while in state Close.");
            return;
        }
    }

    public void endOfStream() {
        SseStreamState sseStreamState = this.state();
        if (sseStreamState instanceof Connecting) {
            Connecting connecting = (Connecting)sseStreamState;
            SseListener listener = connecting.listener();
            this.illegalState(listener, "Invalid state: server notified of end of stream while state was Connecting. Please report.");
            return;
        }
        if (sseStreamState instanceof Open) {
            this.state_$eq(Close$.MODULE$);
            this.fsm().onSseStreamClosed();
            return;
        }
        if (sseStreamState instanceof ProcessingClientCloseRequest) {
            this.state_$eq(Close$.MODULE$);
            return;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("End of stream reached while in state Close.");
            return;
        }
    }

    public void requestingCloseByClient() {
        SseStreamState sseStreamState = this.state();
        if (sseStreamState instanceof Connecting) {
            Connecting connecting = (Connecting)sseStreamState;
            SseListener listener = connecting.listener();
            listener.closeChannel();
            this.state_$eq(new ProcessingClientCloseRequest(listener));
            this.fsm().onSseStreamClosed();
            return;
        }
        if (sseStreamState instanceof Open) {
            Open open = (Open)sseStreamState;
            SseListener listener = open.listener();
            listener.closeChannel();
            this.state_$eq(new ProcessingClientCloseRequest(listener));
            this.fsm().onSseStreamClosed();
            return;
        }
    }

    public void crash(Throwable throwable) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Sse stream crashed", throwable);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            String errorMessage = Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(throwable));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Sse stream crashed: {}", (Object)errorMessage);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        SseStreamState sseStreamState = this.state();
        if (sseStreamState instanceof Open) {
            this.state_$eq(Close$.MODULE$);
            this.fsm().onSseStreamCrashed(throwable);
            return;
        }
        if (sseStreamState instanceof Connecting) {
            this.state_$eq(Close$.MODULE$);
            this.fsm().onSseStreamCrashed(throwable);
            return;
        }
        if (sseStreamState instanceof ProcessingClientCloseRequest) {
            this.state_$eq(Close$.MODULE$);
            return;
        }
    }

    public void eventReceived(ServerSentEvent event) {
        SseStreamState sseStreamState = this.state();
        if (sseStreamState instanceof Open) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Received SSE event {} while in Open state. Propagating.", (Object)event);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            event.retry().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> this.retryDelayInSeconds_$eq(x$5));
            this.fsm().onSseReceived(event.asJsonString());
            return;
        }
        if (sseStreamState instanceof Connecting) {
            Connecting connecting = (Connecting)sseStreamState;
            SseListener listener = connecting.listener();
            this.illegalState(listener, new StringBuilder(71).append("Invalid state: received SSE ").append(event).append(" while state was Connecting. Please report.").toString());
            return;
        }
        if (sseStreamState instanceof ProcessingClientCloseRequest) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Received SSE event {} while in ProcessingClientCloseRequest state. Ignoring.", (Object)event);
                return;
            }
            return;
        }
        this.illegalState(null, new StringBuilder(66).append("Invalid state: received SSE ").append(event).append(" while state was Close. Please report.").toString());
    }

    private void illegalState(SseListener listener, String message) {
        this.fsm().onSseStreamCrashed(new IllegalStateException(message));
        if (listener != null) {
            listener.closeChannel();
        }
        this.state_$eq(Close$.MODULE$);
    }

    public SseStream(Session originalSession, Request connectRequest, String connectActionName, Option<SslContexts> userSslContexts, boolean shareConnections, HttpEngine httpEngine, StatsEngine statsEngine, Clock clock) {
        this.originalSession = originalSession;
        this.connectRequest = connectRequest;
        this.userSslContexts = userSslContexts;
        this.shareConnections = shareConnections;
        this.httpEngine = httpEngine;
        StrictLogging.$init$((StrictLogging)this);
        this.groups = originalSession.groups();
        this.retryDelayInSeconds = SseStream$.MODULE$.io$gatling$http$action$sse$fsm$SseStream$$DefaultRetryDelayInSeconds();
        Statics.releaseFence();
    }
}

