/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.commons.validation.Validation;
import io.gatling.core.CoreComponents;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.session.package;
import io.gatling.core.session.package$;
import io.gatling.http.client.HttpClient;
import io.gatling.http.client.HttpListener;
import io.gatling.http.client.Request;
import io.gatling.http.client.resolver.InetAddressNameResolver;
import io.gatling.http.client.resolver.InetAddressNameResolverWrapper;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.util.Pair;
import io.gatling.http.engine.HttpEngine$;
import io.gatling.http.protocol.HttpComponents;
import io.gatling.http.request.builder.Http;
import io.gatling.http.request.builder.HttpRequestBuilder;
import io.gatling.http.request.builder.RequestBuilder;
import io.gatling.http.util.SslContexts;
import io.gatling.http.util.SslContextsFactory;
import io.gatling.netty.util.Transports;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.ssl.SslContext;
import io.netty.resolver.NameResolver;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.resolver.dns.SequentialDnsServerAddressStreamProvider;
import java.io.Serializable;
import java.net.InetSocketAddress;
import javax.net.ssl.KeyManagerFactory;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005}x!\u0002\u000b\u0016\u0011\u0003qb!\u0002\u0011\u0016\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003\"\u0002\u0016\u0002\t\u0003Yc\u0001\u0002\u0011\u0016\u00015B\u0001b\u0011\u0003\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u0015\u0012\u0011\t\u0011)A\u0005\u0017\"A\u0011\u000b\u0002B\u0001B\u0003%!\u000b\u0003\u0005[\t\t\u0005\t\u0015!\u0003\\\u0011!\u0011GA!A!\u0002\u0013\u0019\u0007\"\u0002\u0015\u0005\t\u0003Y\u0007BB9\u0005A\u0003&!\u000fC\u0003v\t\u0011\u0005a\u000fC\u0004\u0002\u0006\u0011!\t!a\u0002\t\u000f\u00055C\u0001\"\u0001\u0002P!9\u0011\u0011\u0011\u0003\u0005\u0002\u0005\r\u0005bBAI\t\u0011\u0005\u00111\u0013\u0005\b\u0003\u007f#A\u0011AAa\u0011\u001d\t9\u000f\u0002C\u0001\u0003SDq!a<\u0005\t\u0003\n\t0\u0001\u0006IiR\u0004XI\\4j]\u0016T!AF\f\u0002\r\u0015tw-\u001b8f\u0015\tA\u0012$\u0001\u0003iiR\u0004(B\u0001\u000e\u001c\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011\u0001H\u0001\u0003S>\u001c\u0001\u0001\u0005\u0002 \u00035\tQC\u0001\u0006IiR\u0004XI\\4j]\u0016\u001c\"!\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta$A\u0003baBd\u0017\u0010F\u0002-\u0003g\u0004\"a\b\u0003\u0014\t\u0011qc'\u000f\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nA\u0001\\1oO*\t1'\u0001\u0003kCZ\f\u0017BA\u001b1\u0005\u0019y%M[3diB\u0011qfN\u0005\u0003qA\u0012Q\"Q;u_\u000ecwn]3bE2,\u0007C\u0001\u001eB\u001b\u0005Y$B\u0001\u001f>\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tqt(\u0001\u0005usB,7/\u00194f\u0015\u0005\u0001\u0015aA2p[&\u0011!i\u000f\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002%M\u001cHnQ8oi\u0016DHo\u001d$bGR|'/\u001f\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f^\tA!\u001e;jY&\u0011\u0011J\u0012\u0002\u0013'Nd7i\u001c8uKb$8OR1di>\u0014\u00180\u0001\u0006iiR\u00048\t\\5f]R\u0004\"\u0001T(\u000e\u00035S!AT\f\u0002\r\rd\u0017.\u001a8u\u0013\t\u0001VJ\u0001\u0006IiR\u00048\t\\5f]R\fa\"\u001a<f]Rdun\u001c9He>,\b\u000f\u0005\u0002T16\tAK\u0003\u0002V-\u000691\r[1o]\u0016d'BA,\u001c\u0003\u0015qW\r\u001e;z\u0013\tIFK\u0001\bFm\u0016tG\u000fT8pa\u001e\u0013x.\u001e9\u0002\u000b\rdwnY6\u0011\u0005q\u0003W\"A/\u000b\u0005\u001ds&BA0\u001a\u0003\u001d\u0019w.\\7p]NL!!Y/\u0003\u000b\rcwnY6\u0002\u001b\r|gNZ5hkJ\fG/[8o!\t!\u0017.D\u0001f\u0015\t1w-\u0001\u0004d_:4\u0017n\u001a\u0006\u0003Qf\tAaY8sK&\u0011!.\u001a\u0002\u0015\u000f\u0006$H.\u001b8h\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\r1bWN\\8q\u0011\u0015\u0019%\u00021\u0001E\u0011\u0015Q%\u00021\u0001L\u0011\u0015\t&\u00021\u0001S\u0011\u0015Q&\u00021\u0001\\\u0011\u0015\u0011'\u00021\u0001d\u0003!9\u0018M]7fIV\u0003\bCA\u0012t\u0013\t!HEA\u0004C_>dW-\u00198\u0002\r]\f'/\\+q)\t9(\u0010\u0005\u0002$q&\u0011\u0011\u0010\n\u0002\u0005+:LG\u000fC\u0003|\u0019\u0001\u0007A0\u0001\biiR\u00048i\\7q_:,g\u000e^:\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyx#\u0001\u0005qe>$xnY8m\u0013\r\t\u0019A \u0002\u000f\u0011R$\boQ8na>tWM\u001c;t\u00039)\u00070Z2vi\u0016\u0014V-];fgR$rb^A\u0005\u0003'\ti\"!\t\u0002,\u0005U\u0012\u0011\n\u0005\b\u0003\u0017i\u0001\u0019AA\u0007\u00035\u0019G.[3oiJ+\u0017/^3tiB\u0019A*a\u0004\n\u0007\u0005EQJA\u0004SKF,Xm\u001d;\t\u000f\u0005UQ\u00021\u0001\u0002\u0018\u0005A1\r\\5f]RLE\rE\u0002$\u00033I1!a\u0007%\u0005\u0011auN\\4\t\r\u0005}Q\u00021\u0001s\u0003\u0019\u0019\b.\u0019:fI\"9\u00111E\u0007A\u0002\u0005\u0015\u0012!C3wK:$Hj\\8q!\r\u0019\u0016qE\u0005\u0004\u0003S!&!C#wK:$Hj\\8q\u0011\u001d\ti#\u0004a\u0001\u0003_\t\u0001\u0002\\5ti\u0016tWM\u001d\t\u0004\u0019\u0006E\u0012bAA\u001a\u001b\na\u0001\n\u001e;q\u0019&\u001cH/\u001a8fe\"9\u0011qG\u0007A\u0002\u0005e\u0012AC:tY\u000e{g\u000e^3yiB!\u00111HA#\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013aA:tY*\u0019\u00111\t,\u0002\u000f!\fg\u000e\u001a7fe&!\u0011qIA\u001f\u0005)\u00196\u000f\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u0017j\u0001\u0019AA\u001d\u00039\tG\u000e\u001d8Tg2\u001cuN\u001c;fqR\fA#\u001a=fGV$X\r\u0013;uaJ\u0012V-];fgR\u001cH#D<\u0002R\u0005]\u0014\u0011PA>\u0003{\ny\bC\u0004\u0002T9\u0001\r!!\u0016\u0002)I,\u0017/^3tiN\fe\u000e\u001a'jgR,g.\u001a:t!\u0019\t9&a\u001a\u0002n9!\u0011\u0011LA2\u001d\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0;\u00051AH]8pizJ\u0011!J\u0005\u0004\u0003K\"\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003S\nYG\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t)\u0007\n\t\t\u0003_\n\u0019(!\u0004\u000205\u0011\u0011\u0011\u000f\u0006\u0003\u000f6KA!!\u001e\u0002r\t!\u0001+Y5s\u0011\u001d\t)B\u0004a\u0001\u0003/Aa!a\b\u000f\u0001\u0004\u0011\bbBA\u0012\u001d\u0001\u0007\u0011Q\u0005\u0005\b\u0003oq\u0001\u0019AA\u001d\u0011\u001d\tYE\u0004a\u0001\u0003s\taC\\3x\u0015\u00064\u0018\r\u00128t\u001d\u0006lWMU3t_24XM]\u000b\u0003\u0003\u000b\u0003B!a\"\u0002\u000e6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017k\u0015\u0001\u0003:fg>dg/\u001a:\n\t\u0005=\u0015\u0011\u0012\u0002\u0018\u0013:,G/\u00113ee\u0016\u001c8OT1nKJ+7o\u001c7wKJ\fqC\\3x\u0003NLhn\u0019#og:\u000bW.\u001a*fg>dg/\u001a:\u0015\u0011\u0005\u0015\u0015QSAL\u0003[Cq!a\t\u0011\u0001\u0004\t)\u0003C\u0004\u0002\u001aB\u0001\r!a'\u0002\u0015\u0011t7oU3sm\u0016\u00148\u000fE\u0003$\u0003;\u000b\t+C\u0002\u0002 \u0012\u0012Q!\u0011:sCf\u0004B!a)\u0002*6\u0011\u0011Q\u0015\u0006\u0004\u0003O\u0013\u0014a\u00018fi&!\u00111VAS\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o\u001d\u0005\b\u0003_\u0003\u0002\u0019AAY\u0003\u0015\u0019\u0017m\u00195f!\u0011\t\u0019,a/\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000b1\u0001\u001a8t\u0015\r\tYIV\u0005\u0005\u0003{\u000b)L\u0001\u0005E]N\u001c\u0015m\u00195f\u00039qWm^*tY\u000e{g\u000e^3yiN$b!a1\u0002J\u00065\u0007cA#\u0002F&\u0019\u0011q\u0019$\u0003\u0017M\u001bHnQ8oi\u0016DHo\u001d\u0005\u0007\u0003\u0017\f\u0002\u0019\u0001:\u0002\u0019!$H\u000f\u001d\u001aF]\u0006\u0014G.\u001a3\t\u000f\u0005=\u0017\u00031\u0001\u0002R\u0006A\u0002/\u001a:Vg\u0016\u00148*Z=NC:\fw-\u001a:GC\u000e$xN]=\u0011\u000b\r\n\u0019.a6\n\u0007\u0005UGE\u0001\u0004PaRLwN\u001c\t\u0005\u00033\f\u0019/\u0004\u0002\u0002\\*!\u0011qHAo\u0015\u0011\t9+a8\u000b\u0005\u0005\u0005\u0018!\u00026bm\u0006D\u0018\u0002BAs\u00037\u0014\u0011cS3z\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z\u0003U1G.^:i\u00072LWM\u001c;JI\u000eC\u0017M\u001c8fYN$Ra^Av\u0003[Dq!!\u0006\u0013\u0001\u0004\t9\u0002C\u0004\u0002$I\u0001\r!!\n\u0002\u000b\rdwn]3\u0015\u0003]Dq!!>\u0004\u0001\u0004\t90\u0001\bd_J,7i\\7q_:,g\u000e^:\u0011\t\u0005e\u00181`\u0007\u0002O&\u0019\u0011Q`4\u0003\u001d\r{'/Z\"p[B|g.\u001a8ug\u0002")
public class HttpEngine
implements AutoCloseable,
StrictLogging {
    private final SslContextsFactory sslContextsFactory;
    private final HttpClient httpClient;
    private final EventLoopGroup eventLoopGroup;
    private final GatlingConfiguration configuration;
    private boolean warmedUp;
    private Logger logger;

    public static HttpEngine apply(CoreComponents coreComponents) {
        return HttpEngine$.MODULE$.apply(coreComponents);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void warmUp(HttpComponents httpComponents) {
        if (!this.warmedUp) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Start warm up");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.warmedUp = true;
            Option<String> option = httpComponents.httpProtocol().warmUpUrl();
            if (option instanceof Some) {
                Some some = (Some)option;
                String url = (String)some.value();
                io.gatling.http.client.RequestBuilder requestBuilder = new io.gatling.http.client.RequestBuilder("warmUp", HttpMethod.GET, Uri.create((String)url), InetAddressNameResolver.JAVA_RESOLVER).setHeaders(new DefaultHttpHeaders().add((CharSequence)HttpHeaderNames.ACCEPT, (Object)"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8").add((CharSequence)HttpHeaderNames.ACCEPT_LANGUAGE, (Object)"en-US,en;q=0.5").add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP).add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE).add((CharSequence)HttpHeaderNames.USER_AGENT, (Object)"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:16.0) Gecko/20100101 Firefox/16.0")).setRequestTimeout(1000L).setDefaultCharset(this.configuration.core().charset());
                httpComponents.httpProtocol().proxyPart().proxy().foreach((Function1 & Serializable)x$1 -> requestBuilder.setProxyServer(x$1));
                EventLoop eventLoop = this.eventLoopGroup.next();
                try {
                    BoxedUnit boxedUnit3;
                    try {
                        Promise p = Promise$.MODULE$.apply();
                        this.httpClient.sendRequest(requestBuilder.build(), 0L, eventLoop, new HttpListener(null, p){
                            private final Promise p$1;

                            public void onSend() {
                                super.onSend();
                            }

                            public void onProtocolAwareness(boolean x$1) {
                                super.onProtocolAwareness(x$1);
                            }

                            public void onWrite(Channel x$1) {
                                super.onWrite(x$1);
                            }

                            public void onHttpResponse(HttpResponseStatus httpResponseStatus, HttpHeaders httpHeaders) {
                            }

                            public void onThrowable(Throwable throwable) {
                                this.p$1.failure(throwable);
                            }

                            public void onHttpResponseBodyChunk(ByteBuf byteBuf, boolean last) {
                                if (last) {
                                    this.p$1.success((Object)BoxedUnit.UNIT);
                                    return;
                                }
                            }
                            {
                                this.p$1 = p$1;
                            }
                        }, null, null);
                        Await$.MODULE$.result((Awaitable)p.future(), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).seconds());
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug("Warm up request {} successful", (Object)url);
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        Option option2;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable e = (Throwable)option2.get();
                            if (this.logger().underlying().isDebugEnabled()) {
                                if (this.logger().underlying().isDebugEnabled()) {
                                    this.logger().underlying().debug(new StringBuilder(33).append("Couldn't execute warm up request ").append(url).toString(), e);
                                }
                            } else if (this.logger().underlying().isDebugEnabled()) {
                                this.logger().underlying().debug("Couldn't execute warm up request {}: {}", new Object[]{url, Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(e))});
                            }
                        } else {
                            throw throwable;
                        }
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                }
                finally {
                    this.httpClient.flushClientIdChannels(0L, eventLoop);
                }
            } else {
                Function1 expression = package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)"foo"));
                ((HttpRequestBuilder)((RequestBuilder)new Http((Function1<Session, Validation<String>>)expression).get((Function1<Session, Validation<String>>)expression).header("bar", (Function1<Session, Validation<String>>)expression)).queryParam((Function1<Session, Validation<String>>)expression, (Function1<Session, Validation<Object>>)expression)).build(httpComponents.httpCaches(), httpComponents.httpProtocol(), false, this.configuration);
                ((HttpRequestBuilder)new Http((Function1<Session, Validation<String>>)expression).post((Function1<Session, Validation<String>>)expression).header("bar", (Function1<Session, Validation<String>>)expression)).formParam((Function1<Session, Validation<String>>)expression, (Function1<Session, Validation<Object>>)expression).build(httpComponents.httpCaches(), httpComponents.httpProtocol(), false, this.configuration);
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Warm up done");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void executeRequest(Request clientRequest, long clientId, boolean shared, EventLoop eventLoop, HttpListener listener, SslContext sslContext, SslContext alpnSslContext) {
        if (!this.httpClient.isClosed()) {
            this.httpClient.sendRequest(clientRequest, shared ? -1L : clientId, eventLoop, listener, sslContext, alpnSslContext);
            return;
        }
    }

    public void executeHttp2Requests(Iterable<Pair<Request, HttpListener>> requestsAndListeners, long clientId, boolean shared, EventLoop eventLoop, SslContext sslContext, SslContext alpnSslContext) {
        if (!this.httpClient.isClosed()) {
            this.httpClient.sendHttp2Requests((Pair[])requestsAndListeners.toArray(ClassTag$.MODULE$.apply(Pair.class)), shared ? -1L : clientId, eventLoop, sslContext, alpnSslContext);
            return;
        }
    }

    public InetAddressNameResolver newJavaDnsNameResolver() {
        return InetAddressNameResolver.JAVA_RESOLVER;
    }

    public InetAddressNameResolver newAsyncDnsNameResolver(EventLoop eventLoop, InetSocketAddress[] dnsServers, DnsCache cache) {
        return new InetAddressNameResolverWrapper((NameResolver)new DnsNameResolverBuilder(eventLoop).channelFactory(Transports.newDatagramChannelFactory((boolean)this.configuration.netty().useNativeTransport(), (boolean)this.configuration.netty().useIoUring())).nameServerProvider((DnsServerAddressStreamProvider)(dnsServers.length == 0 ? DnsServerAddressStreamProviders.platformDefault() : new SequentialDnsServerAddressStreamProvider(dnsServers))).queryTimeoutMillis((long)((int)this.configuration.http().dns().queryTimeout().toMillis())).maxQueriesPerResolve(this.configuration.http().dns().maxQueriesPerResolve()).resolveCache(cache).build());
    }

    public SslContexts newSslContexts(boolean http2Enabled, Option<KeyManagerFactory> perUserKeyManagerFactory) {
        return this.sslContextsFactory.newSslContexts(http2Enabled, perUserKeyManagerFactory);
    }

    public void flushClientIdChannels(long clientId, EventLoop eventLoop) {
        if (!this.httpClient.isClosed()) {
            this.httpClient.flushClientIdChannels(clientId, eventLoop);
            return;
        }
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    public HttpEngine(SslContextsFactory sslContextsFactory, HttpClient httpClient, EventLoopGroup eventLoopGroup, Clock clock, GatlingConfiguration configuration) {
        this.sslContextsFactory = sslContextsFactory;
        this.httpClient = httpClient;
        this.eventLoopGroup = eventLoopGroup;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        this.warmedUp = false;
        Statics.releaseFence();
    }
}

