/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine.response;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.auth.DigestAuth;
import io.gatling.http.auth.DigestAuthSupport$;
import io.gatling.http.client.Request;
import io.gatling.http.client.realm.DigestRealm;
import io.gatling.http.client.realm.Realm;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.engine.response.Crash;
import io.gatling.http.engine.response.FollowUp;
import io.gatling.http.engine.response.FollowUpProcessor$;
import io.gatling.http.engine.response.Proceed;
import io.gatling.http.engine.response.ProcessorResult;
import io.gatling.http.engine.response.SessionProcessor;
import io.gatling.http.engine.response.StatsProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestConfig;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class ResponseProcessor$
implements StrictLogging {
    public static final ResponseProcessor$ MODULE$ = new ResponseProcessor$();
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProcessorResult processResponse(HttpTx tx, SessionProcessor sessionProcessor, Charset defaultCharset, Response response) {
        ProcessorResult processorResult;
        try {
            Tuple2<Session, Option<String>> tuple2;
            if (HttpHelper$.MODULE$.isRedirect(response.status()) && tx.request().requestConfig().followRedirect()) {
                if (tx.redirectCount() >= tx.request().requestConfig().httpProtocol().responsePart().maxRedirects()) {
                    processorResult = new Crash(new StringBuilder(27).append("Too many redirects, max is ").append(tx.request().requestConfig().httpProtocol().responsePart().maxRedirects()).toString());
                    return processorResult;
                }
                String location = response.headers().get((CharSequence)HttpHeaderNames.LOCATION);
                if (location == null) {
                    processorResult = new Crash("Redirect status, yet no Location header");
                    return processorResult;
                }
                Uri redirectUri = HttpHelper$.MODULE$.resolveFromUri(tx.request().clientRequest().getUri(), location);
                Session newSession = sessionProcessor.updatedRedirectSession(tx.currentSession(), response, redirectUri);
                int newRedirectCount = tx.redirectCount() + 1;
                Request redirectRequest = FollowUpProcessor$.MODULE$.redirectRequest(tx.request().requestName(), tx.request().clientRequest(), newSession, response.status(), tx.request().requestConfig().httpProtocol(), redirectUri, defaultCharset, newRedirectCount);
                Session x$4 = newSession;
                Request x$12 = redirectRequest;
                String x$2 = tx.request().copy$default$1();
                HttpRequestConfig x$3 = tx.request().copy$default$3();
                HttpRequest x$5 = tx.request().copy(x$2, x$12, x$3);
                int x$6 = newRedirectCount;
                Action x$7 = tx.copy$default$3();
                Option<ResourceTx> x$8 = tx.copy$default$4();
                FollowUp followUp = new FollowUp(tx.copy(x$4, x$5, x$7, x$8, x$6));
                processorResult = followUp;
                return processorResult;
            }
            Seq<DigestAuth.Challenge> digestAuthChallenges = DigestAuthSupport$.MODULE$.extractChallenges(response.headers(), tx.request().clientRequest().getUri());
            Realm realm = tx.request().clientRequest().getRealm();
            if (realm instanceof DigestRealm) {
                DigestRealm digestRealm = (DigestRealm)realm;
                HttpResponseStatus httpResponseStatus = response.status();
                HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.UNAUTHORIZED;
                if (!(httpResponseStatus != null ? !httpResponseStatus.equals(httpResponseStatus2) : httpResponseStatus2 != null)) {
                    if (digestAuthChallenges.nonEmpty() && (digestAuthChallenges.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.stale())) || !tx.request().clientRequest().getHeaders().contains((CharSequence)HttpHeaderNames.AUTHORIZATION))) {
                        Request challengeRequest;
                        Session newSession = sessionProcessor.updatedDigestChallengeSession(tx.session(), response, digestAuthChallenges);
                        Request x$9 = challengeRequest = FollowUpProcessor$.MODULE$.digestChallengeRequest(tx.request().requestName(), tx.request().clientRequest(), newSession, digestRealm, defaultCharset);
                        String x$10 = tx.request().copy$default$1();
                        HttpRequestConfig x$11 = tx.request().copy$default$3();
                        FollowUp followUp = new FollowUp(tx.copy(newSession, tx.request().copy(x$10, x$9, x$11), tx.copy$default$3(), tx.copy$default$4(), tx.copy$default$5()));
                        processorResult = followUp;
                        return processorResult;
                    }
                }
            }
            if ((tuple2 = sessionProcessor.updatedSession(tx.currentSession(), response)) == null) throw new MatchError(tuple2);
            Session newSession = (Session)tuple2._1();
            Option errorMessage = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)newSession, (Object)errorMessage);
            Session newSession2 = (Session)tuple22._1();
            Option errorMessage2 = (Option)tuple22._2();
            processorResult = new Proceed(newSession2, (Option<String>)errorMessage2);
            return processorResult;
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            if (throwable2 == null) throw throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) throw throwable;
            Throwable t = (Throwable)option.get();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(85).append("ResponseProcessor crashed while handling response ").append(response.status()).append(" on session=").append(tx.currentSession()).append(" request=").append(tx.request().requestName()).append(": ").append(tx.request().clientRequest()).append(", forwarding").toString(), t);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            processorResult = new Crash(Throwables.PimpedException$.MODULE$.detailedMessage$extension(Throwables$.MODULE$.PimpedException(t)));
            return processorResult;
        }
    }

    public Session processFailure(HttpTx tx, SessionProcessor sessionProcessor, StatsProcessor statsProcessor, HttpFailure failure) {
        Session sessionWithUpdatedStats = sessionProcessor.updateSessionCrashed(tx.session(), failure.startTimestamp(), failure.endTimestamp());
        try {
            statsProcessor.reportStats(tx.fullRequestName(), sessionWithUpdatedStats, (Status)KO$.MODULE$, failure, (Option<String>)new Some((Object)failure.errorMessage()));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable t = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(84).append("ResponseProcessor crashed while handling failure ").append(failure).append(" on session=").append(tx.session()).append(" request=").append(tx.request().requestName()).append(": ").append(tx.request().clientRequest()).append(", forwarding").toString(), t);
                }
            }
            throw throwable;
        }
        return sessionWithUpdatedStats;
    }

    private ResponseProcessor$() {
    }
}

