/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.jms;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.core.protocol.Protocol;
import io.gatling.javaapi.core.ProtocolBuilder;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.jms.JmsJndiConnectionFactoryBuilder;
import io.gatling.javaapi.jms.JmsMessageMatcher;
import io.gatling.javaapi.jms.internal.JmsMessageMatchers;
import io.gatling.jms.protocol.JmsProtocolBuilderBase;
import jakarta.jms.ConnectionFactory;
import java.time.Duration;

public final class JmsProtocolBuilder
implements ProtocolBuilder {
    private final io.gatling.jms.protocol.JmsProtocolBuilder wrapped;

    public JmsProtocolBuilder(io.gatling.jms.protocol.JmsProtocolBuilder jmsProtocolBuilder) {
        this.wrapped = jmsProtocolBuilder;
    }

    public Protocol protocol() {
        return this.wrapped.build();
    }

    @NonNull
    public JmsProtocolBuilder credentials(@NonNull String string, @NonNull String string2) {
        return new JmsProtocolBuilder(this.wrapped.credentials(string, string2));
    }

    @NonNull
    public JmsProtocolBuilder usePersistentDeliveryMode() {
        return new JmsProtocolBuilder(this.wrapped.usePersistentDeliveryMode());
    }

    @NonNull
    public JmsProtocolBuilder useNonPersistentDeliveryMode() {
        return new JmsProtocolBuilder(this.wrapped.useNonPersistentDeliveryMode());
    }

    @NonNull
    public JmsProtocolBuilder matchByMessageId() {
        return new JmsProtocolBuilder(this.wrapped.matchByMessageId());
    }

    @NonNull
    public JmsProtocolBuilder matchByCorrelationId() {
        return new JmsProtocolBuilder(this.wrapped.matchByCorrelationId());
    }

    @NonNull
    public JmsProtocolBuilder messageMatcher(@NonNull JmsMessageMatcher jmsMessageMatcher) {
        return new JmsProtocolBuilder(this.wrapped.messageMatcher(JmsMessageMatchers.toScala(jmsMessageMatcher)));
    }

    @NonNull
    public JmsProtocolBuilder replyTimeout(long l) {
        return this.replyTimeout(Duration.ofSeconds(l));
    }

    @NonNull
    public JmsProtocolBuilder replyTimeout(Duration duration) {
        return new JmsProtocolBuilder(this.wrapped.replyTimeout(Converters.toScalaDuration((Duration)duration)));
    }

    @NonNull
    public JmsProtocolBuilder listenerThreadCount(int n) {
        return new JmsProtocolBuilder(this.wrapped.listenerThreadCount(n));
    }

    public static final class Base {
        public static final Base INSTANCE = new Base();

        private Base() {
        }

        @NonNull
        public JmsProtocolBuilder connectionFactory(@NonNull ConnectionFactory connectionFactory) {
            return new JmsProtocolBuilder(JmsProtocolBuilderBase.connectionFactory((ConnectionFactory)connectionFactory));
        }

        @NonNull
        public JmsProtocolBuilder connectionFactory(@NonNull JmsJndiConnectionFactoryBuilder jmsJndiConnectionFactoryBuilder) {
            return new JmsProtocolBuilder(JmsProtocolBuilderBase.connectionFactory((ConnectionFactory)jmsJndiConnectionFactoryBuilder.build()));
        }
    }
}

