/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.jms;

import io.gatling.javaapi.core.ActionBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.jms.JmsDestination;
import io.gatling.jms.request.SendDslBuilder;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

public final class JmsSendActionBuilder
implements ActionBuilder {
    private final SendDslBuilder wrapped;

    public JmsSendActionBuilder(SendDslBuilder sendDslBuilder) {
        this.wrapped = sendDslBuilder;
    }

    public @NonNull JmsSendActionBuilder property(@NonNull String string, @NonNull String string2) {
        return new JmsSendActionBuilder(this.wrapped.property(Expressions.toStringExpression((String)string), Expressions.toAnyExpression((String)string2)));
    }

    public @NonNull JmsSendActionBuilder property(@NonNull Function<Session, String> function, @NonNull String string) {
        return new JmsSendActionBuilder(this.wrapped.property(Expressions.javaFunctionToExpression(function), Expressions.toAnyExpression((String)string)));
    }

    public @NonNull JmsSendActionBuilder property(@NonNull String string, @NonNull Function<Session, Object> function) {
        return new JmsSendActionBuilder(this.wrapped.property(Expressions.toStringExpression((String)string), Expressions.javaFunctionToExpression(function)));
    }

    public @NonNull JmsSendActionBuilder property(@NonNull Function<Session, String> function, @NonNull Function<Session, Object> function2) {
        return new JmsSendActionBuilder(this.wrapped.property(Expressions.javaFunctionToExpression(function), Expressions.javaFunctionToExpression(function2)));
    }

    public @NonNull JmsSendActionBuilder jmsType(@NonNull String string) {
        return new JmsSendActionBuilder(this.wrapped.jmsType(Expressions.toStringExpression((String)string)));
    }

    public @NonNull JmsSendActionBuilder jmsType(@NonNull Function<Session, String> function) {
        return new JmsSendActionBuilder(this.wrapped.jmsType(Expressions.javaFunctionToExpression(function)));
    }

    public io.gatling.core.action.builder.ActionBuilder asScala() {
        return this.wrapped.build();
    }

    public static final class Message {
        private final SendDslBuilder.Message wrapped;

        public Message(SendDslBuilder.Message message) {
            this.wrapped = message;
        }

        public @NonNull JmsSendActionBuilder textMessage(@NonNull String string) {
            return new JmsSendActionBuilder(this.wrapped.textMessage(Expressions.toStringExpression((String)string)));
        }

        public @NonNull JmsSendActionBuilder textMessage(@NonNull Function<Session, String> function) {
            return new JmsSendActionBuilder(this.wrapped.textMessage(Expressions.javaFunctionToExpression(function)));
        }

        public @NonNull JmsSendActionBuilder bytesMessage(byte[] byArray) {
            return new JmsSendActionBuilder(this.wrapped.bytesMessage(Expressions.toStaticValueExpression((Object)byArray)));
        }

        public @NonNull JmsSendActionBuilder bytesMessage(@NonNull String string) {
            return new JmsSendActionBuilder(this.wrapped.bytesMessage(Expressions.toBytesExpression((String)string)));
        }

        public @NonNull JmsSendActionBuilder bytesMessage(@NonNull Function<Session, byte[]> function) {
            return new JmsSendActionBuilder(this.wrapped.bytesMessage(Expressions.javaFunctionToExpression(function)));
        }

        public @NonNull JmsSendActionBuilder mapMessage(@NonNull Map<String, Object> map) {
            return new JmsSendActionBuilder(this.wrapped.mapMessage(Expressions.toStaticValueExpression((Object)Converters.toScalaMap(map))));
        }

        public @NonNull JmsSendActionBuilder mapMessage(@NonNull String string) {
            return new JmsSendActionBuilder(this.wrapped.mapMessage(Expressions.toMapExpression((String)string)));
        }

        public @NonNull JmsSendActionBuilder mapMessage(@NonNull Function<Session, Map<String, Object>> function) {
            return new JmsSendActionBuilder(this.wrapped.mapMessage(Expressions.javaFunctionToExpression(function.andThen(Converters::toScalaMap))));
        }

        public @NonNull JmsSendActionBuilder objectMessage(@NonNull Serializable serializable) {
            return new JmsSendActionBuilder(this.wrapped.objectMessage(Expressions.toStaticValueExpression((Object)serializable)));
        }

        public @NonNull JmsSendActionBuilder objectMessage(@NonNull String string) {
            return new JmsSendActionBuilder(this.wrapped.objectMessage(Expressions.toExpression((String)string, Serializable.class)));
        }

        public @NonNull JmsSendActionBuilder objectMessage(@NonNull Function<Session, Serializable> function) {
            return new JmsSendActionBuilder(this.wrapped.objectMessage(Expressions.javaFunctionToExpression(function)));
        }
    }

    public static final class Queue {
        private final SendDslBuilder.Queue wrapped;

        public Queue(SendDslBuilder.Queue queue) {
            this.wrapped = queue;
        }

        public @NonNull Message queue(@NonNull String string) {
            return new Message(this.wrapped.queue(Expressions.toStringExpression((String)string)));
        }

        public @NonNull Message queue(@NonNull Function<Session, String> function) {
            return new Message(this.wrapped.queue(Expressions.javaFunctionToExpression(function)));
        }

        public @NonNull Message destination(@NonNull JmsDestination jmsDestination) {
            return new Message(this.wrapped.destination(jmsDestination.asScala()));
        }
    }
}

