/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0001\u0017\tY!*\\:Qe>$WoY3s\u0015\t\u0019A!\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u000b\u0019\t1A[7t\u0015\t9\u0001\"A\u0004hCRd\u0017N\\4\u000b\u0003%\t!![8\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u0011M\u0001!\u0011!Q\u0001\nQ\t!B[7t'\u0016\u001c8/[8o!\t)\u0012$D\u0001\u0017\u0015\t)qCC\u0001\u0019\u0003\u0015Q\u0017M^1y\u0013\tQbCA\u0004TKN\u001c\u0018n\u001c8\t\u0011q\u0001!\u0011!Q\u0001\nu\t\u0001\u0002\u001d:pIV\u001cWM\u001d\t\u0003+yI!a\b\f\u0003\u001f5+7o]1hKB\u0013x\u000eZ;dKJDQ!\t\u0001\u0005\u0002\t\na\u0001P5oSRtDcA\u0012&MA\u0011A\u0005A\u0007\u0002\u0005!)1\u0003\ta\u0001)!)A\u0004\ta\u0001;!)\u0001\u0006\u0001C\u0001S\u0005\u00012/\u001a8e\u0005f$Xm]'fgN\fw-\u001a\u000b\u0006U5*\u0004*\u0014\t\u0003\u001b-J!\u0001\f\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006]\u001d\u0002\raL\u0001\u0006Ef$Xm\u001d\t\u0004\u001bA\u0012\u0014BA\u0019\u000f\u0005\u0015\t%O]1z!\ti1'\u0003\u00025\u001d\t!!)\u001f;f\u0011\u00151t\u00051\u00018\u0003\u0015\u0001(o\u001c9t!\u0011AtHQ#\u000f\u0005ej\u0004C\u0001\u001e\u000f\u001b\u0005Y$B\u0001\u001f\u000b\u0003\u0019a$o\\8u}%\u0011aHD\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%aA'ba*\u0011aH\u0004\t\u0003q\rK!\u0001R!\u0003\rM#(/\u001b8h!\tia)\u0003\u0002H\u001d\t\u0019\u0011I\\=\t\u000b%;\u0003\u0019\u0001&\u0002\u000f)l7\u000fV=qKB\u0019Qb\u0013\"\n\u00051s!AB(qi&|g\u000eC\u0003OO\u0001\u0007q*\u0001\u0006cK\u001a|'/Z*f]\u0012\u0004B!\u0004)SU%\u0011\u0011K\u0004\u0002\n\rVt7\r^5p]F\u0002\"!F*\n\u0005Q3\"aB'fgN\fw-\u001a\u0005\u0006-\u0002!\taV\u0001\u000fg\u0016tG-T1q\u001b\u0016\u001c8/Y4f)\u0015Q\u0003LW.]\u0011\u0015IV\u000b1\u00018\u0003\ri\u0017\r\u001d\u0005\u0006mU\u0003\ra\u000e\u0005\u0006\u0013V\u0003\rA\u0013\u0005\u0006\u001dV\u0003\ra\u0014\u0005\u0006=\u0002!\taX\u0001\u0012g\u0016tGm\u00142kK\u000e$X*Z:tC\u001e,G#\u0002\u0016aS*\\\u0007\"B1^\u0001\u0004\u0011\u0017!A8\u0011\u0005\r<W\"\u00013\u000b\u0005%)'\"\u00014\u0002\t)\fg/Y\u0005\u0003Q\u0012\u0014AbU3sS\u0006d\u0017N_1cY\u0016DQAN/A\u0002]BQ!S/A\u0002)CQAT/A\u0002=CQ!\u001c\u0001\u0005\u00029\fqb]3oIR+\u0007\u0010^'fgN\fw-\u001a\u000b\u0006U=\f(o\u001d\u0005\u0006a2\u0004\rAQ\u0001\f[\u0016\u001c8/Y4f)\u0016DH\u000fC\u00037Y\u0002\u0007q\u0007C\u0003JY\u0002\u0007!\nC\u0003OY\u0002\u0007q\nC\u0003v\u0001\u0011%a/A\u0006tK:$W*Z:tC\u001e,Gc\u0001\u0016xs\")\u0001\u0010\u001ea\u0001%\u00069Q.Z:tC\u001e,\u0007\"\u0002(u\u0001\u0004y\u0005\"B>\u0001\t\u0013a\u0018aE<sSR,\u0007K]8qgR{W*Z:tC\u001e,Gc\u0001\u0016~}\")aG\u001fa\u0001o!)\u0001P\u001fa\u0001%\u0002")
public class JmsProducer {
    private final Session jmsSession;
    private final MessageProducer producer;

    public void sendBytesMessage(byte[] bytes, Map<String, Object> props, Option<String> jmsType, Function1<Message, BoxedUnit> beforeSend) {
        BytesMessage message = this.jmsSession.createBytesMessage();
        message.writeBytes(bytes);
        this.writePropsToMessage(props, (Message)message);
        jmsType.foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            message.setJMSType(x$1);
            return BoxedUnit.UNIT;
        });
        this.sendMessage((Message)message, beforeSend);
    }

    public void sendMapMessage(Map<String, Object> map, Map<String, Object> props, Option<String> jmsType, Function1<Message, BoxedUnit> beforeSend) {
        MapMessage message = this.jmsSession.createMapMessage();
        map.foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            JmsProducer.$anonfun$sendMapMessage$1(message, x0$1);
            return BoxedUnit.UNIT;
        });
        this.writePropsToMessage(props, (Message)message);
        jmsType.foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            message.setJMSType(x$1);
            return BoxedUnit.UNIT;
        });
        this.sendMessage((Message)message, beforeSend);
    }

    public void sendObjectMessage(java.io.Serializable o, Map<String, Object> props, Option<String> jmsType, Function1<Message, BoxedUnit> beforeSend) {
        ObjectMessage message = this.jmsSession.createObjectMessage(o);
        this.writePropsToMessage(props, (Message)message);
        jmsType.foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            message.setJMSType(x$1);
            return BoxedUnit.UNIT;
        });
        this.sendMessage((Message)message, beforeSend);
    }

    public void sendTextMessage(String messageText, Map<String, Object> props, Option<String> jmsType, Function1<Message, BoxedUnit> beforeSend) {
        TextMessage message = this.jmsSession.createTextMessage(messageText);
        this.writePropsToMessage(props, (Message)message);
        jmsType.foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            message.setJMSType(x$1);
            return BoxedUnit.UNIT;
        });
        this.sendMessage((Message)message, beforeSend);
    }

    private void sendMessage(Message message, Function1<Message, BoxedUnit> beforeSend) {
        beforeSend.apply((Object)message);
        this.producer.send(message);
    }

    private void writePropsToMessage(Map<String, Object> props, Message message) {
        props.foreach((Function1 & java.io.Serializable & Serializable)x0$2 -> {
            JmsProducer.$anonfun$writePropsToMessage$1(message, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$sendMapMessage$1(MapMessage message$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        Object value = tuple2._2();
        message$3.setObject(key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$writePropsToMessage$1(Message message$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        Object value = tuple2._2();
        message$2.setObjectProperty(key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public JmsProducer(Session jmsSession, MessageProducer producer) {
        this.jmsSession = jmsSession;
        this.producer = producer;
    }
}

