/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import io.gatling.commons.model.Credentials;
import io.gatling.commons.util.Clock;
import io.gatling.core.actor.ActorSystem;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.StatsEngine;
import io.gatling.jms.client.JmsConnection;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000554AAC\u0006\u0003)!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011!Y\u0003A!A!\u0002\u0013a\u0003\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\t\u000bm\u0002A\u0011\u0001\u001f\t\u000f\r\u0003!\u0019!C\u0005\t\"1\u0001\f\u0001Q\u0001\n\u0015CQ!\u0017\u0001\u0005\u0002iCQ\u0001\u001b\u0001\u0005\u0002%\u0014\u0011CS7t\u0007>tg.Z2uS>t\u0007k\\8m\u0015\taQ\"\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u001d=\t1A[7t\u0015\t\u0001\u0012#A\u0004hCRd\u0017N\\4\u000b\u0003I\t!![8\u0004\u0001M\u0011\u0001!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rML8\u000f^3n!\ti\"%D\u0001\u001f\u0015\ty\u0002%A\u0003bGR|'O\u0003\u0002\"\u001f\u0005!1m\u001c:f\u0013\t\u0019cDA\u0006BGR|'oU=ti\u0016l\u0017aC:uCR\u001cXI\\4j]\u0016\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u0011\u0002\u000bM$\u0018\r^:\n\u0005):#aC*uCR\u001cXI\\4j]\u0016\fQa\u00197pG.\u0004\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\tU$\u0018\u000e\u001c\u0006\u0003c=\tqaY8n[>t7/\u0003\u00024]\t)1\t\\8dW\u0006i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"AN\u001d\u000e\u0003]R!\u0001\u000f\u0011\u0002\r\r|gNZ5h\u0013\tQtG\u0001\u000bHCRd\u0017N\\4D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000buz\u0004)\u0011\"\u0011\u0005y\u0002Q\"A\u0006\t\u000bm)\u0001\u0019\u0001\u000f\t\u000b\u0011*\u0001\u0019A\u0013\t\u000b-*\u0001\u0019\u0001\u0017\t\u000bQ*\u0001\u0019A\u001b\u0002\u0017\r|gN\\3di&|gn]\u000b\u0002\u000bB!a\t\u0014(V\u001b\u00059%B\u0001%J\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003_)S\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u000f\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005=\u001bV\"\u0001)\u000b\u00059\t&\"\u0001*\u0002\u000f)\f7.\u0019:uC&\u0011A\u000b\u0015\u0002\u0012\u0007>tg.Z2uS>tg)Y2u_JL\bC\u0001 W\u0013\t96BA\u0007K[N\u001cuN\u001c8fGRLwN\\\u0001\rG>tg.Z2uS>t7\u000fI\u0001\u000eU6\u001c8i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0007U[V\fC\u0003]\u0011\u0001\u0007a*A\td_:tWm\u0019;j_:4\u0015m\u0019;pefDQA\u0018\u0005A\u0002}\u000b1b\u0019:fI\u0016tG/[1mgB\u0019a\u0003\u00192\n\u0005\u0005<\"AB(qi&|g\u000e\u0005\u0002dM6\tAM\u0003\u0002fa\u0005)Qn\u001c3fY&\u0011q\r\u001a\u0002\f\u0007J,G-\u001a8uS\u0006d7/A\u0003dY>\u001cX\rF\u0001k!\t12.\u0003\u0002m/\t!QK\\5u\u0001")
public final class JmsConnectionPool {
    private final ActorSystem system;
    private final StatsEngine statsEngine;
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final ConcurrentHashMap<ConnectionFactory, JmsConnection> connections;

    private ConcurrentHashMap<ConnectionFactory, JmsConnection> connections() {
        return this.connections;
    }

    public JmsConnection jmsConnection(ConnectionFactory connectionFactory2, Option<Credentials> credentials) {
        JmsConnection connection = this.connections().computeIfAbsent(connectionFactory2, connectionFactory -> {
            Connection connection;
            Some some;
            Credentials credentials;
            Option option = credentials;
            if (option instanceof Some && (credentials = (Credentials)(some = (Some)option).value()) != null) {
                String username = credentials.username();
                String password = credentials.password();
                connection = connectionFactory.createConnection(username, password);
            } else {
                connection = connectionFactory.createConnection();
            }
            Connection connection2 = connection;
            connection2.start();
            return new JmsConnection(connection2, credentials, $this.system, $this.statsEngine, $this.clock, $this.configuration);
        });
        Option<Credentials> option = connection.credentials();
        Option<Credentials> option2 = credentials;
        if (option == null ? option2 != null : !option.equals(option2)) {
            throw new UnsupportedOperationException("The same ConnectionFactory was already used to create a connection with different credentials");
        }
        return connection;
    }

    public void close() {
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.connections().values()).asScala().foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public JmsConnectionPool(ActorSystem system, StatsEngine statsEngine, Clock clock, GatlingConfiguration configuration) {
        this.system = system;
        this.statsEngine = statsEngine;
        this.clock = clock;
        this.configuration = configuration;
        this.connections = new ConcurrentHashMap();
    }
}

