/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.GatlingMojo;
import io.gatling.mojo.MojoUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.toolchain.ToolchainManager;

public abstract class AbstractGatlingMojo
extends AbstractMojo {
    @Parameter(property="gatling.configFolder", alias="cd", defaultValue="${project.basedir}/src/test/resources")
    protected File configFolder;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", readonly=true)
    protected File compiledClassesFolder;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Component
    protected ToolchainManager toolchainManager;
    @Component
    protected RepositorySystem repository;

    protected List<String> buildTestClasspath() throws Exception {
        ArrayList<String> testClasspathElements = new ArrayList<String>();
        if (!new File(this.compiledClassesFolder, "gatling.conf").exists()) {
            testClasspathElements.add(this.configFolder.getCanonicalPath());
        }
        testClasspathElements.addAll(this.mavenProject.getTestClasspathElements());
        testClasspathElements.add(MojoUtils.locateJar(GatlingMojo.class));
        return testClasspathElements;
    }

    protected void addArg(List<String> args, String flag, Object value) {
        if (value != null) {
            args.addAll(Arrays.asList("-" + flag, value.toString()));
        }
    }
}

