/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.CommonLogMessage;
import io.gatling.plugin.EmptyChoicesException;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.SeveralSimulationClassNamesFoundException;
import io.gatling.plugin.exceptions.SeveralTeamsFoundException;
import io.gatling.plugin.exceptions.SimulationStartException;
import io.gatling.plugin.exceptions.UnsupportedJavaVersionException;
import io.gatling.plugin.model.Simulation;
import io.gatling.plugin.model.Team;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public final class RecoverEnterprisePluginException {
    static <R> R handle(EnterprisePluginExceptionFunction<R> f, Log log) throws MojoFailureException {
        try {
            return f.apply();
        }
        catch (UnsupportedJavaVersionException e) {
            String msg = e.getMessage() + "\nIn order to target the supported Java version, please use the following Maven setting:\n<maven.compiler.release>" + e.supportedVersion + "</maven.compiler.release>\nSee also the Maven compiler plugin documentation: https://maven.apache.org/plugins/maven-compiler-plugin/examples/set-compiler-release.html \nAlternatively, the reported class may come from your project's dependencies, published targeting Java " + e.version + ". In this case you need to use dependencies which target Java " + e.supportedVersion + " or lower.";
            throw new MojoFailureException(msg);
        }
        catch (SeveralTeamsFoundException e) {
            String availableTeams = e.getAvailableTeams().stream().map(t -> String.format("- %s (%s)\n", t.id, t.name)).collect(Collectors.joining());
            String teamExample = ((Team)e.getAvailableTeams().get((int)0)).id.toString();
            String msg = "Several teams were found to create a simulation.\nAvailable teams:\n" + availableTeams + CommonLogMessage.missingConfiguration("team", "teamId", "gatling.enterprise.teamId", null, teamExample);
            throw new MojoFailureException(msg);
        }
        catch (SeveralSimulationClassNamesFoundException e) {
            String availableClasses = e.getAvailableSimulationClassNames().stream().map(s -> String.format("- %s\n", s)).collect(Collectors.joining());
            String classExample = (String)e.getAvailableSimulationClassNames().stream().findFirst().get();
            String msg = "Several simulation classes were found.\nAvailable classes:\n" + availableClasses + "\n" + CommonLogMessage.missingConfiguration("class", "simulationClass", "gatling.simulationClass", null, classExample);
            throw new MojoFailureException(msg);
        }
        catch (SimulationStartException e) {
            Simulation simulation = e.getSimulation();
            if (e.isCreated()) {
                log.info((CharSequence)CommonLogMessage.simulationCreated(simulation));
            }
            String msg = "Failed to start simulation.\n" + String.format("Simulation %s with ID %s exists but could not be started: ", simulation.name, simulation.id) + e.getCause().getMessage() + "\n" + CommonLogMessage.simulationConfiguration(simulation, null, false);
            throw new MojoFailureException(msg, (Throwable)e);
        }
        catch (EmptyChoicesException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (EnterprisePluginException e) {
            throw new MojoFailureException("Unhandled Gatling Enterprise plugin exception: " + e.getMessage(), (Throwable)e);
        }
    }

    @FunctionalInterface
    public static interface EnterprisePluginExceptionFunction<R> {
        public R apply() throws EnterprisePluginException;
    }
}

