/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.netty.util.ahc;

import java.util.BitSet;

public final class Utf8UrlEncoder {
    private static final BitSet RFC3986_UNRESERVED_CHARS;
    private static final BitSet RFC3986_GENDELIM_CHARS;
    private static final BitSet RFC3986_SUBDELIM_CHARS;
    private static final BitSet RFC3986_RESERVED_CHARS;
    private static final BitSet RFC3986_PCHARS;
    private static final BitSet BUILT_PATH_UNTOUCHED_CHARS;
    private static final BitSet BUILT_QUERY_UNTOUCHED_CHARS;
    private static final BitSet FORM_URL_ENCODED_SAFE_CHARS;
    private static final char[] HEX;

    private Utf8UrlEncoder() {
    }

    public static String encodePath(String string) {
        StringBuilder stringBuilder = Utf8UrlEncoder.lazyAppendEncoded(null, string, BUILT_PATH_UNTOUCHED_CHARS, false);
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    public static StringBuilder encodeAndAppendQuery(StringBuilder stringBuilder, String string) {
        return Utf8UrlEncoder.appendEncoded(stringBuilder, string, BUILT_QUERY_UNTOUCHED_CHARS, false);
    }

    public static String encodeQueryElement(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 6);
        Utf8UrlEncoder.encodeAndAppendQueryElement(stringBuilder, string);
        return stringBuilder.toString();
    }

    public static StringBuilder encodeAndAppendQueryElement(StringBuilder stringBuilder, CharSequence charSequence) {
        return Utf8UrlEncoder.appendEncoded(stringBuilder, charSequence, FORM_URL_ENCODED_SAFE_CHARS, false);
    }

    public static StringBuilder encodeAndAppendFormElement(StringBuilder stringBuilder, CharSequence charSequence) {
        return Utf8UrlEncoder.appendEncoded(stringBuilder, charSequence, FORM_URL_ENCODED_SAFE_CHARS, true);
    }

    public static String percentEncodeQueryElement(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 6);
        Utf8UrlEncoder.encodeAndAppendPercentEncoded(stringBuilder, string);
        return stringBuilder.toString();
    }

    public static StringBuilder encodeAndAppendPercentEncoded(StringBuilder stringBuilder, CharSequence charSequence) {
        return Utf8UrlEncoder.appendEncoded(stringBuilder, charSequence, RFC3986_UNRESERVED_CHARS, false);
    }

    private static StringBuilder lazyInitStringBuilder(CharSequence charSequence, int n) {
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 6);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(charSequence.charAt(i));
        }
        return stringBuilder;
    }

    private static StringBuilder lazyAppendEncoded(StringBuilder stringBuilder, CharSequence charSequence, BitSet bitSet, boolean bl) {
        int n;
        for (int i = 0; i < charSequence.length(); i += Character.charCount(n)) {
            n = Character.codePointAt(charSequence, i);
            if (n <= 127) {
                if (bitSet.get(n)) {
                    if (stringBuilder == null) continue;
                    stringBuilder.append((char)n);
                    continue;
                }
                if (stringBuilder == null) {
                    stringBuilder = Utf8UrlEncoder.lazyInitStringBuilder(charSequence, i);
                }
                Utf8UrlEncoder.appendSingleByteEncoded(stringBuilder, n, bl);
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = Utf8UrlEncoder.lazyInitStringBuilder(charSequence, i);
            }
            Utf8UrlEncoder.appendMultiByteEncoded(stringBuilder, n);
        }
        return stringBuilder;
    }

    private static StringBuilder appendEncoded(StringBuilder stringBuilder, CharSequence charSequence, BitSet bitSet, boolean bl) {
        int n;
        for (int i = 0; i < charSequence.length(); i += Character.charCount(n)) {
            n = Character.codePointAt(charSequence, i);
            if (n <= 127) {
                if (bitSet.get(n)) {
                    stringBuilder.append((char)n);
                    continue;
                }
                Utf8UrlEncoder.appendSingleByteEncoded(stringBuilder, n, bl);
                continue;
            }
            Utf8UrlEncoder.appendMultiByteEncoded(stringBuilder, n);
        }
        return stringBuilder;
    }

    private static void appendSingleByteEncoded(StringBuilder stringBuilder, int n, boolean bl) {
        if (n == 32 && bl) {
            stringBuilder.append('+');
            return;
        }
        stringBuilder.append('%');
        stringBuilder.append(HEX[n >> 4]);
        stringBuilder.append(HEX[n & 0xF]);
    }

    private static void appendMultiByteEncoded(StringBuilder stringBuilder, int n) {
        if (n < 2048) {
            Utf8UrlEncoder.appendSingleByteEncoded(stringBuilder, 0xC0 | n >> 6, false);
            Utf8UrlEncoder.appendSingleByteEncoded(stringBuilder, 0x80 | n & 0x3F, false);
        } else if (n < 65536) {
            Utf8UrlEncoder.appendSingleByteEncoded(stringBuilder, 0xE0 | n >> 12, false);
            Utf8UrlEncoder.appendSingleByteEncoded(stringBuilder, 0x80 | n >> 6 & 0x3F, false);
            Utf8UrlEncoder.appendSingleByteEncoded(stringBuilder, 0x80 | n & 0x3F, false);
        } else {
            Utf8UrlEncoder.appendSingleByteEncoded(stringBuilder, 0xF0 | n >> 18, false);
            Utf8UrlEncoder.appendSingleByteEncoded(stringBuilder, 0x80 | n >> 12 & 0x3F, false);
            Utf8UrlEncoder.appendSingleByteEncoded(stringBuilder, 0x80 | n >> 6 & 0x3F, false);
            Utf8UrlEncoder.appendSingleByteEncoded(stringBuilder, 0x80 | n & 0x3F, false);
        }
    }

    static {
        int n;
        RFC3986_UNRESERVED_CHARS = new BitSet();
        RFC3986_GENDELIM_CHARS = new BitSet();
        RFC3986_SUBDELIM_CHARS = new BitSet();
        RFC3986_RESERVED_CHARS = new BitSet();
        RFC3986_PCHARS = new BitSet();
        BUILT_PATH_UNTOUCHED_CHARS = new BitSet();
        BUILT_QUERY_UNTOUCHED_CHARS = new BitSet();
        FORM_URL_ENCODED_SAFE_CHARS = new BitSet();
        HEX = "0123456789ABCDEF".toCharArray();
        for (n = 97; n <= 122; ++n) {
            RFC3986_UNRESERVED_CHARS.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            RFC3986_UNRESERVED_CHARS.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            RFC3986_UNRESERVED_CHARS.set(n);
        }
        RFC3986_UNRESERVED_CHARS.set(45);
        RFC3986_UNRESERVED_CHARS.set(46);
        RFC3986_UNRESERVED_CHARS.set(95);
        RFC3986_UNRESERVED_CHARS.set(126);
        RFC3986_GENDELIM_CHARS.set(58);
        RFC3986_GENDELIM_CHARS.set(47);
        RFC3986_GENDELIM_CHARS.set(63);
        RFC3986_GENDELIM_CHARS.set(35);
        RFC3986_GENDELIM_CHARS.set(91);
        RFC3986_GENDELIM_CHARS.set(93);
        RFC3986_GENDELIM_CHARS.set(64);
        RFC3986_SUBDELIM_CHARS.set(33);
        RFC3986_SUBDELIM_CHARS.set(36);
        RFC3986_SUBDELIM_CHARS.set(38);
        RFC3986_SUBDELIM_CHARS.set(39);
        RFC3986_SUBDELIM_CHARS.set(40);
        RFC3986_SUBDELIM_CHARS.set(41);
        RFC3986_SUBDELIM_CHARS.set(42);
        RFC3986_SUBDELIM_CHARS.set(43);
        RFC3986_SUBDELIM_CHARS.set(44);
        RFC3986_SUBDELIM_CHARS.set(59);
        RFC3986_SUBDELIM_CHARS.set(61);
        RFC3986_RESERVED_CHARS.or(RFC3986_GENDELIM_CHARS);
        RFC3986_RESERVED_CHARS.or(RFC3986_SUBDELIM_CHARS);
        RFC3986_PCHARS.or(RFC3986_UNRESERVED_CHARS);
        RFC3986_PCHARS.or(RFC3986_SUBDELIM_CHARS);
        RFC3986_PCHARS.set(58);
        RFC3986_PCHARS.set(64);
        BUILT_PATH_UNTOUCHED_CHARS.or(RFC3986_PCHARS);
        BUILT_PATH_UNTOUCHED_CHARS.set(37);
        BUILT_PATH_UNTOUCHED_CHARS.set(47);
        BUILT_QUERY_UNTOUCHED_CHARS.or(RFC3986_PCHARS);
        BUILT_QUERY_UNTOUCHED_CHARS.set(37);
        BUILT_QUERY_UNTOUCHED_CHARS.set(47);
        BUILT_QUERY_UNTOUCHED_CHARS.set(63);
        for (n = 97; n <= 122; ++n) {
            FORM_URL_ENCODED_SAFE_CHARS.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            FORM_URL_ENCODED_SAFE_CHARS.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            FORM_URL_ENCODED_SAFE_CHARS.set(n);
        }
        FORM_URL_ENCODED_SAFE_CHARS.set(45);
        FORM_URL_ENCODED_SAFE_CHARS.set(46);
        FORM_URL_ENCODED_SAFE_CHARS.set(95);
        FORM_URL_ENCODED_SAFE_CHARS.set(42);
    }
}

