/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.cms.jcajce;

import io.gatling.recorder.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.gatling.recorder.internal.bouncycastle.cms.jcajce.CMSUtils;
import io.gatling.recorder.internal.bouncycastle.cms.jcajce.JcaJceExtHelper;
import io.gatling.recorder.internal.bouncycastle.cms.jcajce.JceCMSKEMKeyUnwrapper;
import io.gatling.recorder.internal.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import io.gatling.recorder.internal.bouncycastle.operator.AsymmetricKeyUnwrapper;
import io.gatling.recorder.internal.bouncycastle.operator.SymmetricKeyUnwrapper;
import io.gatling.recorder.internal.bouncycastle.operator.jcajce.JceAsymmetricKeyUnwrapper;
import io.gatling.recorder.internal.bouncycastle.operator.jcajce.JceKTSKeyUnwrapper;
import io.gatling.recorder.internal.bouncycastle.operator.jcajce.JceSymmetricKeyUnwrapper;
import java.security.PrivateKey;
import javax.crypto.SecretKey;

class DefaultJcaJceExtHelper
extends DefaultJcaJceHelper
implements JcaJceExtHelper {
    DefaultJcaJceExtHelper() {
    }

    @Override
    public JceAsymmetricKeyUnwrapper createAsymmetricUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privateKey) {
        privateKey = CMSUtils.cleanPrivateKey(privateKey);
        return new JceAsymmetricKeyUnwrapper(algorithmIdentifier, privateKey);
    }

    @Override
    public JceKTSKeyUnwrapper createAsymmetricUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privateKey, byte[] byArray, byte[] byArray2) {
        privateKey = CMSUtils.cleanPrivateKey(privateKey);
        return new JceKTSKeyUnwrapper(algorithmIdentifier, privateKey, byArray, byArray2);
    }

    @Override
    public SymmetricKeyUnwrapper createSymmetricUnwrapper(AlgorithmIdentifier algorithmIdentifier, SecretKey secretKey) {
        return new JceSymmetricKeyUnwrapper(algorithmIdentifier, secretKey);
    }

    @Override
    public AsymmetricKeyUnwrapper createKEMUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privateKey) {
        return new JceCMSKEMKeyUnwrapper(algorithmIdentifier, privateKey);
    }
}

