/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.har;

import com.ning.http.util.Base64;
import io.gatling.core.util.StringHelper;
import io.gatling.core.util.StringHelper$;
import io.gatling.recorder.har.Content;
import io.gatling.recorder.har.Entry;
import io.gatling.recorder.har.Header;
import io.gatling.recorder.har.HttpArchive;
import io.gatling.recorder.har.Log;
import io.gatling.recorder.har.PostData;
import io.gatling.recorder.har.PostParam;
import io.gatling.recorder.har.Request;
import io.gatling.recorder.har.Response;
import io.gatling.recorder.util.Json;
import io.gatling.recorder.util.Json$;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.threeten.bp.ZonedDateTime;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class HarMapping$ {
    public static final HarMapping$ MODULE$;
    private final Regex ProtectedValue;
    private final Charset Charset;

    static {
        new HarMapping$();
    }

    private Regex ProtectedValue() {
        return this.ProtectedValue;
    }

    public Charset Charset() {
        return this.Charset;
    }

    public HttpArchive jsonToHttpArchive(Json json) {
        return new HttpArchive(this.buildLog(json.selectDynamic("log")));
    }

    private long parseMillisFromIso8601DateTime(String time) {
        return ZonedDateTime.parse((CharSequence)time).toInstant().toEpochMilli();
    }

    private Log buildLog(Json log) {
        Vector entries = log.selectDynamic("entries").iterator().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Json x$1) {
                return x$1.selectDynamic("request").selectDynamic("url").toString().toLowerCase().startsWith("http");
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Json x$2) {
                return x$2.selectDynamic("response").selectDynamic("status").toInt() != 0;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Entry apply(Json entry) {
                return HarMapping$.MODULE$.io$gatling$recorder$har$HarMapping$$buildEntry(entry);
            }
        }).toVector();
        return new Log((Seq<Entry>)entries);
    }

    public Entry io$gatling$recorder$har$HarMapping$$buildEntry(Json entry) {
        long startTime = this.parseMillisFromIso8601DateTime(Json$.MODULE$.JsonToString(entry.selectDynamic("startedDateTime")));
        long time = BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)new Serializable(entry){
            public static final long serialVersionUID = 0L;
            private final Json entry$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return Json$.MODULE$.JsonToInt(this.entry$1.selectDynamic("time"));
            }
            {
                this.entry$1 = entry$1;
            }
        }).getOrElse((Function0)new Serializable(entry){
            public static final long serialVersionUID = 0L;
            private final Json entry$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return (long)this.entry$1.selectDynamic("time").toDouble();
            }
            {
                this.entry$1 = entry$1;
            }
        }));
        return new Entry(startTime, startTime + time, this.buildRequest(entry.selectDynamic("request")), this.buildResponse(entry.selectDynamic("response")));
    }

    private Request buildRequest(Json request) {
        Option<Json> postData = request.selectDynamic("postData").toOption();
        return new Request(Json$.MODULE$.JsonToString(request.selectDynamic("method")), Json$.MODULE$.JsonToString(request.selectDynamic("url")), (Seq<Header>)((Seq)request.selectDynamic("headers").map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Header apply(Json header) {
                return HarMapping$.MODULE$.io$gatling$recorder$har$HarMapping$$buildHeader(header);
            }
        }, Seq$.MODULE$.canBuildFrom())), (Option<PostData>)postData.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final PostData apply(Json postData) {
                return HarMapping$.MODULE$.io$gatling$recorder$har$HarMapping$$buildPostData(postData);
            }
        }));
    }

    private String unprotected(String string) {
        String unprotected;
        String string2 = string;
        Option option = this.ProtectedValue().unapplySeq((CharSequence)string2);
        String string3 = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 ? (unprotected = (String)((LinearSeqOptimized)option.get()).apply(0)) : string;
        return string3;
    }

    private Response buildResponse(Json response) {
        Json mimeType = response.selectDynamic("content").selectDynamic("mimeType");
        Predef$.MODULE$.assert(mimeType.toOption().isDefined(), (Function0)new Serializable(response){
            public static final long serialVersionUID = 0L;
            private final Json response$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response content ", " does not contains a mimeType"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$1.selectDynamic("content")}));
            }
            {
                this.response$1 = response$1;
            }
        });
        Option rawText = response.selectDynamic("content").selectDynamic("text").toOption().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Json x$3) {
                return x$3.toString().trim();
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                return !x$4.isEmpty();
            }
        });
        Option encoding = response.selectDynamic("content").selectDynamic("encoding").toOption().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Json x$5) {
                return x$5.toString().trim();
            }
        });
        Option text = rawText.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(String x$6) {
                return StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(x$6));
            }
        }).map((Function1)new Serializable(encoding){
            public static final long serialVersionUID = 0L;
            private final Option encoding$1;

            public final String apply(String trimmedText) {
                Some some;
                String string;
                Option option = this.encoding$1;
                String string2 = option instanceof Some && "base64".equals(string = (String)(some = (Some)option).x()) ? new String(Base64.decode((String)trimmedText), HarMapping$.MODULE$.Charset()) : trimmedText;
                return string2;
            }
            {
                this.encoding$1 = encoding$1;
            }
        });
        Content content = new Content(Json$.MODULE$.JsonToString(mimeType), (Option<String>)text);
        return new Response(Json$.MODULE$.JsonToInt(response.selectDynamic("status")), content);
    }

    public Header io$gatling$recorder$har$HarMapping$$buildHeader(Json header) {
        return new Header(Json$.MODULE$.JsonToString(header.selectDynamic("name")), this.unprotected(Json$.MODULE$.JsonToString(header.selectDynamic("value"))));
    }

    public PostData io$gatling$recorder$har$HarMapping$$buildPostData(Json postData) {
        return new PostData(Json$.MODULE$.JsonToString(postData.selectDynamic("mimeType")), Json$.MODULE$.JsonToString(postData.selectDynamic("text")), (Seq<PostParam>)((Seq)postData.selectDynamic("params").map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final PostParam apply(Json postParam) {
                return HarMapping$.MODULE$.io$gatling$recorder$har$HarMapping$$buildPostParam(postParam);
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public PostParam io$gatling$recorder$har$HarMapping$$buildPostParam(Json postParam) {
        return new PostParam(Json$.MODULE$.JsonToString(postParam.selectDynamic("name")), this.unprotected(Json$.MODULE$.JsonToString(postParam.selectDynamic("value"))));
    }

    private HarMapping$() {
        MODULE$ = this;
        this.ProtectedValue = new StringOps(Predef$.MODULE$.augmentString("\"(.*)\\\"")).r();
        this.Charset = StandardCharsets.UTF_8;
    }
}

