/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.controller;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.PathHelper;
import io.gatling.commons.util.PathHelper$;
import io.gatling.commons.util.TimeHelper$;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.recorder.config.RecorderConfiguration$;
import io.gatling.recorder.config.RecorderMode;
import io.gatling.recorder.config.RecorderMode$Har$;
import io.gatling.recorder.config.RecorderMode$Proxy$;
import io.gatling.recorder.config.RecorderPropertiesBuilder;
import io.gatling.recorder.http.HttpProxy;
import io.gatling.recorder.http.handler.remote.TimedHttpRequest;
import io.gatling.recorder.http.model.SafeHttpRequest;
import io.gatling.recorder.http.model.SafeHttpResponse;
import io.gatling.recorder.scenario.RequestElement;
import io.gatling.recorder.scenario.RequestElement$;
import io.gatling.recorder.scenario.ScenarioDefinition;
import io.gatling.recorder.scenario.ScenarioDefinition$;
import io.gatling.recorder.scenario.ScenarioExporter$;
import io.gatling.recorder.scenario.TagElement;
import io.gatling.recorder.scenario.TimedScenarioElement;
import io.gatling.recorder.ui.PauseInfo;
import io.gatling.recorder.ui.RecorderFrontend;
import io.gatling.recorder.ui.RecorderFrontend$;
import io.gatling.recorder.ui.RequestInfo;
import io.gatling.recorder.ui.SSLInfo;
import io.gatling.recorder.ui.TagInfo;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.Base64;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.compat.java8.JFunction0;
import scala.compat.java8.JFunction1;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc!B\u0001\u0003\u0001\u0011Q!A\u0005*fG>\u0014H-\u001a:D_:$(o\u001c7mKJT!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'O\u0003\u0002\u0006\r\u0005A!/Z2pe\u0012,'O\u0003\u0002\b\u0011\u00059q-\u0019;mS:<'\"A\u0005\u0002\u0005%|7c\u0001\u0001\f#A\u0011AbD\u0007\u0002\u001b)\ta\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0011\u001b\t1\u0011I\\=SK\u001a\u0004\"AE\r\u000e\u0003MQ!\u0001F\u000b\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005Y9\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003a\t1aY8n\u0013\tQ2CA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\u0005\u00069\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tq\u0004\u0005\u0002!\u00015\t!\u0001C\u0004#\u0001\t\u0007I\u0011B\u0012\u0002\u0011\u0019\u0014xN\u001c;F]\u0012,\u0012\u0001\n\t\u0003K!j\u0011A\n\u0006\u0003O\u0011\t!!^5\n\u0005%2#\u0001\u0005*fG>\u0014H-\u001a:Ge>tG/\u001a8e\u0011\u0019Y\u0003\u0001)A\u0005I\u0005IaM]8oi\u0016sG\r\t\u0005\n[\u0001\u0001\r\u00111A\u0005\n9\nQ\u0001\u001d:pqf,\u0012a\f\t\u0003aMj\u0011!\r\u0006\u0003e\u0011\tA\u0001\u001b;ua&\u0011A'\r\u0002\n\u0011R$\b\u000f\u0015:pqfD\u0011B\u000e\u0001A\u0002\u0003\u0007I\u0011B\u001c\u0002\u0013A\u0014x\u000e_=`I\u0015\fHC\u0001\u001d<!\ta\u0011(\u0003\u0002;\u001b\t!QK\\5u\u0011\u001daT'!AA\u0002=\n1\u0001\u001f\u00132\u0011\u0019q\u0004\u0001)Q\u0005_\u00051\u0001O]8ys\u0002B#!\u0010!\u0011\u00051\t\u0015B\u0001\"\u000e\u0005!1x\u000e\\1uS2,\u0007b\u0002#\u0001\u0005\u0004%I!R\u0001\u0010GV\u0014(/\u001a8u%\u0016\fX/Z:ugV\ta\tE\u0002H\u001dBk\u0011\u0001\u0013\u0006\u0003\u0013*\u000b!bY8oGV\u0014(/\u001a8u\u0015\tYE*\u0001\u0003vi&d'\"A'\u0002\t)\fg/Y\u0005\u0003\u001f\"\u0013QcQ8oGV\u0014(/\u001a8u\u0019&t7.\u001a3Rk\u0016,X\rE\u0002R)Zk\u0011A\u0015\u0006\u0003'\u0012\t\u0001b]2f]\u0006\u0014\u0018n\\\u0005\u0003+J\u0013A\u0003V5nK\u0012\u001c6-\u001a8be&|W\t\\3nK:$\bCA)X\u0013\tA&K\u0001\bSKF,Xm\u001d;FY\u0016lWM\u001c;\t\ri\u0003\u0001\u0015!\u0003G\u0003A\u0019WO\u001d:f]R\u0014V-];fgR\u001c\b\u0005C\u0004]\u0001\t\u0007I\u0011B/\u0002\u0017\r,(O]3oiR\u000bwm]\u000b\u0002=B\u0019qIT0\u0011\u0007E#\u0006\r\u0005\u0002RC&\u0011!M\u0015\u0002\u000b)\u0006<W\t\\3nK:$\bB\u00023\u0001A\u0003%a,\u0001\u0007dkJ\u0014XM\u001c;UC\u001e\u001c\b\u0005C\u0003g\u0001\u0011\u0005q-\u0001\bti\u0006\u0014HOU3d_J$\u0017N\\4\u0015\u0003aBQ!\u001b\u0001\u0005\u0002)\fQb\u001d;paJ+7m\u001c:eS:<GC\u0001\u001dl\u0011\u0015a\u0007\u000e1\u0001n\u0003\u0011\u0019\u0018M^3\u0011\u00051q\u0017BA8\u000e\u0005\u001d\u0011un\u001c7fC:DQ!\u001d\u0001\u0005\u0002I\faB]3dK&4XMU3rk\u0016\u001cH\u000f\u0006\u00029g\")A\u000f\u001da\u0001k\u00069!/Z9vKN$\bC\u0001<z\u001b\u00059(B\u0001=2\u0003\u0015iw\u000eZ3m\u0013\tQxOA\bTC\u001a,\u0007\n\u001e;q%\u0016\fX/Z:u\u0011\u0015a\b\u0001\"\u0001~\u0003=\u0011XmY3jm\u0016\u0014Vm\u001d9p]N,G\u0003\u0002\u001d\u007f\u0003\u001fAQ\u0001^>A\u0002}\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0004sK6|G/\u001a\u0006\u0004\u0003\u0013\t\u0014a\u00025b]\u0012dWM]\u0005\u0005\u0003\u001b\t\u0019A\u0001\tUS6,G\r\u0013;uaJ+\u0017/^3ti\"9\u0011\u0011C>A\u0002\u0005M\u0011\u0001\u0003:fgB|gn]3\u0011\u0007Y\f)\"C\u0002\u0002\u0018]\u0014\u0001cU1gK\"#H\u000f\u001d*fgB|gn]3\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e\u00051\u0011\r\u001a3UC\u001e$2\u0001OA\u0010\u0011!\t\t#!\u0007A\u0002\u0005\r\u0012\u0001\u0002;fqR\u0004B!!\n\u0002,9\u0019A\"a\n\n\u0007\u0005%R\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\tyC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Si\u0001bBA\u001a\u0001\u0011\u0005\u0011QG\u0001\u0011g\u0016\u001cWO]3D_:tWm\u0019;j_:$2\u0001OA\u001c\u0011!\tI$!\rA\u0002\u0005m\u0012AD:fGV\u0014X\r\u001a%pgR,&+\u0013\t\u0005\u0003{\tY%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003\r)(/\u001b\u0006\u0005\u0003\u000b\n9%A\bbgft7\r\u001b;ua\u000ed\u0017.\u001a8u\u0015\t\tI%A\u0002pe\u001eLA!!\u0014\u0002@\t\u0019QK]5\t\r\u0005E\u0003\u0001\"\u0001h\u0003I\u0019G.Z1s%\u0016\u001cwN\u001d3feN#\u0018\r^3")
public class RecorderController
implements StrictLogging {
    private final RecorderFrontend frontEnd;
    private volatile HttpProxy proxy;
    private final ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> currentRequests;
    private final ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> currentTags;
    private final Logger logger;
    private static /* synthetic */ Map $deserializeLambdaCache$;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private RecorderFrontend frontEnd() {
        return this.frontEnd;
    }

    private HttpProxy proxy() {
        return this.proxy;
    }

    private void proxy_$eq(HttpProxy x$1) {
        this.proxy = x$1;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> currentRequests() {
        return this.currentRequests;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> currentTags() {
        return this.currentTags;
    }

    public void startRecording() {
        RecorderMode selectedMode = this.frontEnd().selectedRecorderMode();
        String harFilePath = this.frontEnd().harFilePath();
        RecorderMode recorderMode = selectedMode;
        RecorderMode$Har$ recorderMode$Har$ = RecorderMode$Har$.MODULE$;
        if (!(recorderMode != null ? !recorderMode.equals(recorderMode$Har$) : recorderMode$Har$ != null) && !PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(PathHelper$.MODULE$.string2path(harFilePath)))) {
            this.frontEnd().handleMissingHarFile(harFilePath);
        } else {
            boolean proceed;
            Path simulationFile = ScenarioExporter$.MODULE$.simulationFilePath(RecorderConfiguration$.MODULE$.configuration());
            boolean bl = PathHelper.RichPath$.MODULE$.exists$extension(PathHelper$.MODULE$.RichPath(simulationFile)) ? this.frontEnd().askSimulationOverwrite() : (proceed = true);
            if (proceed) {
                RecorderMode recorderMode2 = selectedMode;
                if (RecorderMode$Har$.MODULE$.equals(recorderMode2)) {
                    Validation<BoxedUnit> validation = ScenarioExporter$.MODULE$.exportScenario(harFilePath, RecorderConfiguration$.MODULE$.configuration());
                    if (validation instanceof Failure) {
                        Failure failure = (Failure)validation;
                        String errMsg = failure.message();
                        this.frontEnd().handleHarExportFailure(errMsg);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (validation instanceof Success) {
                        this.frontEnd().handleHarExportSuccess();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(validation);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RecorderMode$Proxy$.MODULE$.equals(recorderMode2)) {
                    this.proxy_$eq(new HttpProxy(this, RecorderConfiguration$.MODULE$.configuration()));
                    this.frontEnd().recordingStarted();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)recorderMode2);
                }
            }
        }
    }

    public void stopRecording(boolean save) {
        this.frontEnd().recordingStopped();
        try {
            if (this.currentRequests().isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Nothing was recorded, skipping scenario generation");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                ScenarioDefinition scenario = ScenarioDefinition$.MODULE$.apply((Seq<TimedScenarioElement<RequestElement>>)JavaConversions$.MODULE$.collectionAsScalaIterable(this.currentRequests()).toVector(), (Seq<TimedScenarioElement<TagElement>>)JavaConversions$.MODULE$.collectionAsScalaIterable(this.currentTags()).toVector(), RecorderConfiguration$.MODULE$.configuration());
                ScenarioExporter$.MODULE$.saveScenario(scenario, RecorderConfiguration$.MODULE$.configuration());
            }
        }
        finally {
            this.proxy().shutdown();
            this.clearRecorderState();
            this.frontEnd().init();
        }
    }

    public synchronized void receiveRequest(SafeHttpRequest request) {
        Option$.MODULE$.apply((Object)request.headers().get("Proxy-Authorization")).foreach((Function1)(JFunction1 & Serializable & scala.Serializable)header -> {
            RecorderController.io$gatling$recorder$controller$RecorderController$$$anonfun$1(header);
            return BoxedUnit.UNIT;
        });
    }

    public void receiveResponse(TimedHttpRequest request, SafeHttpResponse response) {
        block0: {
            if (!BoxesRunTime.unboxToBoolean((Object)RecorderConfiguration$.MODULE$.configuration().filters().filters().map((Function1)(JFunction1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.accept(request.httpRequest().uri()))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) break block0;
            long arrivalTime = TimeHelper$.MODULE$.nowMillis();
            this.currentRequests().add(new TimedScenarioElement<RequestElement>(request.sendTime(), arrivalTime, RequestElement$.MODULE$.apply(request.httpRequest(), response, RecorderConfiguration$.MODULE$.configuration())));
            Option previousSendTime = JavaConversions$.MODULE$.collectionAsScalaIterable(this.currentRequests()).lastOption().map((Function1)(JFunction1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.sendTime()));
            previousSendTime.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)t -> {
                block0: {
                    FiniteDuration delta = new package.DurationLong(package$.MODULE$.DurationLong(arrivalTime - t)).milliseconds();
                    if (!delta.$greater((Object)RecorderConfiguration$.MODULE$.configuration().core().thresholdForPauseCreation())) break block0;
                    this.frontEnd().receiveEventInfo(new PauseInfo(delta));
                }
            });
            this.frontEnd().receiveEventInfo(new RequestInfo(request.httpRequest(), response, RecorderConfiguration$.MODULE$.configuration()));
        }
    }

    public void addTag(String text) {
        long now = TimeHelper$.MODULE$.nowMillis();
        this.currentTags().add(new TimedScenarioElement<TagElement>(now, now, new TagElement(text)));
        this.frontEnd().receiveEventInfo(new TagInfo(text));
    }

    public void secureConnection(Uri securedHostURI) {
        this.frontEnd().receiveEventInfo(new SSLInfo(securedHostURI.toUrl()));
    }

    public void clearRecorderState() {
        this.currentRequests().clear();
        this.currentTags().clear();
    }

    public static final /* synthetic */ void io$gatling$recorder$controller$RecorderController$$$anonfun$1(String header) {
        String[] credentials = new String(Base64.decode((String)header.split(" ")[1])).split(":");
        RecorderPropertiesBuilder props = new RecorderPropertiesBuilder();
        props.proxyUsername(credentials[0]);
        props.proxyPassword(credentials[1]);
        RecorderConfiguration$.MODULE$.reload(props.build());
    }

    public RecorderController() {
        StrictLogging.class.$init$((StrictLogging)this);
        this.frontEnd = RecorderFrontend$.MODULE$.newFrontend(this, RecorderConfiguration$.MODULE$.configuration());
        this.currentRequests = new ConcurrentLinkedQueue();
        this.currentTags = new ConcurrentLinkedQueue();
        this.frontEnd().init();
    }
}

