/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.har;

import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.recorder.har.Content;
import io.gatling.recorder.har.Entry;
import io.gatling.recorder.har.Header;
import io.gatling.recorder.har.HttpArchive;
import io.gatling.recorder.har.Json;
import io.gatling.recorder.har.Json$;
import io.gatling.recorder.har.Log;
import io.gatling.recorder.har.PostData;
import io.gatling.recorder.har.PostParam;
import io.gatling.recorder.har.Request;
import io.gatling.recorder.har.Response;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Map;
import org.asynchttpclient.util.Base64;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.compat.java8.JFunction0;
import scala.compat.java8.JFunction1;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class HarMapping$ {
    public static final HarMapping$ MODULE$;
    private final Regex ProtectedValue;
    private final Charset Charset;
    private static /* synthetic */ Map $deserializeLambdaCache$;

    static {
        new HarMapping$();
    }

    private Regex ProtectedValue() {
        return this.ProtectedValue;
    }

    public Charset Charset() {
        return this.Charset;
    }

    public HttpArchive jsonToHttpArchive(Json json) {
        return new HttpArchive(this.buildLog(json.selectDynamic("log")));
    }

    private long parseMillisFromIso8601DateTime(String time) {
        return ZonedDateTime.parse(time).toInstant().toEpochMilli();
    }

    private Log buildLog(Json log) {
        Vector entries = log.selectDynamic("entries").iterator().filter((Function1)(JFunction1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HarMapping$.io$gatling$recorder$har$HarMapping$$$anonfun$1(x$1))).filter((Function1)(JFunction1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HarMapping$.io$gatling$recorder$har$HarMapping$$$anonfun$2(x$2))).map((Function1)(JFunction1 & Serializable & scala.Serializable)entry -> this.buildEntry((Json)entry)).toVector();
        return new Log((Seq<Entry>)entries);
    }

    private Entry buildEntry(Json entry) {
        long startTime = this.parseMillisFromIso8601DateTime(Json$.MODULE$.JsonToString(entry.selectDynamic("startedDateTime")));
        long time = BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Json$.MODULE$.JsonToInt(entry.selectDynamic("time"))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> (long)entry.selectDynamic("time").toDouble()));
        return new Entry(startTime, startTime + time, this.buildRequest(entry.selectDynamic("request")), this.buildResponse(entry.selectDynamic("response")));
    }

    private Request buildRequest(Json request) {
        Option<Json> postData2 = request.selectDynamic("postData").toOption();
        return new Request(Json$.MODULE$.JsonToString(request.selectDynamic("method")), Json$.MODULE$.JsonToString(request.selectDynamic("url")), (Seq<Header>)((Seq)request.selectDynamic("headers").map((Function1)(JFunction1 & Serializable & scala.Serializable)header -> this.buildHeader((Json)header), Seq$.MODULE$.canBuildFrom())), (Option<PostData>)postData2.map((Function1)(JFunction1 & Serializable & scala.Serializable)postData -> this.buildPostData((Json)postData)));
    }

    private String unprotected(String string) {
        String unprotected;
        String string2 = string;
        Option option = this.ProtectedValue().unapplySeq((CharSequence)string2);
        String string3 = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 ? (unprotected = (String)((LinearSeqOptimized)option.get()).apply(0)) : string;
        return string3;
    }

    private Response buildResponse(Json response) {
        Json mimeType = response.selectDynamic("content").selectDynamic("mimeType");
        Predef$.MODULE$.assert(mimeType.toOption().isDefined(), (Function0)(JFunction0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response content ", " does not contains a mimeType"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response.selectDynamic("content")})));
        Option rawText = response.selectDynamic("content").selectDynamic("text").toOption().map((Function1)(JFunction1 & Serializable & scala.Serializable)x$3 -> x$3.toString().trim()).filter((Function1)(JFunction1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)HarMapping$.io$gatling$recorder$har$HarMapping$$$anonfun$10(x$4)));
        Option encoding = response.selectDynamic("content").selectDynamic("encoding").toOption().map((Function1)(JFunction1 & Serializable & scala.Serializable)x$5 -> x$5.toString().trim());
        Option text = rawText.flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)x$6 -> StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(x$6))).map((Function1)(JFunction1 & Serializable & scala.Serializable)trimmedText -> {
            Some some;
            String string;
            Option option = encoding;
            String string2 = option instanceof Some && "base64".equals(string = (String)(some = (Some)option).x()) ? new String(Base64.decode((String)trimmedText), MODULE$.Charset()) : trimmedText;
            return string2;
        });
        Content content = new Content(Json$.MODULE$.JsonToString(mimeType), (Option<String>)text);
        return new Response(Json$.MODULE$.JsonToInt(response.selectDynamic("status")), content);
    }

    private Header buildHeader(Json header) {
        return new Header(Json$.MODULE$.JsonToString(header.selectDynamic("name")), this.unprotected(Json$.MODULE$.JsonToString(header.selectDynamic("value"))));
    }

    private PostData buildPostData(Json postData) {
        return new PostData(Json$.MODULE$.JsonToString(postData.selectDynamic("mimeType")), Json$.MODULE$.JsonToString(postData.selectDynamic("text")), (Seq<PostParam>)((Seq)postData.selectDynamic("params").map((Function1)(JFunction1 & Serializable & scala.Serializable)postParam -> this.buildPostParam((Json)postParam), Seq$.MODULE$.canBuildFrom())));
    }

    private PostParam buildPostParam(Json postParam) {
        return new PostParam(Json$.MODULE$.JsonToString(postParam.selectDynamic("name")), this.unprotected(Json$.MODULE$.JsonToString(postParam.selectDynamic("value"))));
    }

    public static final /* synthetic */ boolean io$gatling$recorder$har$HarMapping$$$anonfun$1(Json x$1) {
        return x$1.selectDynamic("request").selectDynamic("url").toString().toLowerCase().startsWith("http");
    }

    public static final /* synthetic */ boolean io$gatling$recorder$har$HarMapping$$$anonfun$2(Json x$2) {
        return x$2.selectDynamic("response").selectDynamic("status").toInt() != 0;
    }

    public static final /* synthetic */ boolean io$gatling$recorder$har$HarMapping$$$anonfun$10(String x$4) {
        return !x$4.isEmpty();
    }

    private HarMapping$() {
        MODULE$ = this;
        this.ProtectedValue = new StringOps(Predef$.MODULE$.augmentString("\"(.*)\\\"")).r();
        this.Charset = StandardCharsets.UTF_8;
    }
}

