/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.handler.remote;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.recorder.controller.RecorderController;
import io.gatling.recorder.http.channel.BootstrapFactory$;
import io.gatling.recorder.http.handler.ScalaChannelHandler;
import io.gatling.recorder.http.handler.ScalaChannelHandler$class;
import io.gatling.recorder.http.handler.remote.TimedHttpRequest;
import io.gatling.recorder.http.handler.user.SslHandlerSetter;
import io.gatling.recorder.http.model.SafeHttpResponse;
import io.gatling.recorder.http.model.SafeHttpResponse$;
import io.gatling.recorder.http.ssl.SslClientContext$;
import io.gatling.recorder.http.ssl.SslServerContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Map;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.compat.java8.JFunction1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00194Q!\u0001\u0002\u0001\t9\u0011QBU3n_R,\u0007*\u00198eY\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0011X-\\8uK*\u0011QAB\u0001\bQ\u0006tG\r\\3s\u0015\t9\u0001\"\u0001\u0003iiR\u0004(BA\u0005\u000b\u0003!\u0011XmY8sI\u0016\u0014(BA\u0006\r\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!D\u0001\u0003S>\u001cB\u0001A\b\u00187A\u0011\u0001#F\u0007\u0002#)\u0011!cE\u0001\bG\"\fgN\\3m\u0015\t!B\"A\u0003oKR$\u00180\u0003\u0002\u0017#\ta2\t[1o]\u0016d\u0017J\u001c2pk:$\u0007*\u00198eY\u0016\u0014\u0018\tZ1qi\u0016\u0014\bC\u0001\r\u001a\u001b\u0005!\u0011B\u0001\u000e\u0005\u0005M\u00196-\u00197b\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s!\ta2%D\u0001\u001e\u0015\tqr$\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002!C\u0005AA/\u001f9fg\u00064WMC\u0001#\u0003\r\u0019w.\\\u0005\u0003Iu\u0011Qb\u0015;sS\u000e$Hj\\4hS:<\u0007\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u0015\r|g\u000e\u001e:pY2,'o\u0001\u0001\u0011\u0005%ZS\"\u0001\u0016\u000b\u0005\u0019B\u0011B\u0001\u0017+\u0005I\u0011VmY8sI\u0016\u00148i\u001c8ue>dG.\u001a:\t\u00119\u0002!\u0011!Q\u0001\n=\n\u0001c]:m'\u0016\u0014h/\u001a:D_:$X\r\u001f;\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I2\u0011aA:tY&\u0011A'\r\u0002\u0011'Nd7+\u001a:wKJ\u001cuN\u001c;fqRD\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaN\u0001\fkN,'o\u00115b]:,G\u000e\u0005\u0002\u0011q%\u0011\u0011(\u0005\u0002\b\u0007\"\fgN\\3m\u0011!Y\u0004A!a\u0001\n\u0003a\u0014A\u00049fe\u001a|'/\\\"p]:,7\r^\u000b\u0002{A\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t9!i\\8mK\u0006t\u0007\u0002\u0003#\u0001\u0005\u0003\u0007I\u0011A#\u0002%A,'OZ8s[\u000e{gN\\3di~#S-\u001d\u000b\u0003\r&\u0003\"AP$\n\u0005!{$\u0001B+oSRDqAS\"\u0002\u0002\u0003\u0007Q(A\u0002yIEB\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006K!P\u0001\u0010a\u0016\u0014hm\u001c:n\u0007>tg.Z2uA!Aa\n\u0001B\u0001B\u0003%Q(A\u0005sK\u000e|gN\\3di\")\u0001\u000b\u0001C\u0001#\u00061A(\u001b8jiz\"bA\u0015+V-^C\u0006CA*\u0001\u001b\u0005\u0011\u0001\"\u0002\u0014P\u0001\u0004A\u0003\"\u0002\u0018P\u0001\u0004y\u0003\"\u0002\u001cP\u0001\u00049\u0004\"B\u001eP\u0001\u0004i\u0004\"\u0002(P\u0001\u0004i\u0004\"\u0002.\u0001\t\u0003Z\u0016aC2iC:tW\r\u001c*fC\u0012$2A\u0012/b\u0011\u0015i\u0016\f1\u0001_\u0003\r\u0019G\u000f\u001f\t\u0003!}K!\u0001Y\t\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\")!-\u0017a\u0001G\u0006\u0019Qn]4\u0011\u0005y\"\u0017BA3@\u0005\u0019\te.\u001f*fM\u0002")
public class RemoteHandler
extends ChannelInboundHandlerAdapter
implements ScalaChannelHandler,
StrictLogging {
    private final RecorderController controller;
    private final SslServerContext sslServerContext;
    private final Channel userChannel;
    private boolean performConnect;
    private final boolean reconnect;
    private final Logger logger;
    private static /* synthetic */ Map $deserializeLambdaCache$;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Object function2ChannelFutureListener(Function1<ChannelFuture, Object> f) {
        return ScalaChannelHandler$class.function2ChannelFutureListener(this, f);
    }

    @Override
    public Object function2GenericFutureListener(Function1<Future<Channel>, Object> f) {
        return ScalaChannelHandler$class.function2GenericFutureListener(this, f);
    }

    public boolean performConnect() {
        return this.performConnect;
    }

    public void performConnect_$eq(boolean x$1) {
        this.performConnect = x$1;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof FullHttpResponse) {
            BoxedUnit boxedUnit;
            FullHttpResponse fullHttpResponse = (FullHttpResponse)object;
            SafeHttpResponse safeResponse = SafeHttpResponse$.MODULE$.fromNettyResponse(fullHttpResponse);
            if (this.performConnect()) {
                this.handleConnect$1(safeResponse, ctx);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.handleResponse$1(safeResponse, ctx);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received unknown message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        }
    }

    private final void upgradeRemotePipeline$1(ChannelPipeline remotePipeline, SslHandler clientSslHandler) {
        remotePipeline.replace(BootstrapFactory$.MODULE$.CodecHandlerName(), BootstrapFactory$.MODULE$.CodecHandlerName(), (ChannelHandler)new HttpClientCodec());
        remotePipeline.addFirst(BootstrapFactory$.MODULE$.SslHandlerName(), (ChannelHandler)clientSslHandler);
    }

    private final void handleConnect$1(SafeHttpResponse response, ChannelHandlerContext ctx$1) {
        HttpResponseStatus httpResponseStatus = response.status();
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        if (!(httpResponseStatus == null ? httpResponseStatus2 != null : !httpResponseStatus.equals(httpResponseStatus2))) {
            this.performConnect_$eq(false);
            SslHandler remoteSslHandler = new SslHandler(SslClientContext$.MODULE$.createSSLEngine());
            this.upgradeRemotePipeline$1(ctx$1.channel().pipeline(), remoteSslHandler);
            if (!this.reconnect) {
                remoteSslHandler.handshakeFuture().addListener(this.function2GenericFutureListener((Function1)(JFunction1 & Serializable & scala.Serializable)handshakeFuture -> {
                    BoxedUnit boxedUnit;
                    if (handshakeFuture.isSuccess()) {
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)((Channel)handshakeFuture.get()).remoteAddress();
                        this.userChannel.pipeline().addFirst(BootstrapFactory$.MODULE$.SslHandlerSetterName(), (ChannelHandler)new SslHandlerSetter(inetSocketAddress.getHostString(), this.sslServerContext));
                        boxedUnit = this.userChannel.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK));
                    } else if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Handshake failure"})).s((Seq)Nil$.MODULE$), handshakeFuture.cause());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }));
            }
        } else {
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Outgoing proxy refused to connect: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response.status()})));
        }
    }

    private final void handleResponse$1(SafeHttpResponse response, ChannelHandlerContext ctx$1) {
        BoxedUnit boxedUnit;
        TimedHttpRequest timedHttpRequest = (TimedHttpRequest)ctx$1.attr(BootstrapFactory$.MODULE$.TimedHttpRequestAttribute()).getAndSet(null);
        if (timedHttpRequest != null) {
            TimedHttpRequest timedHttpRequest2 = timedHttpRequest;
            this.controller.receiveResponse(timedHttpRequest2, response);
            if (this.userChannel.isActive()) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Write response ", " to user channel ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response, this.userChannel})));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.userChannel.writeAndFlush((Object)response.toNettyResponse());
                boxedUnit = BoxedUnit.UNIT;
            } else if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't write response to disconnected user channel ", ", aborting request:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.userChannel, timedHttpRequest2.httpRequest().uri()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new IllegalStateException("Couldn't find request attribute");
        }
        BoxedUnit boxedUnit3 = boxedUnit;
    }

    public RemoteHandler(RecorderController controller, SslServerContext sslServerContext, Channel userChannel, boolean performConnect, boolean reconnect) {
        this.controller = controller;
        this.sslServerContext = sslServerContext;
        this.userChannel = userChannel;
        this.performConnect = performConnect;
        this.reconnect = reconnect;
        ScalaChannelHandler$class.$init$(this);
        StrictLogging.class.$init$((StrictLogging)this);
    }
}

