/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.scenario;

import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.gatling.http.fetch.EmbeddedResource;
import io.gatling.http.fetch.HtmlParser;
import io.gatling.http.fetch.UserAgent$;
import io.gatling.http.util.HttpHelper$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.http.model.SafeHttpRequest;
import io.gatling.recorder.http.model.SafeHttpResponse;
import io.gatling.recorder.scenario.RequestBody;
import io.gatling.recorder.scenario.RequestBodyBytes;
import io.gatling.recorder.scenario.RequestBodyParams;
import io.gatling.recorder.scenario.RequestElement;
import io.gatling.recorder.scenario.RequestElement$;
import io.gatling.recorder.scenario.ResponseBody;
import io.gatling.recorder.scenario.ResponseBodyBytes;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import org.asynchttpclient.uri.Uri;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.package$;
import scala.io.Codec$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.matching.Regex;

public final class RequestElement$
implements scala.Serializable {
    public static RequestElement$ MODULE$;
    private final Regex HtmlContentType;
    private final Set<String> CacheHeaders;

    static {
        new RequestElement$();
    }

    public List<RequestElement> $lessinit$greater$default$8() {
        return Nil$.MODULE$;
    }

    public Regex HtmlContentType() {
        return this.HtmlContentType;
    }

    public Set<String> CacheHeaders() {
        return this.CacheHeaders;
    }

    public RequestElement apply(SafeHttpRequest request, SafeHttpResponse response, RecorderConfiguration configuration) {
        Map requestHeaders = (Map)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(request.headers().entries()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2(entry.getKey(), entry.getValue()), package$.MODULE$.breakOut(Map$.MODULE$.canBuildFrom()));
        Option requestContentType = requestHeaders.get((Object)HeaderNames$.MODULE$.ContentType());
        Option requestUserAgent = requestHeaders.get((Object)HeaderNames$.MODULE$.UserAgent());
        Option responseContentType = Option$.MODULE$.apply((Object)response.headers().get(HeaderNames$.MODULE$.ContentType()));
        boolean containsFormParams = requestContentType.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains(HeaderValues$.MODULE$.ApplicationFormUrlEncoded())));
        None$ requestBody = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(request.body())).nonEmpty() ? (containsFormParams ? new Some((Object)new RequestBodyParams((List<Tuple2<String, String>>)HttpHelper$.MODULE$.parseFormBody(new String(request.body(), Codec$.MODULE$.UTF8().name())))) : new Some((Object)new RequestBodyBytes(request.body()))) : None$.MODULE$;
        None$ responseBody = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(response.body())).nonEmpty() ? new Some((Object)new ResponseBodyBytes(response.body())) : None$.MODULE$;
        List embeddedResources = (List)responseContentType.collect((PartialFunction)new scala.Serializable(request, response, requestUserAgent){
            public static final long serialVersionUID = 0L;
            private final SafeHttpRequest request$1;
            private final SafeHttpResponse response$1;
            private final Option requestUserAgent$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = RequestElement$.MODULE$.HtmlContentType().unapplySeq(A1);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                    None$ none$;
                    String headerCharset = (String)((LinearSeqOptimized)option.get()).apply(1);
                    String charsetName = (String)Option$.MODULE$.apply((Object)headerCharset).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$1(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Codec$.MODULE$.UTF8().name());
                    Charset charset = Charset.forName(charsetName);
                    if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.response$1.body())).nonEmpty()) {
                        String htmlBuff = new String(this.response$1.body(), charset);
                        Option userAgent2 = this.requestUserAgent$1.flatMap((Function1 & Serializable & scala.Serializable)userAgent -> UserAgent$.MODULE$.parseFromHeader(userAgent));
                        none$ = new Some((Object)new HtmlParser().getEmbeddedResources(Uri.create((String)this.request$1.uri()), htmlBuff, userAgent2));
                    } else {
                        none$ = None$.MODULE$;
                    }
                    object = none$;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                Option option = RequestElement$.MODULE$.HtmlContentType().unapplySeq((CharSequence)string);
                boolean bl = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0;
                return bl;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(String x$1) {
                return Charset.isSupported(x$1);
            }
            {
                this.request$1 = request$1;
                this.response$1 = response$1;
                this.requestUserAgent$1 = requestUserAgent$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(java.lang.String ), $anonfun$applyOrElse$2(), $anonfun$applyOrElse$3(java.lang.String )}, serializedLambda);
            }
        }).flatten(Predef$.MODULE$.$conforms()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Map filteredRequestHeaders = configuration.http().removeCacheHeaders() ? requestHeaders.filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)RequestElement$.$anonfun$apply$4(name))) : requestHeaders;
        return new RequestElement(new String(request.uri()), request.method().toString(), (Map<String, String>)filteredRequestHeaders, (Option<RequestBody>)requestBody, (Option<ResponseBody>)responseBody, response.status().code(), (List<EmbeddedResource>)embeddedResources, this.apply$default$8());
    }

    public List<RequestElement> apply$default$8() {
        return Nil$.MODULE$;
    }

    public RequestElement apply(String uri, String method, Map<String, String> headers, Option<RequestBody> body, Option<ResponseBody> responseBody, int statusCode, List<EmbeddedResource> embeddedResources, List<RequestElement> nonEmbeddedResources) {
        return new RequestElement(uri, method, headers, body, responseBody, statusCode, embeddedResources, nonEmbeddedResources);
    }

    public Option<Tuple8<String, String, Map<String, String>, Option<RequestBody>, Option<ResponseBody>, Object, List<EmbeddedResource>, List<RequestElement>>> unapply(RequestElement x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.uri(), (Object)x$0.method(), x$0.headers(), x$0.body(), x$0.responseBody(), (Object)BoxesRunTime.boxToInteger((int)x$0.statusCode()), x$0.embeddedResources(), x$0.nonEmbeddedResources()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$apply$4(String name) {
        return !MODULE$.CacheHeaders().contains((Object)name);
    }

    private RequestElement$() {
        MODULE$ = this;
        this.HtmlContentType = new StringOps(Predef$.MODULE$.augmentString("(?i)text/html\\s*(;\\s+charset=(.+))?")).r();
        this.CacheHeaders = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HeaderNames$.MODULE$.CacheControl(), HeaderNames$.MODULE$.IfMatch(), HeaderNames$.MODULE$.IfModifiedSince(), HeaderNames$.MODULE$.IfNoneMatch(), HeaderNames$.MODULE$.IfRange(), HeaderNames$.MODULE$.IfUnmodifiedSince()}));
    }
}

