/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.ssl;

import io.gatling.commons.util.PathHelper$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.http.ssl.HttpsMode;
import io.gatling.recorder.http.ssl.HttpsMode$CertificateAuthority$;
import io.gatling.recorder.http.ssl.HttpsMode$ProvidedKeyStore$;
import io.gatling.recorder.http.ssl.HttpsMode$SelfSignedCertificate$;
import io.gatling.recorder.http.ssl.KeyStoreType;
import io.gatling.recorder.http.ssl.SslServerContext;
import io.gatling.recorder.http.ssl.SslServerContext$SelfSignedCertificate$;
import java.io.File;
import java.security.Security;
import scala.Function0;
import scala.MatchError;
import scala.Option$;
import scala.Serializable;

public final class SslServerContext$ {
    public static SslServerContext$ MODULE$;
    private final String io$gatling$recorder$http$ssl$SslServerContext$$Algorithm;
    private final String Protocol;

    static {
        new SslServerContext$();
    }

    public String io$gatling$recorder$http$ssl$SslServerContext$$Algorithm() {
        return this.io$gatling$recorder$http$ssl$SslServerContext$$Algorithm;
    }

    public String Protocol() {
        return this.Protocol;
    }

    public SslServerContext apply(RecorderConfiguration config) {
        SslServerContext sslServerContext;
        HttpsMode httpsMode = config.proxy().https().mode();
        if (HttpsMode$SelfSignedCertificate$.MODULE$.equals(httpsMode)) {
            sslServerContext = SslServerContext$SelfSignedCertificate$.MODULE$;
        } else if (HttpsMode$ProvidedKeyStore$.MODULE$.equals(httpsMode)) {
            File ksFile = new File(config.proxy().https().keyStore().path());
            KeyStoreType keyStoreType = config.proxy().https().keyStore().keyStoreType();
            char[] password = config.proxy().https().keyStore().password().toCharArray();
            sslServerContext = new SslServerContext.ProvidedKeystore(ksFile, keyStoreType, password);
        } else if (HttpsMode$CertificateAuthority$.MODULE$.equals(httpsMode)) {
            sslServerContext = new SslServerContext.OnTheFly(PathHelper$.MODULE$.string2path(config.proxy().https().certificateAuthority().certificatePath()), PathHelper$.MODULE$.string2path(config.proxy().https().certificateAuthority().privateKeyPath()));
        } else {
            throw new MatchError((Object)httpsMode);
        }
        return sslServerContext;
    }

    private SslServerContext$() {
        MODULE$ = this;
        this.io$gatling$recorder$http$ssl$SslServerContext$$Algorithm = (String)Option$.MODULE$.apply((Object)Security.getProperty("ssl.KeyManagerFactory.algorithm")).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "SunX509");
        this.Protocol = "TLS";
    }
}

