/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.controller;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Validation;
import io.gatling.core.filter.Filters$;
import io.gatling.http.client.uri.Uri;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.config.RecorderConfiguration$;
import io.gatling.recorder.config.RecorderMode;
import io.gatling.recorder.config.RecorderMode$Har$;
import io.gatling.recorder.config.RecorderMode$Proxy$;
import io.gatling.recorder.http.Mitm;
import io.gatling.recorder.http.Mitm$;
import io.gatling.recorder.model.HttpRequest;
import io.gatling.recorder.model.HttpResponse;
import io.gatling.recorder.render.HttpTraffic;
import io.gatling.recorder.render.HttpTraffic$;
import io.gatling.recorder.render.HttpTrafficConverter;
import io.gatling.recorder.render.RequestElement;
import io.gatling.recorder.render.RequestElement$;
import io.gatling.recorder.render.TagElement;
import io.gatling.recorder.render.TimedScenarioElement;
import io.gatling.recorder.ui.PauseFrontEndEvent;
import io.gatling.recorder.ui.RecorderFrontEnd;
import io.gatling.recorder.ui.RecorderFrontEnd$;
import io.gatling.recorder.ui.RequestFrontEndEvent;
import io.gatling.recorder.ui.SslFrontEndEvent;
import io.gatling.recorder.ui.TagFrontEndEvent;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentLinkedQueue;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d!B\u000b\u0017\u0005aq\u0002\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000be\u0002A\u0011\u0001\u001e\t\u000fy\u0002!\u0019!C\u0005\u007f!1a\t\u0001Q\u0001\n\u0001C\u0011b\u0012\u0001A\u0002\u0003\u0007I\u0011\u0002%\t\u0013=\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0006\"\u0003,\u0001\u0001\u0004\u0005\t\u0015)\u0003J\u0011%9\u0006\u00011AA\u0002\u0013%\u0001\fC\u0005`\u0001\u0001\u0007\t\u0019!C\u0005A\"I!\r\u0001a\u0001\u0002\u0003\u0006K!\u0017\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0011\u0019!\b\u0001)A\u0005K\"9Q\u000f\u0001b\u0001\n\u00131\bB\u0002?\u0001A\u0003%q\u000fC\u0003~\u0001\u0011\u0005a\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!!\u0013\u0001\t\u0003\tY\u0005\u0003\u0004\u0002d\u0001!\tA \u0002\u0013%\u0016\u001cwN\u001d3fe\u000e{g\u000e\u001e:pY2,'O\u0003\u0002\u00181\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0005eQ\u0012\u0001\u0003:fG>\u0014H-\u001a:\u000b\u0005ma\u0012aB4bi2Lgn\u001a\u0006\u0002;\u0005\u0011\u0011n\\\n\u0004\u0001})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'[5\tqE\u0003\u0002)S\u0005a1oY1mC2|wmZ5oO*\u0011!fK\u0001\tif\u0004Xm]1gK*\tA&A\u0002d_6L!AL\u0014\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003\u0015\u0019Gn\\2l\u0007\u0001\u0001\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0003mi\tqaY8n[>t7/\u0003\u00029g\t)1\t\\8dW\u00061A(\u001b8jiz\"\"aO\u001f\u0011\u0005q\u0002Q\"\u0001\f\t\u000b=\u0012\u0001\u0019A\u0019\u0002\u0011\u0019\u0014xN\u001c;F]\u0012,\u0012\u0001\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007b\t!!^5\n\u0005\u0015\u0013%\u0001\u0005*fG>\u0014H-\u001a:Ge>tG/\u00128e\u0003%1'o\u001c8u\u000b:$\u0007%\u0001\u0003nSRlW#A%\u0011\u0005)kU\"A&\u000b\u00051C\u0012\u0001\u00025uiBL!AT&\u0003\t5KG/\\\u0001\t[&$Xn\u0018\u0013fcR\u0011\u0011\u000b\u0016\t\u0003AIK!aU\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b+\u001a\t\t\u00111\u0001J\u0003\rAH%M\u0001\u0006[&$X\u000eI\u0001\nG>tg/\u001a:uKJ,\u0012!\u0017\t\u00035vk\u0011a\u0017\u0006\u00039b\taA]3oI\u0016\u0014\u0018B\u00010\\\u0005QAE\u000f\u001e9Ue\u00064g-[2D_:4XM\u001d;fe\u0006i1m\u001c8wKJ$XM]0%KF$\"!U1\t\u000fUK\u0011\u0011!a\u00013\u0006Q1m\u001c8wKJ$XM\u001d\u0011\u0002\u0011I,\u0017/^3tiN,\u0012!\u001a\t\u0004M2tW\"A4\u000b\u0005!L\u0017AC2p]\u000e,(O]3oi*\u0011AG\u001b\u0006\u0002W\u0006!!.\u0019<b\u0013\tiwMA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fIF+X-^3\u0011\u0007i{\u0017/\u0003\u0002q7\n!B+[7fIN\u001bWM\\1sS>,E.Z7f]R\u0004\"A\u0017:\n\u0005M\\&A\u0004*fcV,7\u000f^#mK6,g\u000e^\u0001\ne\u0016\fX/Z:ug\u0002\nA\u0001^1hgV\tq\u000fE\u0002gYb\u00042AW8z!\tQ&0\u0003\u0002|7\nQA+Y4FY\u0016lWM\u001c;\u0002\u000bQ\fwm\u001d\u0011\u0002\u001dM$\u0018M\u001d;SK\u000e|'\u000fZ5oOR\t\u0011+A\u0007ti>\u0004(+Z2pe\u0012Lgn\u001a\u000b\u0004#\u0006\r\u0001bBA\u0003!\u0001\u0007\u0011qA\u0001\u0005g\u00064X\rE\u0002!\u0003\u0013I1!a\u0003\"\u0005\u001d\u0011un\u001c7fC:\fqB]3dK&4XMU3ta>t7/\u001a\u000b\u0006#\u0006E\u0011\u0011\u0005\u0005\b\u0003'\t\u0002\u0019AA\u000b\u0003\u001d\u0011X-];fgR\u0004B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037A\u0012!B7pI\u0016d\u0017\u0002BA\u0010\u00033\u00111\u0002\u0013;uaJ+\u0017/^3ti\"9\u00111E\tA\u0002\u0005\u0015\u0012\u0001\u0003:fgB|gn]3\u0011\t\u0005]\u0011qE\u0005\u0005\u0003S\tIB\u0001\u0007IiR\u0004(+Z:q_:\u001cX-\u0001\u0004bI\u0012$\u0016m\u001a\u000b\u0004#\u0006=\u0002bBA\u0019%\u0001\u0007\u00111G\u0001\u0005i\u0016DH\u000f\u0005\u0003\u00026\u0005\rc\u0002BA\u001c\u0003\u007f\u00012!!\u000f\"\u001b\t\tYDC\u0002\u0002>A\na\u0001\u0010:p_Rt\u0014bAA!C\u00051\u0001K]3eK\u001aLA!!\u0012\u0002H\t11\u000b\u001e:j]\u001eT1!!\u0011\"\u0003A\u0019XmY;sK\u000e{gN\\3di&|g\u000eF\u0002R\u0003\u001bBq!a\u0014\u0014\u0001\u0004\t\t&\u0001\btK\u000e,(/\u001a3I_N$XKU%\u0011\t\u0005M\u0013qL\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005\u0019QO]5\u000b\t\u0005m\u0013QL\u0001\u0007G2LWM\u001c;\u000b\u00051S\u0012\u0002BA1\u0003+\u00121!\u0016:j\u0003I\u0019G.Z1s%\u0016\u001cwN\u001d3feN#\u0018\r^3")
public final class RecorderController
implements StrictLogging {
    private final Clock clock;
    private final RecorderFrontEnd frontEnd;
    private Mitm mitm;
    private HttpTrafficConverter converter;
    private final ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> requests;
    private final ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> tags;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private RecorderFrontEnd frontEnd() {
        return this.frontEnd;
    }

    private Mitm mitm() {
        return this.mitm;
    }

    private void mitm_$eq(Mitm x$1) {
        this.mitm = x$1;
    }

    private HttpTrafficConverter converter() {
        return this.converter;
    }

    private void converter_$eq(HttpTrafficConverter x$1) {
        this.converter = x$1;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<RequestElement>> requests() {
        return this.requests;
    }

    private ConcurrentLinkedQueue<TimedScenarioElement<TagElement>> tags() {
        return this.tags;
    }

    public void startRecording() {
        boolean proceed;
        RecorderConfiguration config = RecorderConfiguration$.MODULE$.recorderConfiguration();
        this.converter_$eq(new HttpTrafficConverter(config));
        RecorderMode selectedMode = this.frontEnd().selectedRecorderMode();
        String harFilePath = this.frontEnd().harFilePath();
        Path harFile = Paths.get(harFilePath, new String[0]);
        RecorderMode recorderMode = selectedMode;
        RecorderMode$Har$ recorderMode$Har$ = RecorderMode$Har$.MODULE$;
        if (!(recorderMode != null ? !recorderMode.equals(recorderMode$Har$) : recorderMode$Har$ != null) && !Files.exists(harFile, new LinkOption[0])) {
            this.frontEnd().handleMissingHarFile(harFilePath);
            return;
        }
        boolean bl = proceed = this.converter().simulationFileExists() ? this.frontEnd().askSimulationOverwrite() : true;
        if (proceed) {
            RecorderMode recorderMode2 = selectedMode;
            if (RecorderMode$Har$.MODULE$.equals(recorderMode2)) {
                Validation<BoxedUnit> validation = this.converter().renderHarFile(harFile);
                if (validation instanceof Failure) {
                    Failure failure = (Failure)validation;
                    String errMsg = failure.message();
                    this.frontEnd().handleHarExportFailure(errMsg);
                } else {
                    this.frontEnd().handleHarExportSuccess();
                }
                return;
            }
            if (RecorderMode$Proxy$.MODULE$.equals(recorderMode2)) {
                this.mitm_$eq(Mitm$.MODULE$.apply(this, this.clock, config));
                this.frontEnd().recordingStarted();
                return;
            }
            throw new MatchError((Object)recorderMode2);
        }
    }

    public void stopRecording(boolean save) {
        try {
            this.frontEnd().recordingStopped();
            if (save) {
                if (this.requests().isEmpty()) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Nothing was recorded, skipping Simulation generation");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    RecorderConfiguration config = RecorderConfiguration$.MODULE$.recorderConfiguration();
                    HttpTraffic traffic = HttpTraffic$.MODULE$.apply((List<TimedScenarioElement<RequestElement>>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.requests()).asScala().toList(), (List<TimedScenarioElement<TagElement>>)CollectionConverters$.MODULE$.CollectionHasAsScala(this.tags()).asScala().toList(), config);
                    this.converter().renderHttpTraffic(traffic);
                }
            }
        }
        finally {
            this.mitm().shutdown();
            this.clearRecorderState();
            this.frontEnd().init();
        }
    }

    public void receiveResponse(HttpRequest request, HttpResponse response) {
        RecorderConfiguration config = RecorderConfiguration$.MODULE$.recorderConfiguration();
        if (config.filters().filters().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.accept(request.uri()))) && Filters$.MODULE$.BrowserNoiseFilters().accept(request.uri())) {
            this.requests().add(new TimedScenarioElement<RequestElement>(request.timestamp(), response.timestamp(), RequestElement$.MODULE$.apply(request, response, config)));
            Option previousSendTime = CollectionConverters$.MODULE$.CollectionHasAsScala(this.requests()).asScala().lastOption().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.sendTime()));
            previousSendTime.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)t -> {
                FiniteDuration delta = new package.DurationLong(package$.MODULE$.DurationLong(response.timestamp() - t)).milliseconds();
                if (delta.$greater((Object)config.core().thresholdForPauseCreation())) {
                    this.frontEnd().receiveEvent(new PauseFrontEndEvent(delta));
                    return;
                }
            });
            this.frontEnd().receiveEvent(new RequestFrontEndEvent(request, response, config));
            return;
        }
    }

    public void addTag(String text) {
        long now = this.clock.nowMillis();
        this.tags().add(new TimedScenarioElement<TagElement>(now, now, new TagElement(text)));
        this.frontEnd().receiveEvent(new TagFrontEndEvent(text));
    }

    public void secureConnection(Uri securedHostURI) {
        this.frontEnd().receiveEvent(new SslFrontEndEvent(securedHostURI.toUrl()));
    }

    public void clearRecorderState() {
        this.requests().clear();
        this.tags().clear();
    }

    public RecorderController(Clock clock) {
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.frontEnd = RecorderFrontEnd$.MODULE$.newFrontend(this, RecorderConfiguration$.MODULE$.recorderConfiguration());
        this.requests = new ConcurrentLinkedQueue();
        this.tags = new ConcurrentLinkedQueue();
        this.frontEnd().init();
        Statics.releaseFence();
    }
}

