/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.mitm;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.recorder.http.OutgoingProxy;
import io.gatling.recorder.http.Remote;
import io.gatling.recorder.http.Remote$;
import io.gatling.recorder.http.mitm.TrafficLogger;
import io.gatling.recorder.http.mitm.controller.Controller;
import io.gatling.recorder.http.mitm.controller.Controller$;
import io.gatling.recorder.http.mitm.controller.Controller$Message$ServerChannelInactive$;
import io.gatling.recorder.http.ssl.SslServerContext;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005-c!B\n\u0015\u0005Qq\u0002\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003_\u0011\u00151\u0007\u0001\"\u0001h\u0011\u001dy\u0007\u00011A\u0005\nADq\u0001\u001e\u0001A\u0002\u0013%Q\u000f\u0003\u0004|\u0001\u0001\u0006K!\u001d\u0005\f\u0003\u0003\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0001C\u0006\u0002\f\u0001\u0001\r\u00111A\u0005\n\u00055\u0001bCA\t\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000bA1\"!\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0018!Y\u00111\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0013\u0011-\tI\u0003\u0001a\u0001\u0002\u0003\u0006K!!\u0007\t\u000f\u00055\u0002\u0001\"\u0011\u00020!9\u0011Q\t\u0001\u0005B\u0005\u001d#!D*feZ,'\u000fS1oI2,'O\u0003\u0002\u0016-\u0005!Q.\u001b;n\u0015\t9\u0002$\u0001\u0003iiR\u0004(BA\r\u001b\u0003!\u0011XmY8sI\u0016\u0014(BA\u000e\u001d\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!H\u0001\u0003S>\u001c2\u0001A\u0010(!\t\u0001S%D\u0001\"\u0015\t\u00113%A\u0004dQ\u0006tg.\u001a7\u000b\u0005\u0011b\u0012!\u00028fiRL\u0018B\u0001\u0014\"\u0005q\u0019\u0005.\u00198oK2LeNY8v]\u0012D\u0015M\u001c3mKJ\fE-\u00199uKJ\u0004\"\u0001K\u0018\u000e\u0003%R!AK\u0016\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u00051j\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u00039\n1aY8n\u0013\t\u0001\u0014FA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u000e_V$xm\\5oOB\u0013x\u000e_=\u0004\u0001A\u0019AgN\u001d\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012aa\u00149uS>t\u0007C\u0001\u001e<\u001b\u00051\u0012B\u0001\u001f\u0017\u00055yU\u000f^4pS:<\u0007K]8ys\u0006y1\r\\5f]R\u0014un\u001c;tiJ\f\u0007\u000f\u0005\u0002@\u00056\t\u0001I\u0003\u0002BG\u0005I!m\\8ugR\u0014\u0018\r]\u0005\u0003\u0007\u0002\u0013\u0011BQ8piN$(/\u00199\u0002!M\u001cHnU3sm\u0016\u00148i\u001c8uKb$\bC\u0001$J\u001b\u00059%B\u0001%\u0017\u0003\r\u00198\u000f\\\u0005\u0003\u0015\u001e\u0013\u0001cU:m'\u0016\u0014h/\u001a:D_:$X\r\u001f;\u0002\u001bQ\u0014\u0018M\u001a4jG2{wmZ3s!\tie*D\u0001\u0015\u0013\tyECA\u0007Ue\u00064g-[2M_\u001e<WM]\u0001\u0017QR$\bo\u00117jK:$8i\u001c3fG\u001a\u000b7\r^8ssB\u0019AG\u0015+\n\u0005M+$!\u0003$v]\u000e$\u0018n\u001c81!\t)6,D\u0001W\u0015\t9rK\u0003\u0002Y3\u0006)1m\u001c3fG*\u0011!lI\u0001\bQ\u0006tG\r\\3s\u0013\tafKA\bIiR\u00048\t\\5f]R\u001cu\u000eZ3d\u0003\u0015\u0019Gn\\2l!\tyF-D\u0001a\u0015\t\t'-\u0001\u0003vi&d'BA2\u001b\u0003\u001d\u0019w.\\7p]NL!!\u001a1\u0003\u000b\rcwnY6\u0002\rqJg.\u001b;?)\u001dA\u0017N[6m[:\u0004\"!\u0014\u0001\t\u000bE:\u0001\u0019A\u001a\t\u000bu:\u0001\u0019\u0001 \t\u000b\u0011;\u0001\u0019A#\t\u000b-;\u0001\u0019\u0001'\t\u000bA;\u0001\u0019A)\t\u000bu;\u0001\u0019\u00010\u0002\u000b!$H\u000f]:\u0016\u0003E\u0004\"\u0001\u000e:\n\u0005M,$a\u0002\"p_2,\u0017M\\\u0001\nQR$\bo]0%KF$\"A^=\u0011\u0005Q:\u0018B\u0001=6\u0005\u0011)f.\u001b;\t\u000fiL\u0011\u0011!a\u0001c\u0006\u0019\u0001\u0010J\u0019\u0002\r!$H\u000f]:!Q\tQQ\u0010\u0005\u00025}&\u0011q0\u000e\u0002\tm>d\u0017\r^5mK\u00061!/Z7pi\u0016,\"!!\u0002\u0011\u0007i\n9!C\u0002\u0002\nY\u0011aAU3n_R,\u0017A\u0003:f[>$Xm\u0018\u0013fcR\u0019a/a\u0004\t\u0011id\u0011\u0011!a\u0001\u0003\u000b\tqA]3n_R,\u0007\u0005\u000b\u0002\u000e{\u0006Q1m\u001c8ue>dG.\u001a:\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003?i!!!\b\u000b\u0007\u0005UA#\u0003\u0003\u0002\"\u0005u!AC\"p]R\u0014x\u000e\u001c7fe\u0006q1m\u001c8ue>dG.\u001a:`I\u0015\fHc\u0001<\u0002(!A!pDA\u0001\u0002\u0004\tI\"A\u0006d_:$(o\u001c7mKJ\u0004\u0003F\u0001\t~\u0003-\u0019\u0007.\u00198oK2\u0014V-\u00193\u0015\u000bY\f\t$a\u000f\t\u000f\u0005M\u0012\u00031\u0001\u00026\u0005\u00191\r\u001e=\u0011\u0007\u0001\n9$C\u0002\u0002:\u0005\u0012Qc\u00115b]:,G\u000eS1oI2,'oQ8oi\u0016DH\u000fC\u0004\u0002>E\u0001\r!a\u0010\u0002\u00075\u001cx\rE\u00025\u0003\u0003J1!a\u00116\u0005\u0019\te.\u001f*fM\u0006y1\r[1o]\u0016d\u0017J\\1di&4X\rF\u0002w\u0003\u0013Bq!a\r\u0013\u0001\u0004\t)\u0004")
public final class ServerHandler
extends ChannelInboundHandlerAdapter
implements StrictLogging {
    private final Option<OutgoingProxy> outgoingProxy;
    private final Bootstrap clientBootstrap;
    private final SslServerContext sslServerContext;
    private final TrafficLogger trafficLogger;
    private final Function0<HttpClientCodec> httpClientCodecFactory;
    private final Clock clock;
    private volatile boolean https;
    private volatile Remote remote;
    private volatile Controller controller;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private boolean https() {
        return this.https;
    }

    private void https_$eq(boolean x$1) {
        this.https = x$1;
    }

    private Remote remote() {
        return this.remote;
    }

    private void remote_$eq(Remote x$1) {
        this.remote = x$1;
    }

    private Controller controller() {
        return this.controller;
    }

    private void controller_$eq(Controller x$1) {
        this.controller = x$1;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        long sendTimestamp = this.clock.nowMillis();
        Object object = msg;
        if (object instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)object;
            if (this.controller() == null) {
                HttpMethod httpMethod = fullHttpRequest.method();
                HttpMethod httpMethod2 = HttpMethod.CONNECT;
                if (!(httpMethod != null ? !httpMethod.equals(httpMethod2) : httpMethod2 != null)) {
                    Predef$.MODULE$.assert(!fullHttpRequest.uri().startsWith("http"), (Function0 & Serializable)() -> "Invalid HTTPS Proxy request: URI '" + fullHttpRequest.uri() + "' shouldn't have a scheme.");
                    this.https_$eq(true);
                    this.remote_$eq(Remote$.MODULE$.fromAbsoluteUri(this.https() + "://" + fullHttpRequest.uri()));
                } else {
                    Predef$.MODULE$.assert(fullHttpRequest.uri().startsWith("http://"), (Function0 & Serializable)() -> "Invalid HTTP Proxy request: URI '" + fullHttpRequest.uri() + "' should be absolute with http scheme. You're probably confusing Recorder proxy url and target system url.");
                    this.https_$eq(false);
                    this.remote_$eq(Remote$.MODULE$.fromAbsoluteUri(fullHttpRequest.uri()));
                }
                Bootstrap clientBootstrapOnServerChannelEventLoop = this.clientBootstrap.clone((EventLoopGroup)ctx.channel().eventLoop());
                this.controller_$eq(Controller$.MODULE$.apply(this.outgoingProxy, clientBootstrapOnServerChannelEventLoop, this.sslServerContext, this.trafficLogger, this.httpClientCodecFactory, ctx.channel(), this.https(), this.clock));
            }
            this.trafficLogger.logRequest(ctx.channel().id(), fullHttpRequest, this.remote(), this.https(), sendTimestamp);
            this.controller().$bang(new Controller.Message.RequestReceived(fullHttpRequest));
            return;
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Received unknown message: {}", object);
            return;
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.controller() != null) {
            this.trafficLogger.clear(ctx.channel().id());
            this.controller().$bang(Controller$Message$ServerChannelInactive$.MODULE$);
            return;
        }
    }

    public ServerHandler(Option<OutgoingProxy> outgoingProxy, Bootstrap clientBootstrap, SslServerContext sslServerContext, TrafficLogger trafficLogger, Function0<HttpClientCodec> httpClientCodecFactory, Clock clock) {
        this.outgoingProxy = outgoingProxy;
        this.clientBootstrap = clientBootstrap;
        this.sslServerContext = sslServerContext;
        this.trafficLogger = trafficLogger;
        this.httpClientCodecFactory = httpClientCodecFactory;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.https = false;
        Statics.releaseFence();
    }
}

